/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.intel;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.intel.InstrInfo;
import com.github.icedland.iced.x86.fmt.intel.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.FormatterUtils;

final class SimpleInstrInfo_maskmovq
extends InstrInfo {
    private final FormatterString mnemonic;

    SimpleInstrInfo_maskmovq(String mnemonic) {
        this.mnemonic = new FormatterString(mnemonic);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int shortFormOpKind;
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        int opKind = instruction.getOp0Kind();
        switch (instruction.getCodeSize()) {
            case 0: {
                shortFormOpKind = opKind;
                break;
            }
            case 1: {
                shortFormOpKind = 18;
                break;
            }
            case 2: {
                shortFormOpKind = 19;
                break;
            }
            case 3: {
                shortFormOpKind = 20;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int flags = 16384;
        if (opKind != shortFormOpKind) {
            if (opKind == 18) {
                flags |= 0x40;
            } else if (opKind == 19) {
                flags |= 0x80;
            } else if (opKind == 20) {
                flags |= 0xC0;
            }
        }
        InstrOpInfo info = new InstrOpInfo();
        info.flags = flags;
        info.mnemonic = this.mnemonic;
        info.opCount = (byte)2;
        info.op0Kind = (byte)instruction.getOp1Kind();
        info.op0Index = 1;
        info.op0Register = (byte)instruction.getOp1Register();
        info.op1Kind = (byte)instruction.getOp2Kind();
        info.op1Index = (byte)2;
        info.op1Register = (byte)instruction.getOp2Register();
        int segReg = instruction.getSegmentPrefix();
        if (segReg != 0 && FormatterUtils.showSegmentPrefix(74, instruction, options)) {
            info.opCount = (byte)3;
            info.op2Kind = 0;
            info.op2Register = (byte)segReg;
            info.op2Index = (byte)-3;
        }
        return info;
    }
}

