/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.intel;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class InstrOpInfo {
    FormatterString mnemonic;
    int flags;
    byte opCount;
    byte op0Kind;
    byte op1Kind;
    byte op2Kind;
    byte op3Kind;
    byte op4Kind;
    byte op0Register;
    byte op1Register;
    byte op2Register;
    private byte op3Register;
    private byte op4Register;
    byte op0Index;
    byte op1Index;
    byte op2Index;
    byte op3Index;
    byte op4Index;

    int getOpRegister(int operand) {
        int REG_MASK = 255;
        switch (operand) {
            case 0: {
                return this.op0Register & 0xFF;
            }
            case 1: {
                return this.op1Register & 0xFF;
            }
            case 2: {
                return this.op2Register & 0xFF;
            }
            case 3: {
                return this.op3Register & 0xFF;
            }
            case 4: {
                return this.op4Register & 0xFF;
            }
        }
        throw new IllegalArgumentException("operand");
    }

    int getOpKind(int operand) {
        switch (operand) {
            case 0: {
                return this.op0Kind;
            }
            case 1: {
                return this.op1Kind;
            }
            case 2: {
                return this.op2Kind;
            }
            case 3: {
                return this.op3Kind;
            }
            case 4: {
                return this.op4Kind;
            }
        }
        assert (this.op0Kind == 25 || this.op0Kind == 26 || this.op0Kind == 27 || this.op0Kind == 28) : this.op0Kind;
        return this.op0Kind;
    }

    int getInstructionIndex(int operand) {
        int instructionOperand;
        switch (operand) {
            case 0: {
                instructionOperand = this.op0Index;
                break;
            }
            case 1: {
                instructionOperand = this.op1Index;
                break;
            }
            case 2: {
                instructionOperand = this.op2Index;
                break;
            }
            case 3: {
                instructionOperand = this.op3Index;
                break;
            }
            case 4: {
                instructionOperand = this.op4Index;
                break;
            }
            default: {
                assert (this.op0Kind == 25 || this.op0Kind == 26 || this.op0Kind == 27 || this.op0Kind == 28) : this.op0Kind;
                instructionOperand = -1;
            }
        }
        return instructionOperand < 0 ? -1 : instructionOperand;
    }

    Integer tryGetOpAccess(int operand) {
        byte instructionOperand;
        switch (operand) {
            case 0: {
                instructionOperand = this.op0Index;
                break;
            }
            case 1: {
                instructionOperand = this.op1Index;
                break;
            }
            case 2: {
                instructionOperand = this.op2Index;
                break;
            }
            case 3: {
                instructionOperand = this.op3Index;
                break;
            }
            case 4: {
                instructionOperand = this.op4Index;
                break;
            }
            default: {
                assert (this.op0Kind == 25 || this.op0Kind == 26 || this.op0Kind == 27 || this.op0Kind == 28) : this.op0Kind;
                instructionOperand = this.op0Index;
            }
        }
        if (instructionOperand < -1) {
            return -instructionOperand - 2;
        }
        return null;
    }

    int getOperandIndex(int instructionOperand) {
        int index = instructionOperand == this.op0Index ? 0 : (instructionOperand == this.op1Index ? 1 : (instructionOperand == this.op2Index ? 2 : (instructionOperand == this.op3Index ? 3 : (instructionOperand == this.op4Index ? 4 : -1))));
        return index < this.opCount ? index : -1;
    }

    InstrOpInfo() {
    }

    InstrOpInfo(FormatterString mnemonic, Instruction instruction, int flags) {
        this.mnemonic = mnemonic;
        this.flags = flags;
        this.op0Kind = (byte)instruction.getOp0Kind();
        this.op1Kind = (byte)instruction.getOp1Kind();
        this.op2Kind = (byte)instruction.getOp2Kind();
        this.op3Kind = (byte)instruction.getOp3Kind();
        this.op4Kind = (byte)instruction.getOp4Kind();
        this.op0Register = (byte)instruction.getOp0Register();
        this.op1Register = (byte)instruction.getOp1Register();
        this.op2Register = (byte)instruction.getOp2Register();
        this.op3Register = (byte)instruction.getOp3Register();
        this.op4Register = (byte)instruction.getOp4Register();
        int opCount = instruction.getOpCount();
        this.opCount = (byte)opCount;
        switch (opCount) {
            case 0: {
                this.op0Index = (byte)-1;
                this.op1Index = (byte)-1;
                this.op2Index = (byte)-1;
                this.op3Index = (byte)-1;
                this.op4Index = (byte)-1;
                break;
            }
            case 1: {
                this.op0Index = 0;
                this.op1Index = (byte)-1;
                this.op2Index = (byte)-1;
                this.op3Index = (byte)-1;
                this.op4Index = (byte)-1;
                break;
            }
            case 2: {
                this.op0Index = 0;
                this.op1Index = 1;
                this.op2Index = (byte)-1;
                this.op3Index = (byte)-1;
                this.op4Index = (byte)-1;
                break;
            }
            case 3: {
                this.op0Index = 0;
                this.op1Index = 1;
                this.op2Index = (byte)2;
                this.op3Index = (byte)-1;
                this.op4Index = (byte)-1;
                break;
            }
            case 4: {
                this.op0Index = 0;
                this.op1Index = 1;
                this.op2Index = (byte)2;
                this.op3Index = (byte)3;
                this.op4Index = (byte)-1;
                break;
            }
            case 5: {
                this.op0Index = 0;
                this.op1Index = 1;
                this.op2Index = (byte)2;
                this.op3Index = (byte)3;
                this.op4Index = (byte)4;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

