/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.MnemonicCC;

final class SimpleInstrInfo_os_jcc
extends InstrInfo {
    private final int bitness;
    private final int ccIndex;
    private final FormatterString[] mnemonics;

    SimpleInstrInfo_os_jcc(int bitness, int ccIndex, String[] mnemonics) {
        this.bitness = bitness;
        this.ccIndex = ccIndex;
        this.mnemonics = FormatterString.create(mnemonics);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int prefixSeg;
        int flags = 0;
        int instrBitness = SimpleInstrInfo_os_jcc.getBitness(instruction.getCodeSize());
        if (instrBitness != 0 && instrBitness != this.bitness) {
            flags = this.bitness == 16 ? (flags |= 2) : (this.bitness == 32 ? (flags |= 4) : (flags |= 6));
        }
        if ((prefixSeg = instruction.getSegmentPrefix()) == 72) {
            flags |= 0x100;
        } else if (prefixSeg == 74) {
            flags |= 0x200;
        }
        if (instruction.getRepnePrefix()) {
            flags |= 0x400;
        }
        FormatterString mnemonic = MnemonicCC.getMnemonicCC(options, this.ccIndex, this.mnemonics);
        return new InstrOpInfo(SimpleInstrInfo_os_jcc.getMnemonic(options, instruction, mnemonic, mnemonic, flags), instruction, flags);
    }
}

