/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_os
extends InstrInfo {
    private final int bitness;
    private final FormatterString mnemonic;
    private final boolean canUseBnd;
    private final int flags;

    SimpleInstrInfo_os(int bitness, String mnemonic, boolean canUseBnd, int flags) {
        this.bitness = bitness;
        this.mnemonic = new FormatterString(mnemonic);
        this.canUseBnd = canUseBnd;
        this.flags = flags;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int instrBitness;
        int flags = this.flags;
        if (this.canUseBnd && instruction.getRepnePrefix()) {
            flags |= 0x400;
        }
        if ((instrBitness = SimpleInstrInfo_os.getBitness(instruction.getCodeSize())) != 0 && instrBitness != this.bitness) {
            flags = this.bitness == 16 ? (flags |= 2) : (this.bitness == 32 ? (flags |= 4) : (flags |= 6));
        }
        return new InstrOpInfo(SimpleInstrInfo_os.getMnemonic(options, instruction, this.mnemonic, this.mnemonic, flags), instruction, flags);
    }
}

