/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.fast;

import com.github.icedland.iced.x86.internal.DataReader;
import com.github.icedland.iced.x86.internal.ResourceReader;
import com.github.icedland.iced.x86.internal.fmt.FormatterStringsTable;

final class FmtData {
    static final String[] mnemonics;
    static final byte[] flags;

    FmtData() {
    }

    static byte[] getSerializedData() {
        return ResourceReader.readByteArray(FmtData.class.getClassLoader(), "com/github/icedland/iced/x86/fmt/fast/FmtData.bin");
    }

    static {
        DataReader reader = new DataReader(FmtData.getSerializedData());
        String[] strings = FormatterStringsTable.getStringsTable();
        String[] mnemonicsTmp = new String[4936];
        byte[] flagsTmp = new byte[4936];
        char[] ca = new char[1];
        int prevIndex = -1;
        byte prevFlags = 0;
        for (int i = 0; i < mnemonicsTmp.length; ++i) {
            int currentIndex;
            byte f = (byte)reader.readByte();
            if ((f & 2) != 0) {
                currentIndex = reader.getIndex();
                reader.setIndex(prevIndex);
            } else {
                currentIndex = -1;
                prevIndex = reader.getIndex();
            }
            String mnemonic = strings[reader.readCompressedUInt32()];
            if ((prevFlags & 1) == (f & 1) && (f & 2) != 0) {
                mnemonic = mnemonicsTmp[i - 1];
            } else if ((f & 1) != 0) {
                ca[0] = 118;
                mnemonic = (new String(ca) + mnemonic).intern();
            }
            flagsTmp[i] = f;
            mnemonicsTmp[i] = mnemonic;
            prevFlags = f;
            if (currentIndex < 0) continue;
            reader.setIndex(currentIndex);
        }
        if (reader.canRead()) {
            throw new UnsupportedOperationException();
        }
        flags = flagsTmp;
        mnemonics = mnemonicsTmp;
    }
}

