/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.fast;

public final class FastStringOutput {
    private char[] buffer;
    private int bufferLen;

    public int size() {
        return this.bufferLen;
    }

    public FastStringOutput() {
        this.buffer = new char[64];
    }

    public FastStringOutput(int capacity) {
        this.buffer = new char[capacity];
    }

    public void append(char c) {
        int bufferLen = this.bufferLen;
        char[] buffer = this.buffer;
        if (Integer.compareUnsigned(bufferLen, buffer.length) >= 0) {
            this.resize(1);
            buffer = this.buffer;
        }
        buffer[bufferLen] = c;
        this.bufferLen = bufferLen + 1;
    }

    public void append(String value) {
        if (value != null) {
            char[] buffer = this.buffer;
            int bufferLen = this.bufferLen;
            if (Integer.compareUnsigned(bufferLen + value.length(), buffer.length) > 0) {
                this.resize(value.length());
                buffer = this.buffer;
            }
            for (int i = 0; i < value.length(); ++i) {
                buffer[bufferLen] = value.charAt(i);
                ++bufferLen;
            }
            this.bufferLen = bufferLen;
        }
    }

    private void resize(int extraCount) {
        int capacity = this.buffer.length;
        long required = (long)capacity + (long)extraCount;
        long newCount = Math.min(Math.max((long)capacity << 1, required), Integer.MAX_VALUE);
        if (newCount < required) {
            throw new OutOfMemoryError();
        }
        char[] newArray = new char[(int)newCount];
        System.arraycopy(this.buffer, 0, newArray, 0, this.bufferLen);
        this.buffer = newArray;
    }

    public void clear() {
        this.bufferLen = 0;
    }

    public String toString() {
        return new String(this.buffer, 0, this.bufferLen);
    }
}

