/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt;

import com.github.icedland.iced.x86.fmt.FormatterOptions;

public final class NumberFormattingOptions {
    public String digitSeparator;
    public String prefix;
    public String suffix;
    public byte digitGroupSize;
    public int numberBase;
    public boolean uppercaseHex;
    public boolean smallHexNumbersInDecimal;
    public boolean addLeadingZeroToHexNumbers;
    public boolean leadingZeros;
    public boolean signedNumber;
    public boolean displacementLeadingZeros;

    public static NumberFormattingOptions createImmediate(FormatterOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        return new NumberFormattingOptions(options, options.getLeadingZeros(), options.getSignedImmediateOperands(), false);
    }

    public static NumberFormattingOptions createDisplacement(FormatterOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        return new NumberFormattingOptions(options, options.getLeadingZeros(), options.getSignedMemoryDisplacements(), options.getDisplacementLeadingZeros());
    }

    public static NumberFormattingOptions createBranch(FormatterOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        return new NumberFormattingOptions(options, options.getBranchLeadingZeros(), false, false);
    }

    public NumberFormattingOptions(FormatterOptions options, boolean leadingZeros, boolean signedNumber, boolean displacementLeadingZeros) {
        int digitGroupSize;
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.leadingZeros = leadingZeros;
        this.signedNumber = signedNumber;
        this.displacementLeadingZeros = displacementLeadingZeros;
        this.numberBase = options.getNumberBase();
        this.digitSeparator = options.getDigitSeparator();
        this.uppercaseHex = options.getUppercaseHex();
        this.smallHexNumbersInDecimal = options.getSmallHexNumbersInDecimal();
        this.addLeadingZeroToHexNumbers = options.getAddLeadingZeroToHexNumbers();
        switch (options.getNumberBase()) {
            case 0: {
                this.prefix = options.getHexPrefix();
                this.suffix = options.getHexSuffix();
                digitGroupSize = options.getHexDigitGroupSize();
                break;
            }
            case 1: {
                this.prefix = options.getDecimalPrefix();
                this.suffix = options.getDecimalSuffix();
                digitGroupSize = options.getDecimalDigitGroupSize();
                break;
            }
            case 2: {
                this.prefix = options.getOctalPrefix();
                this.suffix = options.getOctalSuffix();
                digitGroupSize = options.getOctalDigitGroupSize();
                break;
            }
            case 3: {
                this.prefix = options.getBinaryPrefix();
                this.suffix = options.getBinarySuffix();
                digitGroupSize = options.getBinaryDigitGroupSize();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.digitGroupSize = digitGroupSize < 0 ? (byte)0 : (digitGroupSize > 127 ? (byte)127 : (byte)digitGroupSize);
    }
}

