/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

final class OpMRBX
extends Op {
    OpMRBX() {
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        int regSize;
        if (!encoder.verifyOpKind(operand, 24, instruction.getOpKind(operand))) {
            return;
        }
        int baseReg = instruction.getMemoryBase();
        if (instruction.getMemoryDisplSize() != 0 || instruction.getMemoryDisplacement64() != 0L || instruction.getMemoryIndexScale() != 1 || instruction.getMemoryIndex() != 1 || baseReg != 24 && baseReg != 40 && baseReg != 56) {
            encoder.setErrorMessage(String.format("Operand %d: Operand must be [bx+al], [ebx+al], or [rbx+al]", operand));
            return;
        }
        if (baseReg == 56) {
            regSize = 8;
        } else if (baseReg == 40) {
            regSize = 4;
        } else {
            assert (baseReg == 24) : baseReg;
            regSize = 2;
        }
        encoder.setAddrSize(regSize);
    }
}

