/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

final class OpIsX
extends Op {
    private final int regLo;
    private final int regHi;

    OpIsX(int regLo, int regHi) {
        this.regLo = regLo;
        this.regHi = regHi;
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        if (!encoder.verifyOpKind(operand, 0, instruction.getOpKind(operand))) {
            return;
        }
        int reg = instruction.getOpRegister(operand);
        if (!encoder.verify(operand, reg, this.regLo, this.regHi)) {
            return;
        }
        encoder.immSize = 17;
        encoder.immediate = reg - this.regLo << 4;
    }
}

