/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

final class OpIb
extends Op {
    private final int opKind;

    OpIb(int opKind) {
        this.opKind = opKind;
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        switch (encoder.immSize) {
            case 1: {
                if (!encoder.verifyOpKind(operand, 7, instruction.getOpKind(operand))) {
                    return;
                }
                encoder.immSize = 6;
                encoder.immediateHi = instruction.getImmediate8_2nd();
                break;
            }
            case 2: {
                if (!encoder.verifyOpKind(operand, 7, instruction.getOpKind(operand))) {
                    return;
                }
                encoder.immSize = 5;
                encoder.immediateHi = instruction.getImmediate8_2nd();
                break;
            }
            default: {
                int opImmKind = instruction.getOpKind(operand);
                if (!encoder.verifyOpKind(operand, this.opKind, opImmKind)) {
                    return;
                }
                encoder.immSize = 1;
                encoder.immediate = instruction.getImmediate8();
            }
        }
    }

    @Override
    public int getImmediateOpKind() {
        return this.opKind;
    }
}

