/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Code;
import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Block;
import com.github.icedland.iced.x86.enc.BlockData;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Instr;
import com.github.icedland.iced.x86.enc.TargetInstr;
import com.github.icedland.iced.x86.enc.TryEncodeResult;

final class JmpInstr
extends Instr {
    private final byte bitness;
    private Instruction instruction;
    private TargetInstr targetInstr;
    private BlockData pointerData;
    private byte instrKind;
    private final byte shortInstructionSize;
    private final byte nearInstructionSize;

    public JmpInstr(BlockEncoder blockEncoder, Block block, Instruction instruction) {
        super(block, instruction.getIP());
        this.bitness = (byte)blockEncoder.getBitness();
        this.instruction = instruction;
        this.instrKind = (byte)4;
        if (!blockEncoder.fixBranches()) {
            this.instrKind = 0;
            Instruction instrCopy = instruction.copy();
            instrCopy.setNearBranch64(0L);
            this.size = blockEncoder.getInstructionSize(instrCopy, 0L);
            this.shortInstructionSize = 0;
            this.nearInstructionSize = 0;
        } else {
            Instruction instrCopy = instruction.copy();
            instrCopy.setCode(Code.toShortBranch(instruction.getCode()));
            instrCopy.setNearBranch64(0L);
            this.shortInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, 0L);
            instrCopy.setCode(Code.toNearBranch(instruction.getCode()));
            instrCopy.setNearBranch64(0L);
            this.nearInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, 0L);
            this.size = blockEncoder.getBitness() == 64 ? Math.max(this.nearInstructionSize, 6) : (int)this.nearInstructionSize;
        }
    }

    @Override
    void initialize(BlockEncoder blockEncoder) {
        this.targetInstr = blockEncoder.getTarget(this.instruction.getNearBranchTarget());
    }

    @Override
    boolean optimize(long gained) {
        return this.tryOptimize(gained);
    }

    private boolean tryOptimize(long gained) {
        boolean useNear;
        if (this.instrKind == 0 || this.instrKind == 1) {
            this.done = true;
            return false;
        }
        long targetAddress = this.targetInstr.getAddress();
        long nextRip = this.ip + (long)this.shortInstructionSize;
        long diff = targetAddress - nextRip;
        diff = JmpInstr.convertDiffToBitnessDiff(this.bitness, JmpInstr.correctDiff(this.targetInstr.isInBlock(this.block), diff, gained));
        if (-128L <= diff && diff <= 127L) {
            if (this.pointerData != null) {
                this.pointerData.isValid = false;
            }
            this.instrKind = 1;
            this.size = this.shortInstructionSize;
            this.done = true;
            return true;
        }
        boolean bl = useNear = this.bitness != 64 || this.targetInstr.isInBlock(this.block);
        if (!useNear) {
            targetAddress = this.targetInstr.getAddress();
            nextRip = this.ip + (long)this.nearInstructionSize;
            diff = targetAddress - nextRip;
            diff = JmpInstr.convertDiffToBitnessDiff(this.bitness, JmpInstr.correctDiff(this.targetInstr.isInBlock(this.block), diff, gained));
            boolean bl2 = useNear = Integer.MIN_VALUE <= diff && diff <= Integer.MAX_VALUE;
        }
        if (useNear) {
            if (this.pointerData != null) {
                this.pointerData.isValid = false;
            }
            if (diff < -1920L || diff > 1905L) {
                this.done = true;
            }
            this.instrKind = (byte)2;
            this.size = this.nearInstructionSize;
            return true;
        }
        if (this.pointerData == null) {
            this.pointerData = this.block.allocPointerLocation();
        }
        this.instrKind = (byte)3;
        return false;
    }

    @Override
    String tryEncode(Encoder encoder, TryEncodeResult result) {
        switch (this.instrKind) {
            case 0: 
            case 1: 
            case 2: {
                result.isOriginalInstruction = true;
                Instruction instruction = this.instruction.copy();
                if (this.instrKind != 0) {
                    if (this.instrKind == 1) {
                        instruction.setCode(Code.toShortBranch(instruction.getCode()));
                    } else {
                        assert (this.instrKind == 2) : this.instrKind;
                        instruction.setCode(Code.toNearBranch(instruction.getCode()));
                    }
                }
                instruction.setNearBranch64(this.targetInstr.getAddress());
                Object encResult = encoder.tryEncode(instruction, this.ip);
                if (encResult instanceof String) {
                    return JmpInstr.createErrorMessage((String)encResult, instruction);
                }
                result.constantOffsets = encoder.getConstantOffsets();
                return null;
            }
            case 3: {
                assert (this.pointerData != null);
                result.isOriginalInstruction = false;
                result.constantOffsets = new ConstantOffsets();
                this.pointerData.data = this.targetInstr.getAddress();
                Object encResult = this.encodeBranchToPointerData(encoder, false, this.ip, this.pointerData, this.size);
                if (encResult instanceof String) {
                    return JmpInstr.createErrorMessage((String)encResult, this.instruction);
                }
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final class InstrKind {
        static final byte UNCHANGED = 0;
        static final byte SHORT = 1;
        static final byte NEAR = 2;
        static final byte LONG = 3;
        static final byte UNINITIALIZED = 4;

        private InstrKind() {
        }
    }
}

