/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;
import com.github.icedland.iced.x86.enc.OpCodeHandler;
import com.github.icedland.iced.x86.enc.OpTables;
import com.github.icedland.iced.x86.internal.MvexInfo;
import com.github.icedland.iced.x86.internal.MvexTupleTypeLut;
import com.github.icedland.iced.x86.internal.TupleTypeTable;

public final class InternalOpCodeHandlers {
    private InternalOpCodeHandlers() {
    }

    @Deprecated
    public static final class D3nowHandler
    extends OpCodeHandler {
        final int immediate;

        public D3nowHandler(int encFlags2, int encFlags3) {
            super(encFlags2 & 0xFFFF0000 | 0xF, encFlags3, false, null, Op.operands_3dnow);
            this.immediate = D3nowHandler.getOpCode(encFlags2);
            assert (Integer.compareUnsigned(this.immediate, 255) <= 0) : this.immediate;
        }

        @Override
        void encode(Encoder encoder, Instruction instruction) {
            encoder.writePrefixes(instruction);
            encoder.writeByteInternal(15);
            encoder.immSize = 18;
            encoder.immediate = this.immediate;
        }
    }

    @Deprecated
    public static final class MvexHandler
    extends OpCodeHandler {
        private final int wbit;
        private final int table;
        private final int p1Bits;
        private final int mask_W;
        static final OpCodeHandler.TryConvertToDisp8N tryConvertToDisp8N = new TryConvertToDisp8NImpl();

        private static Op[] createOps(int encFlags1) {
            int op0 = encFlags1 >>> 0 & 0xF;
            int op1 = encFlags1 >>> 4 & 0xF;
            int op2 = encFlags1 >>> 8 & 0xF;
            int op3 = encFlags1 >>> 12 & 0xF;
            if (op3 != 0) {
                assert (op0 != 0 && op1 != 0 && op2 != 0);
                return new Op[]{OpTables.mvexOps[op0 - 1], OpTables.mvexOps[op1 - 1], OpTables.mvexOps[op2 - 1], OpTables.mvexOps[op3 - 1]};
            }
            if (op2 != 0) {
                assert (op0 != 0 && op1 != 0);
                return new Op[]{OpTables.mvexOps[op0 - 1], OpTables.mvexOps[op1 - 1], OpTables.mvexOps[op2 - 1]};
            }
            if (op1 != 0) {
                assert (op0 != 0);
                return new Op[]{OpTables.mvexOps[op0 - 1], OpTables.mvexOps[op1 - 1]};
            }
            if (op0 != 0) {
                return new Op[]{OpTables.mvexOps[op0 - 1]};
            }
            return new Op[0];
        }

        public MvexHandler(int encFlags1, int encFlags2, int encFlags3) {
            super(encFlags2, encFlags3, false, tryConvertToDisp8N, MvexHandler.createOps(encFlags1));
            int p1BitsTmp = 0;
            int mask_W_tmp = 0;
            this.table = encFlags2 >>> 17 & 7;
            p1BitsTmp = encFlags2 >>> 20 & 3;
            this.wbit = encFlags2 >>> 22 & 3;
            if (this.wbit == 1) {
                p1BitsTmp |= 0x80;
            }
            if (this.wbit == 2) {
                mask_W_tmp |= 0x80;
            }
            this.p1Bits = p1BitsTmp;
            this.mask_W = mask_W_tmp;
        }

        @Override
        void encode(Encoder encoder, Instruction instruction) {
            encoder.writePrefixes(instruction);
            int encoderFlags = encoder.encoderFlags;
            encoder.writeByteInternal(98);
            int b = this.table;
            b |= (encoderFlags & 7) << 5;
            b |= encoderFlags >>> 5 & 0x10;
            encoder.writeByteInternal(b ^= 0xFFFFFFF0);
            b = this.p1Bits;
            b |= ~encoderFlags >>> 24 & 0x78;
            encoder.writeByteInternal(b |= this.mask_W & encoder.internal_MVEX_WIG);
            b = instruction.getRawOpMask();
            if (b != 0) {
                if ((this.encFlags3 & 0x20000000) == 0) {
                    encoder.setErrorMessage("The instruction doesn't support opmask registers");
                }
            } else if ((this.encFlags3 & Integer.MIN_VALUE) != 0) {
                encoder.setErrorMessage("The instruction must use an opmask register");
            }
            b |= encoderFlags >>> 28 & 8;
            int conv = instruction.getMvexRegMemConv();
            if (instruction.getOp0Kind() == 24 || instruction.getOp1Kind() == 24 || instruction.getOp2Kind() == 24) {
                if (conv >= 9 && conv <= 16) {
                    b |= conv - 9 << 4;
                } else if (conv != 0) {
                    encoder.setErrorMessage("Memory operands must use a valid MvexRegMemConv variant, eg. MvexRegMemConv.MEM_CONV_NONE");
                }
                if (instruction.getMvexEvictionHint()) {
                    if (MvexInfo.canUseEvictionHint(instruction.getCode())) {
                        b |= 0x80;
                    } else {
                        encoder.setErrorMessage("This instruction doesn't support eviction hint (`{eh}`)");
                    }
                }
            } else {
                if (instruction.getMvexEvictionHint()) {
                    encoder.setErrorMessage("Only memory operands can enable eviction hint (`{eh}`)");
                }
                if (conv == 0) {
                    int rc;
                    b |= 0x80;
                    if (instruction.getSuppressAllExceptions()) {
                        b |= 0x40;
                        if ((this.encFlags3 & 0x10000000) == 0) {
                            encoder.setErrorMessage("The instruction doesn't support suppress-all-exceptions");
                        }
                    }
                    if ((rc = instruction.getRoundingControl()) != 0) {
                        if ((this.encFlags3 & 0x8000000) == 0) {
                            encoder.setErrorMessage("The instruction doesn't support rounding control");
                        } else {
                            b |= rc - 1 << 4;
                        }
                    }
                } else if (conv >= 1 && conv <= 8) {
                    if (instruction.getSuppressAllExceptions()) {
                        encoder.setErrorMessage("Can't use {sae} with register swizzles");
                    } else if (instruction.getRoundingControl() != 0) {
                        encoder.setErrorMessage("Can't use rounding control with register swizzles");
                    }
                    b |= (conv - 1 & 7) << 4;
                } else {
                    encoder.setErrorMessage("Register operands can't use memory up/down conversions");
                }
            }
            if (MvexInfo.getEHBit(instruction.getCode()) == 2) {
                b |= 0x80;
            }
            encoder.writeByteInternal(b ^= 8);
        }

        static final class TryConvertToDisp8NImpl
        extends OpCodeHandler.TryConvertToDisp8N {
            TryConvertToDisp8NImpl() {
            }

            @Override
            Integer convert(Encoder encoder, OpCodeHandler handler, Instruction instruction, int displ) {
                int sss = instruction.getMvexRegMemConv() - 9 & 7;
                byte tupleType = MvexTupleTypeLut.data[MvexInfo.getTupleTypeLutKind(instruction.getCode()) * 8 + sss];
                int n = TupleTypeTable.getDisp8N(tupleType, false);
                int res = displ / n;
                if (res * n == displ && -128 <= res && res <= 127) {
                    return res;
                }
                return null;
            }
        }
    }

    @Deprecated
    public static final class EvexHandler
    extends OpCodeHandler {
        private final int wbit;
        private final int tupleType;
        private final int table;
        private final int p1Bits;
        private final int llBits;
        private final int mask_W;
        private final int mask_LL;
        static final OpCodeHandler.TryConvertToDisp8N tryConvertToDisp8N = new TryConvertToDisp8NImpl();

        private static Op[] createOps(int encFlags1) {
            int op0 = encFlags1 >>> 0 & 0x1F;
            int op1 = encFlags1 >>> 5 & 0x1F;
            int op2 = encFlags1 >>> 10 & 0x1F;
            int op3 = encFlags1 >>> 15 & 0x1F;
            if (op3 != 0) {
                assert (op0 != 0 && op1 != 0 && op2 != 0);
                return new Op[]{OpTables.evexOps[op0 - 1], OpTables.evexOps[op1 - 1], OpTables.evexOps[op2 - 1], OpTables.evexOps[op3 - 1]};
            }
            if (op2 != 0) {
                assert (op0 != 0 && op1 != 0);
                return new Op[]{OpTables.evexOps[op0 - 1], OpTables.evexOps[op1 - 1], OpTables.evexOps[op2 - 1]};
            }
            if (op1 != 0) {
                assert (op0 != 0);
                return new Op[]{OpTables.evexOps[op0 - 1], OpTables.evexOps[op1 - 1]};
            }
            if (op0 != 0) {
                return new Op[]{OpTables.evexOps[op0 - 1]};
            }
            return new Op[0];
        }

        public EvexHandler(int encFlags1, int encFlags2, int encFlags3) {
            super(encFlags2, encFlags3, false, tryConvertToDisp8N, EvexHandler.createOps(encFlags1));
            int mask_LL_tmp = 0;
            int p1BitsTmp = 0;
            int mask_W_tmp = 0;
            this.tupleType = encFlags3 >>> 7 & 0x1F;
            this.table = encFlags2 >>> 17 & 7;
            p1BitsTmp = 4 | encFlags2 >>> 20 & 3;
            this.wbit = encFlags2 >>> 22 & 3;
            if (this.wbit == 1) {
                p1BitsTmp |= 0x80;
            }
            switch (encFlags2 >>> 24 & 7) {
                case 2: {
                    this.llBits = 0;
                    mask_LL_tmp = 96;
                    break;
                }
                case 0: 
                case 3: 
                case 4: {
                    this.llBits = 0;
                    break;
                }
                case 1: 
                case 5: {
                    this.llBits = 32;
                    break;
                }
                case 6: {
                    this.llBits = 64;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.wbit == 2) {
                mask_W_tmp |= 0x80;
            }
            this.mask_LL = mask_LL_tmp;
            this.p1Bits = p1BitsTmp;
            this.mask_W = mask_W_tmp;
        }

        @Override
        void encode(Encoder encoder, Instruction instruction) {
            int rc;
            encoder.writePrefixes(instruction);
            int encoderFlags = encoder.encoderFlags;
            encoder.writeByteInternal(98);
            int b = this.table;
            b |= (encoderFlags & 7) << 5;
            b |= encoderFlags >>> 5 & 0x10;
            encoder.writeByteInternal(b ^= 0xFFFFFFF0);
            b = this.p1Bits;
            b |= ~encoderFlags >>> 24 & 0x78;
            encoder.writeByteInternal(b |= this.mask_W & encoder.internal_EVEX_WIG);
            b = instruction.getRawOpMask();
            if (b != 0) {
                if ((this.encFlags3 & 0x20000000) == 0) {
                    encoder.setErrorMessage("The instruction doesn't support opmask registers");
                }
            } else if ((this.encFlags3 & Integer.MIN_VALUE) != 0) {
                encoder.setErrorMessage("The instruction must use an opmask register");
            }
            b |= encoderFlags >>> 28 & 8;
            if (instruction.getSuppressAllExceptions()) {
                if ((this.encFlags3 & 0x10000000) == 0) {
                    encoder.setErrorMessage("The instruction doesn't support suppress-all-exceptions");
                }
                b |= 0x10;
            }
            if ((rc = instruction.getRoundingControl()) != 0) {
                if ((this.encFlags3 & 0x8000000) == 0) {
                    encoder.setErrorMessage("The instruction doesn't support rounding control");
                }
                b |= 0x10;
                b |= rc - 1 << 5;
            } else if ((this.encFlags3 & 0x10000000) == 0 || !instruction.getSuppressAllExceptions()) {
                b |= this.llBits;
            }
            if ((encoderFlags & 0x400) != 0) {
                b |= 0x10;
            } else if (instruction.getBroadcast()) {
                encoder.setErrorMessage("The instruction doesn't support broadcasting");
            }
            if (instruction.getZeroingMasking()) {
                if ((this.encFlags3 & 0x40000000) == 0) {
                    encoder.setErrorMessage("The instruction doesn't support zeroing masking");
                }
                b |= 0x80;
            }
            b ^= 8;
            encoder.writeByteInternal(b |= this.mask_LL & encoder.internal_EVEX_LIG);
        }

        static final class TryConvertToDisp8NImpl
        extends OpCodeHandler.TryConvertToDisp8N {
            TryConvertToDisp8NImpl() {
            }

            @Override
            Integer convert(Encoder encoder, OpCodeHandler handler, Instruction instruction, int displ) {
                EvexHandler evexHandler = (EvexHandler)handler;
                int n = TupleTypeTable.getDisp8N(evexHandler.tupleType, (encoder.encoderFlags & 0x400) != 0);
                int res = displ / n;
                if (res * n == displ && -128 <= res && res <= 127) {
                    return res;
                }
                return null;
            }
        }
    }

    @Deprecated
    public static final class XopHandler
    extends OpCodeHandler {
        private final int table;
        private final int lastByte;

        private static Op[] createOps(int encFlags1) {
            int op0 = encFlags1 >>> 0 & 0x1F;
            int op1 = encFlags1 >>> 5 & 0x1F;
            int op2 = encFlags1 >>> 10 & 0x1F;
            int op3 = encFlags1 >>> 15 & 0x1F;
            if (op3 != 0) {
                assert (op0 != 0 && op1 != 0 && op2 != 0);
                return new Op[]{OpTables.xopOps[op0 - 1], OpTables.xopOps[op1 - 1], OpTables.xopOps[op2 - 1], OpTables.xopOps[op3 - 1]};
            }
            if (op2 != 0) {
                assert (op0 != 0 && op1 != 0);
                return new Op[]{OpTables.xopOps[op0 - 1], OpTables.xopOps[op1 - 1], OpTables.xopOps[op2 - 1]};
            }
            if (op1 != 0) {
                assert (op0 != 0);
                return new Op[]{OpTables.xopOps[op0 - 1], OpTables.xopOps[op1 - 1]};
            }
            if (op0 != 0) {
                return new Op[]{OpTables.xopOps[op0 - 1]};
            }
            return new Op[0];
        }

        public XopHandler(int encFlags1, int encFlags2, int encFlags3) {
            super(encFlags2, encFlags3, false, null, XopHandler.createOps(encFlags1));
            int lastByteTmp = 0;
            this.table = 8 + (encFlags2 >>> 17 & 7);
            assert (this.table == 8 || this.table == 9 || this.table == 10) : this.table;
            switch (encFlags2 >>> 24 & 7) {
                case 1: 
                case 5: {
                    lastByteTmp = 4;
                }
            }
            int wbit = encFlags2 >>> 22 & 3;
            if (wbit == 1) {
                lastByteTmp |= 0x80;
            }
            this.lastByte = lastByteTmp |= encFlags2 >>> 20 & 3;
        }

        @Override
        void encode(Encoder encoder, Instruction instruction) {
            encoder.writePrefixes(instruction);
            encoder.writeByteInternal(143);
            int encoderFlags = encoder.encoderFlags;
            int b = this.table;
            encoder.writeByteInternal(b |= (~encoderFlags & 7) << 5);
            b = this.lastByte;
            encoder.writeByteInternal(b |= ~encoderFlags >>> 24 & 0x78);
        }
    }

    @Deprecated
    public static final class VexHandler
    extends OpCodeHandler {
        private final int table;
        private final int lastByte;
        private final int mask_W_L;
        private final int mask_L;
        private final int W1;

        private static Op[] createOps(int encFlags1) {
            int op0 = encFlags1 >>> 0 & 0x3F;
            int op1 = encFlags1 >>> 6 & 0x3F;
            int op2 = encFlags1 >>> 12 & 0x3F;
            int op3 = encFlags1 >>> 18 & 0x3F;
            int op4 = encFlags1 >>> 24 & 0x3F;
            if (op4 != 0) {
                assert (op0 != 0 && op1 != 0 && op2 != 0 && op3 != 0);
                return new Op[]{OpTables.vexOps[op0 - 1], OpTables.vexOps[op1 - 1], OpTables.vexOps[op2 - 1], OpTables.vexOps[op3 - 1], OpTables.vexOps[op4 - 1]};
            }
            if (op3 != 0) {
                assert (op0 != 0 && op1 != 0 && op2 != 0);
                return new Op[]{OpTables.vexOps[op0 - 1], OpTables.vexOps[op1 - 1], OpTables.vexOps[op2 - 1], OpTables.vexOps[op3 - 1]};
            }
            if (op2 != 0) {
                assert (op0 != 0 && op1 != 0);
                return new Op[]{OpTables.vexOps[op0 - 1], OpTables.vexOps[op1 - 1], OpTables.vexOps[op2 - 1]};
            }
            if (op1 != 0) {
                assert (op0 != 0);
                return new Op[]{OpTables.vexOps[op0 - 1], OpTables.vexOps[op1 - 1]};
            }
            if (op0 != 0) {
                return new Op[]{OpTables.vexOps[op0 - 1]};
            }
            return new Op[0];
        }

        public VexHandler(int encFlags1, int encFlags2, int encFlags3) {
            super(encFlags2, encFlags3, false, null, VexHandler.createOps(encFlags1));
            int lastByteTmp = 0;
            int mask_W_L_tmp = 0;
            int mask_L_tmp = 0;
            this.table = encFlags2 >>> 17 & 7;
            int wbit = encFlags2 >>> 22 & 3;
            this.W1 = wbit == 1 ? -1 : 0;
            int lbit = encFlags2 >>> 24 & 7;
            switch (lbit) {
                case 1: 
                case 5: {
                    lastByteTmp = 4;
                }
            }
            if (this.W1 != 0) {
                lastByteTmp |= 0x80;
            }
            lastByteTmp |= encFlags2 >>> 20 & 3;
            if (wbit == 2) {
                mask_W_L_tmp |= 0x80;
            }
            if (lbit == 2) {
                mask_W_L_tmp |= 4;
                mask_L_tmp |= 4;
            }
            this.lastByte = lastByteTmp;
            this.mask_W_L = mask_W_L_tmp;
            this.mask_L = mask_L_tmp;
        }

        @Override
        void encode(Encoder encoder, Instruction instruction) {
            encoder.writePrefixes(instruction);
            int encoderFlags = encoder.encoderFlags;
            int b = this.lastByte;
            b |= ~encoderFlags >>> 24 & 0x78;
            if ((encoder.internal_PreventVEX2 | this.W1 | this.table - 1 | encoderFlags & 0xB) != 0) {
                encoder.writeByteInternal(196);
                int b2 = this.table;
                encoder.writeByteInternal(b2 |= (~encoderFlags & 7) << 5);
                encoder.writeByteInternal(b |= this.mask_W_L & encoder.internal_VEX_WIG_LIG);
            } else {
                encoder.writeByteInternal(197);
                b |= (~encoderFlags & 4) << 5;
                encoder.writeByteInternal(b |= this.mask_L & encoder.internal_VEX_LIG);
            }
        }
    }

    @Deprecated
    public static final class LegacyHandler
    extends OpCodeHandler {
        private final int tableByte1;
        private final int tableByte2;
        private final int mandatoryPrefix;

        private static Op[] createOps(int encFlags1) {
            int op0 = encFlags1 >>> 0 & 0x7F;
            int op1 = encFlags1 >>> 7 & 0x7F;
            int op2 = encFlags1 >>> 14 & 0x7F;
            int op3 = encFlags1 >>> 21 & 0x7F;
            if (op3 != 0) {
                assert (op0 != 0 && op1 != 0 && op2 != 0);
                return new Op[]{OpTables.legacyOps[op0 - 1], OpTables.legacyOps[op1 - 1], OpTables.legacyOps[op2 - 1], OpTables.legacyOps[op3 - 1]};
            }
            if (op2 != 0) {
                assert (op0 != 0 && op1 != 0);
                return new Op[]{OpTables.legacyOps[op0 - 1], OpTables.legacyOps[op1 - 1], OpTables.legacyOps[op2 - 1]};
            }
            if (op1 != 0) {
                assert (op0 != 0);
                return new Op[]{OpTables.legacyOps[op0 - 1], OpTables.legacyOps[op1 - 1]};
            }
            if (op0 != 0) {
                return new Op[]{OpTables.legacyOps[op0 - 1]};
            }
            return new Op[0];
        }

        public LegacyHandler(int encFlags1, int encFlags2, int encFlags3) {
            super(encFlags2, encFlags3, false, null, LegacyHandler.createOps(encFlags1));
            switch (encFlags2 >>> 17 & 7) {
                case 0: {
                    this.tableByte1 = 0;
                    this.tableByte2 = 0;
                    break;
                }
                case 1: {
                    this.tableByte1 = 15;
                    this.tableByte2 = 0;
                    break;
                }
                case 2: {
                    this.tableByte1 = 15;
                    this.tableByte2 = 56;
                    break;
                }
                case 3: {
                    this.tableByte1 = 15;
                    this.tableByte2 = 58;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            switch (encFlags2 >>> 20 & 3) {
                case 0: {
                    this.mandatoryPrefix = 0;
                    break;
                }
                case 1: {
                    this.mandatoryPrefix = 102;
                    break;
                }
                case 2: {
                    this.mandatoryPrefix = 243;
                    break;
                }
                case 3: {
                    this.mandatoryPrefix = 242;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        @Override
        void encode(Encoder encoder, Instruction instruction) {
            int b = this.mandatoryPrefix;
            encoder.writePrefixes(instruction, b != 243);
            if (b != 0) {
                encoder.writeByteInternal(b);
            }
            b = encoder.encoderFlags;
            if ((b &= 0x4F) != 0) {
                if ((encoder.encoderFlags & 0x800) != 0) {
                    encoder.setErrorMessage("Registers AH, CH, DH, BH can't be used if there's a REX prefix. Use AL, CL, DL, BL, SPL, BPL, SIL, DIL, R8L-R15L instead.");
                }
                encoder.writeByteInternal(b |= 0x40);
            }
            if ((b = this.tableByte1) != 0) {
                encoder.writeByteInternal(b);
                b = this.tableByte2;
                if (b != 0) {
                    encoder.writeByteInternal(b);
                }
            }
        }
    }

    @Deprecated
    public static final class ZeroBytesHandler
    extends OpCodeHandler {
        public ZeroBytesHandler(int code) {
            super(0, 196608, true, null, new Op[0]);
        }

        @Override
        void encode(Encoder encoder, Instruction instruction) {
        }
    }

    @Deprecated
    public static final class DeclareDataHandler
    extends OpCodeHandler {
        final int elemLength;
        final int maxLength;

        public DeclareDataHandler(int code) {
            super(0, 196608, true, null, new Op[0]);
            switch (code) {
                case 1: {
                    this.elemLength = 1;
                    break;
                }
                case 2: {
                    this.elemLength = 2;
                    break;
                }
                case 3: {
                    this.elemLength = 4;
                    break;
                }
                case 4: {
                    this.elemLength = 8;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.maxLength = 16 / this.elemLength;
        }

        @Override
        void encode(Encoder encoder, Instruction instruction) {
            int declDataCount = instruction.getDeclareDataCount();
            if (declDataCount < 1 || declDataCount > this.maxLength) {
                encoder.setErrorMessage(String.format("Invalid db/dw/dd/dq data count. Count = %d, max count = %d", declDataCount, this.maxLength));
                return;
            }
            int length = declDataCount * this.elemLength;
            for (int i = 0; i < length; ++i) {
                encoder.writeByteInternal(instruction.getDeclareByteValue(i));
            }
        }
    }

    @Deprecated
    public static final class InvalidHandler
    extends OpCodeHandler {
        public static final String ERROR_MESSAGE = "Can't encode an invalid instruction";

        public InvalidHandler() {
            super(0, 196608, false, null, new Op[0]);
        }

        @Override
        void encode(Encoder encoder, Instruction instruction) {
            encoder.setErrorMessage(ERROR_MESSAGE);
        }
    }
}

