/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandler;

final class OpCodeHandler_Xchg_Reg_rAX
extends OpCodeHandler {
    private final int index;
    private final int[] codes;
    private static final int[] s_codes = new int[]{299, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 300, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 301, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304};

    OpCodeHandler_Xchg_Reg_rAX(int index) {
        assert (0 <= index && index <= 7) : index;
        this.index = index;
        this.codes = s_codes;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (this.index == 0 && decoder.state_zs_mandatoryPrefix == 2 && (decoder.options & 0x2000) == 0) {
            decoder.clearMandatoryPrefixF3(instruction);
            instruction.setCode(305);
        } else {
            byte sizeIndex = decoder.state_operandSize;
            int codeIndex = this.index + decoder.state_zs_extraBaseRegisterBase;
            instruction.setCode(this.codes[sizeIndex * 16 + codeIndex]);
            if (codeIndex != 0) {
                int reg = sizeIndex * 16 + codeIndex + 21;
                instruction.setOp0Register(reg);
                instruction.setOp1Register(sizeIndex * 16 + 21);
            }
        }
    }
}

