/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandler;

final class OpCodeHandler_MandatoryPrefix4
extends OpCodeHandler {
    private final OpCodeHandler handlerNP;
    private final OpCodeHandler handler66;
    private final OpCodeHandler handlerF3;
    private final OpCodeHandler handlerF2;
    private final int flags;

    OpCodeHandler_MandatoryPrefix4(OpCodeHandler handlerNP, OpCodeHandler handler66, OpCodeHandler handlerF3, OpCodeHandler handlerF2, int flags) {
        if (handlerNP == null) {
            throw new NullPointerException();
        }
        if (handler66 == null) {
            throw new NullPointerException();
        }
        if (handlerF3 == null) {
            throw new NullPointerException();
        }
        if (handlerF2 == null) {
            throw new NullPointerException();
        }
        this.handlerNP = handlerNP;
        this.handler66 = handler66;
        this.handlerF3 = handlerF3;
        this.handlerF2 = handlerF2;
        this.flags = flags;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        OpCodeHandler handler;
        byte prefix = decoder.state_zs_mandatoryPrefix;
        switch (prefix) {
            case 0: {
                handler = this.handlerNP;
                break;
            }
            case 1: {
                handler = this.handler66;
                break;
            }
            case 2: {
                if ((this.flags & 4) != 0) {
                    decoder.clearMandatoryPrefixF3(instruction);
                }
                handler = this.handlerF3;
                break;
            }
            case 3: {
                if ((this.flags & 8) != 0) {
                    decoder.clearMandatoryPrefixF2(instruction);
                }
                handler = this.handlerF2;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (handler.hasModRM && (this.flags & 0x10) != 0) {
            decoder.readModRM();
        }
        handler.decode(decoder, instruction);
    }
}

