/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_EVEX_WkV
extends OpCodeHandlerModRM {
    private final int baseReg1;
    private final int baseReg2;
    private final int code;
    private final int tupleType;
    private final int disallowZeroingMasking;

    OpCodeHandler_EVEX_WkV(int baseReg, int code, int tupleType) {
        this.baseReg1 = baseReg;
        this.baseReg2 = baseReg;
        this.code = code;
        this.tupleType = tupleType;
        this.disallowZeroingMasking = 0;
    }

    OpCodeHandler_EVEX_WkV(int baseReg, int code, int tupleType, boolean allowZeroingMasking) {
        this.baseReg1 = baseReg;
        this.baseReg2 = baseReg;
        this.code = code;
        this.tupleType = tupleType;
        this.disallowZeroingMasking = allowZeroingMasking ? 0 : -1;
    }

    OpCodeHandler_EVEX_WkV(int baseReg1, int baseReg2, int code, int tupleType) {
        this.baseReg1 = baseReg1;
        this.baseReg2 = baseReg2;
        this.code = code;
        this.tupleType = tupleType;
        this.disallowZeroingMasking = 0;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (((decoder.state_zs_flags & 0x10 | decoder.state_vvvv_invalidCheck) & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        instruction.setCode(this.code);
        instruction.setOp1Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + decoder.state_extraRegisterBaseEVEX + this.baseReg2);
        if ((decoder.state_zs_flags & 0x20 & this.disallowZeroingMasking & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        if (decoder.state_mod == 3) {
            instruction.setOp0Register(decoder.state_rm + decoder.state_extraBaseRegisterBaseEVEX + this.baseReg1);
        } else {
            instruction.setOp0Kind(24);
            if ((decoder.state_zs_flags & 0x20 & decoder.invalidCheckMask) != 0) {
                decoder.setInvalidInstruction();
            }
            decoder.readOpMem(instruction, this.tupleType);
        }
    }
}

