/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_EVEX_Ev_VX
extends OpCodeHandlerModRM {
    private final int code32;
    private final int code64;
    private final int tupleTypeW0;
    private final int tupleTypeW1;

    OpCodeHandler_EVEX_Ev_VX(int code32, int code64, int tupleTypeW0, int tupleTypeW1) {
        this.code32 = code32;
        this.code64 = code64;
        this.tupleTypeW0 = tupleTypeW0;
        this.tupleTypeW1 = tupleTypeW1;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        int gpr;
        int tupleType;
        if (((decoder.state_zs_flags & 0x30 | decoder.state_vvvv_invalidCheck | decoder.state_aaa) & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        instruction.setOp1Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + decoder.state_extraRegisterBaseEVEX + 77);
        if ((decoder.state_zs_flags & decoder.is64bMode_and_W) != 0) {
            instruction.setCode(this.code64);
            tupleType = this.tupleTypeW1;
            gpr = 53;
        } else {
            instruction.setCode(this.code32);
            tupleType = this.tupleTypeW0;
            gpr = 37;
        }
        if (decoder.state_mod == 3) {
            instruction.setOp0Register(decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + gpr);
        } else {
            instruction.setOp0Kind(24);
            decoder.readOpMem(instruction, tupleType);
        }
    }
}

