/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_EVEX_Ed_V_Ib
extends OpCodeHandlerModRM {
    private final int baseReg;
    private final int code32;
    private final int code64;
    private final int tupleType32;
    private final int tupleType64;

    OpCodeHandler_EVEX_Ed_V_Ib(int baseReg, int code32, int code64, int tupleType32, int tupleType64) {
        this.baseReg = baseReg;
        this.code32 = code32;
        this.code64 = code64;
        this.tupleType32 = tupleType32;
        this.tupleType64 = tupleType64;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        int gpr;
        if (((decoder.state_zs_flags & 0x30 | decoder.state_vvvv_invalidCheck | decoder.state_aaa) & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        if ((decoder.state_zs_flags & decoder.is64bMode_and_W) != 0) {
            instruction.setCode(this.code64);
            gpr = 53;
        } else {
            instruction.setCode(this.code32);
            gpr = 37;
        }
        if (decoder.state_mod == 3) {
            instruction.setOp0Register(decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + gpr);
        } else {
            instruction.setOp0Kind(24);
            if ((decoder.state_zs_flags & decoder.is64bMode_and_W) != 0) {
                decoder.readOpMem(instruction, this.tupleType64);
            } else {
                decoder.readOpMem(instruction, this.tupleType32);
            }
        }
        instruction.setOp1Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + decoder.state_extraRegisterBaseEVEX + this.baseReg);
        instruction.setOp2Kind(6);
        instruction.setImmediate8((byte)decoder.readByte());
    }
}

