/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_B_Ev
extends OpCodeHandlerModRM {
    private final int code32;
    private final int code64;
    private final int ripRelMask;

    OpCodeHandler_B_Ev(int code32, int code64, boolean supportsRipRel) {
        this.code32 = code32;
        this.code64 = code64;
        this.ripRelMask = supportsRipRel ? 0 : -1;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        int baseReg;
        if (decoder.state_reg > 3 || (decoder.state_zs_extraRegisterBase & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        if (decoder.is64bMode) {
            instruction.setCode(this.code64);
            baseReg = 53;
        } else {
            instruction.setCode(this.code32);
            baseReg = 37;
        }
        instruction.setOp0Register(decoder.state_reg + 181);
        if (decoder.state_mod == 3) {
            instruction.setOp1Register(decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + baseReg);
        } else {
            instruction.setOp1Kind(24);
            decoder.readOpMem_MPX(instruction);
            if ((this.ripRelMask & decoder.invalidCheckMask) != 0 && instruction.getMemoryBase() == 70) {
                decoder.setInvalidInstruction();
            }
        }
    }
}

