/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.asm;

import com.github.icedland.iced.x86.CodeWriter;
import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.MemoryOperand;
import com.github.icedland.iced.x86.Register;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister16;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegister8;
import com.github.icedland.iced.x86.asm.AsmRegisterBND;
import com.github.icedland.iced.x86.asm.AsmRegisterCR;
import com.github.icedland.iced.x86.asm.AsmRegisterDR;
import com.github.icedland.iced.x86.asm.AsmRegisterK;
import com.github.icedland.iced.x86.asm.AsmRegisterMM;
import com.github.icedland.iced.x86.asm.AsmRegisterST;
import com.github.icedland.iced.x86.asm.AsmRegisterSegment;
import com.github.icedland.iced.x86.asm.AsmRegisterTMM;
import com.github.icedland.iced.x86.asm.AsmRegisterTR;
import com.github.icedland.iced.x86.asm.AsmRegisterXMM;
import com.github.icedland.iced.x86.asm.AsmRegisterYMM;
import com.github.icedland.iced.x86.asm.AsmRegisterZMM;
import com.github.icedland.iced.x86.asm.CodeAssemblerResult;
import com.github.icedland.iced.x86.asm.CodeLabel;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.BlockEncoderResult;
import com.github.icedland.iced.x86.enc.InstructionBlock;
import java.util.ArrayList;
import java.util.List;

public class CodeAssembler {
    final int bitness;
    final ArrayList<Instruction> instructions;
    long currentLabelId;
    CodeLabel currentLabel;
    CodeLabel currentAnonLabel;
    CodeLabel nextAnonLabel;
    boolean definedAnonLabel;
    int prefixFlags;
    boolean preferVex;
    boolean preferShortBranch;

    public CodeAssembler(int bitness) {
        switch (bitness) {
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException("bitness");
            }
        }
        this.bitness = bitness;
        this.instructions = new ArrayList();
        this.currentLabelId = 0L;
        this.currentLabel = null;
        this.currentAnonLabel = null;
        this.nextAnonLabel = null;
        this.definedAnonLabel = false;
        this.prefixFlags = 0;
        this.preferVex = true;
        this.preferShortBranch = true;
    }

    public int getBitness() {
        return this.bitness;
    }

    public boolean getPreferVex() {
        return this.preferVex;
    }

    public void setPreferVex(boolean value) {
        this.preferVex = value;
    }

    public boolean getPreferShortBranch() {
        return this.preferShortBranch;
    }

    public void setPreferShortBranch(boolean value) {
        this.preferShortBranch = value;
    }

    boolean getInstructionPreferVex() {
        if ((this.prefixFlags & 0x30) != 0) {
            return (this.prefixFlags & 0x10) != 0;
        }
        return this.getPreferVex();
    }

    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    public void reset() {
        this.instructions.clear();
        this.currentLabelId = 0L;
        this.currentLabel = null;
        this.currentAnonLabel = null;
        this.nextAnonLabel = null;
        this.definedAnonLabel = false;
        this.prefixFlags = 0;
    }

    public CodeLabel createLabel() {
        return this.createLabel(null);
    }

    public CodeLabel createLabel(String name) {
        ++this.currentLabelId;
        CodeLabel label = new CodeLabel(name, this.currentLabelId);
        return label;
    }

    public CodeLabel getCurrentLabel() {
        return this.currentLabel;
    }

    public void label(CodeLabel label) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid label. Must be created via createLabel()");
        }
        if (label.getInstructionIndex() >= 0) {
            throw new IllegalArgumentException(String.format("Cannot reuse label. The specified label is already associated with an instruction at index %d.", label.getInstructionIndex()));
        }
        if (this.currentLabel != null) {
            throw new IllegalArgumentException("At most one label per instruction is allowed");
        }
        label.setInstructionIndex(this.instructions.size());
        this.currentLabel = label;
    }

    public void anonymousLabel() {
        if (this.definedAnonLabel) {
            throw new UnsupportedOperationException("At most one anonymous label per instruction is allowed");
        }
        this.currentAnonLabel = this.nextAnonLabel == null ? this.createLabel() : this.nextAnonLabel;
        this.nextAnonLabel = null;
        this.definedAnonLabel = true;
    }

    public CodeLabel b() {
        if (this.currentAnonLabel == null) {
            throw new UnsupportedOperationException("No anonymous label has been created yet");
        }
        return this.currentAnonLabel;
    }

    public CodeLabel f() {
        if (this.nextAnonLabel == null) {
            this.nextAnonLabel = this.createLabel();
        }
        return this.nextAnonLabel;
    }

    public void addInstruction(Instruction instruction) {
        if (this.currentLabel != null && this.definedAnonLabel) {
            throw new UnsupportedOperationException("You can't create both an anonymous label and a normal label");
        }
        if (this.currentLabel != null) {
            instruction.setIP(this.currentLabel.id);
        } else if (this.definedAnonLabel) {
            instruction.setIP(this.currentAnonLabel.id);
        }
        if (this.prefixFlags != 0) {
            if ((this.prefixFlags & 1) != 0) {
                instruction.setLockPrefix(true);
            }
            if ((this.prefixFlags & 2) != 0) {
                instruction.setRepePrefix(true);
            } else if ((this.prefixFlags & 4) != 0) {
                instruction.setRepnePrefix(true);
            }
            if ((this.prefixFlags & 8) != 0) {
                instruction.setSegmentPrefix(74);
            }
        }
        this.instructions.add(instruction);
        this.currentLabel = null;
        this.definedAnonLabel = false;
        this.prefixFlags = 0;
    }

    void addInstruction(Instruction instruction, int flags) {
        if (flags != 0) {
            if ((flags & 1) != 0) {
                instruction.setBroadcast(true);
            }
            if ((flags & 2) != 0) {
                instruction.setZeroingMasking(true);
            }
            if ((flags & 0x1C0) != 0) {
                instruction.setOpMask(173 + ((flags & 0x1C0) >>> 6));
            }
            if ((flags & 4) != 0) {
                instruction.setSuppressAllExceptions(true);
            }
            if ((flags & 0x38) != 0) {
                instruction.setRoundingControl((flags & 0x38) >>> 3);
            }
        }
        this.addInstruction(instruction);
    }

    public CodeAssembler lock() {
        this.prefixFlags |= 1;
        return this;
    }

    public CodeAssembler xacquire() {
        this.prefixFlags |= 4;
        return this;
    }

    public CodeAssembler xrelease() {
        this.prefixFlags |= 2;
        return this;
    }

    public CodeAssembler rep() {
        this.prefixFlags |= 2;
        return this;
    }

    public CodeAssembler repe() {
        this.prefixFlags |= 2;
        return this;
    }

    public CodeAssembler repz() {
        return this.repe();
    }

    public CodeAssembler repne() {
        this.prefixFlags |= 4;
        return this;
    }

    public CodeAssembler repnz() {
        return this.repne();
    }

    public CodeAssembler bnd() {
        this.prefixFlags |= 4;
        return this;
    }

    public CodeAssembler notrack() {
        this.prefixFlags |= 8;
        return this;
    }

    public CodeAssembler vex() {
        this.prefixFlags |= 0x10;
        return this;
    }

    public CodeAssembler evex() {
        this.prefixFlags |= 0x20;
        return this;
    }

    public void db(byte[] array) {
        this.db(array, 0, array.length);
    }

    public void db(byte[] array, int index, int length) {
        if (index < 0) {
            throw new IllegalArgumentException("index");
        }
        if (length < 0 || (long)(index + length) > (long)array.length) {
            throw new IllegalArgumentException("length");
        }
        int MAX_LENGTH = 16;
        int cycles = length / 16;
        int rest = length % 16;
        int currentPosition = index;
        for (int i = 0; i < cycles; ++i) {
            this.addInstruction(Instruction.createDeclareByte(array, currentPosition, 16));
            currentPosition += 16;
        }
        if (rest > 0) {
            this.addInstruction(Instruction.createDeclareByte(array, currentPosition, rest));
        }
    }

    public void call(int selector, int offset) {
        this.addInstruction(Instruction.createBranch(this.getBitness() >= 32 ? 313 : 312, selector, offset));
    }

    public void jmp(int selector, int offset) {
        this.addInstruction(Instruction.createBranch(this.getBitness() >= 32 ? 698 : 697, selector, offset));
    }

    public void xlatb() {
        ICRegister baseReg;
        switch (this.getBitness()) {
            case 64: {
                baseReg = ICRegisters.rbx;
                break;
            }
            case 32: {
                baseReg = ICRegisters.ebx;
                break;
            }
            default: {
                assert (this.getBitness() == 16) : this.getBitness();
                baseReg = ICRegisters.bx;
            }
        }
        this.addInstruction(Instruction.create(493, new MemoryOperand(baseReg, ICRegisters.al)));
    }

    public void nop(int sizeInBytes) {
        if (sizeInBytes < 0) {
            throw new IllegalArgumentException("sizeInBytes");
        }
        if (this.prefixFlags != 0) {
            throw new UnsupportedOperationException("No prefixes are allowed");
        }
        if (sizeInBytes == 0) {
            return;
        }
        int MAX_MULTIBYTE_NOP_INSTRUCTION_LENGTH = 9;
        int cycles = sizeInBytes / 9;
        int rest = sizeInBytes % 9;
        for (int i = 0; i < cycles; ++i) {
            this.appendNop(9);
        }
        if (rest > 0) {
            this.appendNop(rest);
        }
    }

    private void appendNop(int amount) {
        switch (amount) {
            case 1: {
                this.db(144);
                break;
            }
            case 2: {
                this.db(102, 144);
                break;
            }
            case 3: {
                this.db(15, 31, 0);
                break;
            }
            case 4: {
                this.db(15, 31, 64, 0);
                break;
            }
            case 5: {
                if (this.getBitness() != 16) {
                    this.db(15, 31, 68, 0, 0);
                    break;
                }
                this.db(15, 31, 128, 0, 0);
                break;
            }
            case 6: {
                if (this.getBitness() != 16) {
                    this.db(102, 15, 31, 68, 0, 0);
                    break;
                }
                this.db(102, 15, 31, 128, 0, 0);
                break;
            }
            case 7: {
                if (this.getBitness() != 16) {
                    this.db(15, 31, 128, 0, 0, 0, 0);
                    break;
                }
                this.db(103, 102, 15, 31, 68, 0, 0);
                break;
            }
            case 8: {
                if (this.getBitness() != 16) {
                    this.db(15, 31, 132, 0, 0, 0, 0, 0);
                    break;
                }
                this.db(103, 15, 31, 128, 0, 0, 0, 0);
                break;
            }
            case 9: {
                if (this.getBitness() != 16) {
                    this.db(102, 15, 31, 132, 0, 0, 0, 0, 0);
                    break;
                }
                this.db(103, 15, 31, 132, 0, 0, 0, 0, 0);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public Object assemble(CodeWriter writer, long rip) {
        return this.assemble(writer, rip, 0);
    }

    public Object assemble(CodeWriter writer, long rip, int options) {
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        if (this.prefixFlags != 0) {
            return String.format("Unused prefixes %d. You must emit an instruction after using an instruction prefix.", this.prefixFlags);
        }
        if (this.currentLabel != null) {
            return String.format("Unused label %s. You must emit an instruction after emitting a label.", this.currentLabel.toString());
        }
        if (this.definedAnonLabel) {
            return "Unused anonymous label. You must emit an instruction after emitting a label.";
        }
        if (this.nextAnonLabel != null) {
            return "Found an @F anonymous label reference but there was no call to anonymousLabel()";
        }
        InstructionBlock[] blocks = new InstructionBlock[]{new InstructionBlock(writer, this.instructions, rip)};
        Object result = BlockEncoder.tryEncode(this.getBitness(), blocks, options);
        if (result instanceof BlockEncoderResult[]) {
            return new CodeAssemblerResult((BlockEncoderResult[])result);
        }
        return (String)result;
    }

    IllegalArgumentException noOpCodeFoundFor(int mnemonic, Object ... argNames) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Unable to calculate an OpCode for Mnemonic %d", mnemonic));
        for (int i = 0; i < argNames.length; ++i) {
            builder.append(i == 0 ? " " : ", ");
            builder.append(argNames[i]);
        }
        builder.append(String.format("`. Combination of arguments and/or current bitness %d is not compatible with any existing OpCode encoding.", this.getBitness()));
        return new IllegalArgumentException(builder.toString());
    }

    public void aaa() {
        this.addInstruction(Instruction.create(106));
    }

    public void aad(int imm) {
        this.addInstruction(Instruction.create(491, imm));
    }

    public void aadd(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4840, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void aadd(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4841, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void aam(int imm) {
        this.addInstruction(Instruction.create(490, imm));
    }

    public void aand(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4842, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void aand(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4843, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void aas() {
        this.addInstruction(Instruction.create(119));
    }

    public void adc(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(36, dst.get(), src.get()));
    }

    public void adc(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(36, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void adc(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(37, dst.get(), src.get()));
    }

    public void adc(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(37, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void adc(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(38, dst.get(), src.get()));
    }

    public void adc(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(38, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void adc(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(39, dst.get(), src.get()));
    }

    public void adc(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(39, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void adc(AsmRegister8 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(40, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void adc(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(41, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void adc(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(42, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void adc(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(43, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void adc(AsmRegister8 dst, int imm) {
        int code = dst.getRegister() == 1 ? 44 : 209;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void adc(AsmRegister16 dst, int imm) {
        int code = dst.getRegister() == 21 ? 45 : (imm >= -128 && imm <= 127 ? 253 : 221);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void adc(AsmRegister32 dst, int imm) {
        int code = dst.getRegister() == 37 ? 46 : (imm >= -128 && imm <= 127 ? 254 : 222);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void adc(AsmRegister64 dst, int imm) {
        int code = dst.getRegister() == 53 ? 47 : (imm >= -128 && imm <= 127 ? 255 : 223);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void adc(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = imm >= -128 && imm <= 127 ? 255 : 223;
        } else if (dst.size == 3) {
            code = imm >= -128 && imm <= 127 ? 254 : 222;
        } else if (dst.size == 2) {
            code = imm >= -128 && imm <= 127 ? 253 : 221;
        } else if (dst.size == 1) {
            code = 209;
        } else {
            throw this.noOpCodeFoundFor(5, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void adcx(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(3689, dst.get(), src.get()));
    }

    public void adcx(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(3690, dst.get(), src.get()));
    }

    public void adcx(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3689, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void adcx(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3690, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void add(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(5, dst.get(), src.get()));
    }

    public void add(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(5, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void add(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(6, dst.get(), src.get()));
    }

    public void add(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(6, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void add(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(7, dst.get(), src.get()));
    }

    public void add(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(7, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void add(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(8, dst.get(), src.get()));
    }

    public void add(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(8, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void add(AsmRegister8 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(9, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void add(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(10, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void add(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(11, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void add(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(12, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void add(AsmRegister8 dst, int imm) {
        int code = dst.getRegister() == 1 ? 13 : 207;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void add(AsmRegister16 dst, int imm) {
        int code = dst.getRegister() == 21 ? 14 : (imm >= -128 && imm <= 127 ? 247 : 215);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void add(AsmRegister32 dst, int imm) {
        int code = dst.getRegister() == 37 ? 15 : (imm >= -128 && imm <= 127 ? 248 : 216);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void add(AsmRegister64 dst, int imm) {
        int code = dst.getRegister() == 53 ? 16 : (imm >= -128 && imm <= 127 ? 249 : 217);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void add(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = imm >= -128 && imm <= 127 ? 249 : 217;
        } else if (dst.size == 3) {
            code = imm >= -128 && imm <= 127 ? 248 : 216;
        } else if (dst.size == 2) {
            code = imm >= -128 && imm <= 127 ? 247 : 215;
        } else if (dst.size == 1) {
            code = 207;
        } else {
            throw this.noOpCodeFoundFor(7, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void addpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1342, dst.get(), src.get()));
    }

    public void addpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1342, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void addps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1336, dst.get(), src.get()));
    }

    public void addps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1336, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void addsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1351, dst.get(), src.get()));
    }

    public void addsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1351, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void addss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1348, dst.get(), src.get()));
    }

    public void addss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1348, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void addsubpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2211, dst.get(), src.get()));
    }

    public void addsubpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2211, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void addsubps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2214, dst.get(), src.get()));
    }

    public void addsubps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2214, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void adox(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(3691, dst.get(), src.get()));
    }

    public void adox(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(3692, dst.get(), src.get()));
    }

    public void adox(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3691, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void adox(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3692, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aesdec(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3648, dst.get(), src.get()));
    }

    public void aesdec(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3648, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aesdec128kl(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4289, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aesdec256kl(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4291, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aesdeclast(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3654, dst.get(), src.get()));
    }

    public void aesdeclast(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3654, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aesdecwide128kl(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4284, dst.toMemoryOperand(this.getBitness())));
    }

    public void aesdecwide256kl(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4286, dst.toMemoryOperand(this.getBitness())));
    }

    public void aesenc(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3636, dst.get(), src.get()));
    }

    public void aesenc(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3636, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aesenc128kl(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4288, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aesenc256kl(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4290, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aesenclast(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3642, dst.get(), src.get()));
    }

    public void aesenclast(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3642, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aesencwide128kl(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4283, dst.toMemoryOperand(this.getBitness())));
    }

    public void aesencwide256kl(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4285, dst.toMemoryOperand(this.getBitness())));
    }

    public void aesimc(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3634, dst.get(), src.get()));
    }

    public void aesimc(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3634, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aeskeygenassist(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(4070, dst.get(), src1.get(), imm));
    }

    public void aeskeygenassist(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4070, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void altinst() {
        this.addInstruction(Instruction.create(4254));
    }

    public void and(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(68, dst.get(), src.get()));
    }

    public void and(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(68, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void and(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(69, dst.get(), src.get()));
    }

    public void and(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(69, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void and(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(70, dst.get(), src.get()));
    }

    public void and(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(70, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void and(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(71, dst.get(), src.get()));
    }

    public void and(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(71, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void and(AsmRegister8 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(72, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void and(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(73, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void and(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(74, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void and(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(75, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void and(AsmRegister8 dst, int imm) {
        int code = dst.getRegister() == 1 ? 76 : 211;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void and(AsmRegister16 dst, int imm) {
        int code = dst.getRegister() == 21 ? 77 : (imm >= -128 && imm <= 127 ? 259 : 227);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void and(AsmRegister32 dst, int imm) {
        int code = dst.getRegister() == 37 ? 78 : (imm >= -128 && imm <= 127 ? 260 : 228);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void and(AsmRegister64 dst, int imm) {
        int code = dst.getRegister() == 53 ? 79 : (imm >= -128 && imm <= 127 ? 261 : 229);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void and(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = imm >= -128 && imm <= 127 ? 261 : 229;
        } else if (dst.size == 3) {
            code = imm >= -128 && imm <= 127 ? 260 : 228;
        } else if (dst.size == 2) {
            code = imm >= -128 && imm <= 127 ? 259 : 227;
        } else if (dst.size == 1) {
            code = 211;
        } else {
            throw this.noOpCodeFoundFor(21, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void andn(AsmRegister32 dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3671, dst.get(), src1.get(), src2.get()));
    }

    public void andn(AsmRegister64 dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3672, dst.get(), src1.get(), src2.get()));
    }

    public void andn(AsmRegister32 dst, AsmRegister32 src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3671, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void andn(AsmRegister64 dst, AsmRegister64 src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3672, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void andnpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1306, dst.get(), src.get()));
    }

    public void andnpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1306, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void andnps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1300, dst.get(), src.get()));
    }

    public void andnps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1300, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void andpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1294, dst.get(), src.get()));
    }

    public void andpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1294, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void andps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1288, dst.get(), src.get()));
    }

    public void andps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1288, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void aor(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4846, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void aor(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4847, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void arpl(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(136, dst.get(), src.get()));
    }

    public void arpl(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(136, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void arpl(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(137, dst.get(), src.get()));
    }

    public void arpl(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(137, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void axor(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4844, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void axor(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4845, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void bb0_reset() {
        this.addInstruction(Instruction.create(4250));
    }

    public void bb1_reset() {
        this.addInstruction(Instruction.create(4251));
    }

    public void bextr(AsmRegister32 dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3695, dst.get(), src1.get(), src2.get()));
    }

    public void bextr(AsmRegister32 dst, AsmMemoryOperand src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3695, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void bextr(AsmRegister64 dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3696, dst.get(), src1.get(), src2.get()));
    }

    public void bextr(AsmRegister64 dst, AsmMemoryOperand src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3696, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void bextr(AsmRegister32 dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(4171, dst.get(), src1.get(), imm));
    }

    public void bextr(AsmRegister64 dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(4172, dst.get(), src1.get(), imm));
    }

    public void bextr(AsmRegister32 dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4171, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void bextr(AsmRegister64 dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4172, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void blcfill(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4104, dst.get(), src.get()));
    }

    public void blcfill(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4105, dst.get(), src.get()));
    }

    public void blcfill(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4104, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blcfill(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4105, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blci(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4120, dst.get(), src.get()));
    }

    public void blci(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4121, dst.get(), src.get()));
    }

    public void blci(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4120, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blci(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4121, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blcic(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4112, dst.get(), src.get()));
    }

    public void blcic(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4113, dst.get(), src.get()));
    }

    public void blcic(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4112, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blcic(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4113, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blcmsk(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4118, dst.get(), src.get()));
    }

    public void blcmsk(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4119, dst.get(), src.get()));
    }

    public void blcmsk(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4118, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blcmsk(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4119, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blcs(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4108, dst.get(), src.get()));
    }

    public void blcs(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4109, dst.get(), src.get()));
    }

    public void blcs(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4108, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blcs(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4109, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blendpd(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3760, dst.get(), src1.get(), imm));
    }

    public void blendpd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3760, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void blendps(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3757, dst.get(), src1.get(), imm));
    }

    public void blendps(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3757, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void blendvpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2670, dst.get(), src.get()));
    }

    public void blendvpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2670, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blendvps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2660, dst.get(), src.get()));
    }

    public void blendvps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2660, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsfill(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4106, dst.get(), src.get()));
    }

    public void blsfill(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4107, dst.get(), src.get()));
    }

    public void blsfill(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4106, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsfill(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4107, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsi(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(3677, dst.get(), src.get()));
    }

    public void blsi(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(3678, dst.get(), src.get()));
    }

    public void blsi(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3677, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsi(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3678, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsic(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4114, dst.get(), src.get()));
    }

    public void blsic(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4115, dst.get(), src.get()));
    }

    public void blsic(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4114, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsic(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4115, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsmsk(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(3675, dst.get(), src.get()));
    }

    public void blsmsk(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(3676, dst.get(), src.get()));
    }

    public void blsmsk(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3675, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsmsk(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3676, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsr(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(3673, dst.get(), src.get()));
    }

    public void blsr(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(3674, dst.get(), src.get()));
    }

    public void blsr(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3673, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void blsr(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3674, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bndcl(AsmRegisterBND dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1040, dst.get(), src.get()));
    }

    public void bndcl(AsmRegisterBND dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1041, dst.get(), src.get()));
    }

    public void bndcl(AsmRegisterBND dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 4) {
            code = 1041;
        } else if (src.size == 3) {
            code = 1040;
        } else {
            throw this.noOpCodeFoundFor(43, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bndcn(AsmRegisterBND dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1049, dst.get(), src.get()));
    }

    public void bndcn(AsmRegisterBND dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1050, dst.get(), src.get()));
    }

    public void bndcn(AsmRegisterBND dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 4) {
            code = 1050;
        } else if (src.size == 3) {
            code = 1049;
        } else {
            throw this.noOpCodeFoundFor(44, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bndcu(AsmRegisterBND dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1042, dst.get(), src.get()));
    }

    public void bndcu(AsmRegisterBND dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1043, dst.get(), src.get()));
    }

    public void bndcu(AsmRegisterBND dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 4) {
            code = 1043;
        } else if (src.size == 3) {
            code = 1042;
        } else {
            throw this.noOpCodeFoundFor(45, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bndldx(AsmRegisterBND dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1037, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bndmk(AsmRegisterBND dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 4) {
            code = 1048;
        } else if (src.size == 3) {
            code = 1047;
        } else {
            throw this.noOpCodeFoundFor(47, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bndmov(AsmRegisterBND dst, AsmRegisterBND src) {
        int code = this.getBitness() == 64 ? 1039 : 1038;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void bndmov(AsmMemoryOperand dst, AsmRegisterBND src) {
        int code = this.getBitness() == 64 ? 1046 : 1045;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void bndmov(AsmRegisterBND dst, AsmMemoryOperand src) {
        int code = this.getBitness() == 64 ? 1039 : 1038;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bndstx(AsmMemoryOperand dst, AsmRegisterBND src) {
        this.addInstruction(Instruction.create(1044, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void bound(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(134, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bound(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(135, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bsf(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2118, dst.get(), src.get()));
    }

    public void bsf(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2119, dst.get(), src.get()));
    }

    public void bsf(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2120, dst.get(), src.get()));
    }

    public void bsf(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2118, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bsf(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2119, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bsf(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2120, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bsr(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2124, dst.get(), src.get()));
    }

    public void bsr(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2125, dst.get(), src.get()));
    }

    public void bsr(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2126, dst.get(), src.get()));
    }

    public void bsr(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2124, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bsr(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2125, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bsr(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2126, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void bswap(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(2208, dst.get()));
    }

    public void bswap(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2209, dst.get()));
    }

    public void bswap(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2210, dst.get()));
    }

    public void bt(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1949, dst.get(), src.get()));
    }

    public void bt(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1949, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void bt(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1950, dst.get(), src.get()));
    }

    public void bt(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1950, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void bt(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1951, dst.get(), src.get()));
    }

    public void bt(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1951, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void bt(AsmRegister16 dst, int imm) {
        this.addInstruction(Instruction.create(2103, dst.get(), imm));
    }

    public void bt(AsmRegister32 dst, int imm) {
        this.addInstruction(Instruction.create(2104, dst.get(), imm));
    }

    public void bt(AsmRegister64 dst, int imm) {
        this.addInstruction(Instruction.create(2105, dst.get(), imm));
    }

    public void bt(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = 2105;
        } else if (dst.size == 3) {
            code = 2104;
        } else if (dst.size == 2) {
            code = 2103;
        } else {
            throw this.noOpCodeFoundFor(54, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void btc(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2115, dst.get(), src.get()));
    }

    public void btc(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2115, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void btc(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2116, dst.get(), src.get()));
    }

    public void btc(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2116, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void btc(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2117, dst.get(), src.get()));
    }

    public void btc(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2117, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void btc(AsmRegister16 dst, int imm) {
        this.addInstruction(Instruction.create(2112, dst.get(), imm));
    }

    public void btc(AsmRegister32 dst, int imm) {
        this.addInstruction(Instruction.create(2113, dst.get(), imm));
    }

    public void btc(AsmRegister64 dst, int imm) {
        this.addInstruction(Instruction.create(2114, dst.get(), imm));
    }

    public void btc(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = 2114;
        } else if (dst.size == 3) {
            code = 2113;
        } else if (dst.size == 2) {
            code = 2112;
        } else {
            throw this.noOpCodeFoundFor(55, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void btr(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2080, dst.get(), src.get()));
    }

    public void btr(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2080, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void btr(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2081, dst.get(), src.get()));
    }

    public void btr(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2081, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void btr(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2082, dst.get(), src.get()));
    }

    public void btr(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2082, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void btr(AsmRegister16 dst, int imm) {
        this.addInstruction(Instruction.create(2109, dst.get(), imm));
    }

    public void btr(AsmRegister32 dst, int imm) {
        this.addInstruction(Instruction.create(2110, dst.get(), imm));
    }

    public void btr(AsmRegister64 dst, int imm) {
        this.addInstruction(Instruction.create(2111, dst.get(), imm));
    }

    public void btr(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = 2111;
        } else if (dst.size == 3) {
            code = 2110;
        } else if (dst.size == 2) {
            code = 2109;
        } else {
            throw this.noOpCodeFoundFor(56, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void bts(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1999, dst.get(), src.get()));
    }

    public void bts(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1999, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void bts(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2000, dst.get(), src.get()));
    }

    public void bts(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2000, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void bts(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2001, dst.get(), src.get()));
    }

    public void bts(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2001, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void bts(AsmRegister16 dst, int imm) {
        this.addInstruction(Instruction.create(2106, dst.get(), imm));
    }

    public void bts(AsmRegister32 dst, int imm) {
        this.addInstruction(Instruction.create(2107, dst.get(), imm));
    }

    public void bts(AsmRegister64 dst, int imm) {
        this.addInstruction(Instruction.create(2108, dst.get(), imm));
    }

    public void bts(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = 2108;
        } else if (dst.size == 3) {
            code = 2107;
        } else if (dst.size == 2) {
            code = 2106;
        } else {
            throw this.noOpCodeFoundFor(57, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void bzhi(AsmRegister32 dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3679, dst.get(), src1.get(), src2.get()));
    }

    public void bzhi(AsmRegister32 dst, AsmMemoryOperand src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3679, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void bzhi(AsmRegister64 dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3680, dst.get(), src1.get(), src2.get()));
    }

    public void bzhi(AsmRegister64 dst, AsmMemoryOperand src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3680, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void call(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(757, dst.get()));
    }

    public void call(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(758, dst.get()));
    }

    public void call(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(759, dst.get()));
    }

    public void call(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 5) {
            code = 762;
        } else if (dst.size == 4) {
            code = 759;
        } else if (dst.size == 6) {
            code = 761;
        } else if (dst.size == 3) {
            code = this.getBitness() >= 32 ? 758 : 760;
        } else if (dst.size == 2) {
            code = 757;
        } else {
            throw this.noOpCodeFoundFor(59, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void call(CodeLabel dst) {
        int code = this.getBitness() == 64 ? 693 : (this.getBitness() >= 32 ? 692 : 691);
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void call(long dst) {
        int code = this.getBitness() == 64 ? 693 : (this.getBitness() >= 32 ? 692 : 691);
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void cbw() {
        this.addInstruction(Instruction.create(306));
    }

    public void ccs_encrypt() {
        int code = this.getBitness() == 64 ? 4317 : (this.getBitness() >= 32 ? 4316 : 4315);
        this.addInstruction(Instruction.create(code));
    }

    public void ccs_hash() {
        int code = this.getBitness() == 64 ? 4314 : (this.getBitness() >= 32 ? 4313 : 4312);
        this.addInstruction(Instruction.create(code));
    }

    public void cdq() {
        this.addInstruction(Instruction.create(310));
    }

    public void cdqe() {
        this.addInstruction(Instruction.create(308));
    }

    public void cl1invmb() {
        this.addInstruction(Instruction.create(878));
    }

    public void clac() {
        this.addInstruction(Instruction.create(822));
    }

    public void clc() {
        this.addInstruction(Instruction.create(743));
    }

    public void cld() {
        this.addInstruction(Instruction.create(747));
    }

    public void cldemote(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1051, dst.toMemoryOperand(this.getBitness())));
    }

    public void clflush(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2043, dst.toMemoryOperand(this.getBitness())));
    }

    public void clflushopt(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2044, dst.toMemoryOperand(this.getBitness())));
    }

    public void clgi() {
        this.addInstruction(Instruction.create(842));
    }

    public void cli() {
        this.addInstruction(Instruction.create(745));
    }

    public void clrssbsy(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2037, dst.toMemoryOperand(this.getBitness())));
    }

    public void clts() {
        this.addInstruction(Instruction.create(871));
    }

    public void clui() {
        this.addInstruction(Instruction.create(4300));
    }

    public void clwb(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2034, dst.toMemoryOperand(this.getBitness())));
    }

    public void clzero() {
        int code = this.getBitness() == 64 ? 860 : (this.getBitness() >= 32 ? 859 : 858);
        this.addInstruction(Instruction.create(code));
    }

    public void cmc() {
        this.addInstruction(Instruction.create(710));
    }

    public void cmova(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1190, dst.get(), src.get()));
    }

    public void cmova(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1191, dst.get(), src.get()));
    }

    public void cmova(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1192, dst.get(), src.get()));
    }

    public void cmova(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1190, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmova(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1191, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmova(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1192, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovae(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1178, dst.get(), src.get()));
    }

    public void cmovae(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1179, dst.get(), src.get()));
    }

    public void cmovae(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1180, dst.get(), src.get()));
    }

    public void cmovae(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1178, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovae(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1179, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovae(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1180, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovb(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1175, dst.get(), src.get()));
    }

    public void cmovb(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1176, dst.get(), src.get()));
    }

    public void cmovb(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1177, dst.get(), src.get()));
    }

    public void cmovb(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1175, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovb(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1176, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovb(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1177, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovbe(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1187, dst.get(), src.get()));
    }

    public void cmovbe(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1188, dst.get(), src.get()));
    }

    public void cmovbe(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1189, dst.get(), src.get()));
    }

    public void cmovbe(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1187, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovbe(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1188, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovbe(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1189, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovc(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1175, dst.get(), src.get()));
    }

    public void cmovc(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1176, dst.get(), src.get()));
    }

    public void cmovc(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1177, dst.get(), src.get()));
    }

    public void cmovc(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1175, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovc(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1176, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovc(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1177, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmove(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1181, dst.get(), src.get()));
    }

    public void cmove(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1182, dst.get(), src.get()));
    }

    public void cmove(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1183, dst.get(), src.get()));
    }

    public void cmove(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1181, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmove(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1182, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmove(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1183, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovg(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1214, dst.get(), src.get()));
    }

    public void cmovg(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1215, dst.get(), src.get()));
    }

    public void cmovg(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1216, dst.get(), src.get()));
    }

    public void cmovg(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1214, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovg(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1215, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovg(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1216, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovge(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1208, dst.get(), src.get()));
    }

    public void cmovge(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1209, dst.get(), src.get()));
    }

    public void cmovge(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1210, dst.get(), src.get()));
    }

    public void cmovge(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1208, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovge(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1209, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovge(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1210, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovl(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1205, dst.get(), src.get()));
    }

    public void cmovl(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1206, dst.get(), src.get()));
    }

    public void cmovl(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1207, dst.get(), src.get()));
    }

    public void cmovl(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1205, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovl(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1206, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovl(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1207, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovle(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1211, dst.get(), src.get()));
    }

    public void cmovle(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1212, dst.get(), src.get()));
    }

    public void cmovle(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1213, dst.get(), src.get()));
    }

    public void cmovle(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1211, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovle(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1212, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovle(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1213, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovna(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1187, dst.get(), src.get()));
    }

    public void cmovna(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1188, dst.get(), src.get()));
    }

    public void cmovna(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1189, dst.get(), src.get()));
    }

    public void cmovna(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1187, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovna(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1188, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovna(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1189, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnae(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1175, dst.get(), src.get()));
    }

    public void cmovnae(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1176, dst.get(), src.get()));
    }

    public void cmovnae(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1177, dst.get(), src.get()));
    }

    public void cmovnae(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1175, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnae(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1176, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnae(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1177, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnb(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1178, dst.get(), src.get()));
    }

    public void cmovnb(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1179, dst.get(), src.get()));
    }

    public void cmovnb(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1180, dst.get(), src.get()));
    }

    public void cmovnb(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1178, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnb(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1179, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnb(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1180, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnbe(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1190, dst.get(), src.get()));
    }

    public void cmovnbe(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1191, dst.get(), src.get()));
    }

    public void cmovnbe(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1192, dst.get(), src.get()));
    }

    public void cmovnbe(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1190, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnbe(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1191, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnbe(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1192, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnc(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1178, dst.get(), src.get()));
    }

    public void cmovnc(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1179, dst.get(), src.get()));
    }

    public void cmovnc(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1180, dst.get(), src.get()));
    }

    public void cmovnc(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1178, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnc(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1179, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnc(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1180, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovne(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1184, dst.get(), src.get()));
    }

    public void cmovne(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1185, dst.get(), src.get()));
    }

    public void cmovne(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1186, dst.get(), src.get()));
    }

    public void cmovne(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1184, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovne(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1185, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovne(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1186, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovng(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1211, dst.get(), src.get()));
    }

    public void cmovng(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1212, dst.get(), src.get()));
    }

    public void cmovng(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1213, dst.get(), src.get()));
    }

    public void cmovng(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1211, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovng(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1212, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovng(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1213, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnge(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1205, dst.get(), src.get()));
    }

    public void cmovnge(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1206, dst.get(), src.get()));
    }

    public void cmovnge(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1207, dst.get(), src.get()));
    }

    public void cmovnge(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1205, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnge(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1206, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnge(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1207, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnl(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1208, dst.get(), src.get()));
    }

    public void cmovnl(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1209, dst.get(), src.get()));
    }

    public void cmovnl(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1210, dst.get(), src.get()));
    }

    public void cmovnl(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1208, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnl(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1209, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnl(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1210, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnle(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1214, dst.get(), src.get()));
    }

    public void cmovnle(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1215, dst.get(), src.get()));
    }

    public void cmovnle(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1216, dst.get(), src.get()));
    }

    public void cmovnle(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1214, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnle(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1215, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnle(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1216, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovno(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1172, dst.get(), src.get()));
    }

    public void cmovno(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1173, dst.get(), src.get()));
    }

    public void cmovno(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1174, dst.get(), src.get()));
    }

    public void cmovno(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1172, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovno(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1173, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovno(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1174, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnp(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1202, dst.get(), src.get()));
    }

    public void cmovnp(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1203, dst.get(), src.get()));
    }

    public void cmovnp(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1204, dst.get(), src.get()));
    }

    public void cmovnp(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1202, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnp(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1203, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnp(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1204, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovns(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1196, dst.get(), src.get()));
    }

    public void cmovns(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1197, dst.get(), src.get()));
    }

    public void cmovns(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1198, dst.get(), src.get()));
    }

    public void cmovns(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1196, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovns(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1197, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovns(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1198, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnz(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1184, dst.get(), src.get()));
    }

    public void cmovnz(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1185, dst.get(), src.get()));
    }

    public void cmovnz(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1186, dst.get(), src.get()));
    }

    public void cmovnz(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1184, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnz(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1185, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovnz(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1186, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovo(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1169, dst.get(), src.get()));
    }

    public void cmovo(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1170, dst.get(), src.get()));
    }

    public void cmovo(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1171, dst.get(), src.get()));
    }

    public void cmovo(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1169, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovo(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1170, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovo(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1171, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovp(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1199, dst.get(), src.get()));
    }

    public void cmovp(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1200, dst.get(), src.get()));
    }

    public void cmovp(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1201, dst.get(), src.get()));
    }

    public void cmovp(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1199, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovp(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1200, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovp(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1201, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovpe(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1199, dst.get(), src.get()));
    }

    public void cmovpe(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1200, dst.get(), src.get()));
    }

    public void cmovpe(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1201, dst.get(), src.get()));
    }

    public void cmovpe(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1199, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovpe(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1200, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovpe(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1201, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovpo(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1202, dst.get(), src.get()));
    }

    public void cmovpo(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1203, dst.get(), src.get()));
    }

    public void cmovpo(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1204, dst.get(), src.get()));
    }

    public void cmovpo(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1202, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovpo(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1203, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovpo(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1204, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovs(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1193, dst.get(), src.get()));
    }

    public void cmovs(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1194, dst.get(), src.get()));
    }

    public void cmovs(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1195, dst.get(), src.get()));
    }

    public void cmovs(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1193, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovs(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1194, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovs(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1195, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovz(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1181, dst.get(), src.get()));
    }

    public void cmovz(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1182, dst.get(), src.get()));
    }

    public void cmovz(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1183, dst.get(), src.get()));
    }

    public void cmovz(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1181, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovz(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1182, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmovz(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1183, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmp(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(107, dst.get(), src.get()));
    }

    public void cmp(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(107, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void cmp(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(108, dst.get(), src.get()));
    }

    public void cmp(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(108, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void cmp(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(109, dst.get(), src.get()));
    }

    public void cmp(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(109, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void cmp(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(110, dst.get(), src.get()));
    }

    public void cmp(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(110, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void cmp(AsmRegister8 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(111, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmp(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(112, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmp(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(113, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmp(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(114, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cmp(AsmRegister8 dst, int imm) {
        int code = dst.getRegister() == 1 ? 115 : 214;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void cmp(AsmRegister16 dst, int imm) {
        int code = dst.getRegister() == 21 ? 116 : (imm >= -128 && imm <= 127 ? 268 : 236);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void cmp(AsmRegister32 dst, int imm) {
        int code = dst.getRegister() == 37 ? 117 : (imm >= -128 && imm <= 127 ? 269 : 237);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void cmp(AsmRegister64 dst, int imm) {
        int code = dst.getRegister() == 53 ? 118 : (imm >= -128 && imm <= 127 ? 270 : 238);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void cmp(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = imm >= -128 && imm <= 127 ? 270 : 238;
        } else if (dst.size == 3) {
            code = imm >= -128 && imm <= 127 ? 269 : 237;
        } else if (dst.size == 2) {
            code = imm >= -128 && imm <= 127 ? 268 : 236;
        } else if (dst.size == 1) {
            code = 214;
        } else {
            throw this.noOpCodeFoundFor(93, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void cmpbexadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4891, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpbexadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4892, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpbxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4883, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpbxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4884, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpcxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4883, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpcxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4884, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpeqpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmppd(dst, src, 0);
    }

    public void cmpeqpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmppd(dst, src, 0);
    }

    public void cmpeqps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpps(dst, src, 0);
    }

    public void cmpeqps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpps(dst, src, 0);
    }

    public void cmpeqsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpsd(dst, src, 0);
    }

    public void cmpeqsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpsd(dst, src, 0);
    }

    public void cmpeqss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpss(dst, src, 0);
    }

    public void cmpeqss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpss(dst, src, 0);
    }

    public void cmplepd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmppd(dst, src, 2);
    }

    public void cmplepd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmppd(dst, src, 2);
    }

    public void cmpleps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpps(dst, src, 2);
    }

    public void cmpleps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpps(dst, src, 2);
    }

    public void cmplesd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpsd(dst, src, 2);
    }

    public void cmplesd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpsd(dst, src, 2);
    }

    public void cmpless(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpss(dst, src, 2);
    }

    public void cmpless(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpss(dst, src, 2);
    }

    public void cmplexadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4907, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmplexadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4908, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpltpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmppd(dst, src, 1);
    }

    public void cmpltpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmppd(dst, src, 1);
    }

    public void cmpltps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpps(dst, src, 1);
    }

    public void cmpltps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpps(dst, src, 1);
    }

    public void cmpltsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpsd(dst, src, 1);
    }

    public void cmpltsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpsd(dst, src, 1);
    }

    public void cmpltss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpss(dst, src, 1);
    }

    public void cmpltss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpss(dst, src, 1);
    }

    public void cmplxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4903, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmplxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4904, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnaexadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4883, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnaexadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4884, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnaxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4891, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnaxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4892, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnbexadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4893, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnbexadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4894, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnbxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4885, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnbxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4886, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpncxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4885, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpncxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4886, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpneqpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmppd(dst, src, 4);
    }

    public void cmpneqpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmppd(dst, src, 4);
    }

    public void cmpneqps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpps(dst, src, 4);
    }

    public void cmpneqps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpps(dst, src, 4);
    }

    public void cmpneqsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpsd(dst, src, 4);
    }

    public void cmpneqsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpsd(dst, src, 4);
    }

    public void cmpneqss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpss(dst, src, 4);
    }

    public void cmpneqss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpss(dst, src, 4);
    }

    public void cmpngexadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4903, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpngexadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4904, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpngxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4907, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpngxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4908, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnlepd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmppd(dst, src, 6);
    }

    public void cmpnlepd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmppd(dst, src, 6);
    }

    public void cmpnleps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpps(dst, src, 6);
    }

    public void cmpnleps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpps(dst, src, 6);
    }

    public void cmpnlesd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpsd(dst, src, 6);
    }

    public void cmpnlesd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpsd(dst, src, 6);
    }

    public void cmpnless(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpss(dst, src, 6);
    }

    public void cmpnless(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpss(dst, src, 6);
    }

    public void cmpnlexadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4909, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnlexadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4910, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnltpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmppd(dst, src, 5);
    }

    public void cmpnltpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmppd(dst, src, 5);
    }

    public void cmpnltps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpps(dst, src, 5);
    }

    public void cmpnltps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpps(dst, src, 5);
    }

    public void cmpnltsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpsd(dst, src, 5);
    }

    public void cmpnltsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpsd(dst, src, 5);
    }

    public void cmpnltss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpss(dst, src, 5);
    }

    public void cmpnltss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpss(dst, src, 5);
    }

    public void cmpnlxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4905, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnlxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4906, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnoxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4881, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnoxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4882, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnpxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4901, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnpxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4902, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnsxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4897, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnsxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4898, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnzxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4889, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpnzxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4890, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpordpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmppd(dst, src, 7);
    }

    public void cmpordpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmppd(dst, src, 7);
    }

    public void cmpordps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpps(dst, src, 7);
    }

    public void cmpordps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpps(dst, src, 7);
    }

    public void cmpordsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpsd(dst, src, 7);
    }

    public void cmpordsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpsd(dst, src, 7);
    }

    public void cmpordss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpss(dst, src, 7);
    }

    public void cmpordss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpss(dst, src, 7);
    }

    public void cmpoxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4879, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpoxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4880, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmppd(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(2146, dst.get(), src1.get(), imm));
    }

    public void cmppd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(2146, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void cmppexadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4899, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmppexadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4900, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmppoxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4901, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmppoxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4902, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpps(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(2140, dst.get(), src1.get(), imm));
    }

    public void cmpps(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(2140, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void cmppxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4899, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmppxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4900, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpsb() {
        this.addInstruction(Instruction.createCmpsb(this.getBitness()));
    }

    public void cmpsd() {
        this.addInstruction(Instruction.createCmpsd(this.getBitness()));
    }

    public void cmpsd(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(2155, dst.get(), src1.get(), imm));
    }

    public void cmpsd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(2155, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void cmpsq() {
        this.addInstruction(Instruction.createCmpsq(this.getBitness()));
    }

    public void cmpss(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(2152, dst.get(), src1.get(), imm));
    }

    public void cmpss(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(2152, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void cmpsw() {
        this.addInstruction(Instruction.createCmpsw(this.getBitness()));
    }

    public void cmpsxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4895, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpsxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4896, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpunordpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmppd(dst, src, 3);
    }

    public void cmpunordpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmppd(dst, src, 3);
    }

    public void cmpunordps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpps(dst, src, 3);
    }

    public void cmpunordps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpps(dst, src, 3);
    }

    public void cmpunordsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpsd(dst, src, 3);
    }

    public void cmpunordsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpsd(dst, src, 3);
    }

    public void cmpunordss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.cmpss(dst, src, 3);
    }

    public void cmpunordss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.cmpss(dst, src, 3);
    }

    public void cmpxchg(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(2073, dst.get(), src.get()));
    }

    public void cmpxchg(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(2073, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void cmpxchg(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2074, dst.get(), src.get()));
    }

    public void cmpxchg(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2074, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void cmpxchg(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2075, dst.get(), src.get()));
    }

    public void cmpxchg(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2075, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void cmpxchg(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2076, dst.get(), src.get()));
    }

    public void cmpxchg(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2076, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void cmpxchg16b(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2189, dst.toMemoryOperand(this.getBitness())));
    }

    public void cmpxchg8b(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2188, dst.toMemoryOperand(this.getBitness())));
    }

    public void cmpzxadd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4887, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void cmpzxadd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4888, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void comisd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1156, dst.get(), src.get()));
    }

    public void comisd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1156, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void comiss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1155, dst.get(), src.get()));
    }

    public void comiss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1155, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cpu_read() {
        this.addInstruction(Instruction.create(4253));
    }

    public void cpu_write() {
        this.addInstruction(Instruction.create(4252));
    }

    public void cpuid() {
        this.addInstruction(Instruction.create(1948));
    }

    public void cqo() {
        this.addInstruction(Instruction.create(311));
    }

    public void crc32(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(3663, dst.get(), src.get()));
    }

    public void crc32(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(3664, dst.get(), src.get()));
    }

    public void crc32(AsmRegister32 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(3668, dst.get(), src.get()));
    }

    public void crc32(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(3669, dst.get(), src.get()));
    }

    public void crc32(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(3670, dst.get(), src.get()));
    }

    public void crc32(AsmRegister32 dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 3) {
            code = 3669;
        } else if (src.size == 2) {
            code = 3668;
        } else if (src.size == 1) {
            code = 3663;
        } else {
            throw this.noOpCodeFoundFor(108, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void crc32(AsmRegister64 dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 4) {
            code = 3670;
        } else if (src.size == 1) {
            code = 3664;
        } else {
            throw this.noOpCodeFoundFor(108, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtdq2pd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2378, dst.get(), src.get()));
    }

    public void cvtdq2pd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2378, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtdq2ps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1390, dst.get(), src.get()));
    }

    public void cvtdq2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1390, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtpd2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2387, dst.get(), src.get()));
    }

    public void cvtpd2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2387, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtpd2pi(AsmRegisterMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1136, dst.get(), src.get()));
    }

    public void cvtpd2pi(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1136, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtpd2ps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1378, dst.get(), src.get()));
    }

    public void cvtpd2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1378, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtpi2pd(AsmRegisterXMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1094, dst.get(), src.get()));
    }

    public void cvtpi2pd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1094, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtpi2ps(AsmRegisterXMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1093, dst.get(), src.get()));
    }

    public void cvtpi2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1093, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtps2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1399, dst.get(), src.get()));
    }

    public void cvtps2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1399, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtps2pd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1372, dst.get(), src.get()));
    }

    public void cvtps2pd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1372, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtps2pi(AsmRegisterMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1135, dst.get(), src.get()));
    }

    public void cvtps2pi(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1135, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtsd2si(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1143, dst.get(), src.get()));
    }

    public void cvtsd2si(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1144, dst.get(), src.get()));
    }

    public void cvtsd2si(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1143, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtsd2si(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1144, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtsd2ss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1387, dst.get(), src.get()));
    }

    public void cvtsd2ss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1387, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtsi2sd(AsmRegisterXMM dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1101, dst.get(), src.get()));
    }

    public void cvtsi2sd(AsmRegisterXMM dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1102, dst.get(), src.get()));
    }

    public void cvtsi2sd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 4) {
            code = 1102;
        } else if (src.size == 3) {
            code = 1101;
        } else {
            throw this.noOpCodeFoundFor(121, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtsi2ss(AsmRegisterXMM dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1095, dst.get(), src.get()));
    }

    public void cvtsi2ss(AsmRegisterXMM dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1096, dst.get(), src.get()));
    }

    public void cvtsi2ss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 4) {
            code = 1096;
        } else if (src.size == 3) {
            code = 1095;
        } else {
            throw this.noOpCodeFoundFor(122, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtss2sd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1384, dst.get(), src.get()));
    }

    public void cvtss2sd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1384, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtss2si(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1137, dst.get(), src.get()));
    }

    public void cvtss2si(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1138, dst.get(), src.get()));
    }

    public void cvtss2si(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1137, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvtss2si(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1138, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvttpd2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2372, dst.get(), src.get()));
    }

    public void cvttpd2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2372, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvttpd2pi(AsmRegisterMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1122, dst.get(), src.get()));
    }

    public void cvttpd2pi(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1122, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvttps2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1405, dst.get(), src.get()));
    }

    public void cvttps2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1405, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvttps2pi(AsmRegisterMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1121, dst.get(), src.get()));
    }

    public void cvttps2pi(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1121, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvttsd2si(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1129, dst.get(), src.get()));
    }

    public void cvttsd2si(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1130, dst.get(), src.get()));
    }

    public void cvttsd2si(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1129, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvttsd2si(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1130, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvttss2si(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1123, dst.get(), src.get()));
    }

    public void cvttss2si(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1124, dst.get(), src.get()));
    }

    public void cvttss2si(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1123, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cvttss2si(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1124, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void cwd() {
        this.addInstruction(Instruction.create(309));
    }

    public void cwde() {
        this.addInstruction(Instruction.create(307));
    }

    public void daa() {
        this.addInstruction(Instruction.create(80));
    }

    public void das() {
        this.addInstruction(Instruction.create(93));
    }

    public void dec(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(750, dst.get()));
    }

    public void dec(AsmRegister16 dst) {
        int code = this.getBitness() == 64 ? 754 : 122;
        this.addInstruction(Instruction.create(code, dst.get()));
    }

    public void dec(AsmRegister32 dst) {
        int code = this.getBitness() == 64 ? 755 : 123;
        this.addInstruction(Instruction.create(code, dst.get()));
    }

    public void dec(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(756, dst.get()));
    }

    public void dec(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 756;
        } else if (dst.size == 3) {
            code = 755;
        } else if (dst.size == 2) {
            code = 754;
        } else if (dst.size == 1) {
            code = 750;
        } else {
            throw this.noOpCodeFoundFor(137, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void div(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(717, dst.get()));
    }

    public void div(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(737, dst.get()));
    }

    public void div(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(738, dst.get()));
    }

    public void div(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(739, dst.get()));
    }

    public void div(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 739;
        } else if (dst.size == 3) {
            code = 738;
        } else if (dst.size == 2) {
            code = 737;
        } else if (dst.size == 1) {
            code = 717;
        } else {
            throw this.noOpCodeFoundFor(138, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void divpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1453, dst.get(), src.get()));
    }

    public void divpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1453, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void divps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1447, dst.get(), src.get()));
    }

    public void divps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1447, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void divsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1462, dst.get(), src.get()));
    }

    public void divsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1462, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void divss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1459, dst.get(), src.get()));
    }

    public void divss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1459, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void dmint() {
        this.addInstruction(Instruction.create(4241));
    }

    public void dppd(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3898, dst.get(), src1.get(), imm));
    }

    public void dppd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3898, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void dpps(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3895, dst.get(), src1.get(), imm));
    }

    public void dpps(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3895, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void emms() {
        this.addInstruction(Instruction.create(1735));
    }

    public void encls() {
        this.addInstruction(Instruction.create(824));
    }

    public void enclu() {
        this.addInstruction(Instruction.create(830));
    }

    public void enclv() {
        this.addInstruction(Instruction.create(812));
    }

    public void encodekey128(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4292, dst.get(), src.get()));
    }

    public void encodekey256(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4293, dst.get(), src.get()));
    }

    public void endbr32() {
        this.addInstruction(Instruction.create(1055));
    }

    public void endbr64() {
        this.addInstruction(Instruction.create(1054));
    }

    public void enqcmd(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3709, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void enqcmd(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3710, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void enqcmd(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3711, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void enqcmds(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3706, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void enqcmds(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3707, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void enqcmds(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3708, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void enter(int imm, int imm1) {
        int code = this.getBitness() == 64 ? 410 : (this.getBitness() >= 32 ? 409 : 408);
        this.addInstruction(Instruction.create(code, imm, imm1));
    }

    public void erets() {
        this.addInstruction(Instruction.create(4322));
    }

    public void eretu() {
        this.addInstruction(Instruction.create(4321));
    }

    public void extractps(AsmRegister32 dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3791, dst.get(), src1.get(), imm));
    }

    public void extractps(AsmRegister64 dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3792, dst.get(), src1.get(), imm));
    }

    public void extractps(AsmMemoryOperand dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3791, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void extrq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1766, dst.get(), src.get()));
    }

    public void extrq(AsmRegisterXMM dst, int imm, int imm1) {
        this.addInstruction(Instruction.create(1746, dst.get(), imm, imm1));
    }

    public void f2xm1() {
        this.addInstruction(Instruction.create(537));
    }

    public void fabs() {
        this.addInstruction(Instruction.create(527));
    }

    public void fadd(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 589;
        } else if (dst.size == 3) {
            code = 494;
        } else {
            throw this.noOpCodeFoundFor(160, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fadd(AsmRegisterST dst, AsmRegisterST src) {
        int code = dst.getRegister() == 217 ? 502 : 597;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void faddp(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(631, dst.get(), src.get()));
    }

    public void fbld(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(643, dst.toMemoryOperand(this.getBitness())));
    }

    public void fbstp(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(645, dst.toMemoryOperand(this.getBitness())));
    }

    public void fchs() {
        this.addInstruction(Instruction.create(526));
    }

    public void fclex() {
        this.addInstruction(Instruction.create(581));
    }

    public void fcmovb(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(561, dst.get(), src.get()));
    }

    public void fcmovbe(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(563, dst.get(), src.get()));
    }

    public void fcmove(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(562, dst.get(), src.get()));
    }

    public void fcmovnb(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(572, dst.get(), src.get()));
    }

    public void fcmovnbe(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(574, dst.get(), src.get()));
    }

    public void fcmovne(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(573, dst.get(), src.get()));
    }

    public void fcmovnu(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(575, dst.get(), src.get()));
    }

    public void fcmovu(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(564, dst.get(), src.get()));
    }

    public void fcom(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 591;
        } else if (dst.size == 3) {
            code = 496;
        } else {
            throw this.noOpCodeFoundFor(174, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fcom(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(504, dst.get(), src.get()));
    }

    public void fcomi(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(588, dst.get(), src.get()));
    }

    public void fcomip(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(656, dst.get(), src.get()));
    }

    public void fcomp(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 592;
        } else if (dst.size == 3) {
            code = 497;
        } else {
            throw this.noOpCodeFoundFor(177, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fcomp(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(505, dst.get(), src.get()));
    }

    public void fcompp() {
        this.addInstruction(Instruction.create(634));
    }

    public void fcos() {
        this.addInstruction(Instruction.create(552));
    }

    public void fdecstp() {
        this.addInstruction(Instruction.create(543));
    }

    public void fdisi() {
        this.addInstruction(Instruction.create(579));
    }

    public void fdiv(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 595;
        } else if (dst.size == 3) {
            code = 500;
        } else {
            throw this.noOpCodeFoundFor(182, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fdiv(AsmRegisterST dst, AsmRegisterST src) {
        int code = dst.getRegister() == 217 ? 508 : 604;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void fdivp(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(638, dst.get(), src.get()));
    }

    public void fdivr(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 596;
        } else if (dst.size == 3) {
            code = 501;
        } else {
            throw this.noOpCodeFoundFor(184, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fdivr(AsmRegisterST dst, AsmRegisterST src) {
        int code = dst.getRegister() == 217 ? 509 : 603;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void fdivrp(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(637, dst.get(), src.get()));
    }

    public void femms() {
        this.addInstruction(Instruction.create(886));
    }

    public void feni() {
        this.addInstruction(Instruction.create(577));
    }

    public void ffree(AsmRegisterST dst) {
        this.addInstruction(Instruction.create(617, dst.get()));
    }

    public void ffreep(AsmRegisterST dst) {
        this.addInstruction(Instruction.create(647, dst.get()));
    }

    public void fiadd(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 3) {
            code = 553;
        } else if (dst.size == 2) {
            code = 623;
        } else {
            throw this.noOpCodeFoundFor(190, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void ficom(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 3) {
            code = 555;
        } else if (dst.size == 2) {
            code = 625;
        } else {
            throw this.noOpCodeFoundFor(191, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void ficomp(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 3) {
            code = 556;
        } else if (dst.size == 2) {
            code = 626;
        } else {
            throw this.noOpCodeFoundFor(192, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fidiv(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 3) {
            code = 559;
        } else if (dst.size == 2) {
            code = 629;
        } else {
            throw this.noOpCodeFoundFor(193, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fidivr(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 3) {
            code = 560;
        } else if (dst.size == 2) {
            code = 630;
        } else {
            throw this.noOpCodeFoundFor(194, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fild(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 644;
        } else if (dst.size == 3) {
            code = 566;
        } else if (dst.size == 2) {
            code = 639;
        } else {
            throw this.noOpCodeFoundFor(195, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fimul(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 3) {
            code = 554;
        } else if (dst.size == 2) {
            code = 624;
        } else {
            throw this.noOpCodeFoundFor(196, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fincstp() {
        this.addInstruction(Instruction.create(544));
    }

    public void finit() {
        this.addInstruction(Instruction.create(583));
    }

    public void fist(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 3) {
            code = 568;
        } else if (dst.size == 2) {
            code = 641;
        } else {
            throw this.noOpCodeFoundFor(199, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fistp(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 646;
        } else if (dst.size == 3) {
            code = 569;
        } else if (dst.size == 2) {
            code = 642;
        } else {
            throw this.noOpCodeFoundFor(200, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fisttp(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 606;
        } else if (dst.size == 3) {
            code = 567;
        } else if (dst.size == 2) {
            code = 640;
        } else {
            throw this.noOpCodeFoundFor(201, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fisub(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 3) {
            code = 557;
        } else if (dst.size == 2) {
            code = 627;
        } else {
            throw this.noOpCodeFoundFor(202, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fisubr(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 3) {
            code = 558;
        } else if (dst.size == 2) {
            code = 628;
        } else {
            throw this.noOpCodeFoundFor(203, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fld(AsmRegisterST dst) {
        this.addInstruction(Instruction.create(522, dst.get()));
    }

    public void fld(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 5) {
            code = 570;
        } else if (dst.size == 4) {
            code = 605;
        } else if (dst.size == 3) {
            code = 510;
        } else {
            throw this.noOpCodeFoundFor(204, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fld1() {
        this.addInstruction(Instruction.create(530));
    }

    public void fldcw(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(515, dst.toMemoryOperand(this.getBitness())));
    }

    public void fldenv(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 514 : 513;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fldl2e() {
        this.addInstruction(Instruction.create(532));
    }

    public void fldl2t() {
        this.addInstruction(Instruction.create(531));
    }

    public void fldlg2() {
        this.addInstruction(Instruction.create(534));
    }

    public void fldln2() {
        this.addInstruction(Instruction.create(535));
    }

    public void fldpi() {
        this.addInstruction(Instruction.create(533));
    }

    public void fldz() {
        this.addInstruction(Instruction.create(536));
    }

    public void fmul(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 590;
        } else if (dst.size == 3) {
            code = 495;
        } else {
            throw this.noOpCodeFoundFor(214, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fmul(AsmRegisterST dst, AsmRegisterST src) {
        int code = dst.getRegister() == 217 ? 503 : 598;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void fmulp(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(632, dst.get(), src.get()));
    }

    public void fnclex() {
        this.addInstruction(Instruction.create(580));
    }

    public void fndisi() {
        this.addInstruction(Instruction.create(578));
    }

    public void fneni() {
        this.addInstruction(Instruction.create(576));
    }

    public void fninit() {
        this.addInstruction(Instruction.create(582));
    }

    public void fnop() {
        this.addInstruction(Instruction.create(524));
    }

    public void fnsave(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 613 : 611;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fnsetpm() {
        this.addInstruction(Instruction.create(584));
    }

    public void fnstcw(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(520, dst.toMemoryOperand(this.getBitness())));
    }

    public void fnstdw(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(4236, dst.get()));
    }

    public void fnstenv(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 518 : 516;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fnstsg(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(4237, dst.get()));
    }

    public void fnstsw(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(651, dst.get()));
    }

    public void fnstsw(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(615, dst.toMemoryOperand(this.getBitness())));
    }

    public void fpatan() {
        this.addInstruction(Instruction.create(540));
    }

    public void fprem() {
        this.addInstruction(Instruction.create(545));
    }

    public void fprem1() {
        this.addInstruction(Instruction.create(542));
    }

    public void fptan() {
        this.addInstruction(Instruction.create(539));
    }

    public void frndint() {
        this.addInstruction(Instruction.create(549));
    }

    public void frstor(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 610 : 609;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void frstpm() {
        this.addInstruction(Instruction.create(586));
    }

    public void fsave(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 614 : 612;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fscale() {
        this.addInstruction(Instruction.create(550));
    }

    public void fsetpm() {
        this.addInstruction(Instruction.create(585));
    }

    public void fsin() {
        this.addInstruction(Instruction.create(551));
    }

    public void fsincos() {
        this.addInstruction(Instruction.create(548));
    }

    public void fsqrt() {
        this.addInstruction(Instruction.create(547));
    }

    public void fst(AsmRegisterST dst) {
        this.addInstruction(Instruction.create(619, dst.get()));
    }

    public void fst(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 607;
        } else if (dst.size == 3) {
            code = 511;
        } else {
            throw this.noOpCodeFoundFor(239, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fstcw(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(521, dst.toMemoryOperand(this.getBitness())));
    }

    public void fstdw(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(653, dst.get()));
    }

    public void fstenv(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 519 : 517;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fstp(AsmRegisterST dst) {
        this.addInstruction(Instruction.create(620, dst.get()));
    }

    public void fstp(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 5) {
            code = 571;
        } else if (dst.size == 4) {
            code = 608;
        } else if (dst.size == 3) {
            code = 512;
        } else {
            throw this.noOpCodeFoundFor(243, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fstpnce(AsmRegisterST dst) {
        this.addInstruction(Instruction.create(525, dst.get()));
    }

    public void fstsg(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(654, dst.get()));
    }

    public void fstsw(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(652, dst.get()));
    }

    public void fstsw(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(616, dst.toMemoryOperand(this.getBitness())));
    }

    public void fsub(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 593;
        } else if (dst.size == 3) {
            code = 498;
        } else {
            throw this.noOpCodeFoundFor(247, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fsub(AsmRegisterST dst, AsmRegisterST src) {
        int code = dst.getRegister() == 217 ? 506 : 602;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void fsubp(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(636, dst.get(), src.get()));
    }

    public void fsubr(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 594;
        } else if (dst.size == 3) {
            code = 499;
        } else {
            throw this.noOpCodeFoundFor(249, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void fsubr(AsmRegisterST dst, AsmRegisterST src) {
        int code = dst.getRegister() == 217 ? 507 : 601;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void fsubrp(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(635, dst.get(), src.get()));
    }

    public void ftst() {
        this.addInstruction(Instruction.create(528));
    }

    public void fucom(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(621, dst.get(), src.get()));
    }

    public void fucomi(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(587, dst.get(), src.get()));
    }

    public void fucomip(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(655, dst.get(), src.get()));
    }

    public void fucomp(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(622, dst.get(), src.get()));
    }

    public void fucompp() {
        this.addInstruction(Instruction.create(565));
    }

    public void fxam() {
        this.addInstruction(Instruction.create(529));
    }

    public void fxch(AsmRegisterST dst, AsmRegisterST src) {
        this.addInstruction(Instruction.create(523, dst.get(), src.get()));
    }

    public void fxrstor(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2012, dst.toMemoryOperand(this.getBitness())));
    }

    public void fxrstor64(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2013, dst.toMemoryOperand(this.getBitness())));
    }

    public void fxsave(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2008, dst.toMemoryOperand(this.getBitness())));
    }

    public void fxsave64(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2009, dst.toMemoryOperand(this.getBitness())));
    }

    public void fxtract() {
        this.addInstruction(Instruction.create(541));
    }

    public void fyl2x() {
        this.addInstruction(Instruction.create(538));
    }

    public void fyl2xp1() {
        this.addInstruction(Instruction.create(546));
    }

    public void getsec() {
        this.addInstruction(Instruction.create(1168));
    }

    public void getsecq() {
        this.addInstruction(Instruction.create(4223));
    }

    public void gf2p8affineinvqb(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(4064, dst.get(), src1.get(), imm));
    }

    public void gf2p8affineinvqb(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4064, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void gf2p8affineqb(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(4058, dst.get(), src1.get(), imm));
    }

    public void gf2p8affineqb(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4058, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void gf2p8mulb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3628, dst.get(), src.get()));
    }

    public void gf2p8mulb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3628, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void haddpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1806, dst.get(), src.get()));
    }

    public void haddpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1806, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void haddps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1809, dst.get(), src.get()));
    }

    public void haddps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1809, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void hlt() {
        this.addInstruction(Instruction.create(709));
    }

    public void hreset(int imm) {
        this.addInstruction(Instruction.create(4303, imm));
    }

    public void hsubpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1812, dst.get(), src.get()));
    }

    public void hsubpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1812, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void hsubps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1815, dst.get(), src.get()));
    }

    public void hsubps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1815, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ibts(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1987, dst.get(), src.get()));
    }

    public void ibts(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1987, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void ibts(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1988, dst.get(), src.get()));
    }

    public void ibts(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1988, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void idiv(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(718, dst.get()));
    }

    public void idiv(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(740, dst.get()));
    }

    public void idiv(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(741, dst.get()));
    }

    public void idiv(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(742, dst.get()));
    }

    public void idiv(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 742;
        } else if (dst.size == 3) {
            code = 741;
        } else if (dst.size == 2) {
            code = 740;
        } else if (dst.size == 1) {
            code = 718;
        } else {
            throw this.noOpCodeFoundFor(276, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void imul(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(716, dst.get()));
    }

    public void imul(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(734, dst.get()));
    }

    public void imul(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(735, dst.get()));
    }

    public void imul(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(736, dst.get()));
    }

    public void imul(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 736;
        } else if (dst.size == 3) {
            code = 735;
        } else if (dst.size == 2) {
            code = 734;
        } else if (dst.size == 1) {
            code = 716;
        } else {
            throw this.noOpCodeFoundFor(277, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void imul(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2070, dst.get(), src.get()));
    }

    public void imul(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2071, dst.get(), src.get()));
    }

    public void imul(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2072, dst.get(), src.get()));
    }

    public void imul(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2070, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void imul(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2071, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void imul(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2072, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void imul(AsmRegister16 dst, AsmRegister16 src1, int imm) {
        int code = imm >= -128 && imm <= 127 ? 150 : 144;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), imm));
    }

    public void imul(AsmRegister32 dst, AsmRegister32 src1, int imm) {
        int code = imm >= -128 && imm <= 127 ? 151 : 145;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), imm));
    }

    public void imul(AsmRegister64 dst, AsmRegister64 src1, int imm) {
        int code = imm >= -128 && imm <= 127 ? 152 : 146;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), imm));
    }

    public void imul(AsmRegister16 dst, AsmMemoryOperand src1, int imm) {
        int code = imm >= -128 && imm <= 127 ? 150 : 144;
        this.addInstruction(Instruction.create(code, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void imul(AsmRegister32 dst, AsmMemoryOperand src1, int imm) {
        int code = imm >= -128 && imm <= 127 ? 151 : 145;
        this.addInstruction(Instruction.create(code, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void imul(AsmRegister64 dst, AsmMemoryOperand src1, int imm) {
        int code = imm >= -128 && imm <= 127 ? 152 : 146;
        this.addInstruction(Instruction.create(code, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void in(AsmRegister8 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(702, dst.get(), src.get()));
    }

    public void in(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(703, dst.get(), src.get()));
    }

    public void in(AsmRegister32 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(704, dst.get(), src.get()));
    }

    public void in(AsmRegister8 dst, int imm) {
        this.addInstruction(Instruction.create(685, dst.get(), imm));
    }

    public void in(AsmRegister16 dst, int imm) {
        this.addInstruction(Instruction.create(686, dst.get(), imm));
    }

    public void in(AsmRegister32 dst, int imm) {
        this.addInstruction(Instruction.create(687, dst.get(), imm));
    }

    public void inc(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(749, dst.get()));
    }

    public void inc(AsmRegister16 dst) {
        int code = this.getBitness() == 64 ? 751 : 120;
        this.addInstruction(Instruction.create(code, dst.get()));
    }

    public void inc(AsmRegister32 dst) {
        int code = this.getBitness() == 64 ? 752 : 121;
        this.addInstruction(Instruction.create(code, dst.get()));
    }

    public void inc(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(753, dst.get()));
    }

    public void inc(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 753;
        } else if (dst.size == 3) {
            code = 752;
        } else if (dst.size == 2) {
            code = 751;
        } else if (dst.size == 1) {
            code = 749;
        } else {
            throw this.noOpCodeFoundFor(279, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void incsspd(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2030, dst.get()));
    }

    public void incsspq(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2031, dst.get()));
    }

    public void insb() {
        this.addInstruction(Instruction.createInsb(this.getBitness()));
    }

    public void insd() {
        this.addInstruction(Instruction.createInsd(this.getBitness()));
    }

    public void insertps(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3834, dst.get(), src1.get(), imm));
    }

    public void insertps(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3834, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void insertq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1775, dst.get(), src.get()));
    }

    public void insertq(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm, int imm1) {
        this.addInstruction(Instruction.create(1755, dst.get(), src1.get(), imm, imm1));
    }

    public void insw() {
        this.addInstruction(Instruction.createInsw(this.getBitness()));
    }

    public void int_(int imm) {
        this.addInstruction(Instruction.create(421, imm));
    }

    public void int1() {
        this.addInstruction(Instruction.create(708));
    }

    public void int3() {
        this.addInstruction(Instruction.create(420));
    }

    public void into() {
        this.addInstruction(Instruction.create(422));
    }

    public void invd() {
        this.addInstruction(Instruction.create(875));
    }

    public void invept(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3238, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void invept(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3239, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void invlpg(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(811, dst.toMemoryOperand(this.getBitness())));
    }

    public void invlpga() {
        int code = this.getBitness() == 64 ? 846 : (this.getBitness() >= 32 ? 845 : 844);
        this.addInstruction(Instruction.create(code));
    }

    public void invlpgb() {
        int code = this.getBitness() == 64 ? 4214 : (this.getBitness() >= 32 ? 4213 : 4212);
        this.addInstruction(Instruction.create(code));
    }

    public void invpcid(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3242, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void invpcid(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3243, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void invvpid(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3240, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void invvpid(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3241, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void iret() {
        this.addInstruction(Instruction.create(423));
    }

    public void iretd() {
        this.addInstruction(Instruction.create(424));
    }

    public void iretq() {
        this.addInstruction(Instruction.create(425));
    }

    public void ja(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 182 : (this.getBitness() >= 32 ? 181 : 180)) : (this.getBitness() == 64 ? 1877 : (this.getBitness() >= 32 ? 1876 : 1875));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void ja(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 182 : (this.getBitness() >= 32 ? 181 : 180)) : (this.getBitness() == 64 ? 1877 : (this.getBitness() >= 32 ? 1876 : 1875));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jae(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 170 : (this.getBitness() >= 32 ? 169 : 168)) : (this.getBitness() == 64 ? 1865 : (this.getBitness() >= 32 ? 1864 : 1863));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jae(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 170 : (this.getBitness() >= 32 ? 169 : 168)) : (this.getBitness() == 64 ? 1865 : (this.getBitness() >= 32 ? 1864 : 1863));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jb(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 167 : (this.getBitness() >= 32 ? 166 : 165)) : (this.getBitness() == 64 ? 1862 : (this.getBitness() >= 32 ? 1861 : 1860));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jb(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 167 : (this.getBitness() >= 32 ? 166 : 165)) : (this.getBitness() == 64 ? 1862 : (this.getBitness() >= 32 ? 1861 : 1860));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jbe(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 179 : (this.getBitness() >= 32 ? 178 : 177)) : (this.getBitness() == 64 ? 1874 : (this.getBitness() >= 32 ? 1873 : 1872));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jbe(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 179 : (this.getBitness() >= 32 ? 178 : 177)) : (this.getBitness() == 64 ? 1874 : (this.getBitness() >= 32 ? 1873 : 1872));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jc(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 167 : (this.getBitness() >= 32 ? 166 : 165)) : (this.getBitness() == 64 ? 1862 : (this.getBitness() >= 32 ? 1861 : 1860));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jc(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 167 : (this.getBitness() >= 32 ? 166 : 165)) : (this.getBitness() == 64 ? 1862 : (this.getBitness() >= 32 ? 1861 : 1860));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jcxz(CodeLabel dst) {
        this.addInstruction(Instruction.createBranch(678, dst.id));
    }

    public void jcxz(long dst) {
        this.addInstruction(Instruction.createBranch(678, dst));
    }

    public void je(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 173 : (this.getBitness() >= 32 ? 172 : 171)) : (this.getBitness() == 64 ? 1868 : (this.getBitness() >= 32 ? 1867 : 1866));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void je(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 173 : (this.getBitness() >= 32 ? 172 : 171)) : (this.getBitness() == 64 ? 1868 : (this.getBitness() >= 32 ? 1867 : 1866));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jecxz(CodeLabel dst) {
        this.addInstruction(Instruction.createBranch(681, dst.id));
    }

    public void jecxz(long dst) {
        this.addInstruction(Instruction.createBranch(681, dst));
    }

    public void jg(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 206 : (this.getBitness() >= 32 ? 205 : 204)) : (this.getBitness() == 64 ? 1901 : (this.getBitness() >= 32 ? 1900 : 1899));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jg(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 206 : (this.getBitness() >= 32 ? 205 : 204)) : (this.getBitness() == 64 ? 1901 : (this.getBitness() >= 32 ? 1900 : 1899));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jge(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 200 : (this.getBitness() >= 32 ? 199 : 198)) : (this.getBitness() == 64 ? 1895 : (this.getBitness() >= 32 ? 1894 : 1893));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jge(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 200 : (this.getBitness() >= 32 ? 199 : 198)) : (this.getBitness() == 64 ? 1895 : (this.getBitness() >= 32 ? 1894 : 1893));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jl(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 197 : (this.getBitness() >= 32 ? 196 : 195)) : (this.getBitness() == 64 ? 1892 : (this.getBitness() >= 32 ? 1891 : 1890));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jl(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 197 : (this.getBitness() >= 32 ? 196 : 195)) : (this.getBitness() == 64 ? 1892 : (this.getBitness() >= 32 ? 1891 : 1890));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jle(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 203 : (this.getBitness() >= 32 ? 202 : 201)) : (this.getBitness() == 64 ? 1898 : (this.getBitness() >= 32 ? 1897 : 1896));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jle(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 203 : (this.getBitness() >= 32 ? 202 : 201)) : (this.getBitness() == 64 ? 1898 : (this.getBitness() >= 32 ? 1897 : 1896));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jmp(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(763, dst.get()));
    }

    public void jmp(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(764, dst.get()));
    }

    public void jmp(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(765, dst.get()));
    }

    public void jmp(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 5) {
            code = 768;
        } else if (dst.size == 4) {
            code = 765;
        } else if (dst.size == 6) {
            code = 767;
        } else if (dst.size == 3) {
            code = this.getBitness() >= 32 ? 764 : 766;
        } else if (dst.size == 2) {
            code = 763;
        } else {
            throw this.noOpCodeFoundFor(308, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void jmp(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 701 : (this.getBitness() >= 32 ? 700 : 699)) : (this.getBitness() == 64 ? 696 : (this.getBitness() >= 32 ? 695 : 694));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jmp(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 701 : (this.getBitness() >= 32 ? 700 : 699)) : (this.getBitness() == 64 ? 696 : (this.getBitness() >= 32 ? 695 : 694));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jmpe(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(790, dst.get()));
    }

    public void jmpe(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(791, dst.get()));
    }

    public void jmpe(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 791 : 790;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void jmpe(CodeLabel dst) {
        int code = this.getBitness() >= 32 ? 2096 : 2095;
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jmpe(long dst) {
        int code = this.getBitness() >= 32 ? 2096 : 2095;
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jna(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 179 : (this.getBitness() >= 32 ? 178 : 177)) : (this.getBitness() == 64 ? 1874 : (this.getBitness() >= 32 ? 1873 : 1872));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jna(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 179 : (this.getBitness() >= 32 ? 178 : 177)) : (this.getBitness() == 64 ? 1874 : (this.getBitness() >= 32 ? 1873 : 1872));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jnae(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 167 : (this.getBitness() >= 32 ? 166 : 165)) : (this.getBitness() == 64 ? 1862 : (this.getBitness() >= 32 ? 1861 : 1860));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jnae(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 167 : (this.getBitness() >= 32 ? 166 : 165)) : (this.getBitness() == 64 ? 1862 : (this.getBitness() >= 32 ? 1861 : 1860));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jnb(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 170 : (this.getBitness() >= 32 ? 169 : 168)) : (this.getBitness() == 64 ? 1865 : (this.getBitness() >= 32 ? 1864 : 1863));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jnb(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 170 : (this.getBitness() >= 32 ? 169 : 168)) : (this.getBitness() == 64 ? 1865 : (this.getBitness() >= 32 ? 1864 : 1863));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jnbe(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 182 : (this.getBitness() >= 32 ? 181 : 180)) : (this.getBitness() == 64 ? 1877 : (this.getBitness() >= 32 ? 1876 : 1875));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jnbe(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 182 : (this.getBitness() >= 32 ? 181 : 180)) : (this.getBitness() == 64 ? 1877 : (this.getBitness() >= 32 ? 1876 : 1875));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jnc(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 170 : (this.getBitness() >= 32 ? 169 : 168)) : (this.getBitness() == 64 ? 1865 : (this.getBitness() >= 32 ? 1864 : 1863));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jnc(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 170 : (this.getBitness() >= 32 ? 169 : 168)) : (this.getBitness() == 64 ? 1865 : (this.getBitness() >= 32 ? 1864 : 1863));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jne(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 176 : (this.getBitness() >= 32 ? 175 : 174)) : (this.getBitness() == 64 ? 1871 : (this.getBitness() >= 32 ? 1870 : 1869));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jne(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 176 : (this.getBitness() >= 32 ? 175 : 174)) : (this.getBitness() == 64 ? 1871 : (this.getBitness() >= 32 ? 1870 : 1869));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jng(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 203 : (this.getBitness() >= 32 ? 202 : 201)) : (this.getBitness() == 64 ? 1898 : (this.getBitness() >= 32 ? 1897 : 1896));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jng(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 203 : (this.getBitness() >= 32 ? 202 : 201)) : (this.getBitness() == 64 ? 1898 : (this.getBitness() >= 32 ? 1897 : 1896));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jnge(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 197 : (this.getBitness() >= 32 ? 196 : 195)) : (this.getBitness() == 64 ? 1892 : (this.getBitness() >= 32 ? 1891 : 1890));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jnge(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 197 : (this.getBitness() >= 32 ? 196 : 195)) : (this.getBitness() == 64 ? 1892 : (this.getBitness() >= 32 ? 1891 : 1890));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jnl(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 200 : (this.getBitness() >= 32 ? 199 : 198)) : (this.getBitness() == 64 ? 1895 : (this.getBitness() >= 32 ? 1894 : 1893));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jnl(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 200 : (this.getBitness() >= 32 ? 199 : 198)) : (this.getBitness() == 64 ? 1895 : (this.getBitness() >= 32 ? 1894 : 1893));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jnle(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 206 : (this.getBitness() >= 32 ? 205 : 204)) : (this.getBitness() == 64 ? 1901 : (this.getBitness() >= 32 ? 1900 : 1899));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jnle(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 206 : (this.getBitness() >= 32 ? 205 : 204)) : (this.getBitness() == 64 ? 1901 : (this.getBitness() >= 32 ? 1900 : 1899));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jno(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 164 : (this.getBitness() >= 32 ? 163 : 162)) : (this.getBitness() == 64 ? 1859 : (this.getBitness() >= 32 ? 1858 : 1857));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jno(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 164 : (this.getBitness() >= 32 ? 163 : 162)) : (this.getBitness() == 64 ? 1859 : (this.getBitness() >= 32 ? 1858 : 1857));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jnp(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 194 : (this.getBitness() >= 32 ? 193 : 192)) : (this.getBitness() == 64 ? 1889 : (this.getBitness() >= 32 ? 1888 : 1887));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jnp(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 194 : (this.getBitness() >= 32 ? 193 : 192)) : (this.getBitness() == 64 ? 1889 : (this.getBitness() >= 32 ? 1888 : 1887));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jns(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 188 : (this.getBitness() >= 32 ? 187 : 186)) : (this.getBitness() == 64 ? 1883 : (this.getBitness() >= 32 ? 1882 : 1881));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jns(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 188 : (this.getBitness() >= 32 ? 187 : 186)) : (this.getBitness() == 64 ? 1883 : (this.getBitness() >= 32 ? 1882 : 1881));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jnz(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 176 : (this.getBitness() >= 32 ? 175 : 174)) : (this.getBitness() == 64 ? 1871 : (this.getBitness() >= 32 ? 1870 : 1869));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jnz(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 176 : (this.getBitness() >= 32 ? 175 : 174)) : (this.getBitness() == 64 ? 1871 : (this.getBitness() >= 32 ? 1870 : 1869));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jo(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 161 : (this.getBitness() >= 32 ? 160 : 159)) : (this.getBitness() == 64 ? 1856 : (this.getBitness() >= 32 ? 1855 : 1854));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jo(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 161 : (this.getBitness() >= 32 ? 160 : 159)) : (this.getBitness() == 64 ? 1856 : (this.getBitness() >= 32 ? 1855 : 1854));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jp(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 191 : (this.getBitness() >= 32 ? 190 : 189)) : (this.getBitness() == 64 ? 1886 : (this.getBitness() >= 32 ? 1885 : 1884));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jp(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 191 : (this.getBitness() >= 32 ? 190 : 189)) : (this.getBitness() == 64 ? 1886 : (this.getBitness() >= 32 ? 1885 : 1884));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jpe(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 191 : (this.getBitness() >= 32 ? 190 : 189)) : (this.getBitness() == 64 ? 1886 : (this.getBitness() >= 32 ? 1885 : 1884));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jpe(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 191 : (this.getBitness() >= 32 ? 190 : 189)) : (this.getBitness() == 64 ? 1886 : (this.getBitness() >= 32 ? 1885 : 1884));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jpo(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 194 : (this.getBitness() >= 32 ? 193 : 192)) : (this.getBitness() == 64 ? 1889 : (this.getBitness() >= 32 ? 1888 : 1887));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jpo(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 194 : (this.getBitness() >= 32 ? 193 : 192)) : (this.getBitness() == 64 ? 1889 : (this.getBitness() >= 32 ? 1888 : 1887));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jrcxz(CodeLabel dst) {
        this.addInstruction(Instruction.createBranch(684, dst.id));
    }

    public void jrcxz(long dst) {
        this.addInstruction(Instruction.createBranch(684, dst));
    }

    public void js(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 185 : (this.getBitness() >= 32 ? 184 : 183)) : (this.getBitness() == 64 ? 1880 : (this.getBitness() >= 32 ? 1879 : 1878));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void js(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 185 : (this.getBitness() >= 32 ? 184 : 183)) : (this.getBitness() == 64 ? 1880 : (this.getBitness() >= 32 ? 1879 : 1878));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void jz(CodeLabel dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 173 : (this.getBitness() >= 32 ? 172 : 171)) : (this.getBitness() == 64 ? 1868 : (this.getBitness() >= 32 ? 1867 : 1866));
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void jz(long dst) {
        int code = this.getPreferShortBranch() ? (this.getBitness() == 64 ? 173 : (this.getBitness() >= 32 ? 172 : 171)) : (this.getBitness() == 64 ? 1868 : (this.getBitness() >= 32 ? 1867 : 1866));
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void kaddb(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1243, dst.get(), src1.get(), src2.get()));
    }

    public void kaddd(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1244, dst.get(), src1.get(), src2.get()));
    }

    public void kaddq(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1242, dst.get(), src1.get(), src2.get()));
    }

    public void kaddw(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1241, dst.get(), src1.get(), src2.get()));
    }

    public void kandb(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1219, dst.get(), src1.get(), src2.get()));
    }

    public void kandd(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1220, dst.get(), src1.get(), src2.get()));
    }

    public void kandnb(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1223, dst.get(), src1.get(), src2.get()));
    }

    public void kandnd(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1224, dst.get(), src1.get(), src2.get()));
    }

    public void kandnq(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1222, dst.get(), src1.get(), src2.get()));
    }

    public void kandnw(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1221, dst.get(), src1.get(), src2.get()));
    }

    public void kandq(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1218, dst.get(), src1.get(), src2.get()));
    }

    public void kandw(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1217, dst.get(), src1.get(), src2.get()));
    }

    public void kmovb(AsmRegisterK dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1927, dst.get(), src.get()));
    }

    public void kmovb(AsmRegister32 dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1931, dst.get(), src.get()));
    }

    public void kmovb(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1920, dst.get(), src.get()));
    }

    public void kmovb(AsmMemoryOperand dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1924, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void kmovb(AsmRegisterK dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1920, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void kmovd(AsmRegisterK dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1928, dst.get(), src.get()));
    }

    public void kmovd(AsmRegister32 dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1932, dst.get(), src.get()));
    }

    public void kmovd(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1921, dst.get(), src.get()));
    }

    public void kmovd(AsmMemoryOperand dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1925, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void kmovd(AsmRegisterK dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1921, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void kmovq(AsmRegisterK dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1929, dst.get(), src.get()));
    }

    public void kmovq(AsmRegister64 dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1933, dst.get(), src.get()));
    }

    public void kmovq(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1919, dst.get(), src.get()));
    }

    public void kmovq(AsmMemoryOperand dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1923, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void kmovq(AsmRegisterK dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1919, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void kmovw(AsmRegisterK dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1926, dst.get(), src.get()));
    }

    public void kmovw(AsmRegister32 dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1930, dst.get(), src.get()));
    }

    public void kmovw(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1918, dst.get(), src.get()));
    }

    public void kmovw(AsmMemoryOperand dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1922, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void kmovw(AsmRegisterK dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1918, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void knotb(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1227, dst.get(), src.get()));
    }

    public void knotd(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1228, dst.get(), src.get()));
    }

    public void knotq(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1226, dst.get(), src.get()));
    }

    public void knotw(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1225, dst.get(), src.get()));
    }

    public void korb(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1231, dst.get(), src1.get(), src2.get()));
    }

    public void kord(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1232, dst.get(), src1.get(), src2.get()));
    }

    public void korq(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1230, dst.get(), src1.get(), src2.get()));
    }

    public void kortestb(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1936, dst.get(), src.get()));
    }

    public void kortestd(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1937, dst.get(), src.get()));
    }

    public void kortestq(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1935, dst.get(), src.get()));
    }

    public void kortestw(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1934, dst.get(), src.get()));
    }

    public void korw(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1229, dst.get(), src1.get(), src2.get()));
    }

    public void kshiftlb(AsmRegisterK dst, AsmRegisterK src1, int imm) {
        this.addInstruction(Instruction.create(3865, dst.get(), src1.get(), imm));
    }

    public void kshiftld(AsmRegisterK dst, AsmRegisterK src1, int imm) {
        this.addInstruction(Instruction.create(3867, dst.get(), src1.get(), imm));
    }

    public void kshiftlq(AsmRegisterK dst, AsmRegisterK src1, int imm) {
        this.addInstruction(Instruction.create(3868, dst.get(), src1.get(), imm));
    }

    public void kshiftlw(AsmRegisterK dst, AsmRegisterK src1, int imm) {
        this.addInstruction(Instruction.create(3866, dst.get(), src1.get(), imm));
    }

    public void kshiftrb(AsmRegisterK dst, AsmRegisterK src1, int imm) {
        this.addInstruction(Instruction.create(3861, dst.get(), src1.get(), imm));
    }

    public void kshiftrd(AsmRegisterK dst, AsmRegisterK src1, int imm) {
        this.addInstruction(Instruction.create(3863, dst.get(), src1.get(), imm));
    }

    public void kshiftrq(AsmRegisterK dst, AsmRegisterK src1, int imm) {
        this.addInstruction(Instruction.create(3864, dst.get(), src1.get(), imm));
    }

    public void kshiftrw(AsmRegisterK dst, AsmRegisterK src1, int imm) {
        this.addInstruction(Instruction.create(3862, dst.get(), src1.get(), imm));
    }

    public void ktestb(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1940, dst.get(), src.get()));
    }

    public void ktestd(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1941, dst.get(), src.get()));
    }

    public void ktestq(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1939, dst.get(), src.get()));
    }

    public void ktestw(AsmRegisterK dst, AsmRegisterK src) {
        this.addInstruction(Instruction.create(1938, dst.get(), src.get()));
    }

    public void kunpckbw(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1247, dst.get(), src1.get(), src2.get()));
    }

    public void kunpckdq(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1246, dst.get(), src1.get(), src2.get()));
    }

    public void kunpckwd(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1245, dst.get(), src1.get(), src2.get()));
    }

    public void kxnorb(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1235, dst.get(), src1.get(), src2.get()));
    }

    public void kxnord(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1236, dst.get(), src1.get(), src2.get()));
    }

    public void kxnorq(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1234, dst.get(), src1.get(), src2.get()));
    }

    public void kxnorw(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1233, dst.get(), src1.get(), src2.get()));
    }

    public void kxorb(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1239, dst.get(), src1.get(), src2.get()));
    }

    public void kxord(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1240, dst.get(), src1.get(), src2.get()));
    }

    public void kxorq(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1238, dst.get(), src1.get(), src2.get()));
    }

    public void kxorw(AsmRegisterK dst, AsmRegisterK src1, AsmRegisterK src2) {
        this.addInstruction(Instruction.create(1237, dst.get(), src1.get(), src2.get()));
    }

    public void lahf() {
        this.addInstruction(Instruction.create(322));
    }

    public void lar(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(862, dst.get(), src.get()));
    }

    public void lar(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(863, dst.get(), src.get()));
    }

    public void lar(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(864, dst.get(), src.get()));
    }

    public void lar(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(862, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lar(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(863, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lddqu(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2462, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ldmxcsr(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2016, dst.toMemoryOperand(this.getBitness())));
    }

    public void lds(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(399, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lds(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(400, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ldtilecfg(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4224, dst.toMemoryOperand(this.getBitness())));
    }

    public void lea(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(290, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lea(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(291, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lea(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(292, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void leave() {
        int code = this.getBitness() == 64 ? 413 : (this.getBitness() >= 32 ? 412 : 411);
        this.addInstruction(Instruction.create(code));
    }

    public void les(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(397, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void les(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(398, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lfence() {
        this.addInstruction(Instruction.create(2045));
    }

    public void lfs(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2083, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lfs(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2084, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lfs(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2085, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lgdt(AsmMemoryOperand dst) {
        int code = this.getBitness() == 64 ? 800 : (this.getBitness() >= 32 ? 799 : 798);
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void lgs(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2086, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lgs(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2087, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lgs(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2088, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lidt(AsmMemoryOperand dst) {
        int code = this.getBitness() == 64 ? 803 : (this.getBitness() >= 32 ? 802 : 801);
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void lkgs(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(4318, dst.get()));
    }

    public void lkgs(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(4319, dst.get()));
    }

    public void lkgs(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(4320, dst.get()));
    }

    public void lkgs(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 4319 : 4318;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void lldt(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(778, dst.get()));
    }

    public void lldt(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(779, dst.get()));
    }

    public void lldt(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(780, dst.get()));
    }

    public void lldt(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 779 : 778;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void llwpcb(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(4122, dst.get()));
    }

    public void llwpcb(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(4123, dst.get()));
    }

    public void lmsw(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(808, dst.get()));
    }

    public void lmsw(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(809, dst.get()));
    }

    public void lmsw(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(810, dst.get()));
    }

    public void lmsw(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 809 : 808;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void loadall() {
        this.addInstruction(Instruction.create(872));
    }

    public void loadiwkey(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4287, dst.get(), src.get()));
    }

    public void lodsb() {
        this.addInstruction(Instruction.createLodsb(this.getBitness()));
    }

    public void lodsd() {
        this.addInstruction(Instruction.createLodsd(this.getBitness()));
    }

    public void lodsq() {
        this.addInstruction(Instruction.createLodsq(this.getBitness()));
    }

    public void lodsw() {
        this.addInstruction(Instruction.createLodsw(this.getBitness()));
    }

    public void loop(CodeLabel dst) {
        int code = this.getBitness() == 64 ? 677 : (this.getBitness() >= 32 ? 674 : 671);
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void loop(long dst) {
        int code = this.getBitness() == 64 ? 677 : (this.getBitness() >= 32 ? 674 : 671);
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void loope(CodeLabel dst) {
        int code = this.getBitness() == 64 ? 670 : (this.getBitness() >= 32 ? 667 : 664);
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void loope(long dst) {
        int code = this.getBitness() == 64 ? 670 : (this.getBitness() >= 32 ? 667 : 664);
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void loopne(CodeLabel dst) {
        int code = this.getBitness() == 64 ? 663 : (this.getBitness() >= 32 ? 660 : 657);
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void loopne(long dst) {
        int code = this.getBitness() == 64 ? 663 : (this.getBitness() >= 32 ? 660 : 657);
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void loopnz(CodeLabel dst) {
        int code = this.getBitness() == 64 ? 663 : (this.getBitness() >= 32 ? 660 : 657);
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void loopnz(long dst) {
        int code = this.getBitness() == 64 ? 663 : (this.getBitness() >= 32 ? 660 : 657);
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void loopz(CodeLabel dst) {
        int code = this.getBitness() == 64 ? 670 : (this.getBitness() >= 32 ? 667 : 664);
        this.addInstruction(Instruction.createBranch(code, dst.id));
    }

    public void loopz(long dst) {
        int code = this.getBitness() == 64 ? 670 : (this.getBitness() >= 32 ? 667 : 664);
        this.addInstruction(Instruction.createBranch(code, dst));
    }

    public void lsl(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(865, dst.get(), src.get()));
    }

    public void lsl(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(866, dst.get(), src.get()));
    }

    public void lsl(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(867, dst.get(), src.get()));
    }

    public void lsl(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(865, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lsl(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(866, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lss(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2077, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lss(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2078, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lss(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2079, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ltr(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(781, dst.get()));
    }

    public void ltr(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(782, dst.get()));
    }

    public void ltr(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(783, dst.get()));
    }

    public void ltr(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 782 : 781;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void lwpins(AsmRegister32 dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(4173, dst.get(), src1.get(), imm));
    }

    public void lwpins(AsmRegister64 dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(4174, dst.get(), src1.get(), imm));
    }

    public void lwpins(AsmRegister32 dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4173, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void lwpins(AsmRegister64 dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4174, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void lwpval(AsmRegister32 dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(4175, dst.get(), src1.get(), imm));
    }

    public void lwpval(AsmRegister64 dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(4176, dst.get(), src1.get(), imm));
    }

    public void lwpval(AsmRegister32 dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4175, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void lwpval(AsmRegister64 dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4176, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void lzcnt(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2127, dst.get(), src.get()));
    }

    public void lzcnt(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2128, dst.get(), src.get()));
    }

    public void lzcnt(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2129, dst.get(), src.get()));
    }

    public void lzcnt(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2127, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lzcnt(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2128, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void lzcnt(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2129, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void maskmovdqu(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.createMaskmovdqu(this.getBitness(), dst.get(), src.get()));
    }

    public void maskmovq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.createMaskmovq(this.getBitness(), dst.get(), src.get()));
    }

    public void maxpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1471, dst.get(), src.get()));
    }

    public void maxpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1471, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void maxps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1465, dst.get(), src.get()));
    }

    public void maxps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1465, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void maxsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1480, dst.get(), src.get()));
    }

    public void maxsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1480, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void maxss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1477, dst.get(), src.get()));
    }

    public void maxss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1477, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mcommit() {
        this.addInstruction(Instruction.create(856));
    }

    public void mfence() {
        this.addInstruction(Instruction.create(2053));
    }

    public void minpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1435, dst.get(), src.get()));
    }

    public void minpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1435, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void minps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1429, dst.get(), src.get()));
    }

    public void minps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1429, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void minsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1444, dst.get(), src.get()));
    }

    public void minsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1444, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void minss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1441, dst.get(), src.get()));
    }

    public void minss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1441, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void monitor() {
        int code = this.getBitness() == 64 ? 820 : (this.getBitness() >= 32 ? 819 : 818);
        this.addInstruction(Instruction.create(code));
    }

    public void monitorx() {
        int code = this.getBitness() == 64 ? 855 : (this.getBitness() >= 32 ? 854 : 853);
        this.addInstruction(Instruction.create(code));
    }

    public void montmul() {
        int code = this.getBitness() == 64 ? 1960 : (this.getBitness() >= 32 ? 1959 : 1958);
        this.addInstruction(Instruction.create(code));
    }

    public void mov(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(279, dst.get(), src.get()));
    }

    public void mov(AsmMemoryOperand dst, AsmRegister8 src) {
        int code = src.getRegister() == 1 && this.getBitness() == 64 && dst.isDisplacementOnly() ? 327 : (src.getRegister() == 1 && this.getBitness() < 64 && dst.isDisplacementOnly() ? 327 : 279);
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void mov(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(280, dst.get(), src.get()));
    }

    public void mov(AsmRegisterSegment dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(293, dst.get(), src.get()));
    }

    public void mov(AsmMemoryOperand dst, AsmRegister16 src) {
        int code = src.getRegister() == 21 && this.getBitness() == 64 && dst.isDisplacementOnly() ? 328 : (src.getRegister() == 21 && this.getBitness() < 64 && dst.isDisplacementOnly() ? 328 : 280);
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void mov(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(281, dst.get(), src.get()));
    }

    public void mov(AsmRegisterSegment dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(294, dst.get(), src.get()));
    }

    public void mov(AsmRegisterCR dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1063, dst.get(), src.get()));
    }

    public void mov(AsmRegisterDR dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1065, dst.get(), src.get()));
    }

    public void mov(AsmRegisterTR dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1068, dst.get(), src.get()));
    }

    public void mov(AsmMemoryOperand dst, AsmRegister32 src) {
        int code = src.getRegister() == 37 && this.getBitness() == 64 && dst.isDisplacementOnly() ? 329 : (src.getRegister() == 37 && this.getBitness() < 64 && dst.isDisplacementOnly() ? 329 : 281);
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void mov(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(282, dst.get(), src.get()));
    }

    public void mov(AsmRegisterSegment dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(295, dst.get(), src.get()));
    }

    public void mov(AsmRegisterCR dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1064, dst.get(), src.get()));
    }

    public void mov(AsmRegisterDR dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1066, dst.get(), src.get()));
    }

    public void mov(AsmMemoryOperand dst, AsmRegister64 src) {
        int code = src.getRegister() == 53 && this.getBitness() == 64 && dst.isDisplacementOnly() ? 330 : (src.getRegister() == 53 && this.getBitness() < 64 && dst.isDisplacementOnly() ? 330 : 282);
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void mov(AsmRegister16 dst, AsmRegisterSegment src) {
        this.addInstruction(Instruction.create(287, dst.get(), src.get()));
    }

    public void mov(AsmRegister32 dst, AsmRegisterSegment src) {
        this.addInstruction(Instruction.create(288, dst.get(), src.get()));
    }

    public void mov(AsmRegister64 dst, AsmRegisterSegment src) {
        this.addInstruction(Instruction.create(289, dst.get(), src.get()));
    }

    public void mov(AsmMemoryOperand dst, AsmRegisterSegment src) {
        int code = this.getBitness() >= 32 ? 288 : 287;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void mov(AsmRegister32 dst, AsmRegisterCR src) {
        this.addInstruction(Instruction.create(1059, dst.get(), src.get()));
    }

    public void mov(AsmRegister64 dst, AsmRegisterCR src) {
        this.addInstruction(Instruction.create(1060, dst.get(), src.get()));
    }

    public void mov(AsmRegister32 dst, AsmRegisterDR src) {
        this.addInstruction(Instruction.create(1061, dst.get(), src.get()));
    }

    public void mov(AsmRegister64 dst, AsmRegisterDR src) {
        this.addInstruction(Instruction.create(1062, dst.get(), src.get()));
    }

    public void mov(AsmRegister32 dst, AsmRegisterTR src) {
        this.addInstruction(Instruction.create(1067, dst.get(), src.get()));
    }

    public void mov(AsmRegister8 dst, AsmMemoryOperand src) {
        int code = dst.getRegister() == 1 && this.getBitness() == 64 && src.isDisplacementOnly() ? 323 : (dst.getRegister() == 1 && this.getBitness() < 64 && src.isDisplacementOnly() ? 323 : 283);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mov(AsmRegister16 dst, AsmMemoryOperand src) {
        int code = dst.getRegister() == 21 && this.getBitness() == 64 && src.isDisplacementOnly() ? 324 : (dst.getRegister() == 21 && this.getBitness() < 64 && src.isDisplacementOnly() ? 324 : 284);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mov(AsmRegister32 dst, AsmMemoryOperand src) {
        int code = dst.getRegister() == 37 && this.getBitness() == 64 && src.isDisplacementOnly() ? 325 : (dst.getRegister() == 37 && this.getBitness() < 64 && src.isDisplacementOnly() ? 325 : 285);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mov(AsmRegister64 dst, AsmMemoryOperand src) {
        int code = dst.getRegister() == 53 && this.getBitness() == 64 && src.isDisplacementOnly() ? 326 : (dst.getRegister() == 53 && this.getBitness() < 64 && src.isDisplacementOnly() ? 326 : 286);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mov(AsmRegisterSegment dst, AsmMemoryOperand src) {
        int code = this.getBitness() >= 32 ? 294 : 293;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mov(AsmRegister8 dst, int imm) {
        this.addInstruction(Instruction.create(355, dst.get(), imm));
    }

    public void mov(AsmRegister16 dst, int imm) {
        this.addInstruction(Instruction.create(356, dst.get(), imm));
    }

    public void mov(AsmRegister32 dst, int imm) {
        this.addInstruction(Instruction.create(357, dst.get(), imm));
    }

    public void mov(AsmRegister64 dst, long imm) {
        this.addInstruction(Instruction.create(358, dst.get(), imm));
    }

    public void mov(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = 405;
        } else if (dst.size == 3) {
            code = 404;
        } else if (dst.size == 2) {
            code = 403;
        } else if (dst.size == 1) {
            code = 401;
        } else {
            throw this.noOpCodeFoundFor(414, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void movapd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1075, dst.get(), src.get()));
    }

    public void movapd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1087, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movapd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1075, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movaps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1069, dst.get(), src.get()));
    }

    public void movaps(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1081, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movaps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1069, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movbe(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(3665, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movbe(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(3666, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movbe(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(3667, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movbe(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3660, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movbe(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3661, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movbe(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3662, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movd(AsmRegisterMM dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1579, dst.get(), src.get()));
    }

    public void movd(AsmRegisterXMM dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1581, dst.get(), src.get()));
    }

    public void movd(AsmRegister32 dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1818, dst.get(), src.get()));
    }

    public void movd(AsmMemoryOperand dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1818, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movd(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1820, dst.get(), src.get()));
    }

    public void movd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1820, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1579, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1581, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movddup(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(952, dst.get(), src.get()));
    }

    public void movddup(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(952, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movdir64b(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3703, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movdir64b(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3704, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movdir64b(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3705, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movdiri(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(3712, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movdiri(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(3713, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movdq2q(AsmRegisterMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2256, dst.get(), src.get()));
    }

    public void movdqa(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1588, dst.get(), src.get()));
    }

    public void movdqa(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1830, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movdqa(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1588, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movdqu(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1597, dst.get(), src.get()));
    }

    public void movdqu(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1839, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movdqu(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1597, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movhlps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(937, dst.get(), src.get()));
    }

    public void movhpd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1006, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movhpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(994, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movhps(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1003, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movhps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(991, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movlhps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(988, dst.get(), src.get()));
    }

    public void movlpd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(961, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movlpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(943, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movlps(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(958, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movlps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(938, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movmskpd(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1254, dst.get(), src.get()));
    }

    public void movmskpd(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1255, dst.get(), src.get()));
    }

    public void movmskps(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1248, dst.get(), src.get()));
    }

    public void movmskps(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1249, dst.get(), src.get()));
    }

    public void movntdq(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2394, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movntdqa(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2831, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movnti(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2158, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movnti(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2159, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movntpd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1113, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movntps(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1107, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movntq(AsmMemoryOperand dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2393, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movntsd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1120, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movntss(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1119, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movq(AsmRegisterMM dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1580, dst.get(), src.get()));
    }

    public void movq(AsmRegisterXMM dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1582, dst.get(), src.get()));
    }

    public void movq(AsmRegister64 dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1819, dst.get(), src.get()));
    }

    public void movq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1587, dst.get(), src.get()));
    }

    public void movq(AsmMemoryOperand dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1829, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movq(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1821, dst.get(), src.get()));
    }

    public void movq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1826, dst.get(), src.get()));
    }

    public void movq(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2252, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movq(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1587, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1826, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movq2dq(AsmRegisterXMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2255, dst.get(), src.get()));
    }

    public void movsb() {
        this.addInstruction(Instruction.createMovsb(this.getBitness()));
    }

    public void movsd() {
        this.addInstruction(Instruction.createMovsd(this.getBitness()));
    }

    public void movsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(910, dst.get(), src.get()));
    }

    public void movsd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(932, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(910, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movshdup(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(997, dst.get(), src.get()));
    }

    public void movshdup(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(997, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movsldup(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(946, dst.get(), src.get()));
    }

    public void movsldup(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(946, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movsq() {
        this.addInstruction(Instruction.createMovsq(this.getBitness()));
    }

    public void movss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(905, dst.get(), src.get()));
    }

    public void movss(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(927, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(905, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movsw() {
        this.addInstruction(Instruction.createMovsw(this.getBitness()));
    }

    public void movsx(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(2130, dst.get(), src.get()));
    }

    public void movsx(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(2131, dst.get(), src.get()));
    }

    public void movsx(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(2132, dst.get(), src.get()));
    }

    public void movsx(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2133, dst.get(), src.get()));
    }

    public void movsx(AsmRegister32 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2134, dst.get(), src.get()));
    }

    public void movsx(AsmRegister64 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2135, dst.get(), src.get()));
    }

    public void movsx(AsmRegister16 dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 2) {
            code = 2133;
        } else if (src.size == 1) {
            code = 2130;
        } else {
            throw this.noOpCodeFoundFor(450, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movsx(AsmRegister32 dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 2) {
            code = 2134;
        } else if (src.size == 1) {
            code = 2131;
        } else {
            throw this.noOpCodeFoundFor(450, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movsx(AsmRegister64 dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 2) {
            code = 2135;
        } else if (src.size == 1) {
            code = 2132;
        } else {
            throw this.noOpCodeFoundFor(450, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movsxd(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(138, dst.get(), src.get()));
    }

    public void movsxd(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(139, dst.get(), src.get()));
    }

    public void movsxd(AsmRegister64 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(140, dst.get(), src.get()));
    }

    public void movsxd(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(138, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movsxd(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(139, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movsxd(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(140, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movupd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(899, dst.get(), src.get()));
    }

    public void movupd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(921, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movupd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(899, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movups(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(893, dst.get(), src.get()));
    }

    public void movups(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(915, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void movups(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(893, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movzx(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(2089, dst.get(), src.get()));
    }

    public void movzx(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(2090, dst.get(), src.get()));
    }

    public void movzx(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(2091, dst.get(), src.get()));
    }

    public void movzx(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2092, dst.get(), src.get()));
    }

    public void movzx(AsmRegister32 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2093, dst.get(), src.get()));
    }

    public void movzx(AsmRegister64 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2094, dst.get(), src.get()));
    }

    public void movzx(AsmRegister16 dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 2) {
            code = 2092;
        } else if (src.size == 1) {
            code = 2089;
        } else {
            throw this.noOpCodeFoundFor(454, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movzx(AsmRegister32 dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 2) {
            code = 2093;
        } else if (src.size == 1) {
            code = 2090;
        } else {
            throw this.noOpCodeFoundFor(454, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void movzx(AsmRegister64 dst, AsmMemoryOperand src) {
        int code;
        if (src.size == 2) {
            code = 2094;
        } else if (src.size == 1) {
            code = 2091;
        } else {
            throw this.noOpCodeFoundFor(454, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mpsadbw(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3900, dst.get(), src1.get(), imm));
    }

    public void mpsadbw(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3900, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void mul(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(715, dst.get()));
    }

    public void mul(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(731, dst.get()));
    }

    public void mul(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(732, dst.get()));
    }

    public void mul(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(733, dst.get()));
    }

    public void mul(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 733;
        } else if (dst.size == 3) {
            code = 732;
        } else if (dst.size == 2) {
            code = 731;
        } else if (dst.size == 1) {
            code = 715;
        } else {
            throw this.noOpCodeFoundFor(456, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void mulpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1360, dst.get(), src.get()));
    }

    public void mulpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1360, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mulps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1354, dst.get(), src.get()));
    }

    public void mulps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1354, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mulsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1369, dst.get(), src.get()));
    }

    public void mulsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1369, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mulss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1366, dst.get(), src.get()));
    }

    public void mulss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1366, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void mulx(AsmRegister32 dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3693, dst.get(), src1.get(), src2.get()));
    }

    public void mulx(AsmRegister64 dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3694, dst.get(), src1.get(), src2.get()));
    }

    public void mulx(AsmRegister32 dst, AsmRegister32 src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3693, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void mulx(AsmRegister64 dst, AsmRegister64 src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3694, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void mwait() {
        this.addInstruction(Instruction.create(821));
    }

    public void mwaitx() {
        this.addInstruction(Instruction.create(857));
    }

    public void neg(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(714, dst.get()));
    }

    public void neg(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(728, dst.get()));
    }

    public void neg(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(729, dst.get()));
    }

    public void neg(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(730, dst.get()));
    }

    public void neg(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 730;
        } else if (dst.size == 3) {
            code = 729;
        } else if (dst.size == 2) {
            code = 728;
        } else if (dst.size == 1) {
            code = 714;
        } else {
            throw this.noOpCodeFoundFor(464, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void nop() {
        int code = this.getBitness() >= 32 ? 300 : 299;
        this.addInstruction(Instruction.create(code));
    }

    public void nop(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(1056, dst.get()));
    }

    public void nop(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(1057, dst.get()));
    }

    public void nop(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(1058, dst.get()));
    }

    public void nop(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 1058;
        } else if (dst.size == 3) {
            code = 1057;
        } else if (dst.size == 2) {
            code = 1056;
        } else {
            throw this.noOpCodeFoundFor(465, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void not(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(713, dst.get()));
    }

    public void not(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(725, dst.get()));
    }

    public void not(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(726, dst.get()));
    }

    public void not(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(727, dst.get()));
    }

    public void not(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 727;
        } else if (dst.size == 3) {
            code = 726;
        } else if (dst.size == 2) {
            code = 725;
        } else if (dst.size == 1) {
            code = 713;
        } else {
            throw this.noOpCodeFoundFor(466, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void or(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(21, dst.get(), src.get()));
    }

    public void or(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(21, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void or(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(22, dst.get(), src.get()));
    }

    public void or(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(22, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void or(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(23, dst.get(), src.get()));
    }

    public void or(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(23, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void or(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(24, dst.get(), src.get()));
    }

    public void or(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(24, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void or(AsmRegister8 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(25, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void or(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(26, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void or(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(27, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void or(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(28, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void or(AsmRegister8 dst, int imm) {
        int code = dst.getRegister() == 1 ? 29 : 208;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void or(AsmRegister16 dst, int imm) {
        int code = dst.getRegister() == 21 ? 30 : (imm >= -128 && imm <= 127 ? 250 : 218);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void or(AsmRegister32 dst, int imm) {
        int code = dst.getRegister() == 37 ? 31 : (imm >= -128 && imm <= 127 ? 251 : 219);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void or(AsmRegister64 dst, int imm) {
        int code = dst.getRegister() == 53 ? 32 : (imm >= -128 && imm <= 127 ? 252 : 220);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void or(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = imm >= -128 && imm <= 127 ? 252 : 220;
        } else if (dst.size == 3) {
            code = imm >= -128 && imm <= 127 ? 251 : 219;
        } else if (dst.size == 2) {
            code = imm >= -128 && imm <= 127 ? 250 : 218;
        } else if (dst.size == 1) {
            code = 208;
        } else {
            throw this.noOpCodeFoundFor(467, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void orpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1318, dst.get(), src.get()));
    }

    public void orpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1318, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void orps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1312, dst.get(), src.get()));
    }

    public void orps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1312, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void out(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(705, dst.get(), src.get()));
    }

    public void out(int imm, AsmRegister8 src) {
        this.addInstruction(Instruction.create(688, imm, src.get()));
    }

    public void out(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(706, dst.get(), src.get()));
    }

    public void out(int imm, AsmRegister16 src) {
        this.addInstruction(Instruction.create(689, imm, src.get()));
    }

    public void out(AsmRegister16 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(707, dst.get(), src.get()));
    }

    public void out(int imm, AsmRegister32 src) {
        this.addInstruction(Instruction.create(690, imm, src.get()));
    }

    public void outsb() {
        this.addInstruction(Instruction.createOutsb(this.getBitness()));
    }

    public void outsd() {
        this.addInstruction(Instruction.createOutsd(this.getBitness()));
    }

    public void outsw() {
        this.addInstruction(Instruction.createOutsw(this.getBitness()));
    }

    public void pabsb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2705, dst.get(), src.get()));
    }

    public void pabsb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2706, dst.get(), src.get()));
    }

    public void pabsb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2705, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pabsb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2706, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pabsd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2719, dst.get(), src.get()));
    }

    public void pabsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2720, dst.get(), src.get()));
    }

    public void pabsd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2719, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pabsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2720, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pabsw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2712, dst.get(), src.get()));
    }

    public void pabsw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2713, dst.get(), src.get()));
    }

    public void pabsw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2712, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pabsw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2713, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void packssdw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1560, dst.get(), src.get()));
    }

    public void packssdw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1561, dst.get(), src.get()));
    }

    public void packssdw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1560, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void packssdw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1561, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void packsswb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1504, dst.get(), src.get()));
    }

    public void packsswb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1505, dst.get(), src.get()));
    }

    public void packsswb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1504, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void packsswb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1505, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void packusdw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2840, dst.get(), src.get()));
    }

    public void packusdw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2840, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void packuswb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1532, dst.get(), src.get()));
    }

    public void packuswb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1533, dst.get(), src.get()));
    }

    public void packuswb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1532, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void packuswb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1533, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2538, dst.get(), src.get()));
    }

    public void paddb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2539, dst.get(), src.get()));
    }

    public void paddb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2538, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2539, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2552, dst.get(), src.get()));
    }

    public void paddd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2553, dst.get(), src.get()));
    }

    public void paddd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2552, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2553, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2238, dst.get(), src.get()));
    }

    public void paddq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2239, dst.get(), src.get()));
    }

    public void paddq(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2238, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2239, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddsb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2431, dst.get(), src.get()));
    }

    public void paddsb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2432, dst.get(), src.get()));
    }

    public void paddsb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2431, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddsb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2432, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddsiw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4256, dst.get(), src.get()));
    }

    public void paddsiw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4256, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddsw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2438, dst.get(), src.get()));
    }

    public void paddsw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2439, dst.get(), src.get()));
    }

    public void paddsw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2438, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddsw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2439, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddusb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2296, dst.get(), src.get()));
    }

    public void paddusb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2297, dst.get(), src.get()));
    }

    public void paddusb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2296, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddusb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2297, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddusw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2303, dst.get(), src.get()));
    }

    public void paddusw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2304, dst.get(), src.get()));
    }

    public void paddusw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2303, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddusw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2304, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2545, dst.get(), src.get()));
    }

    public void paddw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2546, dst.get(), src.get()));
    }

    public void paddw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2545, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void paddw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2546, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void palignr(AsmRegisterMM dst, AsmRegisterMM src1, int imm) {
        this.addInstruction(Instruction.create(3766, dst.get(), src1.get(), imm));
    }

    public void palignr(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3767, dst.get(), src1.get(), imm));
    }

    public void palignr(AsmRegisterMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3766, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void palignr(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3767, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pand(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2286, dst.get(), src.get()));
    }

    public void pand(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2287, dst.get(), src.get()));
    }

    public void pand(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2286, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pand(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2287, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pandn(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2317, dst.get(), src.get()));
    }

    public void pandn(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2318, dst.get(), src.get()));
    }

    public void pandn(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2317, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pandn(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2318, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pause() {
        this.addInstruction(Instruction.create(305));
    }

    public void paveb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4255, dst.get(), src.get()));
    }

    public void paveb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4255, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pavgb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2327, dst.get(), src.get()));
    }

    public void pavgb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2328, dst.get(), src.get()));
    }

    public void pavgb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2327, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pavgb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2328, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pavgusb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4202, dst.get(), src.get()));
    }

    public void pavgusb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4202, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pavgw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2351, dst.get(), src.get()));
    }

    public void pavgw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2352, dst.get(), src.get()));
    }

    public void pavgw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2351, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pavgw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2352, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pblendvb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2633, dst.get(), src.get()));
    }

    public void pblendvb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2633, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pblendw(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3763, dst.get(), src1.get(), imm));
    }

    public void pblendw(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3763, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pbndkb() {
        this.addInstruction(Instruction.create(4913));
    }

    public void pclmulhqhqdq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.pclmulqdq(dst, src, 17);
    }

    public void pclmulhqhqdq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.pclmulqdq(dst, src, 17);
    }

    public void pclmulhqlqdq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.pclmulqdq(dst, src, 1);
    }

    public void pclmulhqlqdq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.pclmulqdq(dst, src, 1);
    }

    public void pclmullqhqdq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.pclmulqdq(dst, src, 16);
    }

    public void pclmullqhqdq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.pclmulqdq(dst, src, 16);
    }

    public void pclmullqlqdq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.pclmulqdq(dst, src, 0);
    }

    public void pclmullqlqdq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.pclmulqdq(dst, src, 0);
    }

    public void pclmulqdq(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3910, dst.get(), src1.get(), imm));
    }

    public void pclmulqdq(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3910, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pcmpeqb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1714, dst.get(), src.get()));
    }

    public void pcmpeqb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1715, dst.get(), src.get()));
    }

    public void pcmpeqb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1714, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpeqb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1715, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpeqd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1728, dst.get(), src.get()));
    }

    public void pcmpeqd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1729, dst.get(), src.get()));
    }

    public void pcmpeqd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1728, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpeqd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1729, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpeqq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2819, dst.get(), src.get()));
    }

    public void pcmpeqq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2819, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpeqw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1721, dst.get(), src.get()));
    }

    public void pcmpeqw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1722, dst.get(), src.get()));
    }

    public void pcmpeqw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1721, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpeqw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1722, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpestri(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3975, dst.get(), src1.get(), imm));
    }

    public void pcmpestri(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3975, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pcmpestri64(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3976, dst.get(), src1.get(), imm));
    }

    public void pcmpestri64(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3976, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pcmpestrm(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3971, dst.get(), src1.get(), imm));
    }

    public void pcmpestrm(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3971, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pcmpestrm64(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3972, dst.get(), src1.get(), imm));
    }

    public void pcmpestrm64(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3972, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pcmpgtb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1511, dst.get(), src.get()));
    }

    public void pcmpgtb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1512, dst.get(), src.get()));
    }

    public void pcmpgtb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1511, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpgtb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1512, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpgtd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1525, dst.get(), src.get()));
    }

    public void pcmpgtd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1526, dst.get(), src.get()));
    }

    public void pcmpgtd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1525, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpgtd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1526, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpgtq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2921, dst.get(), src.get()));
    }

    public void pcmpgtq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2921, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpgtw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1518, dst.get(), src.get()));
    }

    public void pcmpgtw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1519, dst.get(), src.get()));
    }

    public void pcmpgtw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1518, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpgtw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1519, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pcmpistri(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3981, dst.get(), src1.get(), imm));
    }

    public void pcmpistri(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3981, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pcmpistrm(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3979, dst.get(), src1.get(), imm));
    }

    public void pcmpistrm(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3979, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pcommit() {
        this.addInstruction(Instruction.create(2069));
    }

    public void pconfig() {
        this.addInstruction(Instruction.create(817));
    }

    public void pdep(AsmRegister32 dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3685, dst.get(), src1.get(), src2.get()));
    }

    public void pdep(AsmRegister64 dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3686, dst.get(), src1.get(), src2.get()));
    }

    public void pdep(AsmRegister32 dst, AsmRegister32 src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3685, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void pdep(AsmRegister64 dst, AsmRegister64 src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3686, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void pdistib(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4258, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pext(AsmRegister32 dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3683, dst.get(), src1.get(), src2.get()));
    }

    public void pext(AsmRegister64 dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3684, dst.get(), src1.get(), src2.get()));
    }

    public void pext(AsmRegister32 dst, AsmRegister32 src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3683, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void pext(AsmRegister64 dst, AsmRegister64 src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3684, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void pextrb(AsmRegister32 dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3773, dst.get(), src1.get(), imm));
    }

    public void pextrb(AsmRegister64 dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3774, dst.get(), src1.get(), imm));
    }

    public void pextrb(AsmMemoryOperand dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3773, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void pextrd(AsmRegister32 dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3785, dst.get(), src1.get(), imm));
    }

    public void pextrd(AsmMemoryOperand dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3785, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void pextrq(AsmRegister64 dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3786, dst.get(), src1.get(), imm));
    }

    public void pextrq(AsmMemoryOperand dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3786, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void pextrw(AsmRegister32 dst, AsmRegisterMM src1, int imm) {
        this.addInstruction(Instruction.create(2168, dst.get(), src1.get(), imm));
    }

    public void pextrw(AsmRegister64 dst, AsmRegisterMM src1, int imm) {
        this.addInstruction(Instruction.create(2169, dst.get(), src1.get(), imm));
    }

    public void pextrw(AsmRegister32 dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(2170, dst.get(), src1.get(), imm));
    }

    public void pextrw(AsmRegister64 dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(2171, dst.get(), src1.get(), imm));
    }

    public void pextrw(AsmMemoryOperand dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3779, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void pf2id(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4180, dst.get(), src.get()));
    }

    public void pf2id(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4180, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pf2iw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4179, dst.get(), src.get()));
    }

    public void pf2iw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4179, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfacc(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4196, dst.get(), src.get()));
    }

    public void pfacc(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4196, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfadd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4190, dst.get(), src.get()));
    }

    public void pfadd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4190, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfcmpeq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4197, dst.get(), src.get()));
    }

    public void pfcmpeq(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4197, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfcmpge(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4185, dst.get(), src.get()));
    }

    public void pfcmpge(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4185, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfcmpgt(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4191, dst.get(), src.get()));
    }

    public void pfcmpgt(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4191, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfmax(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4192, dst.get(), src.get()));
    }

    public void pfmax(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4192, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfmin(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4186, dst.get(), src.get()));
    }

    public void pfmin(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4186, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfmul(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4198, dst.get(), src.get()));
    }

    public void pfmul(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4198, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfnacc(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4183, dst.get(), src.get()));
    }

    public void pfnacc(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4183, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfpnacc(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4184, dst.get(), src.get()));
    }

    public void pfpnacc(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4184, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfrcp(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4187, dst.get(), src.get()));
    }

    public void pfrcp(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4187, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfrcpit1(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4193, dst.get(), src.get()));
    }

    public void pfrcpit1(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4193, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfrcpit2(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4199, dst.get(), src.get()));
    }

    public void pfrcpit2(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4199, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfrcpv(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4181, dst.get(), src.get()));
    }

    public void pfrcpv(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4181, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfrsqit1(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4194, dst.get(), src.get()));
    }

    public void pfrsqit1(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4194, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfrsqrt(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4188, dst.get(), src.get()));
    }

    public void pfrsqrt(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4188, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfrsqrtv(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4182, dst.get(), src.get()));
    }

    public void pfrsqrtv(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4182, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfsub(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4189, dst.get(), src.get()));
    }

    public void pfsub(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4189, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pfsubr(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4195, dst.get(), src.get()));
    }

    public void pfsubr(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4195, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phaddd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2573, dst.get(), src.get()));
    }

    public void phaddd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2574, dst.get(), src.get()));
    }

    public void phaddd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2573, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phaddd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2574, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phaddsw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2577, dst.get(), src.get()));
    }

    public void phaddsw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2578, dst.get(), src.get()));
    }

    public void phaddsw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2577, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phaddsw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2578, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phaddw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2569, dst.get(), src.get()));
    }

    public void phaddw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2570, dst.get(), src.get()));
    }

    public void phaddw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2569, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phaddw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2570, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phminposuw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3011, dst.get(), src.get()));
    }

    public void phminposuw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3011, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phsubd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2592, dst.get(), src.get()));
    }

    public void phsubd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2593, dst.get(), src.get()));
    }

    public void phsubd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2592, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phsubd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2593, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phsubsw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2596, dst.get(), src.get()));
    }

    public void phsubsw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2597, dst.get(), src.get()));
    }

    public void phsubsw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2596, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phsubsw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2597, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phsubw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2588, dst.get(), src.get()));
    }

    public void phsubw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2589, dst.get(), src.get()));
    }

    public void phsubw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2588, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void phsubw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2589, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pi2fd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4178, dst.get(), src.get()));
    }

    public void pi2fd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4178, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pi2fw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4177, dst.get(), src.get()));
    }

    public void pi2fw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4177, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pinsrb(AsmRegisterXMM dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(3828, dst.get(), src1.get(), imm));
    }

    public void pinsrb(AsmRegisterXMM dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(3829, dst.get(), src1.get(), imm));
    }

    public void pinsrb(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3828, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pinsrd(AsmRegisterXMM dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(3837, dst.get(), src1.get(), imm));
    }

    public void pinsrd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3837, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pinsrq(AsmRegisterXMM dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(3838, dst.get(), src1.get(), imm));
    }

    public void pinsrq(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3838, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pinsrw(AsmRegisterMM dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(2160, dst.get(), src1.get(), imm));
    }

    public void pinsrw(AsmRegisterXMM dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(2162, dst.get(), src1.get(), imm));
    }

    public void pinsrw(AsmRegisterMM dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(2161, dst.get(), src1.get(), imm));
    }

    public void pinsrw(AsmRegisterXMM dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(2163, dst.get(), src1.get(), imm));
    }

    public void pinsrw(AsmRegisterMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(2160, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pinsrw(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(2162, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pmachriw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4266, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaddubsw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2581, dst.get(), src.get()));
    }

    public void pmaddubsw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2582, dst.get(), src.get()));
    }

    public void pmaddubsw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2581, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaddubsw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2582, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaddwd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2493, dst.get(), src.get()));
    }

    public void pmaddwd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2494, dst.get(), src.get()));
    }

    public void pmaddwd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2493, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaddwd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2494, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmagw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4257, dst.get(), src.get()));
    }

    public void pmagw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4257, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaxsb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2972, dst.get(), src.get()));
    }

    public void pmaxsb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2972, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaxsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2978, dst.get(), src.get()));
    }

    public void pmaxsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2978, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaxsw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2445, dst.get(), src.get()));
    }

    public void pmaxsw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2446, dst.get(), src.get()));
    }

    public void pmaxsw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2445, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaxsw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2446, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaxub(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2310, dst.get(), src.get()));
    }

    public void pmaxub(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2311, dst.get(), src.get()));
    }

    public void pmaxub(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2310, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaxub(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2311, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaxud(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2993, dst.get(), src.get()));
    }

    public void pmaxud(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2993, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmaxuw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2987, dst.get(), src.get()));
    }

    public void pmaxuw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2987, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pminsb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2927, dst.get(), src.get()));
    }

    public void pminsb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2927, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pminsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2939, dst.get(), src.get()));
    }

    public void pminsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2939, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pminsw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2414, dst.get(), src.get()));
    }

    public void pminsw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2415, dst.get(), src.get()));
    }

    public void pminsw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2414, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pminsw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2415, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pminub(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2279, dst.get(), src.get()));
    }

    public void pminub(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2280, dst.get(), src.get()));
    }

    public void pminub(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2279, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pminub(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2280, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pminud(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2963, dst.get(), src.get()));
    }

    public void pminud(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2963, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pminuw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2954, dst.get(), src.get()));
    }

    public void pminuw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2954, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovmskb(AsmRegister32 dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2257, dst.get(), src.get()));
    }

    public void pmovmskb(AsmRegister64 dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2258, dst.get(), src.get()));
    }

    public void pmovmskb(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2259, dst.get(), src.get()));
    }

    public void pmovmskb(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2260, dst.get(), src.get()));
    }

    public void pmovsxbd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2738, dst.get(), src.get()));
    }

    public void pmovsxbd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2738, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovsxbq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2747, dst.get(), src.get()));
    }

    public void pmovsxbq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2747, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovsxbw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2729, dst.get(), src.get()));
    }

    public void pmovsxbw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2729, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovsxdq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2774, dst.get(), src.get()));
    }

    public void pmovsxdq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2774, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovsxwd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2756, dst.get(), src.get()));
    }

    public void pmovsxwd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2756, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovsxwq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2765, dst.get(), src.get()));
    }

    public void pmovsxwq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2765, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovzxbd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2871, dst.get(), src.get()));
    }

    public void pmovzxbd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2871, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovzxbq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2880, dst.get(), src.get()));
    }

    public void pmovzxbq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2880, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovzxbw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2862, dst.get(), src.get()));
    }

    public void pmovzxbw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2862, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovzxdq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2907, dst.get(), src.get()));
    }

    public void pmovzxdq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2907, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovzxwd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2889, dst.get(), src.get()));
    }

    public void pmovzxwd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2889, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmovzxwq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2898, dst.get(), src.get()));
    }

    public void pmovzxwq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2898, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmuldq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2807, dst.get(), src.get()));
    }

    public void pmuldq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2807, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulhriw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4265, dst.get(), src.get()));
    }

    public void pmulhriw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4265, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulhrsw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2612, dst.get(), src.get()));
    }

    public void pmulhrsw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2613, dst.get(), src.get()));
    }

    public void pmulhrsw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2612, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulhrsw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2613, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulhrw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4200, dst.get(), src.get()));
    }

    public void pmulhrw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4200, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulhrw_cyrix(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4261, dst.get(), src.get()));
    }

    public void pmulhrw_cyrix(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4261, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulhuw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2358, dst.get(), src.get()));
    }

    public void pmulhuw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2359, dst.get(), src.get()));
    }

    public void pmulhuw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2358, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulhuw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2359, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulhw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2365, dst.get(), src.get()));
    }

    public void pmulhw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2366, dst.get(), src.get()));
    }

    public void pmulhw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2365, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulhw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2366, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmulld(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3002, dst.get(), src.get()));
    }

    public void pmulld(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3002, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmullw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2245, dst.get(), src.get()));
    }

    public void pmullw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2246, dst.get(), src.get()));
    }

    public void pmullw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2245, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmullw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2246, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmuludq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2486, dst.get(), src.get()));
    }

    public void pmuludq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2487, dst.get(), src.get()));
    }

    public void pmuludq(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2486, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmuludq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2487, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmvgezb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4264, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmvlzb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4263, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmvnzb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4262, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pmvzb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4260, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pop(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(127, dst.get()));
    }

    public void pop(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(128, dst.get()));
    }

    public void pop(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(129, dst.get()));
    }

    public void pop(AsmRegisterSegment dst) {
        int code;
        if (dst.getRegister() == 75) {
            code = this.getBitness() == 64 ? 1947 : (this.getBitness() >= 32 ? 1946 : 1945);
        } else if (dst.getRegister() == 76) {
            code = this.getBitness() == 64 ? 1997 : (this.getBitness() >= 32 ? 1996 : 1995);
        } else if (dst.getRegister() == 71) {
            code = this.getBitness() >= 32 ? 20 : 19;
        } else if (dst.getRegister() == 73) {
            code = this.getBitness() >= 32 ? 51 : 50;
        } else if (dst.getRegister() == 74) {
            code = this.getBitness() >= 32 ? 67 : 66;
        } else {
            throw this.noOpCodeFoundFor(590, dst);
        }
        this.addInstruction(Instruction.create(code, dst.get()));
    }

    public void pop(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 298;
        } else if (dst.size == 3) {
            code = 297;
        } else if (dst.size == 2) {
            code = 296;
        } else {
            throw this.noOpCodeFoundFor(590, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void popa() {
        this.addInstruction(Instruction.create(132));
    }

    public void popad() {
        this.addInstruction(Instruction.create(133));
    }

    public void popcnt(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2097, dst.get(), src.get()));
    }

    public void popcnt(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2098, dst.get(), src.get()));
    }

    public void popcnt(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2099, dst.get(), src.get()));
    }

    public void popcnt(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2097, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void popcnt(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2098, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void popcnt(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2099, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void popf() {
        this.addInstruction(Instruction.create(318));
    }

    public void popfd() {
        this.addInstruction(Instruction.create(319));
    }

    public void popfq() {
        this.addInstruction(Instruction.create(320));
    }

    public void por(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2421, dst.get(), src.get()));
    }

    public void por(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2422, dst.get(), src.get()));
    }

    public void por(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2421, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void por(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2422, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void prefetch(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(883, dst.toMemoryOperand(this.getBitness())));
    }

    public void prefetchit0(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4839, dst.toMemoryOperand(this.getBitness())));
    }

    public void prefetchit1(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4838, dst.toMemoryOperand(this.getBitness())));
    }

    public void prefetchnta(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1033, dst.toMemoryOperand(this.getBitness())));
    }

    public void prefetcht0(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1034, dst.toMemoryOperand(this.getBitness())));
    }

    public void prefetcht1(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1035, dst.toMemoryOperand(this.getBitness())));
    }

    public void prefetcht2(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1036, dst.toMemoryOperand(this.getBitness())));
    }

    public void prefetchw(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(884, dst.toMemoryOperand(this.getBitness())));
    }

    public void prefetchwt1(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(885, dst.toMemoryOperand(this.getBitness())));
    }

    public void psadbw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2500, dst.get(), src.get()));
    }

    public void psadbw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2501, dst.get(), src.get()));
    }

    public void psadbw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2500, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psadbw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2501, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pshufb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2562, dst.get(), src.get()));
    }

    public void pshufb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2563, dst.get(), src.get()));
    }

    public void pshufb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2562, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pshufb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2563, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pshufd(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(1613, dst.get(), src1.get(), imm));
    }

    public void pshufd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(1613, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pshufhw(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(1619, dst.get(), src1.get(), imm));
    }

    public void pshufhw(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(1619, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pshuflw(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(1625, dst.get(), src1.get(), imm));
    }

    public void pshuflw(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(1625, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void pshufw(AsmRegisterMM dst, AsmRegisterMM src1, int imm) {
        this.addInstruction(Instruction.create(1612, dst.get(), src1.get(), imm));
    }

    public void pshufw(AsmRegisterMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(1612, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void psignb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2600, dst.get(), src.get()));
    }

    public void psignb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2601, dst.get(), src.get()));
    }

    public void psignb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2600, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psignb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2601, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psignd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2608, dst.get(), src.get()));
    }

    public void psignd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2609, dst.get(), src.get()));
    }

    public void psignd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2608, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psignd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2609, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psignw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2604, dst.get(), src.get()));
    }

    public void psignw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2605, dst.get(), src.get()));
    }

    public void psignw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2604, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psignw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2605, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pslld(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2472, dst.get(), src.get()));
    }

    public void pslld(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2473, dst.get(), src.get()));
    }

    public void pslld(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2472, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pslld(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2473, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pslld(AsmRegisterMM dst, int imm) {
        this.addInstruction(Instruction.create(1681, dst.get(), imm));
    }

    public void pslld(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1682, dst.get(), imm));
    }

    public void pslldq(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1708, dst.get(), imm));
    }

    public void psllq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2479, dst.get(), src.get()));
    }

    public void psllq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2480, dst.get(), src.get()));
    }

    public void psllq(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2479, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psllq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2480, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psllq(AsmRegisterMM dst, int imm) {
        this.addInstruction(Instruction.create(1701, dst.get(), imm));
    }

    public void psllq(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1702, dst.get(), imm));
    }

    public void psllw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2465, dst.get(), src.get()));
    }

    public void psllw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2466, dst.get(), src.get()));
    }

    public void psllw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2465, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psllw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2466, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psllw(AsmRegisterMM dst, int imm) {
        this.addInstruction(Instruction.create(1645, dst.get(), imm));
    }

    public void psllw(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1646, dst.get(), imm));
    }

    public void psmash() {
        this.addInstruction(Instruction.create(4205));
    }

    public void psrad(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2341, dst.get(), src.get()));
    }

    public void psrad(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2342, dst.get(), src.get()));
    }

    public void psrad(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2341, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psrad(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2342, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psrad(AsmRegisterMM dst, int imm) {
        this.addInstruction(Instruction.create(1671, dst.get(), imm));
    }

    public void psrad(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1672, dst.get(), imm));
    }

    public void psraw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2334, dst.get(), src.get()));
    }

    public void psraw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2335, dst.get(), src.get()));
    }

    public void psraw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2334, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psraw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2335, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psraw(AsmRegisterMM dst, int imm) {
        this.addInstruction(Instruction.create(1638, dst.get(), imm));
    }

    public void psraw(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1639, dst.get(), imm));
    }

    public void psrld(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2224, dst.get(), src.get()));
    }

    public void psrld(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2225, dst.get(), src.get()));
    }

    public void psrld(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2224, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psrld(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2225, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psrld(AsmRegisterMM dst, int imm) {
        this.addInstruction(Instruction.create(1664, dst.get(), imm));
    }

    public void psrld(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1665, dst.get(), imm));
    }

    public void psrldq(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1695, dst.get(), imm));
    }

    public void psrlq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2231, dst.get(), src.get()));
    }

    public void psrlq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2232, dst.get(), src.get()));
    }

    public void psrlq(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2231, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psrlq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2232, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psrlq(AsmRegisterMM dst, int imm) {
        this.addInstruction(Instruction.create(1688, dst.get(), imm));
    }

    public void psrlq(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1689, dst.get(), imm));
    }

    public void psrlw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2217, dst.get(), src.get()));
    }

    public void psrlw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2218, dst.get(), src.get()));
    }

    public void psrlw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2217, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psrlw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2218, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psrlw(AsmRegisterMM dst, int imm) {
        this.addInstruction(Instruction.create(1631, dst.get(), imm));
    }

    public void psrlw(AsmRegisterXMM dst, int imm) {
        this.addInstruction(Instruction.create(1632, dst.get(), imm));
    }

    public void psubb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2510, dst.get(), src.get()));
    }

    public void psubb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2511, dst.get(), src.get()));
    }

    public void psubb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2510, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2511, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2524, dst.get(), src.get()));
    }

    public void psubd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2525, dst.get(), src.get()));
    }

    public void psubd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2524, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2525, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2531, dst.get(), src.get()));
    }

    public void psubq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2532, dst.get(), src.get()));
    }

    public void psubq(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2531, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2532, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubsb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2400, dst.get(), src.get()));
    }

    public void psubsb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2401, dst.get(), src.get()));
    }

    public void psubsb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2400, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubsb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2401, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubsiw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4259, dst.get(), src.get()));
    }

    public void psubsiw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4259, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubsw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2407, dst.get(), src.get()));
    }

    public void psubsw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2408, dst.get(), src.get()));
    }

    public void psubsw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2407, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubsw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2408, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubusb(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2265, dst.get(), src.get()));
    }

    public void psubusb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2266, dst.get(), src.get()));
    }

    public void psubusb(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2265, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubusb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2266, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubusw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2272, dst.get(), src.get()));
    }

    public void psubusw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2273, dst.get(), src.get()));
    }

    public void psubusw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2272, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubusw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2273, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2517, dst.get(), src.get()));
    }

    public void psubw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2518, dst.get(), src.get()));
    }

    public void psubw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2517, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void psubw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2518, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pswapd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(4201, dst.get(), src.get()));
    }

    public void pswapd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4201, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ptest(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2685, dst.get(), src.get()));
    }

    public void ptest(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2685, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ptwrite(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2026, dst.get()));
    }

    public void ptwrite(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2027, dst.get()));
    }

    public void ptwrite(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 2027;
        } else if (dst.size == 3) {
            code = 2026;
        } else {
            throw this.noOpCodeFoundFor(631, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void punpckhbw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1539, dst.get(), src.get()));
    }

    public void punpckhbw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1540, dst.get(), src.get()));
    }

    public void punpckhbw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1539, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpckhbw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1540, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpckhdq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1553, dst.get(), src.get()));
    }

    public void punpckhdq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1554, dst.get(), src.get()));
    }

    public void punpckhdq(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1553, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpckhdq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1554, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpckhqdq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1573, dst.get(), src.get()));
    }

    public void punpckhqdq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1573, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpckhwd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1546, dst.get(), src.get()));
    }

    public void punpckhwd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1547, dst.get(), src.get()));
    }

    public void punpckhwd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1546, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpckhwd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1547, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpcklbw(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1483, dst.get(), src.get()));
    }

    public void punpcklbw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1484, dst.get(), src.get()));
    }

    public void punpcklbw(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1483, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpcklbw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1484, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpckldq(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1497, dst.get(), src.get()));
    }

    public void punpckldq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1498, dst.get(), src.get()));
    }

    public void punpckldq(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1497, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpckldq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1498, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpcklqdq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1567, dst.get(), src.get()));
    }

    public void punpcklqdq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1567, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpcklwd(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(1490, dst.get(), src.get()));
    }

    public void punpcklwd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1491, dst.get(), src.get()));
    }

    public void punpcklwd(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1490, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void punpcklwd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1491, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void push(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(124, dst.get()));
    }

    public void push(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(125, dst.get()));
    }

    public void push(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(126, dst.get()));
    }

    public void push(AsmRegisterSegment dst) {
        int code;
        if (dst.getRegister() == 75) {
            code = this.getBitness() == 64 ? 1944 : (this.getBitness() >= 32 ? 1943 : 1942);
        } else if (dst.getRegister() == 76) {
            code = this.getBitness() == 64 ? 1994 : (this.getBitness() >= 32 ? 1993 : 1992);
        } else if (dst.getRegister() == 71) {
            code = this.getBitness() >= 32 ? 18 : 17;
        } else if (dst.getRegister() == 72) {
            code = this.getBitness() >= 32 ? 34 : 33;
        } else if (dst.getRegister() == 73) {
            code = this.getBitness() >= 32 ? 49 : 48;
        } else if (dst.getRegister() == 74) {
            code = this.getBitness() >= 32 ? 65 : 64;
        } else {
            throw this.noOpCodeFoundFor(640, dst);
        }
        this.addInstruction(Instruction.create(code, dst.get()));
    }

    public void push(AsmMemoryOperand dst) {
        int code;
        if (dst.size == 4) {
            code = 771;
        } else if (dst.size == 3) {
            code = 770;
        } else if (dst.size == 2) {
            code = 769;
        } else {
            throw this.noOpCodeFoundFor(640, dst);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void push(int imm) {
        int code = this.getBitness() == 64 ? (imm >= -128 && imm <= 127 ? 149 : 143) : (this.getBitness() >= 32 ? (imm >= -128 && imm <= 127 ? 148 : 142) : (imm >= -128 && imm <= 127 ? 147 : 141));
        this.addInstruction(Instruction.create(code, imm));
    }

    public void pusha() {
        this.addInstruction(Instruction.create(130));
    }

    public void pushad() {
        this.addInstruction(Instruction.create(131));
    }

    public void pushf() {
        this.addInstruction(Instruction.create(315));
    }

    public void pushfd() {
        this.addInstruction(Instruction.create(316));
    }

    public void pushfq() {
        this.addInstruction(Instruction.create(317));
    }

    public void pvalidate() {
        int code = this.getBitness() == 64 ? 4208 : (this.getBitness() >= 32 ? 4207 : 4206);
        this.addInstruction(Instruction.create(code));
    }

    public void pxor(AsmRegisterMM dst, AsmRegisterMM src) {
        this.addInstruction(Instruction.create(2452, dst.get(), src.get()));
    }

    public void pxor(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2453, dst.get(), src.get()));
    }

    public void pxor(AsmRegisterMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2452, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void pxor(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2453, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void rcl(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(460, dst.get(), src.get()));
    }

    public void rcl(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(472, dst.get(), src.get()));
    }

    public void rcl(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(473, dst.get(), src.get()));
    }

    public void rcl(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(474, dst.get(), src.get()));
    }

    public void rcl(AsmMemoryOperand dst, AsmRegister8 src) {
        int code;
        if (dst.size == 4) {
            code = 474;
        } else if (dst.size == 3) {
            code = 473;
        } else if (dst.size == 2) {
            code = 472;
        } else if (dst.size == 1) {
            code = 460;
        } else {
            throw this.noOpCodeFoundFor(644, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void rcl(AsmRegister8 dst, int imm) {
        int code = imm == 1 ? 428 : 361;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void rcl(AsmRegister16 dst, int imm) {
        int code = imm == 1 ? 440 : 373;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void rcl(AsmRegister32 dst, int imm) {
        int code = imm == 1 ? 441 : 374;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void rcl(AsmRegister64 dst, int imm) {
        int code = imm == 1 ? 442 : 375;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rcl(AsmMemoryOperand dst, int imm) {
        int code;
        if (imm == 1) {
            if (dst.size == 4) {
                code = 442;
            } else if (dst.size == 3) {
                code = 441;
            } else if (dst.size == 2) {
                code = 440;
            } else {
                if (dst.size != 1) throw this.noOpCodeFoundFor(644, dst, imm);
                code = 428;
            }
        } else if (dst.size == 4) {
            code = 375;
        } else if (dst.size == 3) {
            code = 374;
        } else if (dst.size == 2) {
            code = 373;
        } else {
            if (dst.size != 1) throw this.noOpCodeFoundFor(644, dst, imm);
            code = 361;
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void rcpps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1283, dst.get(), src.get()));
    }

    public void rcpps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1283, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void rcpss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1286, dst.get(), src.get()));
    }

    public void rcpss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1286, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void rcr(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(461, dst.get(), src.get()));
    }

    public void rcr(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(475, dst.get(), src.get()));
    }

    public void rcr(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(476, dst.get(), src.get()));
    }

    public void rcr(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(477, dst.get(), src.get()));
    }

    public void rcr(AsmMemoryOperand dst, AsmRegister8 src) {
        int code;
        if (dst.size == 4) {
            code = 477;
        } else if (dst.size == 3) {
            code = 476;
        } else if (dst.size == 2) {
            code = 475;
        } else if (dst.size == 1) {
            code = 461;
        } else {
            throw this.noOpCodeFoundFor(647, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void rcr(AsmRegister8 dst, int imm) {
        int code = imm == 1 ? 429 : 362;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void rcr(AsmRegister16 dst, int imm) {
        int code = imm == 1 ? 443 : 376;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void rcr(AsmRegister32 dst, int imm) {
        int code = imm == 1 ? 444 : 377;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void rcr(AsmRegister64 dst, int imm) {
        int code = imm == 1 ? 445 : 378;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rcr(AsmMemoryOperand dst, int imm) {
        int code;
        if (imm == 1) {
            if (dst.size == 4) {
                code = 445;
            } else if (dst.size == 3) {
                code = 444;
            } else if (dst.size == 2) {
                code = 443;
            } else {
                if (dst.size != 1) throw this.noOpCodeFoundFor(647, dst, imm);
                code = 429;
            }
        } else if (dst.size == 4) {
            code = 378;
        } else if (dst.size == 3) {
            code = 377;
        } else if (dst.size == 2) {
            code = 376;
        } else {
            if (dst.size != 1) throw this.noOpCodeFoundFor(647, dst, imm);
            code = 362;
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void rdfsbase(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2010, dst.get()));
    }

    public void rdfsbase(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2011, dst.get()));
    }

    public void rdgsbase(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2014, dst.get()));
    }

    public void rdgsbase(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2015, dst.get()));
    }

    public void rdm() {
        this.addInstruction(Instruction.create(4242));
    }

    public void rdmsr() {
        this.addInstruction(Instruction.create(1163));
    }

    public void rdmsrlist() {
        this.addInstruction(Instruction.create(4836));
    }

    public void rdpid(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2206, dst.get()));
    }

    public void rdpid(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2207, dst.get()));
    }

    public void rdpkru() {
        this.addInstruction(Instruction.create(849));
    }

    public void rdpmc() {
        this.addInstruction(Instruction.create(1164));
    }

    public void rdpru() {
        this.addInstruction(Instruction.create(861));
    }

    public void rdrand(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(2199, dst.get()));
    }

    public void rdrand(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2200, dst.get()));
    }

    public void rdrand(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2201, dst.get()));
    }

    public void rdseed(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(2203, dst.get()));
    }

    public void rdseed(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2204, dst.get()));
    }

    public void rdseed(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2205, dst.get()));
    }

    public void rdshr(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(4238, dst.get()));
    }

    public void rdshr(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4238, dst.toMemoryOperand(this.getBitness())));
    }

    public void rdsspd(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(1052, dst.get()));
    }

    public void rdsspq(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(1053, dst.get()));
    }

    public void rdtsc() {
        this.addInstruction(Instruction.create(1162));
    }

    public void rdtscp() {
        this.addInstruction(Instruction.create(852));
    }

    public void rdudbg() {
        this.addInstruction(Instruction.create(4561));
    }

    public void reservednop_0f0d(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(880, dst.get(), src.get()));
    }

    public void reservednop_0f0d(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(880, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f0d(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(881, dst.get(), src.get()));
    }

    public void reservednop_0f0d(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(881, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f0d(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(882, dst.get(), src.get()));
    }

    public void reservednop_0f0d(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(882, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f18(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1009, dst.get(), src.get()));
    }

    public void reservednop_0f18(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1009, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f18(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1010, dst.get(), src.get()));
    }

    public void reservednop_0f18(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1010, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f18(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1011, dst.get(), src.get()));
    }

    public void reservednop_0f18(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1011, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f19(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1012, dst.get(), src.get()));
    }

    public void reservednop_0f19(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1012, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f19(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1013, dst.get(), src.get()));
    }

    public void reservednop_0f19(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1013, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f19(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1014, dst.get(), src.get()));
    }

    public void reservednop_0f19(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1014, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1a(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1015, dst.get(), src.get()));
    }

    public void reservednop_0f1a(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1015, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1a(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1016, dst.get(), src.get()));
    }

    public void reservednop_0f1a(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1016, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1a(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1017, dst.get(), src.get()));
    }

    public void reservednop_0f1a(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1017, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1b(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1018, dst.get(), src.get()));
    }

    public void reservednop_0f1b(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1018, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1b(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1019, dst.get(), src.get()));
    }

    public void reservednop_0f1b(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1019, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1b(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1020, dst.get(), src.get()));
    }

    public void reservednop_0f1b(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1020, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1c(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1021, dst.get(), src.get()));
    }

    public void reservednop_0f1c(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1021, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1c(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1022, dst.get(), src.get()));
    }

    public void reservednop_0f1c(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1022, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1c(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1023, dst.get(), src.get()));
    }

    public void reservednop_0f1c(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1023, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1d(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1024, dst.get(), src.get()));
    }

    public void reservednop_0f1d(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1024, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1d(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1025, dst.get(), src.get()));
    }

    public void reservednop_0f1d(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1025, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1d(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1026, dst.get(), src.get()));
    }

    public void reservednop_0f1d(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1026, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1e(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1027, dst.get(), src.get()));
    }

    public void reservednop_0f1e(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1027, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1e(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1028, dst.get(), src.get()));
    }

    public void reservednop_0f1e(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1028, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1e(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1029, dst.get(), src.get()));
    }

    public void reservednop_0f1e(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1029, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1f(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1030, dst.get(), src.get()));
    }

    public void reservednop_0f1f(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(1030, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1f(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1031, dst.get(), src.get()));
    }

    public void reservednop_0f1f(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1031, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void reservednop_0f1f(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1032, dst.get(), src.get()));
    }

    public void reservednop_0f1f(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1032, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void ret() {
        int code = this.getBitness() == 64 ? 396 : (this.getBitness() >= 32 ? 395 : 394);
        this.addInstruction(Instruction.create(code));
    }

    public void ret(int imm) {
        int code = this.getBitness() == 64 ? 393 : (this.getBitness() >= 32 ? 392 : 391);
        this.addInstruction(Instruction.create(code, imm));
    }

    public void retf() {
        int code = this.getBitness() == 64 ? 419 : (this.getBitness() >= 32 ? 418 : 417);
        this.addInstruction(Instruction.create(code));
    }

    public void retf(int imm) {
        int code = this.getBitness() == 64 ? 416 : (this.getBitness() >= 32 ? 415 : 414);
        this.addInstruction(Instruction.create(code, imm));
    }

    public void rmpadjust() {
        this.addInstruction(Instruction.create(4203));
    }

    public void rmpquery() {
        this.addInstruction(Instruction.create(4837));
    }

    public void rmpupdate() {
        this.addInstruction(Instruction.create(4204));
    }

    public void rol(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(458, dst.get(), src.get()));
    }

    public void rol(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(466, dst.get(), src.get()));
    }

    public void rol(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(467, dst.get(), src.get()));
    }

    public void rol(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(468, dst.get(), src.get()));
    }

    public void rol(AsmMemoryOperand dst, AsmRegister8 src) {
        int code;
        if (dst.size == 4) {
            code = 468;
        } else if (dst.size == 3) {
            code = 467;
        } else if (dst.size == 2) {
            code = 466;
        } else if (dst.size == 1) {
            code = 458;
        } else {
            throw this.noOpCodeFoundFor(664, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void rol(AsmRegister8 dst, int imm) {
        int code = imm == 1 ? 426 : 359;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void rol(AsmRegister16 dst, int imm) {
        int code = imm == 1 ? 434 : 367;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void rol(AsmRegister32 dst, int imm) {
        int code = imm == 1 ? 435 : 368;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void rol(AsmRegister64 dst, int imm) {
        int code = imm == 1 ? 436 : 369;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rol(AsmMemoryOperand dst, int imm) {
        int code;
        if (imm == 1) {
            if (dst.size == 4) {
                code = 436;
            } else if (dst.size == 3) {
                code = 435;
            } else if (dst.size == 2) {
                code = 434;
            } else {
                if (dst.size != 1) throw this.noOpCodeFoundFor(664, dst, imm);
                code = 426;
            }
        } else if (dst.size == 4) {
            code = 369;
        } else if (dst.size == 3) {
            code = 368;
        } else if (dst.size == 2) {
            code = 367;
        } else {
            if (dst.size != 1) throw this.noOpCodeFoundFor(664, dst, imm);
            code = 359;
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void ror(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(459, dst.get(), src.get()));
    }

    public void ror(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(469, dst.get(), src.get()));
    }

    public void ror(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(470, dst.get(), src.get()));
    }

    public void ror(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(471, dst.get(), src.get()));
    }

    public void ror(AsmMemoryOperand dst, AsmRegister8 src) {
        int code;
        if (dst.size == 4) {
            code = 471;
        } else if (dst.size == 3) {
            code = 470;
        } else if (dst.size == 2) {
            code = 469;
        } else if (dst.size == 1) {
            code = 459;
        } else {
            throw this.noOpCodeFoundFor(665, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void ror(AsmRegister8 dst, int imm) {
        int code = imm == 1 ? 427 : 360;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void ror(AsmRegister16 dst, int imm) {
        int code = imm == 1 ? 437 : 370;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void ror(AsmRegister32 dst, int imm) {
        int code = imm == 1 ? 438 : 371;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void ror(AsmRegister64 dst, int imm) {
        int code = imm == 1 ? 439 : 372;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ror(AsmMemoryOperand dst, int imm) {
        int code;
        if (imm == 1) {
            if (dst.size == 4) {
                code = 439;
            } else if (dst.size == 3) {
                code = 438;
            } else if (dst.size == 2) {
                code = 437;
            } else {
                if (dst.size != 1) throw this.noOpCodeFoundFor(665, dst, imm);
                code = 427;
            }
        } else if (dst.size == 4) {
            code = 372;
        } else if (dst.size == 3) {
            code = 371;
        } else if (dst.size == 2) {
            code = 370;
        } else {
            if (dst.size != 1) throw this.noOpCodeFoundFor(665, dst, imm);
            code = 360;
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void rorx(AsmRegister32 dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(4072, dst.get(), src1.get(), imm));
    }

    public void rorx(AsmRegister64 dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(4073, dst.get(), src1.get(), imm));
    }

    public void rorx(AsmRegister32 dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4072, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void rorx(AsmRegister64 dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4073, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void roundpd(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3745, dst.get(), src1.get(), imm));
    }

    public void roundpd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3745, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void roundps(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3739, dst.get(), src1.get(), imm));
    }

    public void roundps(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3739, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void roundsd(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3754, dst.get(), src1.get(), imm));
    }

    public void roundsd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3754, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void roundss(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3751, dst.get(), src1.get(), imm));
    }

    public void roundss(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3751, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void rsdc(AsmRegisterSegment dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4244, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void rsldt(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4246, dst.toMemoryOperand(this.getBitness())));
    }

    public void rsm() {
        this.addInstruction(Instruction.create(1998));
    }

    public void rsqrtps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1278, dst.get(), src.get()));
    }

    public void rsqrtps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1278, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void rsqrtss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1281, dst.get(), src.get()));
    }

    public void rsqrtss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1281, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void rstorssp(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(807, dst.toMemoryOperand(this.getBitness())));
    }

    public void rsts(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4248, dst.toMemoryOperand(this.getBitness())));
    }

    public void sahf() {
        this.addInstruction(Instruction.create(321));
    }

    public void sal(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(464, dst.get(), src.get()));
    }

    public void sal(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(484, dst.get(), src.get()));
    }

    public void sal(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(485, dst.get(), src.get()));
    }

    public void sal(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(486, dst.get(), src.get()));
    }

    public void sal(AsmMemoryOperand dst, AsmRegister8 src) {
        int code;
        if (dst.size == 4) {
            code = 486;
        } else if (dst.size == 3) {
            code = 485;
        } else if (dst.size == 2) {
            code = 484;
        } else if (dst.size == 1) {
            code = 464;
        } else {
            throw this.noOpCodeFoundFor(676, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sal(AsmRegister8 dst, int imm) {
        int code = imm == 1 ? 432 : 365;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sal(AsmRegister16 dst, int imm) {
        int code = imm == 1 ? 452 : 385;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sal(AsmRegister32 dst, int imm) {
        int code = imm == 1 ? 453 : 386;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sal(AsmRegister64 dst, int imm) {
        int code = imm == 1 ? 454 : 387;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sal(AsmMemoryOperand dst, int imm) {
        int code;
        if (imm == 1) {
            if (dst.size == 4) {
                code = 454;
            } else if (dst.size == 3) {
                code = 453;
            } else if (dst.size == 2) {
                code = 452;
            } else {
                if (dst.size != 1) throw this.noOpCodeFoundFor(676, dst, imm);
                code = 432;
            }
        } else if (dst.size == 4) {
            code = 387;
        } else if (dst.size == 3) {
            code = 386;
        } else if (dst.size == 2) {
            code = 385;
        } else {
            if (dst.size != 1) throw this.noOpCodeFoundFor(676, dst, imm);
            code = 365;
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void salc() {
        this.addInstruction(Instruction.create(492));
    }

    public void sar(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(465, dst.get(), src.get()));
    }

    public void sar(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(487, dst.get(), src.get()));
    }

    public void sar(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(488, dst.get(), src.get()));
    }

    public void sar(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(489, dst.get(), src.get()));
    }

    public void sar(AsmMemoryOperand dst, AsmRegister8 src) {
        int code;
        if (dst.size == 4) {
            code = 489;
        } else if (dst.size == 3) {
            code = 488;
        } else if (dst.size == 2) {
            code = 487;
        } else if (dst.size == 1) {
            code = 465;
        } else {
            throw this.noOpCodeFoundFor(678, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sar(AsmRegister8 dst, int imm) {
        int code = imm == 1 ? 433 : 366;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sar(AsmRegister16 dst, int imm) {
        int code = imm == 1 ? 455 : 388;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sar(AsmRegister32 dst, int imm) {
        int code = imm == 1 ? 456 : 389;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sar(AsmRegister64 dst, int imm) {
        int code = imm == 1 ? 457 : 390;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sar(AsmMemoryOperand dst, int imm) {
        int code;
        if (imm == 1) {
            if (dst.size == 4) {
                code = 457;
            } else if (dst.size == 3) {
                code = 456;
            } else if (dst.size == 2) {
                code = 455;
            } else {
                if (dst.size != 1) throw this.noOpCodeFoundFor(678, dst, imm);
                code = 433;
            }
        } else if (dst.size == 4) {
            code = 390;
        } else if (dst.size == 3) {
            code = 389;
        } else if (dst.size == 2) {
            code = 388;
        } else {
            if (dst.size != 1) throw this.noOpCodeFoundFor(678, dst, imm);
            code = 366;
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void sarx(AsmRegister32 dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3699, dst.get(), src1.get(), src2.get()));
    }

    public void sarx(AsmRegister32 dst, AsmMemoryOperand src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3699, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void sarx(AsmRegister64 dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3700, dst.get(), src1.get(), src2.get()));
    }

    public void sarx(AsmRegister64 dst, AsmMemoryOperand src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3700, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void saveprevssp() {
        this.addInstruction(Instruction.create(848));
    }

    public void sbb(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(52, dst.get(), src.get()));
    }

    public void sbb(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(52, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sbb(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(53, dst.get(), src.get()));
    }

    public void sbb(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(53, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sbb(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(54, dst.get(), src.get()));
    }

    public void sbb(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(54, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sbb(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(55, dst.get(), src.get()));
    }

    public void sbb(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(55, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sbb(AsmRegister8 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(56, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sbb(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(57, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sbb(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(58, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sbb(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(59, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sbb(AsmRegister8 dst, int imm) {
        int code = dst.getRegister() == 1 ? 60 : 210;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sbb(AsmRegister16 dst, int imm) {
        int code = dst.getRegister() == 21 ? 61 : (imm >= -128 && imm <= 127 ? 256 : 224);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sbb(AsmRegister32 dst, int imm) {
        int code = dst.getRegister() == 37 ? 62 : (imm >= -128 && imm <= 127 ? 257 : 225);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sbb(AsmRegister64 dst, int imm) {
        int code = dst.getRegister() == 53 ? 63 : (imm >= -128 && imm <= 127 ? 258 : 226);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sbb(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = imm >= -128 && imm <= 127 ? 258 : 226;
        } else if (dst.size == 3) {
            code = imm >= -128 && imm <= 127 ? 257 : 225;
        } else if (dst.size == 2) {
            code = imm >= -128 && imm <= 127 ? 256 : 224;
        } else if (dst.size == 1) {
            code = 210;
        } else {
            throw this.noOpCodeFoundFor(681, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void scasb() {
        this.addInstruction(Instruction.createScasb(this.getBitness()));
    }

    public void scasd() {
        this.addInstruction(Instruction.createScasd(this.getBitness()));
    }

    public void scasq() {
        this.addInstruction(Instruction.createScasq(this.getBitness()));
    }

    public void scasw() {
        this.addInstruction(Instruction.createScasw(this.getBitness()));
    }

    public void seamcall() {
        this.addInstruction(Instruction.create(4282));
    }

    public void seamops() {
        this.addInstruction(Instruction.create(4281));
    }

    public void seamret() {
        this.addInstruction(Instruction.create(4280));
    }

    public void senduipi(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(4302, dst.get()));
    }

    public void serialize() {
        this.addInstruction(Instruction.create(4209));
    }

    public void seta(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1909, dst.get()));
    }

    public void seta(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1909, dst.toMemoryOperand(this.getBitness())));
    }

    public void setae(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1905, dst.get()));
    }

    public void setae(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1905, dst.toMemoryOperand(this.getBitness())));
    }

    public void setb(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1904, dst.get()));
    }

    public void setb(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1904, dst.toMemoryOperand(this.getBitness())));
    }

    public void setbe(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1908, dst.get()));
    }

    public void setbe(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1908, dst.toMemoryOperand(this.getBitness())));
    }

    public void setc(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1904, dst.get()));
    }

    public void setc(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1904, dst.toMemoryOperand(this.getBitness())));
    }

    public void sete(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1906, dst.get()));
    }

    public void sete(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1906, dst.toMemoryOperand(this.getBitness())));
    }

    public void setg(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1917, dst.get()));
    }

    public void setg(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1917, dst.toMemoryOperand(this.getBitness())));
    }

    public void setge(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1915, dst.get()));
    }

    public void setge(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1915, dst.toMemoryOperand(this.getBitness())));
    }

    public void setl(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1914, dst.get()));
    }

    public void setl(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1914, dst.toMemoryOperand(this.getBitness())));
    }

    public void setle(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1916, dst.get()));
    }

    public void setle(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1916, dst.toMemoryOperand(this.getBitness())));
    }

    public void setna(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1908, dst.get()));
    }

    public void setna(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1908, dst.toMemoryOperand(this.getBitness())));
    }

    public void setnae(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1904, dst.get()));
    }

    public void setnae(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1904, dst.toMemoryOperand(this.getBitness())));
    }

    public void setnb(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1905, dst.get()));
    }

    public void setnb(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1905, dst.toMemoryOperand(this.getBitness())));
    }

    public void setnbe(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1909, dst.get()));
    }

    public void setnbe(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1909, dst.toMemoryOperand(this.getBitness())));
    }

    public void setnc(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1905, dst.get()));
    }

    public void setnc(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1905, dst.toMemoryOperand(this.getBitness())));
    }

    public void setne(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1907, dst.get()));
    }

    public void setne(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1907, dst.toMemoryOperand(this.getBitness())));
    }

    public void setng(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1916, dst.get()));
    }

    public void setng(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1916, dst.toMemoryOperand(this.getBitness())));
    }

    public void setnge(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1914, dst.get()));
    }

    public void setnge(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1914, dst.toMemoryOperand(this.getBitness())));
    }

    public void setnl(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1915, dst.get()));
    }

    public void setnl(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1915, dst.toMemoryOperand(this.getBitness())));
    }

    public void setnle(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1917, dst.get()));
    }

    public void setnle(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1917, dst.toMemoryOperand(this.getBitness())));
    }

    public void setno(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1903, dst.get()));
    }

    public void setno(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1903, dst.toMemoryOperand(this.getBitness())));
    }

    public void setnp(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1913, dst.get()));
    }

    public void setnp(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1913, dst.toMemoryOperand(this.getBitness())));
    }

    public void setns(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1911, dst.get()));
    }

    public void setns(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1911, dst.toMemoryOperand(this.getBitness())));
    }

    public void setnz(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1907, dst.get()));
    }

    public void setnz(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1907, dst.toMemoryOperand(this.getBitness())));
    }

    public void seto(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1902, dst.get()));
    }

    public void seto(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1902, dst.toMemoryOperand(this.getBitness())));
    }

    public void setp(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1912, dst.get()));
    }

    public void setp(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1912, dst.toMemoryOperand(this.getBitness())));
    }

    public void setpe(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1912, dst.get()));
    }

    public void setpe(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1912, dst.toMemoryOperand(this.getBitness())));
    }

    public void setpo(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1913, dst.get()));
    }

    public void setpo(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1913, dst.toMemoryOperand(this.getBitness())));
    }

    public void sets(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1910, dst.get()));
    }

    public void sets(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1910, dst.toMemoryOperand(this.getBitness())));
    }

    public void setssbsy() {
        this.addInstruction(Instruction.create(847));
    }

    public void setz(AsmRegister8 dst) {
        this.addInstruction(Instruction.create(1906, dst.get()));
    }

    public void setz(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(1906, dst.toMemoryOperand(this.getBitness())));
    }

    public void sfence() {
        this.addInstruction(Instruction.create(2061));
    }

    public void sgdt(AsmMemoryOperand dst) {
        int code = this.getBitness() == 64 ? 794 : (this.getBitness() >= 32 ? 793 : 792);
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void sha1msg1(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3615, dst.get(), src.get()));
    }

    public void sha1msg1(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3615, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sha1msg2(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3616, dst.get(), src.get()));
    }

    public void sha1msg2(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3616, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sha1nexte(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3612, dst.get(), src.get()));
    }

    public void sha1nexte(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3612, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sha1rnds4(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(4057, dst.get(), src1.get(), imm));
    }

    public void sha1rnds4(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4057, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void sha256msg1(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3622, dst.get(), src.get()));
    }

    public void sha256msg1(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3622, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sha256msg2(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3625, dst.get(), src.get()));
    }

    public void sha256msg2(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3625, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sha256rnds2(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3619, dst.get(), src.get()));
    }

    public void sha256rnds2(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3619, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void shl(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(462, dst.get(), src.get()));
    }

    public void shl(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(478, dst.get(), src.get()));
    }

    public void shl(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(479, dst.get(), src.get()));
    }

    public void shl(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(480, dst.get(), src.get()));
    }

    public void shl(AsmMemoryOperand dst, AsmRegister8 src) {
        int code;
        if (dst.size == 4) {
            code = 480;
        } else if (dst.size == 3) {
            code = 479;
        } else if (dst.size == 2) {
            code = 478;
        } else if (dst.size == 1) {
            code = 462;
        } else {
            throw this.noOpCodeFoundFor(712, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void shl(AsmRegister8 dst, int imm) {
        int code = imm == 1 ? 430 : 363;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void shl(AsmRegister16 dst, int imm) {
        int code = imm == 1 ? 446 : 379;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void shl(AsmRegister32 dst, int imm) {
        int code = imm == 1 ? 447 : 380;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void shl(AsmRegister64 dst, int imm) {
        int code = imm == 1 ? 448 : 381;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shl(AsmMemoryOperand dst, int imm) {
        int code;
        if (imm == 1) {
            if (dst.size == 4) {
                code = 448;
            } else if (dst.size == 3) {
                code = 447;
            } else if (dst.size == 2) {
                code = 446;
            } else {
                if (dst.size != 1) throw this.noOpCodeFoundFor(712, dst, imm);
                code = 430;
            }
        } else if (dst.size == 4) {
            code = 381;
        } else if (dst.size == 3) {
            code = 380;
        } else if (dst.size == 2) {
            code = 379;
        } else {
            if (dst.size != 1) throw this.noOpCodeFoundFor(712, dst, imm);
            code = 363;
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void shld(AsmRegister16 dst, AsmRegister16 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(1955, dst.get(), src1.get(), src2.get()));
    }

    public void shld(AsmMemoryOperand dst, AsmRegister16 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(1955, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void shld(AsmRegister32 dst, AsmRegister32 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(1956, dst.get(), src1.get(), src2.get()));
    }

    public void shld(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(1956, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void shld(AsmRegister64 dst, AsmRegister64 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(1957, dst.get(), src1.get(), src2.get()));
    }

    public void shld(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(1957, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void shld(AsmRegister16 dst, AsmRegister16 src1, int imm) {
        this.addInstruction(Instruction.create(1952, dst.get(), src1.get(), imm));
    }

    public void shld(AsmMemoryOperand dst, AsmRegister16 src1, int imm) {
        this.addInstruction(Instruction.create(1952, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void shld(AsmRegister32 dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(1953, dst.get(), src1.get(), imm));
    }

    public void shld(AsmMemoryOperand dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(1953, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void shld(AsmRegister64 dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(1954, dst.get(), src1.get(), imm));
    }

    public void shld(AsmMemoryOperand dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(1954, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void shlx(AsmRegister32 dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3697, dst.get(), src1.get(), src2.get()));
    }

    public void shlx(AsmRegister32 dst, AsmMemoryOperand src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3697, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void shlx(AsmRegister64 dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3698, dst.get(), src1.get(), src2.get()));
    }

    public void shlx(AsmRegister64 dst, AsmMemoryOperand src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3698, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void shr(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(463, dst.get(), src.get()));
    }

    public void shr(AsmRegister16 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(481, dst.get(), src.get()));
    }

    public void shr(AsmRegister32 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(482, dst.get(), src.get()));
    }

    public void shr(AsmRegister64 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(483, dst.get(), src.get()));
    }

    public void shr(AsmMemoryOperand dst, AsmRegister8 src) {
        int code;
        if (dst.size == 4) {
            code = 483;
        } else if (dst.size == 3) {
            code = 482;
        } else if (dst.size == 2) {
            code = 481;
        } else if (dst.size == 1) {
            code = 463;
        } else {
            throw this.noOpCodeFoundFor(715, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void shr(AsmRegister8 dst, int imm) {
        int code = imm == 1 ? 431 : 364;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void shr(AsmRegister16 dst, int imm) {
        int code = imm == 1 ? 449 : 382;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void shr(AsmRegister32 dst, int imm) {
        int code = imm == 1 ? 450 : 383;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void shr(AsmRegister64 dst, int imm) {
        int code = imm == 1 ? 451 : 384;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shr(AsmMemoryOperand dst, int imm) {
        int code;
        if (imm == 1) {
            if (dst.size == 4) {
                code = 451;
            } else if (dst.size == 3) {
                code = 450;
            } else if (dst.size == 2) {
                code = 449;
            } else {
                if (dst.size != 1) throw this.noOpCodeFoundFor(715, dst, imm);
                code = 431;
            }
        } else if (dst.size == 4) {
            code = 384;
        } else if (dst.size == 3) {
            code = 383;
        } else if (dst.size == 2) {
            code = 382;
        } else {
            if (dst.size != 1) throw this.noOpCodeFoundFor(715, dst, imm);
            code = 364;
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void shrd(AsmRegister16 dst, AsmRegister16 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(2005, dst.get(), src1.get(), src2.get()));
    }

    public void shrd(AsmMemoryOperand dst, AsmRegister16 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(2005, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void shrd(AsmRegister32 dst, AsmRegister32 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(2006, dst.get(), src1.get(), src2.get()));
    }

    public void shrd(AsmMemoryOperand dst, AsmRegister32 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(2006, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void shrd(AsmRegister64 dst, AsmRegister64 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(2007, dst.get(), src1.get(), src2.get()));
    }

    public void shrd(AsmMemoryOperand dst, AsmRegister64 src1, AsmRegister8 src2) {
        this.addInstruction(Instruction.create(2007, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void shrd(AsmRegister16 dst, AsmRegister16 src1, int imm) {
        this.addInstruction(Instruction.create(2002, dst.get(), src1.get(), imm));
    }

    public void shrd(AsmMemoryOperand dst, AsmRegister16 src1, int imm) {
        this.addInstruction(Instruction.create(2002, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void shrd(AsmRegister32 dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(2003, dst.get(), src1.get(), imm));
    }

    public void shrd(AsmMemoryOperand dst, AsmRegister32 src1, int imm) {
        this.addInstruction(Instruction.create(2003, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void shrd(AsmRegister64 dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(2004, dst.get(), src1.get(), imm));
    }

    public void shrd(AsmMemoryOperand dst, AsmRegister64 src1, int imm) {
        this.addInstruction(Instruction.create(2004, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void shrx(AsmRegister32 dst, AsmRegister32 src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3701, dst.get(), src1.get(), src2.get()));
    }

    public void shrx(AsmRegister32 dst, AsmMemoryOperand src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(3701, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void shrx(AsmRegister64 dst, AsmRegister64 src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3702, dst.get(), src1.get(), src2.get()));
    }

    public void shrx(AsmRegister64 dst, AsmMemoryOperand src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(3702, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void shufpd(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(2182, dst.get(), src1.get(), imm));
    }

    public void shufpd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(2182, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void shufps(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(2176, dst.get(), src1.get(), imm));
    }

    public void shufps(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(2176, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void sidt(AsmMemoryOperand dst) {
        int code = this.getBitness() == 64 ? 797 : (this.getBitness() >= 32 ? 796 : 795);
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void skinit() {
        this.addInstruction(Instruction.create(843));
    }

    public void sldt(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(772, dst.get()));
    }

    public void sldt(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(773, dst.get()));
    }

    public void sldt(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(774, dst.get()));
    }

    public void sldt(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 773 : 772;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void slwpcb(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(4124, dst.get()));
    }

    public void slwpcb(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(4125, dst.get()));
    }

    public void smint() {
        this.addInstruction(Instruction.create(4240));
    }

    public void smint_0f7e() {
        this.addInstruction(Instruction.create(4249));
    }

    public void smsw(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(804, dst.get()));
    }

    public void smsw(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(805, dst.get()));
    }

    public void smsw(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(806, dst.get()));
    }

    public void smsw(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 805 : 804;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void sqrtpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1266, dst.get(), src.get()));
    }

    public void sqrtpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1266, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sqrtps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1260, dst.get(), src.get()));
    }

    public void sqrtps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1260, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sqrtsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1275, dst.get(), src.get()));
    }

    public void sqrtsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1275, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sqrtss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1272, dst.get(), src.get()));
    }

    public void sqrtss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1272, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void stac() {
        this.addInstruction(Instruction.create(823));
    }

    public void stc() {
        this.addInstruction(Instruction.create(744));
    }

    public void std() {
        this.addInstruction(Instruction.create(748));
    }

    public void stgi() {
        this.addInstruction(Instruction.create(841));
    }

    public void sti() {
        this.addInstruction(Instruction.create(746));
    }

    public void stmxcsr(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2020, dst.toMemoryOperand(this.getBitness())));
    }

    public void stosb() {
        this.addInstruction(Instruction.createStosb(this.getBitness()));
    }

    public void stosd() {
        this.addInstruction(Instruction.createStosd(this.getBitness()));
    }

    public void stosq() {
        this.addInstruction(Instruction.createStosq(this.getBitness()));
    }

    public void stosw() {
        this.addInstruction(Instruction.createStosw(this.getBitness()));
    }

    public void str(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(775, dst.get()));
    }

    public void str(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(776, dst.get()));
    }

    public void str(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(777, dst.get()));
    }

    public void str(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 776 : 775;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void sttilecfg(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4226, dst.toMemoryOperand(this.getBitness())));
    }

    public void stui() {
        this.addInstruction(Instruction.create(4301));
    }

    public void sub(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(81, dst.get(), src.get()));
    }

    public void sub(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(81, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sub(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(82, dst.get(), src.get()));
    }

    public void sub(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(82, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sub(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(83, dst.get(), src.get()));
    }

    public void sub(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(83, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sub(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(84, dst.get(), src.get()));
    }

    public void sub(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(84, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void sub(AsmRegister8 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(85, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sub(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(86, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sub(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(87, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sub(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(88, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void sub(AsmRegister8 dst, int imm) {
        int code = dst.getRegister() == 1 ? 89 : 212;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sub(AsmRegister16 dst, int imm) {
        int code = dst.getRegister() == 21 ? 90 : (imm >= -128 && imm <= 127 ? 262 : 230);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sub(AsmRegister32 dst, int imm) {
        int code = dst.getRegister() == 37 ? 91 : (imm >= -128 && imm <= 127 ? 263 : 231);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sub(AsmRegister64 dst, int imm) {
        int code = dst.getRegister() == 53 ? 92 : (imm >= -128 && imm <= 127 ? 264 : 232);
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void sub(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = imm >= -128 && imm <= 127 ? 264 : 232;
        } else if (dst.size == 3) {
            code = imm >= -128 && imm <= 127 ? 263 : 231;
        } else if (dst.size == 2) {
            code = imm >= -128 && imm <= 127 ? 262 : 230;
        } else if (dst.size == 1) {
            code = 212;
        } else {
            throw this.noOpCodeFoundFor(740, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void subpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1417, dst.get(), src.get()));
    }

    public void subpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1417, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void subps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1411, dst.get(), src.get()));
    }

    public void subps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1411, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void subsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1426, dst.get(), src.get()));
    }

    public void subsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1426, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void subss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1423, dst.get(), src.get()));
    }

    public void subss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1423, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void svdc(AsmMemoryOperand dst, AsmRegisterSegment src) {
        this.addInstruction(Instruction.create(4243, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void svldt(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4245, dst.toMemoryOperand(this.getBitness())));
    }

    public void svts(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(4247, dst.toMemoryOperand(this.getBitness())));
    }

    public void swapgs() {
        this.addInstruction(Instruction.create(851));
    }

    public void syscall() {
        this.addInstruction(Instruction.create(870));
    }

    public void sysenter() {
        this.addInstruction(Instruction.create(1165));
    }

    public void sysexit() {
        this.addInstruction(Instruction.create(1166));
    }

    public void sysexitq() {
        this.addInstruction(Instruction.create(1167));
    }

    public void sysret() {
        this.addInstruction(Instruction.create(873));
    }

    public void sysretq() {
        this.addInstruction(Instruction.create(874));
    }

    public void t1mskc(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4116, dst.get(), src.get()));
    }

    public void t1mskc(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4117, dst.get(), src.get()));
    }

    public void t1mskc(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4116, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void t1mskc(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4117, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void tcmmimfp16ps(AsmRegisterTMM dst, AsmRegisterTMM src1, AsmRegisterTMM src2) {
        this.addInstruction(Instruction.create(4912, dst.get(), src1.get(), src2.get()));
    }

    public void tcmmrlfp16ps(AsmRegisterTMM dst, AsmRegisterTMM src1, AsmRegisterTMM src2) {
        this.addInstruction(Instruction.create(4911, dst.get(), src1.get(), src2.get()));
    }

    public void tdcall() {
        this.addInstruction(Instruction.create(4279));
    }

    public void tdpbf16ps(AsmRegisterTMM dst, AsmRegisterTMM src1, AsmRegisterTMM src2) {
        this.addInstruction(Instruction.create(4231, dst.get(), src1.get(), src2.get()));
    }

    public void tdpbssd(AsmRegisterTMM dst, AsmRegisterTMM src1, AsmRegisterTMM src2) {
        this.addInstruction(Instruction.create(4235, dst.get(), src1.get(), src2.get()));
    }

    public void tdpbsud(AsmRegisterTMM dst, AsmRegisterTMM src1, AsmRegisterTMM src2) {
        this.addInstruction(Instruction.create(4234, dst.get(), src1.get(), src2.get()));
    }

    public void tdpbusd(AsmRegisterTMM dst, AsmRegisterTMM src1, AsmRegisterTMM src2) {
        this.addInstruction(Instruction.create(4233, dst.get(), src1.get(), src2.get()));
    }

    public void tdpbuud(AsmRegisterTMM dst, AsmRegisterTMM src1, AsmRegisterTMM src2) {
        this.addInstruction(Instruction.create(4232, dst.get(), src1.get(), src2.get()));
    }

    public void tdpfp16ps(AsmRegisterTMM dst, AsmRegisterTMM src1, AsmRegisterTMM src2) {
        this.addInstruction(Instruction.create(4860, dst.get(), src1.get(), src2.get()));
    }

    public void test(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(271, dst.get(), src.get()));
    }

    public void test(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(271, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void test(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(272, dst.get(), src.get()));
    }

    public void test(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(272, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void test(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(273, dst.get(), src.get()));
    }

    public void test(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(273, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void test(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(274, dst.get(), src.get()));
    }

    public void test(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(274, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void test(AsmRegister8 dst, int imm) {
        int code = dst.getRegister() == 1 ? 339 : 711;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void test(AsmRegister16 dst, int imm) {
        int code = dst.getRegister() == 21 ? 340 : 719;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void test(AsmRegister32 dst, int imm) {
        int code = dst.getRegister() == 37 ? 341 : 720;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void test(AsmRegister64 dst, int imm) {
        int code = dst.getRegister() == 53 ? 342 : 721;
        this.addInstruction(Instruction.create(code, dst.get(), imm));
    }

    public void test(AsmMemoryOperand dst, int imm) {
        int code;
        if (dst.size == 4) {
            code = 721;
        } else if (dst.size == 3) {
            code = 720;
        } else if (dst.size == 2) {
            code = 719;
        } else if (dst.size == 1) {
            code = 711;
        } else {
            throw this.noOpCodeFoundFor(751, dst, imm);
        }
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), imm));
    }

    public void testui() {
        this.addInstruction(Instruction.create(4299));
    }

    public void tileloadd(AsmRegisterTMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4230, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void tileloaddt1(AsmRegisterTMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4228, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void tilerelease() {
        this.addInstruction(Instruction.create(4225));
    }

    public void tilestored(AsmMemoryOperand dst, AsmRegisterTMM src) {
        this.addInstruction(Instruction.create(4229, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void tilezero(AsmRegisterTMM dst) {
        this.addInstruction(Instruction.create(4227, dst.get()));
    }

    public void tlbsync() {
        this.addInstruction(Instruction.create(4215));
    }

    public void tpause(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2035, dst.get()));
    }

    public void tpause(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2036, dst.get()));
    }

    public void tzcnt(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2121, dst.get(), src.get()));
    }

    public void tzcnt(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2122, dst.get(), src.get()));
    }

    public void tzcnt(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2123, dst.get(), src.get()));
    }

    public void tzcnt(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2121, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void tzcnt(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2122, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void tzcnt(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2123, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void tzmsk(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4110, dst.get(), src.get()));
    }

    public void tzmsk(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4111, dst.get(), src.get()));
    }

    public void tzmsk(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4110, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void tzmsk(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4111, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ucomisd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1152, dst.get(), src.get()));
    }

    public void ucomisd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1152, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ucomiss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1149, dst.get(), src.get()));
    }

    public void ucomiss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1149, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ud0() {
        this.addInstruction(Instruction.create(4221));
    }

    public void ud0(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2559, dst.get(), src.get()));
    }

    public void ud0(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2560, dst.get(), src.get()));
    }

    public void ud0(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2561, dst.get(), src.get()));
    }

    public void ud0(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2559, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ud0(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2560, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ud0(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2561, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ud1(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(2100, dst.get(), src.get()));
    }

    public void ud1(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(2101, dst.get(), src.get()));
    }

    public void ud1(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(2102, dst.get(), src.get()));
    }

    public void ud1(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2100, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ud1(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2101, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ud1(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2102, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void ud2() {
        this.addInstruction(Instruction.create(879));
    }

    public void uiret() {
        this.addInstruction(Instruction.create(4298));
    }

    public void umonitor(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(2038, dst.get()));
    }

    public void umonitor(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2039, dst.get()));
    }

    public void umonitor(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2040, dst.get()));
    }

    public void umov(AsmRegister8 dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(887, dst.get(), src.get()));
    }

    public void umov(AsmMemoryOperand dst, AsmRegister8 src) {
        this.addInstruction(Instruction.create(887, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void umov(AsmRegister16 dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(888, dst.get(), src.get()));
    }

    public void umov(AsmMemoryOperand dst, AsmRegister16 src) {
        this.addInstruction(Instruction.create(888, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void umov(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(889, dst.get(), src.get()));
    }

    public void umov(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(889, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void umov(AsmRegister8 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(890, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void umov(AsmRegister16 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(891, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void umov(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(892, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void umwait(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(2041, dst.get()));
    }

    public void umwait(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(2042, dst.get()));
    }

    public void unpckhpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(982, dst.get(), src.get()));
    }

    public void unpckhpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(982, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void unpckhps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(976, dst.get(), src.get()));
    }

    public void unpckhps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(976, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void unpcklpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(970, dst.get(), src.get()));
    }

    public void unpcklpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(970, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void unpcklps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(964, dst.get(), src.get()));
    }

    public void unpcklps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(964, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void v4fmaddps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3372, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void v4fmaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3377, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void v4fnmaddps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3474, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void v4fnmaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3479, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1343 : 1345;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1344 : 1346;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vaddpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1347, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1345 : (this.getInstructionPreferVex() ? 1343 : 1345);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1346 : (this.getInstructionPreferVex() ? 1344 : 1346);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1347, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4323, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vaddph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4324, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vaddph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4325, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vaddph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4323, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4324, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4325, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1337 : 1339;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1338 : 1340;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vaddps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1341, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1339 : (this.getInstructionPreferVex() ? 1337 : 1339);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1340 : (this.getInstructionPreferVex() ? 1338 : 1340);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1341, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1352 : 1353;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vaddsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1352 : 1353;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4326, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vaddsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4326, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1349 : 1350;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1349 : 1350;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vaddsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(2212, dst.get(), src1.get(), src2.get()));
    }

    public void vaddsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(2213, dst.get(), src1.get(), src2.get()));
    }

    public void vaddsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(2212, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaddsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(2213, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaddsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(2215, dst.get(), src1.get(), src2.get()));
    }

    public void vaddsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(2216, dst.get(), src1.get(), src2.get()));
    }

    public void vaddsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(2215, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaddsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(2216, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesdec(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3649 : 3651;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vaesdec(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3650 : 3652;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vaesdec(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3653, dst.get(), src1.get(), src2.get()));
    }

    public void vaesdec(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3649 : 3651;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesdec(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3650 : 3652;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesdec(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3653, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesdeclast(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3655 : 3657;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vaesdeclast(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3656 : 3658;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vaesdeclast(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3659, dst.get(), src1.get(), src2.get()));
    }

    public void vaesdeclast(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3655 : 3657;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesdeclast(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3656 : 3658;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesdeclast(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3659, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesenc(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3637 : 3639;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vaesenc(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3638 : 3640;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vaesenc(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3641, dst.get(), src1.get(), src2.get()));
    }

    public void vaesenc(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3637 : 3639;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesenc(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3638 : 3640;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesenc(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3641, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesenclast(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3643 : 3645;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vaesenclast(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3644 : 3646;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vaesenclast(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3647, dst.get(), src1.get(), src2.get()));
    }

    public void vaesenclast(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3643 : 3645;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesenclast(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3644 : 3646;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesenclast(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3647, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vaesimc(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3635, dst.get(), src.get()));
    }

    public void vaesimc(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3635, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vaeskeygenassist(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(4071, dst.get(), src1.get(), imm));
    }

    public void vaeskeygenassist(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4071, dst.get(), src1.toMemoryOperand(this.getBitness()), imm));
    }

    public void valignd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3722, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void valignd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3723, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void valignd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(3724, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void valignd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3722, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void valignd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3723, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void valignd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3724, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void valignq(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3725, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void valignq(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3726, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void valignq(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(3727, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void valignq(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3725, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void valignq(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3726, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void valignq(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3727, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vandnpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1307 : 1309;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandnpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1308 : 1310;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandnpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1311, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandnpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1309 : (this.getInstructionPreferVex() ? 1307 : 1309);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandnpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1310 : (this.getInstructionPreferVex() ? 1308 : 1310);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandnpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1311, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandnps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1301 : 1303;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandnps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1302 : 1304;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandnps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1305, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandnps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1303 : (this.getInstructionPreferVex() ? 1301 : 1303);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandnps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1304 : (this.getInstructionPreferVex() ? 1302 : 1304);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandnps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1305, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1295 : 1297;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1296 : 1298;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1299, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1297 : (this.getInstructionPreferVex() ? 1295 : 1297);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1298 : (this.getInstructionPreferVex() ? 1296 : 1298);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1299, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1289 : 1291;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1290 : 1292;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1293, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vandps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1291 : (this.getInstructionPreferVex() ? 1289 : 1291);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1292 : (this.getInstructionPreferVex() ? 1290 : 1292);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vandps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1293, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vbcstnebf162ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4873, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vbcstnebf162ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4874, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vbcstnesh2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4871, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vbcstnesh2ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4872, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vblendmpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3141, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vblendmpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(3142, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vblendmpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3143, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vblendmpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3141, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vblendmpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3142, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vblendmpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3143, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vblendmps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3138, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vblendmps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(3139, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vblendmps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3140, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vblendmps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3138, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vblendmps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3139, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vblendmps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3140, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vblendpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3761, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vblendpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3762, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vblendpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3761, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vblendpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3762, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vblendps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3758, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vblendps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3759, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vblendps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3758, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vblendps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3759, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vblendvpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3927, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vblendvpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3927, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vblendvpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3928, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vblendvpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3928, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vblendvps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3925, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vblendvps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3925, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vblendvps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3926, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vblendvps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3926, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vbroadcastf128(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2698, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vbroadcastf32x2(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2694, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcastf32x2(AsmRegisterZMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2695, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcastf32x2(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2694, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastf32x2(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2695, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastf32x4(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2699, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastf32x4(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2700, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastf32x8(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2703, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastf64x2(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2701, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastf64x2(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2702, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastf64x4(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2704, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcasti128(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3113, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vbroadcasti32x2(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3107, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcasti32x2(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3108, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcasti32x2(AsmRegisterZMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3109, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcasti32x2(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3107, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcasti32x2(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3108, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcasti32x2(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3109, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcasti32x4(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3114, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcasti32x4(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3115, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcasti32x8(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3118, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcasti64x2(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3116, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcasti64x2(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3117, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcasti64x4(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3119, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastsd(AsmRegisterYMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 4296 : 2696;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcastsd(AsmRegisterZMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2697, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcastsd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 2693 : 2696;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastsd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2697, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 4294 : 2690;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcastss(AsmRegisterYMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 4295 : 2691;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcastss(AsmRegisterZMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2692, dst.get(), src.get()), dst.flags);
    }

    public void vbroadcastss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 2688 : 2690;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastss(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 2689 : 2691;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vbroadcastss(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2692, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vcmpeq_ospd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_ospd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_ospd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_ospd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_ospd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_ospd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_ospd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_ospd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_ospd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_ospd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 16);
    }

    public void vcmpeq_osph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 16);
    }

    public void vcmpeq_osph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 16);
    }

    public void vcmpeq_osph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 16);
    }

    public void vcmpeq_osph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 16);
    }

    public void vcmpeq_osph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 16);
    }

    public void vcmpeq_osph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_osps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 16);
    }

    public void vcmpeq_ossd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 16);
    }

    public void vcmpeq_ossd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 16);
    }

    public void vcmpeq_ossd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 16);
    }

    public void vcmpeq_ossd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 16);
    }

    public void vcmpeq_ossh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 16);
    }

    public void vcmpeq_ossh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 16);
    }

    public void vcmpeq_osss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 16);
    }

    public void vcmpeq_osss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 16);
    }

    public void vcmpeq_osss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 16);
    }

    public void vcmpeq_osss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 16);
    }

    public void vcmpeq_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 8);
    }

    public void vcmpeq_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 8);
    }

    public void vcmpeq_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 8);
    }

    public void vcmpeq_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 8);
    }

    public void vcmpeq_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 8);
    }

    public void vcmpeq_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 8);
    }

    public void vcmpeq_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 8);
    }

    public void vcmpeq_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 8);
    }

    public void vcmpeq_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 8);
    }

    public void vcmpeq_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 8);
    }

    public void vcmpeq_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 8);
    }

    public void vcmpeq_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 8);
    }

    public void vcmpeq_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 8);
    }

    public void vcmpeq_uspd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_uspd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_uspd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_uspd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_uspd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_uspd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_uspd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_uspd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_uspd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_uspd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 24);
    }

    public void vcmpeq_usph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 24);
    }

    public void vcmpeq_usph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 24);
    }

    public void vcmpeq_usph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 24);
    }

    public void vcmpeq_usph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 24);
    }

    public void vcmpeq_usph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 24);
    }

    public void vcmpeq_usph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_usps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 24);
    }

    public void vcmpeq_ussd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 24);
    }

    public void vcmpeq_ussd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 24);
    }

    public void vcmpeq_ussd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 24);
    }

    public void vcmpeq_ussd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 24);
    }

    public void vcmpeq_ussh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 24);
    }

    public void vcmpeq_ussh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 24);
    }

    public void vcmpeq_usss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 24);
    }

    public void vcmpeq_usss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 24);
    }

    public void vcmpeq_usss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 24);
    }

    public void vcmpeq_usss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 24);
    }

    public void vcmpeqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 0);
    }

    public void vcmpeqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 0);
    }

    public void vcmpeqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 0);
    }

    public void vcmpeqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 0);
    }

    public void vcmpeqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 0);
    }

    public void vcmpeqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 0);
    }

    public void vcmpeqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 0);
    }

    public void vcmpeqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 0);
    }

    public void vcmpeqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 0);
    }

    public void vcmpeqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 0);
    }

    public void vcmpeqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 0);
    }

    public void vcmpeqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 0);
    }

    public void vcmpeqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 0);
    }

    public void vcmpeqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 0);
    }

    public void vcmpeqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 0);
    }

    public void vcmpeqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 0);
    }

    public void vcmpeqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 0);
    }

    public void vcmpfalse_ospd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ospd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ospd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ospd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ospd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ospd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ospd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ospd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ospd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ospd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 27);
    }

    public void vcmpfalse_osph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 27);
    }

    public void vcmpfalse_osph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 27);
    }

    public void vcmpfalse_osph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 27);
    }

    public void vcmpfalse_osph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 27);
    }

    public void vcmpfalse_osph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 27);
    }

    public void vcmpfalse_osph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_osps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 27);
    }

    public void vcmpfalse_ossd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ossd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ossd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ossd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 27);
    }

    public void vcmpfalse_ossh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 27);
    }

    public void vcmpfalse_ossh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 27);
    }

    public void vcmpfalse_osss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 27);
    }

    public void vcmpfalse_osss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 27);
    }

    public void vcmpfalse_osss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 27);
    }

    public void vcmpfalse_osss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 27);
    }

    public void vcmpfalsepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalsepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalsepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalsepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalsepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalsepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalsepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalsepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalsepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalsepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 11);
    }

    public void vcmpfalseph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 11);
    }

    public void vcmpfalseph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 11);
    }

    public void vcmpfalseph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 11);
    }

    public void vcmpfalseph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 11);
    }

    public void vcmpfalseph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 11);
    }

    public void vcmpfalseph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalseps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 11);
    }

    public void vcmpfalsesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 11);
    }

    public void vcmpfalsesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 11);
    }

    public void vcmpfalsesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 11);
    }

    public void vcmpfalsesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 11);
    }

    public void vcmpfalsesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 11);
    }

    public void vcmpfalsesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 11);
    }

    public void vcmpfalsess(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 11);
    }

    public void vcmpfalsess(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 11);
    }

    public void vcmpfalsess(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 11);
    }

    public void vcmpfalsess(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 11);
    }

    public void vcmpge_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 29);
    }

    public void vcmpge_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 29);
    }

    public void vcmpge_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 29);
    }

    public void vcmpge_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 29);
    }

    public void vcmpge_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 29);
    }

    public void vcmpge_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 29);
    }

    public void vcmpge_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 29);
    }

    public void vcmpge_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 29);
    }

    public void vcmpge_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 29);
    }

    public void vcmpge_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 29);
    }

    public void vcmpge_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 29);
    }

    public void vcmpge_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 29);
    }

    public void vcmpge_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 29);
    }

    public void vcmpge_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 29);
    }

    public void vcmpge_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 29);
    }

    public void vcmpge_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 29);
    }

    public void vcmpge_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 29);
    }

    public void vcmpgepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 13);
    }

    public void vcmpgeph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 13);
    }

    public void vcmpgeph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 13);
    }

    public void vcmpgeph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 13);
    }

    public void vcmpgeph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 13);
    }

    public void vcmpgeph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 13);
    }

    public void vcmpgeph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgeps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 13);
    }

    public void vcmpgesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 13);
    }

    public void vcmpgesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 13);
    }

    public void vcmpgesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 13);
    }

    public void vcmpgesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 13);
    }

    public void vcmpgesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 13);
    }

    public void vcmpgesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 13);
    }

    public void vcmpgess(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 13);
    }

    public void vcmpgess(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 13);
    }

    public void vcmpgess(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 13);
    }

    public void vcmpgess(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 13);
    }

    public void vcmpgt_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 30);
    }

    public void vcmpgt_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 30);
    }

    public void vcmpgt_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 30);
    }

    public void vcmpgt_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 30);
    }

    public void vcmpgt_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 30);
    }

    public void vcmpgt_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 30);
    }

    public void vcmpgt_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 30);
    }

    public void vcmpgt_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 30);
    }

    public void vcmpgt_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 30);
    }

    public void vcmpgt_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 30);
    }

    public void vcmpgt_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 30);
    }

    public void vcmpgt_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 30);
    }

    public void vcmpgt_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 30);
    }

    public void vcmpgtpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 14);
    }

    public void vcmpgtph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 14);
    }

    public void vcmpgtph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 14);
    }

    public void vcmpgtph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 14);
    }

    public void vcmpgtph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 14);
    }

    public void vcmpgtph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 14);
    }

    public void vcmpgtph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 14);
    }

    public void vcmpgtsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 14);
    }

    public void vcmpgtsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 14);
    }

    public void vcmpgtsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 14);
    }

    public void vcmpgtsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 14);
    }

    public void vcmpgtsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 14);
    }

    public void vcmpgtsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 14);
    }

    public void vcmpgtss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 14);
    }

    public void vcmpgtss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 14);
    }

    public void vcmpgtss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 14);
    }

    public void vcmpgtss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 14);
    }

    public void vcmple_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 18);
    }

    public void vcmple_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 18);
    }

    public void vcmple_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 18);
    }

    public void vcmple_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 18);
    }

    public void vcmple_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 18);
    }

    public void vcmple_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 18);
    }

    public void vcmple_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 18);
    }

    public void vcmple_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 18);
    }

    public void vcmple_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 18);
    }

    public void vcmple_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 18);
    }

    public void vcmple_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 18);
    }

    public void vcmple_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 18);
    }

    public void vcmple_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 18);
    }

    public void vcmple_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 18);
    }

    public void vcmple_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 18);
    }

    public void vcmple_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 18);
    }

    public void vcmple_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 18);
    }

    public void vcmplepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmplepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmplepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmplepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmplepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmplepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmplepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmplepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmplepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmplepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 2);
    }

    public void vcmpleph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 2);
    }

    public void vcmpleph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 2);
    }

    public void vcmpleph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 2);
    }

    public void vcmpleph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 2);
    }

    public void vcmpleph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 2);
    }

    public void vcmpleph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmpleps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 2);
    }

    public void vcmplesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 2);
    }

    public void vcmplesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 2);
    }

    public void vcmplesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 2);
    }

    public void vcmplesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 2);
    }

    public void vcmplesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 2);
    }

    public void vcmplesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 2);
    }

    public void vcmpless(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 2);
    }

    public void vcmpless(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 2);
    }

    public void vcmpless(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 2);
    }

    public void vcmpless(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 2);
    }

    public void vcmplt_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 17);
    }

    public void vcmplt_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 17);
    }

    public void vcmplt_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 17);
    }

    public void vcmplt_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 17);
    }

    public void vcmplt_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 17);
    }

    public void vcmplt_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 17);
    }

    public void vcmplt_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 17);
    }

    public void vcmplt_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 17);
    }

    public void vcmplt_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 17);
    }

    public void vcmplt_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 17);
    }

    public void vcmplt_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 17);
    }

    public void vcmplt_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 17);
    }

    public void vcmplt_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 17);
    }

    public void vcmplt_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 17);
    }

    public void vcmplt_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 17);
    }

    public void vcmplt_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 17);
    }

    public void vcmplt_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 17);
    }

    public void vcmpltpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 1);
    }

    public void vcmpltph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 1);
    }

    public void vcmpltph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 1);
    }

    public void vcmpltph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 1);
    }

    public void vcmpltph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 1);
    }

    public void vcmpltph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 1);
    }

    public void vcmpltph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 1);
    }

    public void vcmpltsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 1);
    }

    public void vcmpltsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 1);
    }

    public void vcmpltsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 1);
    }

    public void vcmpltsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 1);
    }

    public void vcmpltsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 1);
    }

    public void vcmpltsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 1);
    }

    public void vcmpltss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 1);
    }

    public void vcmpltss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 1);
    }

    public void vcmpltss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 1);
    }

    public void vcmpltss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 1);
    }

    public void vcmpneq_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 12);
    }

    public void vcmpneq_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 12);
    }

    public void vcmpneq_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 12);
    }

    public void vcmpneq_oqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 12);
    }

    public void vcmpneq_oqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 12);
    }

    public void vcmpneq_oqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 12);
    }

    public void vcmpneq_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 12);
    }

    public void vcmpneq_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 12);
    }

    public void vcmpneq_oqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 12);
    }

    public void vcmpneq_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 12);
    }

    public void vcmpneq_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 12);
    }

    public void vcmpneq_oqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 12);
    }

    public void vcmpneq_oqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 12);
    }

    public void vcmpneq_ospd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_ospd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_ospd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_ospd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_ospd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_ospd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_ospd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_ospd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_ospd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_ospd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 28);
    }

    public void vcmpneq_osph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 28);
    }

    public void vcmpneq_osph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 28);
    }

    public void vcmpneq_osph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 28);
    }

    public void vcmpneq_osph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 28);
    }

    public void vcmpneq_osph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 28);
    }

    public void vcmpneq_osph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_osps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 28);
    }

    public void vcmpneq_ossd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 28);
    }

    public void vcmpneq_ossd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 28);
    }

    public void vcmpneq_ossd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 28);
    }

    public void vcmpneq_ossd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 28);
    }

    public void vcmpneq_ossh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 28);
    }

    public void vcmpneq_ossh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 28);
    }

    public void vcmpneq_osss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 28);
    }

    public void vcmpneq_osss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 28);
    }

    public void vcmpneq_osss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 28);
    }

    public void vcmpneq_osss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 28);
    }

    public void vcmpneq_uspd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_uspd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_uspd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_uspd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_uspd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_uspd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_uspd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_uspd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_uspd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_uspd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 20);
    }

    public void vcmpneq_usph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 20);
    }

    public void vcmpneq_usph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 20);
    }

    public void vcmpneq_usph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 20);
    }

    public void vcmpneq_usph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 20);
    }

    public void vcmpneq_usph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 20);
    }

    public void vcmpneq_usph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_usps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 20);
    }

    public void vcmpneq_ussd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 20);
    }

    public void vcmpneq_ussd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 20);
    }

    public void vcmpneq_ussd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 20);
    }

    public void vcmpneq_ussd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 20);
    }

    public void vcmpneq_ussh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 20);
    }

    public void vcmpneq_ussh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 20);
    }

    public void vcmpneq_usss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 20);
    }

    public void vcmpneq_usss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 20);
    }

    public void vcmpneq_usss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 20);
    }

    public void vcmpneq_usss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 20);
    }

    public void vcmpneqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 4);
    }

    public void vcmpneqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 4);
    }

    public void vcmpneqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 4);
    }

    public void vcmpneqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 4);
    }

    public void vcmpneqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 4);
    }

    public void vcmpneqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 4);
    }

    public void vcmpneqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 4);
    }

    public void vcmpneqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 4);
    }

    public void vcmpneqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 4);
    }

    public void vcmpneqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 4);
    }

    public void vcmpneqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 4);
    }

    public void vcmpneqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 4);
    }

    public void vcmpneqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 4);
    }

    public void vcmpneqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 4);
    }

    public void vcmpneqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 4);
    }

    public void vcmpneqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 4);
    }

    public void vcmpneqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 4);
    }

    public void vcmpnge_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 25);
    }

    public void vcmpnge_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 25);
    }

    public void vcmpnge_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 25);
    }

    public void vcmpnge_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 25);
    }

    public void vcmpnge_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 25);
    }

    public void vcmpnge_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 25);
    }

    public void vcmpnge_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 25);
    }

    public void vcmpnge_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 25);
    }

    public void vcmpnge_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 25);
    }

    public void vcmpnge_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 25);
    }

    public void vcmpnge_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 25);
    }

    public void vcmpnge_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 25);
    }

    public void vcmpnge_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 25);
    }

    public void vcmpngepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 9);
    }

    public void vcmpngeph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 9);
    }

    public void vcmpngeph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 9);
    }

    public void vcmpngeph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 9);
    }

    public void vcmpngeph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 9);
    }

    public void vcmpngeph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 9);
    }

    public void vcmpngeph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngeps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 9);
    }

    public void vcmpngesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 9);
    }

    public void vcmpngesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 9);
    }

    public void vcmpngesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 9);
    }

    public void vcmpngesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 9);
    }

    public void vcmpngesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 9);
    }

    public void vcmpngesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 9);
    }

    public void vcmpngess(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 9);
    }

    public void vcmpngess(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 9);
    }

    public void vcmpngess(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 9);
    }

    public void vcmpngess(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 9);
    }

    public void vcmpngt_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 26);
    }

    public void vcmpngt_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 26);
    }

    public void vcmpngt_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 26);
    }

    public void vcmpngt_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 26);
    }

    public void vcmpngt_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 26);
    }

    public void vcmpngt_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 26);
    }

    public void vcmpngt_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 26);
    }

    public void vcmpngt_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 26);
    }

    public void vcmpngt_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 26);
    }

    public void vcmpngt_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 26);
    }

    public void vcmpngt_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 26);
    }

    public void vcmpngt_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 26);
    }

    public void vcmpngt_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 26);
    }

    public void vcmpngtpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 10);
    }

    public void vcmpngtph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 10);
    }

    public void vcmpngtph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 10);
    }

    public void vcmpngtph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 10);
    }

    public void vcmpngtph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 10);
    }

    public void vcmpngtph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 10);
    }

    public void vcmpngtph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 10);
    }

    public void vcmpngtsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 10);
    }

    public void vcmpngtsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 10);
    }

    public void vcmpngtsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 10);
    }

    public void vcmpngtsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 10);
    }

    public void vcmpngtsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 10);
    }

    public void vcmpngtsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 10);
    }

    public void vcmpngtss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 10);
    }

    public void vcmpngtss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 10);
    }

    public void vcmpngtss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 10);
    }

    public void vcmpngtss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 10);
    }

    public void vcmpnle_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 22);
    }

    public void vcmpnle_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 22);
    }

    public void vcmpnle_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 22);
    }

    public void vcmpnle_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 22);
    }

    public void vcmpnle_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 22);
    }

    public void vcmpnle_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 22);
    }

    public void vcmpnle_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 22);
    }

    public void vcmpnle_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 22);
    }

    public void vcmpnle_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 22);
    }

    public void vcmpnle_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 22);
    }

    public void vcmpnle_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 22);
    }

    public void vcmpnle_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 22);
    }

    public void vcmpnle_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 22);
    }

    public void vcmpnlepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnlepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnlepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnlepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnlepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnlepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnlepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnlepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnlepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnlepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 6);
    }

    public void vcmpnleph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 6);
    }

    public void vcmpnleph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 6);
    }

    public void vcmpnleph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 6);
    }

    public void vcmpnleph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 6);
    }

    public void vcmpnleph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 6);
    }

    public void vcmpnleph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnleps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 6);
    }

    public void vcmpnlesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 6);
    }

    public void vcmpnlesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 6);
    }

    public void vcmpnlesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 6);
    }

    public void vcmpnlesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 6);
    }

    public void vcmpnlesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 6);
    }

    public void vcmpnlesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 6);
    }

    public void vcmpnless(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 6);
    }

    public void vcmpnless(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 6);
    }

    public void vcmpnless(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 6);
    }

    public void vcmpnless(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 6);
    }

    public void vcmpnlt_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 21);
    }

    public void vcmpnlt_uqss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 21);
    }

    public void vcmpnltpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 5);
    }

    public void vcmpnltph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 5);
    }

    public void vcmpnltph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 5);
    }

    public void vcmpnltph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 5);
    }

    public void vcmpnltph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 5);
    }

    public void vcmpnltph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 5);
    }

    public void vcmpnltph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 5);
    }

    public void vcmpnltsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 5);
    }

    public void vcmpnltsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 5);
    }

    public void vcmpnltsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 5);
    }

    public void vcmpnltsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 5);
    }

    public void vcmpnltsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 5);
    }

    public void vcmpnltsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 5);
    }

    public void vcmpnltss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 5);
    }

    public void vcmpnltss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 5);
    }

    public void vcmpnltss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 5);
    }

    public void vcmpnltss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 5);
    }

    public void vcmpord_spd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_spd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_spd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_spd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_spd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_spd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_spd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_spd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_spd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_spd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 23);
    }

    public void vcmpord_sph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 23);
    }

    public void vcmpord_sph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 23);
    }

    public void vcmpord_sph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 23);
    }

    public void vcmpord_sph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 23);
    }

    public void vcmpord_sph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 23);
    }

    public void vcmpord_sph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_sps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 23);
    }

    public void vcmpord_ssd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 23);
    }

    public void vcmpord_ssd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 23);
    }

    public void vcmpord_ssd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 23);
    }

    public void vcmpord_ssd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 23);
    }

    public void vcmpord_ssh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 23);
    }

    public void vcmpord_ssh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 23);
    }

    public void vcmpord_sss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 23);
    }

    public void vcmpord_sss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 23);
    }

    public void vcmpord_sss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 23);
    }

    public void vcmpord_sss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 23);
    }

    public void vcmpordpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 7);
    }

    public void vcmpordph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 7);
    }

    public void vcmpordph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 7);
    }

    public void vcmpordph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 7);
    }

    public void vcmpordph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 7);
    }

    public void vcmpordph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 7);
    }

    public void vcmpordph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 7);
    }

    public void vcmpordsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 7);
    }

    public void vcmpordsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 7);
    }

    public void vcmpordsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 7);
    }

    public void vcmpordsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 7);
    }

    public void vcmpordsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 7);
    }

    public void vcmpordsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 7);
    }

    public void vcmpordss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 7);
    }

    public void vcmpordss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 7);
    }

    public void vcmpordss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 7);
    }

    public void vcmpordss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 7);
    }

    public void vcmppd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(2149, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vcmppd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(2147, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vcmppd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(2150, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vcmppd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(2148, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vcmppd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(2151, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vcmppd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2149, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmppd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2147, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vcmppd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2150, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmppd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2148, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vcmppd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2151, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(4327, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vcmpph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(4328, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vcmpph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(4329, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vcmpph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(4327, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(4328, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(4329, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(2143, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vcmpps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(2141, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vcmpps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(2144, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vcmpps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(2142, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vcmpps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(2145, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vcmpps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2143, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2141, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vcmpps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2144, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2142, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vcmpps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2145, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(2157, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vcmpsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(2156, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vcmpsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2157, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2156, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vcmpsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(4330, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vcmpsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(4330, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(2154, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vcmpss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(2153, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vcmpss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2154, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vcmpss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(2153, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vcmptrue_uspd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_uspd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_uspd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_uspd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_uspd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_uspd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_uspd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_uspd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_uspd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_uspd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 31);
    }

    public void vcmptrue_usph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 31);
    }

    public void vcmptrue_usph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 31);
    }

    public void vcmptrue_usph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 31);
    }

    public void vcmptrue_usph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 31);
    }

    public void vcmptrue_usph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 31);
    }

    public void vcmptrue_usph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_usps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 31);
    }

    public void vcmptrue_ussd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 31);
    }

    public void vcmptrue_ussd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 31);
    }

    public void vcmptrue_ussd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 31);
    }

    public void vcmptrue_ussd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 31);
    }

    public void vcmptrue_ussh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 31);
    }

    public void vcmptrue_ussh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 31);
    }

    public void vcmptrue_usss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 31);
    }

    public void vcmptrue_usss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 31);
    }

    public void vcmptrue_usss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 31);
    }

    public void vcmptrue_usss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 31);
    }

    public void vcmptruepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptruepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptruepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptruepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptruepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptruepd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptruepd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptruepd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptruepd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptruepd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 15);
    }

    public void vcmptrueph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 15);
    }

    public void vcmptrueph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 15);
    }

    public void vcmptrueph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 15);
    }

    public void vcmptrueph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 15);
    }

    public void vcmptrueph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 15);
    }

    public void vcmptrueph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptrueps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 15);
    }

    public void vcmptruesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 15);
    }

    public void vcmptruesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 15);
    }

    public void vcmptruesd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 15);
    }

    public void vcmptruesd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 15);
    }

    public void vcmptruesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 15);
    }

    public void vcmptruesh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 15);
    }

    public void vcmptruess(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 15);
    }

    public void vcmptruess(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 15);
    }

    public void vcmptruess(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 15);
    }

    public void vcmptruess(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 15);
    }

    public void vcmpunord_spd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_spd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_spd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_spd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_spd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_spd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_spd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_spd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_spd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_spd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 19);
    }

    public void vcmpunord_sph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 19);
    }

    public void vcmpunord_sph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 19);
    }

    public void vcmpunord_sph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 19);
    }

    public void vcmpunord_sph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 19);
    }

    public void vcmpunord_sph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 19);
    }

    public void vcmpunord_sph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_sps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 19);
    }

    public void vcmpunord_ssd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 19);
    }

    public void vcmpunord_ssd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 19);
    }

    public void vcmpunord_ssd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 19);
    }

    public void vcmpunord_ssd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 19);
    }

    public void vcmpunord_ssh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 19);
    }

    public void vcmpunord_ssh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 19);
    }

    public void vcmpunord_sss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 19);
    }

    public void vcmpunord_sss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 19);
    }

    public void vcmpunord_sss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 19);
    }

    public void vcmpunord_sss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 19);
    }

    public void vcmpunordpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordpd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordpd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordpd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmppd(dst, src1, src2, 3);
    }

    public void vcmpunordph(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpph(dst, src1, src2, 3);
    }

    public void vcmpunordph(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpph(dst, src1, src2, 3);
    }

    public void vcmpunordph(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpph(dst, src1, src2, 3);
    }

    public void vcmpunordph(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 3);
    }

    public void vcmpunordph(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 3);
    }

    public void vcmpunordph(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpph(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordps(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.vcmpps(dst, src1, src2, 3);
    }

    public void vcmpunordsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 3);
    }

    public void vcmpunordsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsd(dst, src1, src2, 3);
    }

    public void vcmpunordsd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 3);
    }

    public void vcmpunordsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsd(dst, src1, src2, 3);
    }

    public void vcmpunordsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpsh(dst, src1, src2, 3);
    }

    public void vcmpunordsh(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpsh(dst, src1, src2, 3);
    }

    public void vcmpunordss(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 3);
    }

    public void vcmpunordss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.vcmpss(dst, src1, src2, 3);
    }

    public void vcmpunordss(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 3);
    }

    public void vcmpunordss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.vcmpss(dst, src1, src2, 3);
    }

    public void vcomisd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1158 : 1160;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcomisd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1158 : 1160;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcomish(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4331, dst.get(), src.get()), src.flags);
    }

    public void vcomish(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4331, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcomiss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1157 : 1159;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcomiss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1157 : 1159;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcompresspd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3262, dst.get(), src.get()), dst.flags);
    }

    public void vcompresspd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3262, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vcompresspd(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(3263, dst.get(), src.get()), dst.flags);
    }

    public void vcompresspd(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(3263, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vcompresspd(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3264, dst.get(), src.get()), dst.flags);
    }

    public void vcompresspd(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3264, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vcompressps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3259, dst.get(), src.get()), dst.flags);
    }

    public void vcompressps(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3259, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vcompressps(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(3260, dst.get(), src.get()), dst.flags);
    }

    public void vcompressps(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(3260, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vcompressps(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3261, dst.get(), src.get()), dst.flags);
    }

    public void vcompressps(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3261, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vcvtdq2pd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2379 : 2381;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtdq2pd(AsmRegisterYMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2380 : 2382;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtdq2pd(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(2383, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtdq2pd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 2381 : (this.getInstructionPreferVex() ? 2379 : 2381);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtdq2pd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 2382 : (this.getInstructionPreferVex() ? 2380 : 2382);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtdq2pd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2383, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtdq2ph(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4332, dst.get(), src.get()), dst.flags);
    }

    public void vcvtdq2ph(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4333, dst.get(), src.get()), dst.flags);
    }

    public void vcvtdq2ph(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4334, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtdq2ph(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 4333;
        } else if (src.size == 8) {
            code = 4333;
        } else if (src.size == 7) {
            code = 4332;
        } else {
            throw this.noOpCodeFoundFor(1638, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtdq2ph(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4334, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtdq2phx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4332, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtdq2phy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4333, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtdq2ps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1391 : 1393;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtdq2ps(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1392 : 1394;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtdq2ps(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1395, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtdq2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 1393 : (this.getInstructionPreferVex() ? 1391 : 1393);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtdq2ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 1394 : (this.getInstructionPreferVex() ? 1392 : 1394);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtdq2ps(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1395, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtne2ps2bf16(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3171, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vcvtne2ps2bf16(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(3172, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vcvtne2ps2bf16(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3173, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vcvtne2ps2bf16(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3171, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vcvtne2ps2bf16(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3172, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vcvtne2ps2bf16(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3173, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vcvtneebf162ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4867, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vcvtneebf162ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4868, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vcvtneeph2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4865, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vcvtneeph2ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4866, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vcvtneobf162ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4869, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vcvtneobf162ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4870, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vcvtneoph2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4863, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vcvtneoph2ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4864, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vcvtneps2bf16(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 4861 : 3168;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtneps2bf16(AsmRegisterXMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 4862 : 3169;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtneps2bf16(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3170, dst.get(), src.get()), dst.flags);
    }

    public void vcvtneps2bf16(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 3169;
        } else if (src.size == 8) {
            code = this.getInstructionPreferVex() ? 4862 : 3169;
        } else if (src.size == 7) {
            code = this.getInstructionPreferVex() ? 4861 : 3168;
        } else {
            throw this.noOpCodeFoundFor(820, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtneps2bf16(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3170, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtneps2bf16x(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3168, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtneps2bf16y(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3169, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2388 : 2390;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2dq(AsmRegisterXMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 2389 : 2391;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2dq(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(2392, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtpd2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 2391;
        } else if (src.size == 8) {
            code = this.getInstructionPreferVex() ? 2389 : 2391;
        } else if (src.size == 7) {
            code = this.getInstructionPreferVex() ? 2388 : 2390;
        } else {
            throw this.noOpCodeFoundFor(821, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2dq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2392, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2dqx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2390, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2dqy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2391, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2ph(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4335, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2ph(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4336, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2ph(AsmRegisterXMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4337, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtpd2ph(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 4337;
        } else if (src.size == 9) {
            code = 4337;
        } else if (src.size == 8) {
            code = 4336;
        } else if (src.size == 7) {
            code = 4335;
        } else {
            throw this.noOpCodeFoundFor(1639, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2phx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4335, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2phy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4336, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2phz(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4337, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2ps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1379 : 1381;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2ps(AsmRegisterXMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1380 : 1382;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2ps(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1383, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtpd2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 1382;
        } else if (src.size == 8) {
            code = this.getInstructionPreferVex() ? 1380 : 1382;
        } else if (src.size == 7) {
            code = this.getInstructionPreferVex() ? 1379 : 1381;
        } else {
            throw this.noOpCodeFoundFor(822, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1383, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2psx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1381, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2psy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1382, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2qq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1799, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2qq(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1800, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2qq(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1801, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtpd2qq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1799, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2qq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1800, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2qq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1801, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2udq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1763, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2udq(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1764, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2udq(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1765, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtpd2udq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 1764;
        } else if (src.size == 8) {
            code = 1764;
        } else if (src.size == 7) {
            code = 1763;
        } else {
            throw this.noOpCodeFoundFor(824, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2udq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1765, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2udqx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1763, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2udqy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1764, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2uqq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1770, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2uqq(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1771, dst.get(), src.get()), dst.flags);
    }

    public void vcvtpd2uqq(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1772, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtpd2uqq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1770, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2uqq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1771, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtpd2uqq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1772, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4338, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2dq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4339, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2dq(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4340, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtph2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4338, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2dq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4339, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2dq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4340, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2pd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4341, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2pd(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4342, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2pd(AsmRegisterZMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4343, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtph2pd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4341, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2pd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4342, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2pd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4343, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2ps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2652 : 2654;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2ps(AsmRegisterYMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2653 : 2655;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2ps(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(2656, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtph2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 2652 : 2654;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vcvtph2ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 2653 : 2655;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vcvtph2ps(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2656, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2psx(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4344, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2psx(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4345, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2psx(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4346, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtph2psx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4344, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2psx(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4345, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2psx(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4346, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2qq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4347, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2qq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4348, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2qq(AsmRegisterZMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4349, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtph2qq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4347, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2qq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4348, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2qq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4349, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2udq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4350, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2udq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4351, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2udq(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4352, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtph2udq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4350, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2udq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4351, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2udq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4352, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2uqq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4353, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2uqq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4354, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2uqq(AsmRegisterZMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4355, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtph2uqq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4353, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2uqq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4354, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2uqq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4355, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2uw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4356, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2uw(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4357, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2uw(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4358, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtph2uw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4356, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2uw(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4357, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2uw(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4358, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2w(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4359, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2w(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4360, dst.get(), src.get()), dst.flags);
    }

    public void vcvtph2w(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4361, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtph2w(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4359, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2w(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4360, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtph2w(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4361, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1400 : 1402;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2dq(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1401 : 1403;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2dq(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1404, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtps2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 1402 : (this.getInstructionPreferVex() ? 1400 : 1402);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2dq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 1403 : (this.getInstructionPreferVex() ? 1401 : 1403);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2dq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1404, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2pd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1373 : 1375;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2pd(AsmRegisterYMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1374 : 1376;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2pd(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1377, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtps2pd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 1375 : (this.getInstructionPreferVex() ? 1373 : 1375);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2pd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 1376 : (this.getInstructionPreferVex() ? 1374 : 1376);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2pd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1377, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2ph(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        int code = this.getInstructionPreferVex() ? 3811 : 3813;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vcvtps2ph(AsmMemoryOperand dst, AsmRegisterXMM src1, int imm) {
        int code = this.getInstructionPreferVex() ? 3811 : 3813;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vcvtps2ph(AsmRegisterXMM dst, AsmRegisterYMM src1, int imm) {
        int code = this.getInstructionPreferVex() ? 3812 : 3814;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vcvtps2ph(AsmMemoryOperand dst, AsmRegisterYMM src1, int imm) {
        int code = this.getInstructionPreferVex() ? 3812 : 3814;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vcvtps2ph(AsmRegisterYMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3815, dst.get(), src1.get(), imm), dst.flags | src1.flags);
    }

    public void vcvtps2ph(AsmMemoryOperand dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3815, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags | src1.flags);
    }

    public void vcvtps2phx(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4362, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2phx(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4363, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2phx(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4364, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtps2phx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 4363;
        } else if (src.size == 8) {
            code = 4363;
        } else if (src.size == 7) {
            code = 4362;
        } else {
            throw this.noOpCodeFoundFor(1648, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2phx(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4364, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2phxx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4362, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2phxy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4363, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2qq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1796, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2qq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1797, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2qq(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1798, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtps2qq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1796, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2qq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1797, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2qq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1798, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2udq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1760, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2udq(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1761, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2udq(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1762, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtps2udq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1760, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2udq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1761, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2udq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1762, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2uqq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1767, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2uqq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1768, dst.get(), src.get()), dst.flags);
    }

    public void vcvtps2uqq(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1769, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtps2uqq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1767, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2uqq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1768, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtps2uqq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1769, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2pd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(2384, dst.get(), src.get()), dst.flags);
    }

    public void vcvtqq2pd(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(2385, dst.get(), src.get()), dst.flags);
    }

    public void vcvtqq2pd(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(2386, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtqq2pd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2384, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2pd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2385, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2pd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2386, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2ph(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4365, dst.get(), src.get()), dst.flags);
    }

    public void vcvtqq2ph(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4366, dst.get(), src.get()), dst.flags);
    }

    public void vcvtqq2ph(AsmRegisterXMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4367, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtqq2ph(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 4367;
        } else if (src.size == 9) {
            code = 4367;
        } else if (src.size == 8) {
            code = 4366;
        } else if (src.size == 7) {
            code = 4365;
        } else {
            throw this.noOpCodeFoundFor(1649, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2phx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4365, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2phy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4366, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2phz(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4367, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2ps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1396, dst.get(), src.get()), dst.flags);
    }

    public void vcvtqq2ps(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1397, dst.get(), src.get()), dst.flags);
    }

    public void vcvtqq2ps(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1398, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtqq2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 1397;
        } else if (src.size == 8) {
            code = 1397;
        } else if (src.size == 7) {
            code = 1396;
        } else {
            throw this.noOpCodeFoundFor(834, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1398, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2psx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1396, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtqq2psy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1397, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtsd2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4368, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vcvtsd2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4368, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vcvtsd2si(AsmRegister32 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1145 : 1147;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcvtsd2si(AsmRegister64 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1146 : 1148;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcvtsd2si(AsmRegister32 dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1145 : 1147;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtsd2si(AsmRegister64 dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1146 : 1148;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtsd2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1388 : 1389;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vcvtsd2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1388 : 1389;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vcvtsd2usi(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1776, dst.get(), src.get()), src.flags);
    }

    public void vcvtsd2usi(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1777, dst.get(), src.get()), src.flags);
    }

    public void vcvtsd2usi(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1776, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtsd2usi(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1777, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtsh2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4369, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vcvtsh2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4369, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vcvtsh2si(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4370, dst.get(), src.get()), src.flags);
    }

    public void vcvtsh2si(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4371, dst.get(), src.get()), src.flags);
    }

    public void vcvtsh2si(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4370, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtsh2si(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4371, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtsh2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4372, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vcvtsh2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4372, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vcvtsh2usi(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4373, dst.get(), src.get()), src.flags);
    }

    public void vcvtsh2usi(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4374, dst.get(), src.get()), src.flags);
    }

    public void vcvtsh2usi(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4373, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtsh2usi(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4374, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtsi2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister32 src2) {
        int code = this.getInstructionPreferVex() ? 1103 : 1105;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtsi2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister64 src2) {
        int code = this.getInstructionPreferVex() ? 1104 : 1106;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtsi2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code;
        if (src2.size == 4) {
            code = this.getInstructionPreferVex() ? 1104 : 1106;
        } else if (src2.size == 3) {
            code = this.getInstructionPreferVex() ? 1103 : 1105;
        } else {
            throw this.noOpCodeFoundFor(838, dst, src1, src2);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vcvtsi2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4375, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtsi2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4376, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtsi2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code;
        if (src2.size == 4) {
            code = 4376;
        } else if (src2.size == 3) {
            code = 4375;
        } else {
            throw this.noOpCodeFoundFor(1655, dst, src1, src2);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vcvtsi2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister32 src2) {
        int code = this.getInstructionPreferVex() ? 1097 : 1099;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtsi2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister64 src2) {
        int code = this.getInstructionPreferVex() ? 1098 : 1100;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtsi2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code;
        if (src2.size == 4) {
            code = this.getInstructionPreferVex() ? 1098 : 1100;
        } else if (src2.size == 3) {
            code = this.getInstructionPreferVex() ? 1097 : 1099;
        } else {
            throw this.noOpCodeFoundFor(839, dst, src1, src2);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vcvtss2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1385 : 1386;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vcvtss2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1385 : 1386;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vcvtss2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4377, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vcvtss2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4377, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vcvtss2si(AsmRegister32 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1139 : 1141;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcvtss2si(AsmRegister64 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1140 : 1142;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcvtss2si(AsmRegister32 dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1139 : 1141;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtss2si(AsmRegister64 dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1140 : 1142;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtss2usi(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1773, dst.get(), src.get()), src.flags);
    }

    public void vcvtss2usi(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1774, dst.get(), src.get()), src.flags);
    }

    public void vcvtss2usi(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1773, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtss2usi(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1774, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttpd2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2373 : 2375;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvttpd2dq(AsmRegisterXMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 2374 : 2376;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvttpd2dq(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(2377, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttpd2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 2376;
        } else if (src.size == 8) {
            code = this.getInstructionPreferVex() ? 2374 : 2376;
        } else if (src.size == 7) {
            code = this.getInstructionPreferVex() ? 2373 : 2375;
        } else {
            throw this.noOpCodeFoundFor(843, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2dq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2377, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2dqx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2375, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2dqy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2376, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2qq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1781, dst.get(), src.get()), dst.flags);
    }

    public void vcvttpd2qq(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1782, dst.get(), src.get()), dst.flags);
    }

    public void vcvttpd2qq(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1783, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttpd2qq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1781, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2qq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1782, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2qq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1783, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2udq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1743, dst.get(), src.get()), dst.flags);
    }

    public void vcvttpd2udq(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1744, dst.get(), src.get()), dst.flags);
    }

    public void vcvttpd2udq(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1745, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttpd2udq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 1744;
        } else if (src.size == 8) {
            code = 1744;
        } else if (src.size == 7) {
            code = 1743;
        } else {
            throw this.noOpCodeFoundFor(845, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2udq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1745, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2udqx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1743, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2udqy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1744, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2uqq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1750, dst.get(), src.get()), dst.flags);
    }

    public void vcvttpd2uqq(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1751, dst.get(), src.get()), dst.flags);
    }

    public void vcvttpd2uqq(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1752, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttpd2uqq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1750, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2uqq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1751, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttpd2uqq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1752, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4378, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2dq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4379, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2dq(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4380, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttph2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4378, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2dq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4379, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2dq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4380, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2qq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4381, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2qq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4382, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2qq(AsmRegisterZMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4383, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttph2qq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4381, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2qq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4382, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2qq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4383, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2udq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4384, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2udq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4385, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2udq(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4386, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttph2udq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4384, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2udq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4385, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2udq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4386, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2uqq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4387, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2uqq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4388, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2uqq(AsmRegisterZMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4389, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttph2uqq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4387, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2uqq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4388, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2uqq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4389, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2uw(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4390, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2uw(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4391, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2uw(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4392, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttph2uw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4390, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2uw(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4391, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2uw(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4392, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2w(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4393, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2w(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4394, dst.get(), src.get()), dst.flags);
    }

    public void vcvttph2w(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4395, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttph2w(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4393, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2w(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4394, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttph2w(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4395, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2dq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1406 : 1408;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvttps2dq(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1407 : 1409;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vcvttps2dq(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1410, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttps2dq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 1408 : (this.getInstructionPreferVex() ? 1406 : 1408);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2dq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = src.isBroadcast() ? 1409 : (this.getInstructionPreferVex() ? 1407 : 1409);
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2dq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1410, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2qq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1778, dst.get(), src.get()), dst.flags);
    }

    public void vcvttps2qq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1779, dst.get(), src.get()), dst.flags);
    }

    public void vcvttps2qq(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1780, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttps2qq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1778, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2qq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1779, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2qq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1780, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2udq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1740, dst.get(), src.get()), dst.flags);
    }

    public void vcvttps2udq(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1741, dst.get(), src.get()), dst.flags);
    }

    public void vcvttps2udq(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1742, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttps2udq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1740, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2udq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1741, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2udq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1742, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2uqq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1747, dst.get(), src.get()), dst.flags);
    }

    public void vcvttps2uqq(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1748, dst.get(), src.get()), dst.flags);
    }

    public void vcvttps2uqq(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1749, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvttps2uqq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1747, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2uqq(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1748, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttps2uqq(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1749, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvttsd2si(AsmRegister32 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1131 : 1133;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcvttsd2si(AsmRegister64 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1132 : 1134;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcvttsd2si(AsmRegister32 dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1131 : 1133;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttsd2si(AsmRegister64 dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1132 : 1134;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttsd2usi(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1756, dst.get(), src.get()), src.flags);
    }

    public void vcvttsd2usi(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1757, dst.get(), src.get()), src.flags);
    }

    public void vcvttsd2usi(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1756, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttsd2usi(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1757, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttsh2si(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4396, dst.get(), src.get()), src.flags);
    }

    public void vcvttsh2si(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4397, dst.get(), src.get()), src.flags);
    }

    public void vcvttsh2si(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4396, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttsh2si(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4397, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttsh2usi(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4398, dst.get(), src.get()), src.flags);
    }

    public void vcvttsh2usi(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4399, dst.get(), src.get()), src.flags);
    }

    public void vcvttsh2usi(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4398, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttsh2usi(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4399, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttss2si(AsmRegister32 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1125 : 1127;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcvttss2si(AsmRegister64 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1126 : 1128;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), src.flags);
    }

    public void vcvttss2si(AsmRegister32 dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1125 : 1127;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttss2si(AsmRegister64 dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1126 : 1128;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttss2usi(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1753, dst.get(), src.get()), src.flags);
    }

    public void vcvttss2usi(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1754, dst.get(), src.get()), src.flags);
    }

    public void vcvttss2usi(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1753, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvttss2usi(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1754, dst.get(), src.toMemoryOperand(this.getBitness())), src.flags);
    }

    public void vcvtudq2pd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1784, dst.get(), src.get()), dst.flags);
    }

    public void vcvtudq2pd(AsmRegisterYMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1785, dst.get(), src.get()), dst.flags);
    }

    public void vcvtudq2pd(AsmRegisterZMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1786, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtudq2pd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1784, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtudq2pd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1785, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtudq2pd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1786, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtudq2ph(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4400, dst.get(), src.get()), dst.flags);
    }

    public void vcvtudq2ph(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4401, dst.get(), src.get()), dst.flags);
    }

    public void vcvtudq2ph(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4402, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtudq2ph(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 4401;
        } else if (src.size == 8) {
            code = 4401;
        } else if (src.size == 7) {
            code = 4400;
        } else {
            throw this.noOpCodeFoundFor(1665, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtudq2ph(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4402, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtudq2phx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4400, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtudq2phy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4401, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtudq2ps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1790, dst.get(), src.get()), dst.flags);
    }

    public void vcvtudq2ps(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1791, dst.get(), src.get()), dst.flags);
    }

    public void vcvtudq2ps(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1792, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtudq2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1790, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtudq2ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1791, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtudq2ps(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1792, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2pd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1787, dst.get(), src.get()), dst.flags);
    }

    public void vcvtuqq2pd(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1788, dst.get(), src.get()), dst.flags);
    }

    public void vcvtuqq2pd(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1789, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtuqq2pd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1787, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2pd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1788, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2pd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1789, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2ph(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4403, dst.get(), src.get()), dst.flags);
    }

    public void vcvtuqq2ph(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4404, dst.get(), src.get()), dst.flags);
    }

    public void vcvtuqq2ph(AsmRegisterXMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4405, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtuqq2ph(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 4405;
        } else if (src.size == 9) {
            code = 4405;
        } else if (src.size == 8) {
            code = 4404;
        } else if (src.size == 7) {
            code = 4403;
        } else {
            throw this.noOpCodeFoundFor(1666, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2phx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4403, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2phy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4404, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2phz(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4405, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2ps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1793, dst.get(), src.get()), dst.flags);
    }

    public void vcvtuqq2ps(AsmRegisterXMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1794, dst.get(), src.get()), dst.flags);
    }

    public void vcvtuqq2ps(AsmRegisterYMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1795, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtuqq2ps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (src.isBroadcast()) {
            code = 1794;
        } else if (src.size == 8) {
            code = 1794;
        } else if (src.size == 7) {
            code = 1793;
        } else {
            throw this.noOpCodeFoundFor(858, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2ps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1795, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2psx(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1793, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuqq2psy(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1794, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtusi2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(1804, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtusi2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(1805, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtusi2sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code;
        if (src2.size == 4) {
            code = 1805;
        } else if (src2.size == 3) {
            code = 1804;
        } else {
            throw this.noOpCodeFoundFor(859, dst, src1, src2);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vcvtusi2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(4406, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtusi2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(4407, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtusi2sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code;
        if (src2.size == 4) {
            code = 4407;
        } else if (src2.size == 3) {
            code = 4406;
        } else {
            throw this.noOpCodeFoundFor(1667, dst, src1, src2);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vcvtusi2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister32 src2) {
        this.addInstruction(Instruction.create(1802, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtusi2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegister64 src2) {
        this.addInstruction(Instruction.create(1803, dst.get(), src1.get(), src2.get()), src2.flags);
    }

    public void vcvtusi2ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code;
        if (src2.size == 4) {
            code = 1803;
        } else if (src2.size == 3) {
            code = 1802;
        } else {
            throw this.noOpCodeFoundFor(860, dst, src1, src2);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vcvtuw2ph(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4408, dst.get(), src.get()), dst.flags);
    }

    public void vcvtuw2ph(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4409, dst.get(), src.get()), dst.flags);
    }

    public void vcvtuw2ph(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4410, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtuw2ph(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4408, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuw2ph(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4409, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtuw2ph(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4410, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtw2ph(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4411, dst.get(), src.get()), dst.flags);
    }

    public void vcvtw2ph(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4412, dst.get(), src.get()), dst.flags);
    }

    public void vcvtw2ph(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4413, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vcvtw2ph(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4411, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtw2ph(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4412, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vcvtw2ph(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4413, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vdbpsadbw(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3903, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vdbpsadbw(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3904, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vdbpsadbw(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(3905, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vdbpsadbw(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3903, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vdbpsadbw(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3904, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vdbpsadbw(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3905, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vdivpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1454 : 1456;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vdivpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1455 : 1457;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vdivpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1458, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vdivpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1456 : (this.getInstructionPreferVex() ? 1454 : 1456);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1457 : (this.getInstructionPreferVex() ? 1455 : 1457);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1458, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4414, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vdivph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4415, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vdivph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4416, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vdivph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4414, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4415, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4416, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1448 : 1450;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vdivps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1449 : 1451;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vdivps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1452, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vdivps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1450 : (this.getInstructionPreferVex() ? 1448 : 1450);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1451 : (this.getInstructionPreferVex() ? 1449 : 1451);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1452, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1463 : 1464;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vdivsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1463 : 1464;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4417, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vdivsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4417, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdivss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1460 : 1461;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vdivss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1460 : 1461;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdpbf16ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3080, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vdpbf16ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(3081, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vdpbf16ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3082, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vdpbf16ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3080, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdpbf16ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3081, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdpbf16ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3082, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vdppd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3899, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vdppd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3899, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vdpps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3896, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vdpps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3897, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vdpps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3896, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vdpps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3897, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void verr(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(784, dst.get()));
    }

    public void verr(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(785, dst.get()));
    }

    public void verr(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(786, dst.get()));
    }

    public void verr(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 785 : 784;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void verw(AsmRegister16 dst) {
        this.addInstruction(Instruction.create(787, dst.get()));
    }

    public void verw(AsmRegister32 dst) {
        this.addInstruction(Instruction.create(788, dst.get()));
    }

    public void verw(AsmRegister64 dst) {
        this.addInstruction(Instruction.create(789, dst.get()));
    }

    public void verw(AsmMemoryOperand dst) {
        int code = this.getBitness() >= 32 ? 788 : 787;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness())));
    }

    public void vexp2pd(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3614, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vexp2pd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3614, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vexp2ps(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3613, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vexp2ps(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3613, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vexpandpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3250, dst.get(), src.get()), dst.flags);
    }

    public void vexpandpd(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(3251, dst.get(), src.get()), dst.flags);
    }

    public void vexpandpd(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3252, dst.get(), src.get()), dst.flags);
    }

    public void vexpandpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3250, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vexpandpd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3251, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vexpandpd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3252, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vexpandps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3247, dst.get(), src.get()), dst.flags);
    }

    public void vexpandps(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(3248, dst.get(), src.get()), dst.flags);
    }

    public void vexpandps(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3249, dst.get(), src.get()), dst.flags);
    }

    public void vexpandps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3247, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vexpandps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3248, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vexpandps(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3249, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vextractf128(AsmRegisterXMM dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3802, dst.get(), src1.get(), imm));
    }

    public void vextractf128(AsmMemoryOperand dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3802, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void vextractf32x4(AsmRegisterXMM dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3803, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextractf32x4(AsmMemoryOperand dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3803, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextractf32x4(AsmRegisterXMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3804, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextractf32x4(AsmMemoryOperand dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3804, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextractf32x8(AsmRegisterYMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3809, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextractf32x8(AsmMemoryOperand dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3809, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextractf64x2(AsmRegisterXMM dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3805, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextractf64x2(AsmMemoryOperand dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3805, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextractf64x2(AsmRegisterXMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3806, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextractf64x2(AsmMemoryOperand dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3806, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextractf64x4(AsmRegisterYMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3810, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextractf64x4(AsmMemoryOperand dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3810, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextracti128(AsmRegisterXMM dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3874, dst.get(), src1.get(), imm));
    }

    public void vextracti128(AsmMemoryOperand dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3874, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void vextracti32x4(AsmRegisterXMM dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3875, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextracti32x4(AsmMemoryOperand dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3875, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextracti32x4(AsmRegisterXMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3876, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextracti32x4(AsmMemoryOperand dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3876, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextracti32x8(AsmRegisterYMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3881, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextracti32x8(AsmMemoryOperand dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3881, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextracti64x2(AsmRegisterXMM dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3877, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextracti64x2(AsmMemoryOperand dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3877, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextracti64x2(AsmRegisterXMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3878, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextracti64x2(AsmMemoryOperand dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3878, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextracti64x4(AsmRegisterYMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3882, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vextracti64x4(AsmMemoryOperand dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3882, dst.toMemoryOperand(this.getBitness()), src1.get(), imm), dst.flags);
    }

    public void vextractps(AsmRegister32 dst, AsmRegisterXMM src1, int imm) {
        int code = this.getInstructionPreferVex() ? 3793 : 3795;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), imm));
    }

    public void vextractps(AsmRegister64 dst, AsmRegisterXMM src1, int imm) {
        int code = this.getInstructionPreferVex() ? 3794 : 3796;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), imm));
    }

    public void vextractps(AsmMemoryOperand dst, AsmRegisterXMM src1, int imm) {
        int code = this.getInstructionPreferVex() ? 3793 : 3795;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src1.get(), imm));
    }

    public void vfcmaddcph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4418, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfcmaddcph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4419, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfcmaddcph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4420, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfcmaddcph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4418, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfcmaddcph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4419, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfcmaddcph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4420, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfcmaddcsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4424, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfcmaddcsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4424, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfcmulcph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4426, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfcmulcph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4427, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfcmulcph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4428, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfcmulcph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4426, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfcmulcph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4427, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfcmulcph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4428, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfcmulcsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4432, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfcmulcsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4432, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfixupimmpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3942, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vfixupimmpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3943, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vfixupimmpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(3944, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vfixupimmpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3942, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vfixupimmpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3943, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vfixupimmpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3944, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vfixupimmps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3939, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vfixupimmps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3940, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vfixupimmps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(3941, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vfixupimmps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3939, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vfixupimmps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3940, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vfixupimmps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3941, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vfixupimmsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3946, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vfixupimmsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3946, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vfixupimmss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3945, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vfixupimmss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3945, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vfmadd132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3350 : 3355;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3351 : 3356;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3357, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3355 : (this.getInstructionPreferVex() ? 3350 : 3355);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3356 : (this.getInstructionPreferVex() ? 3351 : 3356);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3357, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4452, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4453, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4454, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4452, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4453, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4454, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3348 : 3352;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3349 : 3353;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3354, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3352 : (this.getInstructionPreferVex() ? 3348 : 3352);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3353 : (this.getInstructionPreferVex() ? 3349 : 3353);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3354, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3359 : 3361;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd132sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3359 : 3361;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4470, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd132sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4470, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd132ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3358 : 3360;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd132ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3358 : 3360;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3452 : 3457;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3453 : 3458;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3459, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3457 : (this.getInstructionPreferVex() ? 3452 : 3457);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3458 : (this.getInstructionPreferVex() ? 3453 : 3458);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3459, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4455, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4456, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4457, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4455, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4456, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4457, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3450 : 3454;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3451 : 3455;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3456, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3454 : (this.getInstructionPreferVex() ? 3450 : 3454);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3455 : (this.getInstructionPreferVex() ? 3451 : 3455);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3456, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3461 : 3463;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd213sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3461 : 3463;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4471, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd213sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4471, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd213ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3460 : 3462;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd213ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3460 : 3462;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3536 : 3541;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3537 : 3542;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3543, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3541 : (this.getInstructionPreferVex() ? 3536 : 3541);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3542 : (this.getInstructionPreferVex() ? 3537 : 3542);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3543, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4458, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4459, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4460, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4458, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4459, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4460, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3534 : 3538;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3535 : 3539;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmadd231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3540, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3538 : (this.getInstructionPreferVex() ? 3534 : 3538);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3539 : (this.getInstructionPreferVex() ? 3535 : 3539);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3540, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3545 : 3547;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd231sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3545 : 3547;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4472, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd231sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4472, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmadd231ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3544 : 3546;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmadd231ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3544 : 3546;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddcph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4421, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddcph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4422, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddcph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4423, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddcph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4421, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddcph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4422, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddcph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4423, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddcsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4425, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddcsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4425, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3995, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3995, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3996, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3996, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3997, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3998, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3991, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3991, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3992, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3992, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3993, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3994, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmaddsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4001, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4001, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4002, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3999, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3999, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4000, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmaddsub132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3330 : 3335;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3331 : 3336;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3337, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddsub132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3335 : (this.getInstructionPreferVex() ? 3330 : 3335);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3336 : (this.getInstructionPreferVex() ? 3331 : 3336);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3337, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4434, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4435, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4436, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddsub132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4434, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4435, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4436, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3328 : 3332;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3329 : 3333;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3334, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddsub132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3332 : (this.getInstructionPreferVex() ? 3328 : 3332);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3333 : (this.getInstructionPreferVex() ? 3329 : 3333);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3334, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3432 : 3437;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3433 : 3438;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3439, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddsub213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3437 : (this.getInstructionPreferVex() ? 3432 : 3437);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3438 : (this.getInstructionPreferVex() ? 3433 : 3438);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3439, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4437, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4438, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4439, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddsub213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4437, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4438, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4439, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3430 : 3434;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3431 : 3435;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3436, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddsub213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3434 : (this.getInstructionPreferVex() ? 3430 : 3434);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3435 : (this.getInstructionPreferVex() ? 3431 : 3435);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3436, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3516 : 3521;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3517 : 3522;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3523, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddsub231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3521 : (this.getInstructionPreferVex() ? 3516 : 3521);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3522 : (this.getInstructionPreferVex() ? 3517 : 3522);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3523, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4440, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4441, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4442, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddsub231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4440, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4441, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4442, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3514 : 3518;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3515 : 3519;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmaddsub231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3520, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmaddsub231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3518 : (this.getInstructionPreferVex() ? 3514 : 3518);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3519 : (this.getInstructionPreferVex() ? 3515 : 3519);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsub231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3520, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmaddsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3959, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3959, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3960, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3960, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3961, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmaddsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3962, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmaddsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3955, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3955, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3956, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmaddsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3956, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmaddsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3957, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmaddsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3958, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsub132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3364 : 3369;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3365 : 3370;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3371, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3369 : (this.getInstructionPreferVex() ? 3364 : 3369);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3370 : (this.getInstructionPreferVex() ? 3365 : 3370);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3371, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4476, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4477, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4478, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4476, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4477, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4478, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3362 : 3366;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3363 : 3367;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3368, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3366 : (this.getInstructionPreferVex() ? 3362 : 3366);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3367 : (this.getInstructionPreferVex() ? 3363 : 3367);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3368, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3374 : 3376;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub132sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3374 : 3376;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4494, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub132sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4494, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub132ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3373 : 3375;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub132ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3373 : 3375;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3466 : 3471;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3467 : 3472;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3473, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3471 : (this.getInstructionPreferVex() ? 3466 : 3471);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3472 : (this.getInstructionPreferVex() ? 3467 : 3472);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3473, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4479, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4480, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4481, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4479, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4480, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4481, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3464 : 3468;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3465 : 3469;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3470, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3468 : (this.getInstructionPreferVex() ? 3464 : 3468);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3469 : (this.getInstructionPreferVex() ? 3465 : 3469);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3470, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3476 : 3478;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub213sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3476 : 3478;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4495, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub213sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4495, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub213ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3475 : 3477;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub213ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3475 : 3477;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3550 : 3555;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3551 : 3556;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3557, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3555 : (this.getInstructionPreferVex() ? 3550 : 3555);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3556 : (this.getInstructionPreferVex() ? 3551 : 3556);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3557, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4482, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4483, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4484, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4482, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4483, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4484, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3548 : 3552;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3549 : 3553;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsub231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3554, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3552 : (this.getInstructionPreferVex() ? 3548 : 3552);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3553 : (this.getInstructionPreferVex() ? 3549 : 3553);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3554, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3559 : 3561;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub231sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3559 : 3561;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4496, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub231sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4496, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsub231ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3558 : 3560;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsub231ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3558 : 3560;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3340 : 3345;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3341 : 3346;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3347, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsubadd132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3345 : (this.getInstructionPreferVex() ? 3340 : 3345);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3346 : (this.getInstructionPreferVex() ? 3341 : 3346);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3347, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4443, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4444, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4445, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsubadd132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4443, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4444, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4445, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3338 : 3342;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3339 : 3343;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3344, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsubadd132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3342 : (this.getInstructionPreferVex() ? 3338 : 3342);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3343 : (this.getInstructionPreferVex() ? 3339 : 3343);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3344, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3442 : 3447;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3443 : 3448;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3449, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsubadd213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3447 : (this.getInstructionPreferVex() ? 3442 : 3447);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3448 : (this.getInstructionPreferVex() ? 3443 : 3448);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3449, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4446, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4447, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4448, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsubadd213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4446, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4447, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4448, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3440 : 3444;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3441 : 3445;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3446, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsubadd213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3444 : (this.getInstructionPreferVex() ? 3440 : 3444);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3445 : (this.getInstructionPreferVex() ? 3441 : 3445);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3446, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3526 : 3531;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3527 : 3532;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3533, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsubadd231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3531 : (this.getInstructionPreferVex() ? 3526 : 3531);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3532 : (this.getInstructionPreferVex() ? 3527 : 3532);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3533, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4449, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4450, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4451, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsubadd231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4449, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4450, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4451, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3524 : 3528;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3525 : 3529;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmsubadd231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3530, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmsubadd231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3528 : (this.getInstructionPreferVex() ? 3524 : 3528);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3529 : (this.getInstructionPreferVex() ? 3525 : 3529);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubadd231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3530, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmsubaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3967, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3967, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3968, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3968, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3969, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsubaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3970, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsubaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3963, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(3963, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3964, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(3964, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3965, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsubaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(3966, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4007, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4007, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4008, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4008, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4009, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4010, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4003, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4003, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4004, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4004, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4005, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4006, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsubsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4013, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4013, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4014, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmsubss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4011, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfmsubss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4011, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfmsubss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4012, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfmulcph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4429, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmulcph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4430, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfmulcph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4431, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmulcph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4429, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmulcph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4430, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmulcph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4431, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfmulcsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4433, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfmulcsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4433, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3380 : 3385;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3381 : 3386;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3387, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3385 : (this.getInstructionPreferVex() ? 3380 : 3385);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3386 : (this.getInstructionPreferVex() ? 3381 : 3386);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3387, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4461, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4462, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4463, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4461, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4462, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4463, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3378 : 3382;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3379 : 3383;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3384, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3382 : (this.getInstructionPreferVex() ? 3378 : 3382);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3383 : (this.getInstructionPreferVex() ? 3379 : 3383);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3384, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3389 : 3391;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd132sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3389 : 3391;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4473, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd132sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4473, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd132ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3388 : 3390;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd132ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3388 : 3390;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3482 : 3487;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3483 : 3488;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3489, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3487 : (this.getInstructionPreferVex() ? 3482 : 3487);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3488 : (this.getInstructionPreferVex() ? 3483 : 3488);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3489, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4464, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4465, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4466, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4464, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4465, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4466, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3480 : 3484;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3481 : 3485;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3486, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3484 : (this.getInstructionPreferVex() ? 3480 : 3484);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3485 : (this.getInstructionPreferVex() ? 3481 : 3485);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3486, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3491 : 3493;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd213sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3491 : 3493;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4474, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd213sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4474, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd213ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3490 : 3492;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd213ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3490 : 3492;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3564 : 3569;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3565 : 3570;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3571, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3569 : (this.getInstructionPreferVex() ? 3564 : 3569);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3570 : (this.getInstructionPreferVex() ? 3565 : 3570);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3571, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4467, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4468, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4469, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4467, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4468, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4469, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3562 : 3566;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3563 : 3567;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmadd231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3568, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3566 : (this.getInstructionPreferVex() ? 3562 : 3566);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3567 : (this.getInstructionPreferVex() ? 3563 : 3567);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3568, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3573 : 3575;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd231sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3573 : 3575;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4475, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd231sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4475, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmadd231ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3572 : 3574;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmadd231ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3572 : 3574;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4037, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4037, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4038, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4038, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4039, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4040, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4033, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4033, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4034, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4034, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4035, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4036, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmaddsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4043, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmaddsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4043, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmaddsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4044, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4041, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4041, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmaddss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4042, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmsub132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3394 : 3399;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3395 : 3400;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3401, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub132pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3399 : (this.getInstructionPreferVex() ? 3394 : 3399);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3400 : (this.getInstructionPreferVex() ? 3395 : 3400);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3401, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4485, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4486, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4487, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub132ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4485, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4486, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4487, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3392 : 3396;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3393 : 3397;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3398, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub132ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3396 : (this.getInstructionPreferVex() ? 3392 : 3396);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3397 : (this.getInstructionPreferVex() ? 3393 : 3397);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3398, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3403 : 3405;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub132sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3403 : 3405;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4497, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub132sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4497, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub132ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3402 : 3404;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub132ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3402 : 3404;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3496 : 3501;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3497 : 3502;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3503, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub213pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3501 : (this.getInstructionPreferVex() ? 3496 : 3501);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3502 : (this.getInstructionPreferVex() ? 3497 : 3502);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3503, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4488, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4489, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4490, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub213ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4488, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4489, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4490, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3494 : 3498;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3495 : 3499;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3500, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub213ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3498 : (this.getInstructionPreferVex() ? 3494 : 3498);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3499 : (this.getInstructionPreferVex() ? 3495 : 3499);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3500, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3505 : 3507;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub213sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3505 : 3507;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4498, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub213sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4498, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub213ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3504 : 3506;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub213ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3504 : 3506;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3578 : 3583;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3579 : 3584;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3585, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub231pd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3583 : (this.getInstructionPreferVex() ? 3578 : 3583);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231pd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3584 : (this.getInstructionPreferVex() ? 3579 : 3584);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231pd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3585, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4491, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4492, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4493, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub231ph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4491, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231ph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4492, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231ph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4493, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3576 : 3580;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3577 : 3581;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vfnmsub231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3582, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub231ps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3580 : (this.getInstructionPreferVex() ? 3576 : 3580);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231ps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 3581 : (this.getInstructionPreferVex() ? 3577 : 3581);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231ps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3582, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3587 : 3589;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub231sd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3587 : 3589;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4499, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub231sh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4499, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsub231ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3586 : 3588;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vfnmsub231ss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3586 : 3588;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vfnmsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4049, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4049, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4050, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4050, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4051, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4052, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4045, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4045, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4046, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, AsmRegisterYMM src3) {
        this.addInstruction(Instruction.create(4046, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4047, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4048, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmsubsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4055, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmsubsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4055, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmsubsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4056, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfnmsubss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4053, dst.get(), src1.get(), src2.get(), src3.get()));
    }

    public void vfnmsubss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, AsmRegisterXMM src3) {
        this.addInstruction(Instruction.create(4053, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), src3.get()));
    }

    public void vfnmsubss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, AsmMemoryOperand src3) {
        this.addInstruction(Instruction.create(4054, dst.get(), src1.get(), src2.get(), src3.toMemoryOperand(this.getBitness())));
    }

    public void vfpclasspd(AsmRegisterK dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3986, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclasspd(AsmRegisterK dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3987, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclasspd(AsmRegisterK dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3988, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclasspd(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        int code;
        if (src1.isBroadcast()) {
            code = 3988;
        } else if (src1.size == 9) {
            code = 3988;
        } else if (src1.size == 8) {
            code = 3987;
        } else if (src1.size == 7) {
            code = 3986;
        } else {
            throw this.noOpCodeFoundFor(970, dst, src1, imm);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclasspdx(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3986, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclasspdy(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3987, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclasspdz(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3988, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclassph(AsmRegisterK dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(4500, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclassph(AsmRegisterK dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(4501, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclassph(AsmRegisterK dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(4502, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclassph(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        int code;
        if (src1.isBroadcast()) {
            code = 4502;
        } else if (src1.size == 9) {
            code = 4502;
        } else if (src1.size == 8) {
            code = 4501;
        } else if (src1.size == 7) {
            code = 4500;
        } else {
            throw this.noOpCodeFoundFor(1710, dst, src1, imm);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclassphx(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4500, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclassphy(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4501, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclassphz(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4502, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclassps(AsmRegisterK dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3983, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclassps(AsmRegisterK dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3984, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclassps(AsmRegisterK dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3985, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclassps(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        int code;
        if (src1.isBroadcast()) {
            code = 3985;
        } else if (src1.size == 9) {
            code = 3985;
        } else if (src1.size == 8) {
            code = 3984;
        } else if (src1.size == 7) {
            code = 3983;
        } else {
            throw this.noOpCodeFoundFor(971, dst, src1, imm);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclasspsx(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3983, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclasspsy(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3984, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclasspsz(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3985, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vfpclasssd(AsmRegisterK dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3990, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclasssd(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3990, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vfpclasssh(AsmRegisterK dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(4503, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclasssh(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4503, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vfpclassss(AsmRegisterK dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3989, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vfpclassss(AsmRegisterK dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3989, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vfrczpd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4128, dst.get(), src.get()));
    }

    public void vfrczpd(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4129, dst.get(), src.get()));
    }

    public void vfrczpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4128, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vfrczpd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4129, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vfrczps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4126, dst.get(), src.get()));
    }

    public void vfrczps(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4127, dst.get(), src.get()));
    }

    public void vfrczps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4126, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vfrczps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4127, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vfrczsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4131, dst.get(), src.get()));
    }

    public void vfrczsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4131, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vfrczss(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4130, dst.get(), src.get()));
    }

    public void vfrczss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4130, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vgatherdpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3315, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherdpd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3316, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherdpd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3317, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherdpd(AsmRegisterXMM dst, AsmMemoryOperand src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3310, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void vgatherdpd(AsmRegisterYMM dst, AsmMemoryOperand src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(3311, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void vgatherdps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3312, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherdps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3313, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherdps(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3314, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherdps(AsmRegisterXMM dst, AsmMemoryOperand src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3308, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void vgatherdps(AsmRegisterYMM dst, AsmMemoryOperand src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(3309, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void vgatherpf0dpd(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(3597, dst.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherpf0dps(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(3596, dst.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherpf0qpd(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(3605, dst.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherpf0qps(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(3604, dst.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherpf1dpd(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(3599, dst.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherpf1dps(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(3598, dst.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherpf1qpd(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(3607, dst.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherpf1qps(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(3606, dst.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherqpd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3325, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherqpd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3326, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherqpd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3327, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherqpd(AsmRegisterXMM dst, AsmMemoryOperand src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3320, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void vgatherqpd(AsmRegisterYMM dst, AsmMemoryOperand src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(3321, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void vgatherqps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code;
        if (Register.isXMM(src.index.get())) {
            code = 3322;
        } else if (Register.isYMM(src.index.get())) {
            code = 3323;
        } else {
            throw this.noOpCodeFoundFor(989, dst, src);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherqps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3324, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgatherqps(AsmRegisterXMM dst, AsmMemoryOperand src1, AsmRegisterXMM src2) {
        int code;
        if (Register.isXMM(src1.index.get())) {
            code = 3318;
        } else if (Register.isYMM(src1.index.get())) {
            code = 3319;
        } else {
            throw this.noOpCodeFoundFor(989, dst, src1, src2);
        }
        this.addInstruction(Instruction.create(code, dst.get(), src1.toMemoryOperand(this.getBitness()), src2.get()));
    }

    public void vgetexppd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3016, dst.get(), src.get()), dst.flags);
    }

    public void vgetexppd(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(3017, dst.get(), src.get()), dst.flags);
    }

    public void vgetexppd(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3018, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vgetexppd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3016, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vgetexppd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3017, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vgetexppd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3018, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vgetexpph(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4504, dst.get(), src.get()), dst.flags);
    }

    public void vgetexpph(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(4505, dst.get(), src.get()), dst.flags);
    }

    public void vgetexpph(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(4506, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vgetexpph(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4504, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vgetexpph(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4505, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vgetexpph(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4506, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vgetexpps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(3013, dst.get(), src.get()), dst.flags);
    }

    public void vgetexpps(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(3014, dst.get(), src.get()), dst.flags);
    }

    public void vgetexpps(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(3015, dst.get(), src.get()), dst.flags | src.flags);
    }

    public void vgetexpps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3013, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vgetexpps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3014, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vgetexpps(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(3015, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags | src.flags);
    }

    public void vgetexpsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3020, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vgetexpsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3020, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vgetexpsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4507, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vgetexpsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4507, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vgetexpss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3019, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vgetexpss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3019, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vgetmantpd(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3856, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vgetmantpd(AsmRegisterYMM dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3857, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vgetmantpd(AsmRegisterZMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3858, dst.get(), src1.get(), imm), dst.flags | src1.flags);
    }

    public void vgetmantpd(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3856, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vgetmantpd(AsmRegisterYMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3857, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vgetmantpd(AsmRegisterZMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3858, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vgetmantph(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(4508, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vgetmantph(AsmRegisterYMM dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(4509, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vgetmantph(AsmRegisterZMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(4510, dst.get(), src1.get(), imm), dst.flags | src1.flags);
    }

    public void vgetmantph(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4508, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vgetmantph(AsmRegisterYMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4509, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vgetmantph(AsmRegisterZMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(4510, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vgetmantps(AsmRegisterXMM dst, AsmRegisterXMM src1, int imm) {
        this.addInstruction(Instruction.create(3853, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vgetmantps(AsmRegisterYMM dst, AsmRegisterYMM src1, int imm) {
        this.addInstruction(Instruction.create(3854, dst.get(), src1.get(), imm), dst.flags);
    }

    public void vgetmantps(AsmRegisterZMM dst, AsmRegisterZMM src1, int imm) {
        this.addInstruction(Instruction.create(3855, dst.get(), src1.get(), imm), dst.flags | src1.flags);
    }

    public void vgetmantps(AsmRegisterXMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3853, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vgetmantps(AsmRegisterYMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3854, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vgetmantps(AsmRegisterZMM dst, AsmMemoryOperand src1, int imm) {
        this.addInstruction(Instruction.create(3855, dst.get(), src1.toMemoryOperand(this.getBitness()), imm), dst.flags | src1.flags);
    }

    public void vgetmantsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3860, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vgetmantsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3860, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vgetmantsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(4511, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vgetmantsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(4511, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vgetmantss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3859, dst.get(), src1.get(), src2.get(), imm), dst.flags | src2.flags);
    }

    public void vgetmantss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3859, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vgf2p8affineinvqb(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        int code = this.getInstructionPreferVex() ? 4065 : 4067;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vgf2p8affineinvqb(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        int code = this.getInstructionPreferVex() ? 4066 : 4068;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vgf2p8affineinvqb(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(4069, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vgf2p8affineinvqb(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        int code = src2.isBroadcast() ? 4067 : (this.getInstructionPreferVex() ? 4065 : 4067);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vgf2p8affineinvqb(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        int code = src2.isBroadcast() ? 4068 : (this.getInstructionPreferVex() ? 4066 : 4068);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vgf2p8affineinvqb(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(4069, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vgf2p8affineqb(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        int code = this.getInstructionPreferVex() ? 4059 : 4061;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vgf2p8affineqb(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        int code = this.getInstructionPreferVex() ? 4060 : 4062;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vgf2p8affineqb(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2, int imm) {
        this.addInstruction(Instruction.create(4063, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vgf2p8affineqb(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        int code = src2.isBroadcast() ? 4061 : (this.getInstructionPreferVex() ? 4059 : 4061);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vgf2p8affineqb(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        int code = src2.isBroadcast() ? 4062 : (this.getInstructionPreferVex() ? 4060 : 4062);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vgf2p8affineqb(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(4063, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags | src2.flags);
    }

    public void vgf2p8mulb(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 3629 : 3631;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vgf2p8mulb(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 3630 : 3632;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vgf2p8mulb(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3633, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vgf2p8mulb(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3629 : 3631;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgf2p8mulb(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 3630 : 3632;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vgf2p8mulb(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3633, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vhaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(1807, dst.get(), src1.get(), src2.get()));
    }

    public void vhaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(1808, dst.get(), src1.get(), src2.get()));
    }

    public void vhaddpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1807, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vhaddpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1808, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vhaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(1810, dst.get(), src1.get(), src2.get()));
    }

    public void vhaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(1811, dst.get(), src1.get(), src2.get()));
    }

    public void vhaddps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1810, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vhaddps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1811, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vhsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(1813, dst.get(), src1.get(), src2.get()));
    }

    public void vhsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(1814, dst.get(), src1.get(), src2.get()));
    }

    public void vhsubpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1813, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vhsubpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1814, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vhsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(1816, dst.get(), src1.get(), src2.get()));
    }

    public void vhsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(1817, dst.get(), src1.get(), src2.get()));
    }

    public void vhsubps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1816, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vhsubps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1817, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vinsertf128(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3797, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vinsertf128(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3797, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vinsertf32x4(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3798, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinsertf32x4(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3799, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinsertf32x4(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3798, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinsertf32x4(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3799, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinsertf32x8(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3807, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinsertf32x8(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3807, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinsertf64x2(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3800, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinsertf64x2(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3801, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinsertf64x2(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3800, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinsertf64x2(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3801, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinsertf64x4(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3808, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinsertf64x4(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3808, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinserti128(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3869, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vinserti128(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3869, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vinserti32x4(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3870, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinserti32x4(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3871, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinserti32x4(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3870, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinserti32x4(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3871, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinserti32x8(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3879, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinserti32x8(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3879, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinserti64x2(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3872, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinserti64x2(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3873, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinserti64x2(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3872, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinserti64x2(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3873, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinserti64x4(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3880, dst.get(), src1.get(), src2.get(), imm), dst.flags);
    }

    public void vinserti64x4(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3880, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm), dst.flags);
    }

    public void vinsertps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        int code = this.getInstructionPreferVex() ? 3835 : 3836;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vinsertps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        int code = this.getInstructionPreferVex() ? 3835 : 3836;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vlddqu(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2463, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vlddqu(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2464, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vldmxcsr(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2019, dst.toMemoryOperand(this.getBitness())));
    }

    public void vmaskmovdqu(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.createVmaskmovdqu(this.getBitness(), dst.get(), src.get()));
    }

    public void vmaskmovpd(AsmMemoryOperand dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(2860, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void vmaskmovpd(AsmMemoryOperand dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(2861, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void vmaskmovpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(2854, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vmaskmovpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(2855, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vmaskmovps(AsmMemoryOperand dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(2858, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void vmaskmovps(AsmMemoryOperand dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(2859, dst.toMemoryOperand(this.getBitness()), src1.get(), src2.get()));
    }

    public void vmaskmovps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(2846, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vmaskmovps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(2847, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vmaxpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1472 : 1474;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmaxpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1473 : 1475;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmaxpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1476, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmaxpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1474 : (this.getInstructionPreferVex() ? 1472 : 1474);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1475 : (this.getInstructionPreferVex() ? 1473 : 1475);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1476, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4512, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmaxph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4513, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmaxph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4514, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmaxph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4512, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4513, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4514, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1466 : 1468;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmaxps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1467 : 1469;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmaxps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1470, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmaxps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1468 : (this.getInstructionPreferVex() ? 1466 : 1468);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1469 : (this.getInstructionPreferVex() ? 1467 : 1469);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1470, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1481 : 1482;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmaxsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1481 : 1482;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4515, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmaxsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4515, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmaxss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1478 : 1479;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmaxss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1478 : 1479;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmcall() {
        this.addInstruction(Instruction.create(813));
    }

    public void vmclear(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2197, dst.toMemoryOperand(this.getBitness())));
    }

    public void vmfunc() {
        this.addInstruction(Instruction.create(827));
    }

    public void vmgexit() {
        this.addInstruction(Instruction.create(4222));
    }

    public void vminpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1436 : 1438;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vminpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1437 : 1439;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vminpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1440, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vminpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1438 : (this.getInstructionPreferVex() ? 1436 : 1438);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1439 : (this.getInstructionPreferVex() ? 1437 : 1439);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1440, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4516, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vminph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4517, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vminph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4518, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vminph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4516, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4517, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4518, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1430 : 1432;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vminps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1431 : 1433;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vminps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1434, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vminps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1432 : (this.getInstructionPreferVex() ? 1430 : 1432);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1433 : (this.getInstructionPreferVex() ? 1431 : 1433);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1434, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1445 : 1446;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vminsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1445 : 1446;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4519, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vminsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4519, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vminss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1442 : 1443;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vminss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1442 : 1443;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmlaunch() {
        this.addInstruction(Instruction.create(814));
    }

    public void vmload() {
        int code = this.getBitness() == 64 ? 837 : (this.getBitness() >= 32 ? 836 : 835);
        this.addInstruction(Instruction.create(code));
    }

    public void vmmcall() {
        this.addInstruction(Instruction.create(834));
    }

    public void vmovapd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1076 : 1078;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovapd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1088 : 1090;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovapd(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1077 : 1079;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovapd(AsmMemoryOperand dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1089 : 1091;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovapd(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1080, dst.get(), src.get()), dst.flags);
    }

    public void vmovapd(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1092, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovapd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1076 : 1078;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovapd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1077 : 1079;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovapd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1080, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovaps(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1070 : 1072;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovaps(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1082 : 1084;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovaps(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1071 : 1073;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovaps(AsmMemoryOperand dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1083 : 1085;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovaps(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1074, dst.get(), src.get()), dst.flags);
    }

    public void vmovaps(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1086, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovaps(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1070 : 1072;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovaps(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1071 : 1073;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovaps(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1074, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovd(AsmRegisterXMM dst, AsmRegister32 src) {
        int code = this.getInstructionPreferVex() ? 1583 : 1585;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void vmovd(AsmRegister32 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1822 : 1824;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void vmovd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1822 : 1824;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1583 : 1585;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmovddup(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 953 : 955;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovddup(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 954 : 956;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovddup(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(957, dst.get(), src.get()), dst.flags);
    }

    public void vmovddup(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 953 : 955;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovddup(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 954 : 956;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovddup(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(957, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqa(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1589, dst.get(), src.get()));
    }

    public void vmovdqa(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1831, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovdqa(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1590, dst.get(), src.get()));
    }

    public void vmovdqa(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1832, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovdqa(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1589, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmovdqa(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1590, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmovdqa32(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1591, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqa32(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1833, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqa32(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1592, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqa32(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1834, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqa32(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1593, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqa32(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1835, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqa32(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1591, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqa32(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1592, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqa32(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1593, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqa64(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1594, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqa64(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1836, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqa64(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1595, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqa64(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1837, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqa64(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1596, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqa64(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1838, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqa64(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1594, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqa64(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1595, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqa64(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1596, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1598, dst.get(), src.get()));
    }

    public void vmovdqu(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1840, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovdqu(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1599, dst.get(), src.get()));
    }

    public void vmovdqu(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1841, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovdqu(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1598, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmovdqu(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1599, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmovdqu16(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1609, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu16(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1851, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu16(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1610, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu16(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1852, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu16(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1611, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu16(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1853, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu16(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1609, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu16(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1610, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu16(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1611, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu32(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1600, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu32(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1842, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu32(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1601, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu32(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1843, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu32(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1602, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu32(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1844, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu32(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1600, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu32(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1601, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu32(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1602, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu64(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1603, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu64(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1845, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu64(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1604, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu64(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1846, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu64(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1605, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu64(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1847, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu64(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1603, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu64(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1604, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu64(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1605, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu8(AsmRegisterXMM dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1606, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu8(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1848, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu8(AsmRegisterYMM dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1607, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu8(AsmMemoryOperand dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1849, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu8(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1608, dst.get(), src.get()), dst.flags);
    }

    public void vmovdqu8(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1850, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovdqu8(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1606, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu8(AsmRegisterYMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1607, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovdqu8(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1608, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovhlps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 939 : 941;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vmovhpd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1007 : 1008;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovhpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 995 : 996;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vmovhps(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1004 : 1005;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovhps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 992 : 993;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vmovlhps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 989 : 990;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()));
    }

    public void vmovlpd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 962 : 963;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovlpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 944 : 945;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vmovlps(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 959 : 960;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovlps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 940 : 942;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())));
    }

    public void vmovmskpd(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1256, dst.get(), src.get()));
    }

    public void vmovmskpd(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1257, dst.get(), src.get()));
    }

    public void vmovmskpd(AsmRegister32 dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1258, dst.get(), src.get()));
    }

    public void vmovmskpd(AsmRegister64 dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1259, dst.get(), src.get()));
    }

    public void vmovmskps(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1250, dst.get(), src.get()));
    }

    public void vmovmskps(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(1251, dst.get(), src.get()));
    }

    public void vmovmskps(AsmRegister32 dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1252, dst.get(), src.get()));
    }

    public void vmovmskps(AsmRegister64 dst, AsmRegisterYMM src) {
        this.addInstruction(Instruction.create(1253, dst.get(), src.get()));
    }

    public void vmovntdq(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2395 : 2397;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovntdq(AsmMemoryOperand dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 2396 : 2398;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovntdq(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(2399, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovntdqa(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 2832 : 2834;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmovntdqa(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 2833 : 2835;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmovntdqa(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2836, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmovntpd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1114 : 1116;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovntpd(AsmMemoryOperand dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1115 : 1117;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovntpd(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1118, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovntps(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1108 : 1110;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovntps(AsmMemoryOperand dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 1109 : 1111;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovntps(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1112, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovq(AsmRegisterXMM dst, AsmRegister64 src) {
        int code = this.getInstructionPreferVex() ? 1584 : 1586;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void vmovq(AsmRegister64 dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1823 : 1825;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void vmovq(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 1827 : 1828;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()));
    }

    public void vmovq(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2253 : 2254;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovq(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 1827 : 1828;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmovsd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 934 : 936;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovsd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 912 : 914;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 911 : 913;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmovsh(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4521, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovsh(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4520, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4522, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmovshdup(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 998 : 1000;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovshdup(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 999 : 1001;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovshdup(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(1002, dst.get(), src.get()), dst.flags);
    }

    public void vmovshdup(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 998 : 1000;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovshdup(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 999 : 1001;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovshdup(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1002, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovsldup(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 947 : 949;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovsldup(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 948 : 950;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovsldup(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(951, dst.get(), src.get()), dst.flags);
    }

    public void vmovsldup(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 947 : 949;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovsldup(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 948 : 950;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovsldup(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(951, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovss(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 929 : 931;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovss(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 907 : 909;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 906 : 908;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmovupd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 900 : 902;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovupd(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 922 : 924;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovupd(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 901 : 903;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovupd(AsmMemoryOperand dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 923 : 925;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovupd(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(904, dst.get(), src.get()), dst.flags);
    }

    public void vmovupd(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(926, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovupd(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 900 : 902;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovupd(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 901 : 903;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovupd(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(904, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovups(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 894 : 896;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovups(AsmMemoryOperand dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 916 : 918;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovups(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 895 : 897;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vmovups(AsmMemoryOperand dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 917 : 919;
        this.addInstruction(Instruction.create(code, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovups(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(898, dst.get(), src.get()), dst.flags);
    }

    public void vmovups(AsmMemoryOperand dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(920, dst.toMemoryOperand(this.getBitness()), src.get()), dst.flags);
    }

    public void vmovups(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 894 : 896;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovups(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 895 : 897;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovups(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(898, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vmovw(AsmRegisterXMM dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(4524, dst.get(), src.get()));
    }

    public void vmovw(AsmRegisterXMM dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(4525, dst.get(), src.get()));
    }

    public void vmovw(AsmRegister32 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4526, dst.get(), src.get()));
    }

    public void vmovw(AsmRegister64 dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4527, dst.get(), src.get()));
    }

    public void vmovw(AsmMemoryOperand dst, AsmRegisterXMM src) {
        this.addInstruction(Instruction.create(4526, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmovw(AsmRegisterXMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(4524, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmpsadbw(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2, int imm) {
        this.addInstruction(Instruction.create(3901, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vmpsadbw(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2, int imm) {
        this.addInstruction(Instruction.create(3902, dst.get(), src1.get(), src2.get(), imm));
    }

    public void vmpsadbw(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3901, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vmpsadbw(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2, int imm) {
        this.addInstruction(Instruction.create(3902, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness()), imm));
    }

    public void vmptrld(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2196, dst.toMemoryOperand(this.getBitness())));
    }

    public void vmptrst(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2202, dst.toMemoryOperand(this.getBitness())));
    }

    public void vmread(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1738, dst.get(), src.get()));
    }

    public void vmread(AsmMemoryOperand dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1738, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmread(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1739, dst.get(), src.get()));
    }

    public void vmread(AsmMemoryOperand dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1739, dst.toMemoryOperand(this.getBitness()), src.get()));
    }

    public void vmresume() {
        this.addInstruction(Instruction.create(815));
    }

    public void vmrun() {
        int code = this.getBitness() == 64 ? 833 : (this.getBitness() >= 32 ? 832 : 831);
        this.addInstruction(Instruction.create(code));
    }

    public void vmsave() {
        int code = this.getBitness() == 64 ? 840 : (this.getBitness() >= 32 ? 839 : 838);
        this.addInstruction(Instruction.create(code));
    }

    public void vmulpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1361 : 1363;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmulpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1362 : 1364;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmulpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1365, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmulpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1363 : (this.getInstructionPreferVex() ? 1361 : 1363);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1364 : (this.getInstructionPreferVex() ? 1362 : 1364);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1365, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4528, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmulph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(4529, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmulph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(4530, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmulph(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4528, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulph(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4529, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulph(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4530, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1355 : 1357;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmulps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1356 : 1358;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vmulps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1359, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmulps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1357 : (this.getInstructionPreferVex() ? 1355 : 1357);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1358 : (this.getInstructionPreferVex() ? 1356 : 1358);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1359, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1370 : 1371;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmulsd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1370 : 1371;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(4531, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmulsh(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(4531, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmulss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1367 : 1368;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags | src2.flags);
    }

    public void vmulss(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = this.getInstructionPreferVex() ? 1367 : 1368;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vmwrite(AsmRegister32 dst, AsmRegister32 src) {
        this.addInstruction(Instruction.create(1758, dst.get(), src.get()));
    }

    public void vmwrite(AsmRegister64 dst, AsmRegister64 src) {
        this.addInstruction(Instruction.create(1759, dst.get(), src.get()));
    }

    public void vmwrite(AsmRegister32 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1758, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmwrite(AsmRegister64 dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(1759, dst.get(), src.toMemoryOperand(this.getBitness())));
    }

    public void vmxoff() {
        this.addInstruction(Instruction.create(816));
    }

    public void vmxon(AsmMemoryOperand dst) {
        this.addInstruction(Instruction.create(2198, dst.toMemoryOperand(this.getBitness())));
    }

    public void vorpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1319 : 1321;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vorpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1320 : 1322;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vorpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1323, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vorpd(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1321 : (this.getInstructionPreferVex() ? 1319 : 1321);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vorpd(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1322 : (this.getInstructionPreferVex() ? 1320 : 1322);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vorpd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1323, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vorps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        int code = this.getInstructionPreferVex() ? 1313 : 1315;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vorps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        int code = this.getInstructionPreferVex() ? 1314 : 1316;
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vorps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(1317, dst.get(), src1.get(), src2.get()), dst.flags);
    }

    public void vorps(AsmRegisterXMM dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1315 : (this.getInstructionPreferVex() ? 1313 : 1315);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vorps(AsmRegisterYMM dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        int code = src2.isBroadcast() ? 1316 : (this.getInstructionPreferVex() ? 1314 : 1316);
        this.addInstruction(Instruction.create(code, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vorps(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(1317, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags | src2.flags);
    }

    public void vp2intersectd(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3150, dst.get(), src1.get(), src2.get()));
    }

    public void vp2intersectd(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(3151, dst.get(), src1.get(), src2.get()));
    }

    public void vp2intersectd(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3152, dst.get(), src1.get(), src2.get()));
    }

    public void vp2intersectd(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3150, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vp2intersectd(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3151, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vp2intersectd(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3152, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vp2intersectq(AsmRegisterK dst, AsmRegisterXMM src1, AsmRegisterXMM src2) {
        this.addInstruction(Instruction.create(3153, dst.get(), src1.get(), src2.get()));
    }

    public void vp2intersectq(AsmRegisterK dst, AsmRegisterYMM src1, AsmRegisterYMM src2) {
        this.addInstruction(Instruction.create(3154, dst.get(), src1.get(), src2.get()));
    }

    public void vp2intersectq(AsmRegisterK dst, AsmRegisterZMM src1, AsmRegisterZMM src2) {
        this.addInstruction(Instruction.create(3155, dst.get(), src1.get(), src2.get()));
    }

    public void vp2intersectq(AsmRegisterK dst, AsmRegisterXMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3153, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vp2intersectq(AsmRegisterK dst, AsmRegisterYMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3154, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vp2intersectq(AsmRegisterK dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3155, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), src2.flags);
    }

    public void vp4dpwssd(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3083, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vp4dpwssds(AsmRegisterZMM dst, AsmRegisterZMM src1, AsmMemoryOperand src2) {
        this.addInstruction(Instruction.create(3087, dst.get(), src1.get(), src2.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vpabsb(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2707 : 2709;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vpabsb(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 2708 : 2710;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vpabsb(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(2711, dst.get(), src.get()), dst.flags);
    }

    public void vpabsb(AsmRegisterXMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 2707 : 2709;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vpabsb(AsmRegisterYMM dst, AsmMemoryOperand src) {
        int code = this.getInstructionPreferVex() ? 2708 : 2710;
        this.addInstruction(Instruction.create(code, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vpabsb(AsmRegisterZMM dst, AsmMemoryOperand src) {
        this.addInstruction(Instruction.create(2711, dst.get(), src.toMemoryOperand(this.getBitness())), dst.flags);
    }

    public void vpabsd(AsmRegisterXMM dst, AsmRegisterXMM src) {
        int code = this.getInstructionPreferVex() ? 2721 : 2723;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vpabsd(AsmRegisterYMM dst, AsmRegisterYMM src) {
        int code = this.getInstructionPreferVex() ? 2722 : 2724;
        this.addInstruction(Instruction.create(code, dst.get(), src.get()), dst.flags);
    }

    public void vpabsd(AsmRegisterZMM dst, AsmRegisterZMM src) {
        this.addInstruction(Instruction.create(2725, dst.get(), src.get()), dst.flags);
    }

    public void vpabsd(AsmReg