/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.asm;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Register;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;

public final class AsmRegisterZMM {
    private final ICRegister register;
    final int flags;

    public AsmRegisterZMM(ICRegister register) {
        if (!Register.isZMM(register.get())) {
            throw new IllegalArgumentException("Invalid register value. Must be a ZMM register");
        }
        this.register = register;
        this.flags = 0;
    }

    public ICRegister get() {
        return this.register;
    }

    public int getRegister() {
        return this.register.get();
    }

    public AsmRegisterZMM(ICRegister register, int flags) {
        if (!Register.isZMM(register.get())) {
            throw new IllegalArgumentException("Invalid register value. Must be a ZMM register");
        }
        this.register = register;
        this.flags = flags;
    }

    public AsmRegisterZMM k1() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFE3F | 0x40);
    }

    public AsmRegisterZMM k2() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFE3F | 0x80);
    }

    public AsmRegisterZMM k3() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFE3F | 0xC0);
    }

    public AsmRegisterZMM k4() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFE3F | 0x100);
    }

    public AsmRegisterZMM k5() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFE3F | 0x140);
    }

    public AsmRegisterZMM k6() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFE3F | 0x180);
    }

    public AsmRegisterZMM k7() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFE3F | 0x1C0);
    }

    public AsmRegisterZMM z() {
        return new AsmRegisterZMM(this.register, this.flags | 2);
    }

    public AsmRegisterZMM sae() {
        return new AsmRegisterZMM(this.register, this.flags | 4);
    }

    public AsmRegisterZMM rn_sae() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFFC7 | 8);
    }

    public AsmRegisterZMM rd_sae() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFFC7 | 0x10);
    }

    public AsmRegisterZMM ru_sae() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFFC7 | 0x18);
    }

    public AsmRegisterZMM rz_sae() {
        return new AsmRegisterZMM(this.register, this.flags & 0xFFFFFFC7 | 0x20);
    }

    public AsmMemoryOperand add(long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, this.get(), 1, displacement, 0);
    }

    public AsmMemoryOperand sub(long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, this.get(), 1, -displacement, 0);
    }

    public AsmMemoryOperand scale(int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, this.get(), scale, 0L, 0);
    }

    public AsmMemoryOperand add(AsmRegister32 base) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), this.get(), 1, 0L, 0);
    }

    public AsmMemoryOperand add(AsmRegister64 base) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), this.get(), 1, 0L, 0);
    }

    public AsmMemoryOperand add(AsmMemoryOperand mem) {
        return mem.add(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsmRegisterZMM other = (AsmRegisterZMM)obj;
        return this.register.get() == other.register.get() && this.flags == other.flags;
    }

    public int hashCode() {
        return this.register.get() * 397 ^ this.flags;
    }

    public String toString() {
        return String.format("Register %d, flags: %d", this.getRegister(), this.flags);
    }
}

