/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.asm;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Register;

public final class AsmRegisterK {
    private final ICRegister register;
    final int flags;

    public AsmRegisterK(ICRegister register) {
        if (!Register.isK(register.get())) {
            throw new IllegalArgumentException("Invalid register value. Must be a K register");
        }
        this.register = register;
        this.flags = 0;
    }

    public ICRegister get() {
        return this.register;
    }

    public int getRegister() {
        return this.register.get();
    }

    public AsmRegisterK(ICRegister register, int flags) {
        if (!Register.isK(register.get())) {
            throw new IllegalArgumentException("Invalid register value. Must be a K register");
        }
        this.register = register;
        this.flags = flags;
    }

    public AsmRegisterK k1() {
        return new AsmRegisterK(this.register, this.flags & 0xFFFFFE3F | 0x40);
    }

    public AsmRegisterK k2() {
        return new AsmRegisterK(this.register, this.flags & 0xFFFFFE3F | 0x80);
    }

    public AsmRegisterK k3() {
        return new AsmRegisterK(this.register, this.flags & 0xFFFFFE3F | 0xC0);
    }

    public AsmRegisterK k4() {
        return new AsmRegisterK(this.register, this.flags & 0xFFFFFE3F | 0x100);
    }

    public AsmRegisterK k5() {
        return new AsmRegisterK(this.register, this.flags & 0xFFFFFE3F | 0x140);
    }

    public AsmRegisterK k6() {
        return new AsmRegisterK(this.register, this.flags & 0xFFFFFE3F | 0x180);
    }

    public AsmRegisterK k7() {
        return new AsmRegisterK(this.register, this.flags & 0xFFFFFE3F | 0x1C0);
    }

    public AsmRegisterK z() {
        return new AsmRegisterK(this.register, this.flags | 2);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsmRegisterK other = (AsmRegisterK)obj;
        return this.register.get() == other.register.get() && this.flags == other.flags;
    }

    public int hashCode() {
        return this.register.get() * 397 ^ this.flags;
    }

    public String toString() {
        return String.format("Register %d, flags: %d", this.getRegister(), this.flags);
    }
}

