/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86;

public final class MemorySizeInfo {
    static final MemorySizeInfo[] infos = MemorySizeInfo.createMemorySizeInfos();
    private final int size;
    private final int elementSize;
    private final int memorySize;
    private final int elementType;
    private final boolean isSigned;
    private final boolean isBroadcast;

    private static MemorySizeInfo[] createMemorySizeInfos() {
        byte[] data = new byte[]{0, 0, 0, 1, 33, 0, 2, 66, 0, 3, 99, 0, 4, -91, 0, 5, -91, 0, 6, 8, 1, 7, 74, 1, 8, -116, 1, 9, 33, -128, 10, 66, -128, 11, 99, -128, 12, -91, -128, 13, 8, -127, 14, 74, -127, 15, -116, -127, 16, 99, 0, 17, -124, 0, 18, -58, 0, 19, 66, 0, 20, 99, 0, 21, -91, 0, 2, 67, 0, 3, 101, 0, 24, -91, 0, 25, 8, 1, 26, -124, 0, 27, -58, 0, 28, 66, -128, 29, 99, -128, 30, -91, -128, 31, -58, -128, 32, 8, -127, 33, 66, -128, 34, -25, 0, 35, 41, 1, 36, -83, 1, 37, -50, 1, 38, -17, 1, 39, -17, 1, 40, 0, 0, 41, 0, 0, 42, -58, -128, 43, -116, 1, 44, 0, 0, 45, -58, 0, 46, 107, 1, 47, -116, 1, 1, 34, 0, 9, 34, -128, 1, 35, 0, 9, 35, -128, 2, 67, 0, 10, 67, -128, 28, 67, -128, 33, 67, -128, 1, 37, 0, 9, 37, -128, 2, 69, 0, 10, 69, -128, 3, 101, 0, 11, 101, -128, 28, 69, -128, 29, 101, -128, 1, 40, 0, 9, 40, -128, 2, 72, 0, 10, 72, -128, 3, 104, 0, 11, 104, -128, 4, -88, 0, 5, -88, 0, 12, -88, -128, 28, 72, -128, 29, 104, -128, 30, -88, -128, 33, 72, -128, 54, 104, -128, 55, 104, -128, 1, 42, 0, 9, 42, -128, 2, 74, 0, 10, 74, -128, 3, 106, 0, 11, 106, -128, 4, -86, 0, 5, -86, 0, 12, -86, -128, 6, 10, 1, 13, 10, -127, 28, 74, -128, 29, 106, -128, 30, -86, -128, 32, 10, -127, 33, 74, -128, 54, 106, -128, 55, 106, -128, 1, 44, 0, 9, 44, -128, 2, 76, 0, 10, 76, -128, 3, 108, 0, 11, 108, -128, 4, -84, 0, 5, -84, 0, 12, -84, -128, 6, 12, 1, 28, 76, -128, 29, 108, -128, 30, -84, -128, 54, 108, -128, 55, 108, -128, 28, 66, -128, 3, 99, 0, 11, 99, -128, 28, 66, -128, 29, 99, -128, 10, 66, 0, 2, 66, 0, 3, 99, 0, 11, 99, -128, 4, -91, 0, 5, -91, 0, 12, -91, -128, 28, 66, -128, 29, 99, -128, 30, -91, -128, 53, 99, -128, 61, -91, -128, 60, -91, 0, 54, 99, -128, 55, 99, -128, 10, 66, 0, 2, 66, 0, 3, 99, 0, 11, 99, -128, 4, -91, 0, 5, -91, 0, 12, -91, -128, 28, 66, -128, 29, 99, -128, 30, -91, -128, 53, 99, -128, 61, -91, -128, 60, -91, 0, 54, 99, -128, 55, 99, -128, 10, 66, 0, 2, 66, 0, 3, 99, 0, 11, 99, -128, 4, -91, 0, 5, -91, 0, 12, -91, -128, 28, 66, -128, 29, 99, -128, 30, -91, -128, 54, 99, -128, 53, 99, -128, 60, -91, 0, 61, -91, -128, 55, 99, -128};
        int IS_SIGNED = Short.MIN_VALUE;
        int SIZE_MASK = 31;
        boolean SIZE_SHIFT = false;
        int ELEM_SIZE_SHIFT = 5;
        short[] sizes = new short[]{0, 1, 2, 4, 6, 8, 10, 14, 16, 28, 32, 48, 64, 94, 108, 512};
        MemorySizeInfo[] infos = new MemorySizeInfo[162];
        int i = 0;
        int j = 0;
        while (i < infos.length) {
            int elementType = data[j] & 0xFF;
            int value = (data[j + 2] & 0xFF) << 8 | data[j + 1] & 0xFF;
            short size = sizes[value >>> 0 & 0x1F];
            short elementSize = sizes[value >>> 5 & 0x1F];
            infos[i] = new MemorySizeInfo(i, size, elementSize, elementType, (value & Short.MIN_VALUE) != 0, i >= 112);
            ++i;
            j += 3;
        }
        return infos;
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    public int getSize() {
        return this.size;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public int getElementType() {
        return this.elementType;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public boolean isPacked() {
        return this.elementSize < this.size;
    }

    public int getElementCount() {
        return this.elementSize == this.size ? 1 : this.size / this.elementSize;
    }

    private MemorySizeInfo(int memorySize, int size, int elementSize, int elementType, boolean isSigned, boolean isBroadcast) {
        this.memorySize = memorySize;
        this.size = size;
        this.elementSize = elementSize;
        this.elementType = elementType;
        this.isSigned = isSigned;
        this.isBroadcast = isBroadcast;
    }
}

