/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86;

import com.github.icedland.iced.x86.ICRegister;

public final class MemoryOperand {
    public final ICRegister segmentPrefix;
    public final ICRegister base;
    public final ICRegister index;
    public final int scale;
    public final long displacement;
    public final int displSize;
    public final boolean isBroadcast;

    public MemoryOperand(ICRegister base, ICRegister index, int scale, long displacement, int displSize, boolean isBroadcast, ICRegister segmentPrefix) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        if (index == null) {
            index = ICRegister.NONE;
        }
        if (segmentPrefix == null) {
            segmentPrefix = ICRegister.NONE;
        }
        this.segmentPrefix = segmentPrefix;
        this.base = base;
        this.index = index;
        this.scale = scale;
        this.displacement = displacement;
        this.displSize = displSize;
        this.isBroadcast = isBroadcast;
    }

    public MemoryOperand(ICRegister base, ICRegister index, int scale, boolean isBroadcast, ICRegister segmentPrefix) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        if (index == null) {
            index = ICRegister.NONE;
        }
        if (segmentPrefix == null) {
            segmentPrefix = ICRegister.NONE;
        }
        this.segmentPrefix = segmentPrefix;
        this.base = base;
        this.index = index;
        this.scale = scale;
        this.displacement = 0L;
        this.displSize = 0;
        this.isBroadcast = isBroadcast;
    }

    public MemoryOperand(ICRegister base, long displacement, int displSize, boolean isBroadcast, ICRegister segmentPrefix) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        if (segmentPrefix == null) {
            segmentPrefix = ICRegister.NONE;
        }
        this.segmentPrefix = segmentPrefix;
        this.base = base;
        this.index = ICRegister.NONE;
        this.scale = 1;
        this.displacement = displacement;
        this.displSize = displSize;
        this.isBroadcast = isBroadcast;
    }

    public MemoryOperand(ICRegister index, int scale, long displacement, int displSize, boolean isBroadcast, ICRegister segmentPrefix) {
        if (index == null) {
            index = ICRegister.NONE;
        }
        if (segmentPrefix == null) {
            segmentPrefix = ICRegister.NONE;
        }
        this.segmentPrefix = segmentPrefix;
        this.base = ICRegister.NONE;
        this.index = index;
        this.scale = scale;
        this.displacement = displacement;
        this.displSize = displSize;
        this.isBroadcast = isBroadcast;
    }

    public MemoryOperand(ICRegister base, long displacement, boolean isBroadcast, ICRegister segmentPrefix) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        if (segmentPrefix == null) {
            segmentPrefix = ICRegister.NONE;
        }
        this.segmentPrefix = segmentPrefix;
        this.base = base;
        this.index = ICRegister.NONE;
        this.scale = 1;
        this.displacement = displacement;
        this.displSize = 1;
        this.isBroadcast = isBroadcast;
    }

    public MemoryOperand(ICRegister base, ICRegister index, int scale, long displacement, int displSize) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        if (index == null) {
            index = ICRegister.NONE;
        }
        this.segmentPrefix = ICRegister.NONE;
        this.base = base;
        this.index = index;
        this.scale = scale;
        this.displacement = displacement;
        this.displSize = displSize;
        this.isBroadcast = false;
    }

    public MemoryOperand(ICRegister base, ICRegister index, int scale) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        if (index == null) {
            index = ICRegister.NONE;
        }
        this.segmentPrefix = ICRegister.NONE;
        this.base = base;
        this.index = index;
        this.scale = scale;
        this.displacement = 0L;
        this.displSize = 0;
        this.isBroadcast = false;
    }

    public MemoryOperand(ICRegister base, ICRegister index) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        if (index == null) {
            index = ICRegister.NONE;
        }
        this.segmentPrefix = ICRegister.NONE;
        this.base = base;
        this.index = index;
        this.scale = 1;
        this.displacement = 0L;
        this.displSize = 0;
        this.isBroadcast = false;
    }

    public MemoryOperand(ICRegister base, long displacement, int displSize) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        this.segmentPrefix = ICRegister.NONE;
        this.base = base;
        this.index = ICRegister.NONE;
        this.scale = 1;
        this.displacement = displacement;
        this.displSize = displSize;
        this.isBroadcast = false;
    }

    public MemoryOperand(ICRegister index, int scale, long displacement, int displSize) {
        if (index == null) {
            index = ICRegister.NONE;
        }
        this.segmentPrefix = ICRegister.NONE;
        this.base = ICRegister.NONE;
        this.index = index;
        this.scale = scale;
        this.displacement = displacement;
        this.displSize = displSize;
        this.isBroadcast = false;
    }

    public MemoryOperand(ICRegister base, long displacement) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        this.segmentPrefix = ICRegister.NONE;
        this.base = base;
        this.index = ICRegister.NONE;
        this.scale = 1;
        this.displacement = displacement;
        this.displSize = 1;
        this.isBroadcast = false;
    }

    public MemoryOperand(ICRegister base) {
        if (base == null) {
            base = ICRegister.NONE;
        }
        this.segmentPrefix = ICRegister.NONE;
        this.base = base;
        this.index = ICRegister.NONE;
        this.scale = 1;
        this.displacement = 0L;
        this.displSize = 0;
        this.isBroadcast = false;
    }

    public MemoryOperand(long displacement, int displSize) {
        this.segmentPrefix = ICRegister.NONE;
        this.base = ICRegister.NONE;
        this.index = ICRegister.NONE;
        this.scale = 1;
        this.displacement = displacement;
        this.displSize = displSize;
        this.isBroadcast = false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.base.hashCode();
        result = 31 * result + this.displSize;
        result = 31 * result + Long.hashCode(this.displacement);
        result = 31 * result + this.index.hashCode();
        result = 31 * result + (this.isBroadcast ? 1231 : 1237);
        result = 31 * result + this.scale;
        result = 31 * result + this.segmentPrefix.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryOperand other = (MemoryOperand)obj;
        return this.base.equals(other.base) && this.displSize == other.displSize && this.displacement == other.displacement && this.index.equals(other.index) && this.isBroadcast == other.isBroadcast && this.scale == other.scale && this.segmentPrefix.equals(other.segmentPrefix);
    }
}

