/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.util;

import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Adler32;

public class Packer {
    protected ByteArrayOutputStream bytes;
    protected DataOutputStream out;
    protected byte[] bdata = new byte[4];
    protected ByteBuffer buffer = ByteBuffer.wrap(this.bdata);

    public void little() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void big() {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    public Packer() {
        this.bytes = new ByteArrayOutputStream(4096);
        this.out = new DataOutputStream(this.bytes);
    }

    public void pad(int x) {
        try {
            byte[] temp = new byte[x];
            this.out.write(temp, 0, x);
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public void addByte(int x) {
        try {
            byte[] temp = new byte[]{(byte)x};
            this.out.write(temp, 0, 1);
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public void addBytes(byte[] x) {
        try {
            this.out.write(x, 0, x.length);
        }
        catch (IOException ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public void addInt(int x) {
        try {
            this.buffer.clear();
            this.buffer.putInt(x);
            this.out.write(this.bdata, 0, 4);
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public void addShort(short x) {
        try {
            this.buffer.clear();
            this.buffer.putShort(x);
            this.out.write(this.bdata, 0, 2);
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public void addUShort(int x) {
        try {
            this.buffer.clear();
            this.buffer.putShort((short)x);
            this.out.write(this.bdata, 0, 2);
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public void addData(byte[] x) {
        try {
            this.addInt(x.length);
            this.out.write(x, 0, x.length);
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public void addDataVerify(byte[] x) {
        Adler32 checksum = new Adler32();
        checksum.update(x);
        try {
            this.addInt((int)checksum.getValue());
            Logger.print_stat("verify " + x.length + "b to 0x" + Integer.toString((int)checksum.getValue(), 16));
            this.out.write(x, 0, x.length);
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public void addWideString(String x) {
        try {
            x = x + '\u0000';
            this.addData(x.getBytes("UTF-16LE"));
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public void addUTF8String(String x) {
        try {
            x = x + '\u0000';
            this.addData(x.getBytes("UTF-8"));
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
    }

    public int size() {
        try {
            this.out.flush();
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
        return this.bytes.size();
    }

    public byte[] getBytes() {
        try {
            this.out.flush();
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
        }
        return this.bytes.toByteArray();
    }
}

