/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.util;

import crystalpalace.util.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.Adler32;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class CrystalUtils {
    public static boolean isWindows() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.indexOf("win") >= 0;
    }

    public static final void print_error(String message) {
        if (CrystalUtils.isWindows()) {
            System.out.println("[-] " + message);
        } else {
            System.out.println("\u001b[01;31m[-]\u001b[0m " + message);
        }
    }

    public static final void print_good(String message) {
        if (CrystalUtils.isWindows()) {
            System.out.println("[+] " + message);
        } else {
            System.out.println("\u001b[01;32m[+]\u001b[0m " + message);
        }
    }

    public static final void print_info(String message) {
        if (CrystalUtils.isWindows()) {
            System.out.println("[*] " + message);
        } else {
            System.out.println("\u001b[01;34m[*]\u001b[0m " + message);
        }
    }

    public static final void print_warn(String message) {
        if (CrystalUtils.isWindows()) {
            System.out.println("[!] " + message);
        } else {
            System.out.println("\u001b[01;33m[!]\u001b[0m " + message);
        }
    }

    public static final void print_stat(String message) {
        if (CrystalUtils.isWindows()) {
            System.out.println("[%] " + message);
        } else {
            System.out.println("\u001b[01;35m[%] " + message + "\u001b[0m");
        }
    }

    public static String toHex(long n) {
        return "0x" + Long.toHexString(n);
    }

    public static final void handleException(Throwable e) {
        System.out.println("Exception (" + Thread.currentThread().getName() + "/" + Thread.currentThread().getId() + ") " + e.getClass() + ": " + e.getMessage());
        e.printStackTrace();
    }

    public static final void reportException(Throwable e) {
        CrystalUtils.print_info("Exception (" + Thread.currentThread().getName() + "/" + Thread.currentThread().getId() + ") " + e.getClass() + ": " + e.getMessage());
    }

    public static int parseInt(String x, int failValue) {
        try {
            return Integer.parseInt(x);
        }
        catch (Exception ex) {
            return failValue;
        }
    }

    public static byte[] readBytes(InputStream in, int size) throws IOException {
        byte[] content = new byte[size];
        int read = in.read(content);
        in.close();
        return content;
    }

    public static byte[] readFromFile(String file) throws IOException {
        byte[] content = new byte[(int)new File(file).length()];
        FileInputStream in = new FileInputStream(file);
        int read = ((InputStream)in).read(content);
        ((InputStream)in).close();
        return content;
    }

    public static void writeToFile(String file, byte[] contents) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        ((OutputStream)out).write(contents);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    public static byte[] toUTF8(String content) {
        return content.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] toUTF8Z(String content) {
        content = content + '\u0000';
        return content.getBytes(StandardCharsets.UTF_8);
    }

    public static Set toSet(String text) {
        HashSet<String> temp = new HashSet<String>();
        String[] blah = text.split(",\\s*");
        for (int x = 0; x < blah.length; ++x) {
            temp.add(blah[x].trim());
        }
        return temp;
    }

    public static String readStringFromFile(String file) throws IOException {
        return new String(CrystalUtils.readFromFile(file), StandardCharsets.UTF_8);
    }

    public static String bytesToHex(byte[] temp) {
        LinkedList<String> list = new LinkedList<String>();
        for (int x = 0; x < temp.length; ++x) {
            list.add(String.format("%02x", temp[x] & 0xFF));
        }
        return String.join((CharSequence)" ", list);
    }

    public static String bytesToHex(int[] temp) {
        LinkedList<String> list = new LinkedList<String>();
        for (int x = 0; x < temp.length; ++x) {
            list.add(String.format("%02x", temp[x]));
        }
        return String.join((CharSequence)" ", list);
    }

    public static int getDWORD(byte[] val, int loc) {
        ByteBuffer off = ByteBuffer.wrap(val, loc, 4);
        off.order(ByteOrder.LITTLE_ENDIAN);
        return off.getInt();
    }

    public static void putDWORD(byte[] val, int loc, int valz) {
        ByteBuffer off = ByteBuffer.wrap(val, loc, 4);
        off.order(ByteOrder.LITTLE_ENDIAN);
        off.putInt(valz);
    }

    public static byte[] hexToBytes(String temp) throws NumberFormatException {
        if ((temp = temp.replace(" ", "")).length() % 2 != 0) {
            throw new NumberFormatException("String length not divisible by 2");
        }
        byte[] result = new byte[temp.length() / 2];
        for (int x = 0; x < result.length; ++x) {
            String hexstr = temp.substring(x * 2, x * 2 + 2);
            result[x] = (byte)Integer.parseInt(hexstr, 16);
        }
        return result;
    }

    public static byte[] rc4encrypt(byte[] key, byte[] val) throws Exception {
        long checksum = CrystalUtils.adler32checksum(val);
        Logger.print_stat("rc4encrypt: " + val.length + "b hash: 0x" + Long.toString(checksum, 16) + " - " + checksum);
        Cipher rc4 = Cipher.getInstance("ARCFOUR");
        SecretKeySpec jkey = new SecretKeySpec(key, "ARCFOUR");
        rc4.init(1, jkey);
        return rc4.doFinal(val);
    }

    public static long adler32checksum(byte[] value) {
        Adler32 checksum = new Adler32();
        checksum.update(value);
        return checksum.getValue();
    }

    public static byte[] toBytes(String x, String enc) {
        try {
            return x.getBytes(enc);
        }
        catch (Exception ex) {
            CrystalUtils.handleException(ex);
            return null;
        }
    }

    public static byte[] reverse(byte[] fwd) {
        byte[] rev = new byte[fwd.length];
        for (int x = 0; x < rev.length; ++x) {
            rev[x] = fwd[rev.length - (x + 1)];
        }
        return rev;
    }
}

