/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CommandParser {
    protected String original;
    protected String[] args = new String[0];
    protected char quotechar = (char)34;
    protected String command = "";
    protected Set options = new HashSet();

    public CommandParser(String text) {
        this.original = text;
        this.work(text);
    }

    public char getQuoteCharacter() {
        return this.quotechar;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.args;
    }

    public String getFullCommand() {
        CharSequence[] copy = new String[this.args.length + 1];
        copy[0] = this.command;
        for (int x = 0; x < this.args.length; ++x) {
            copy[x + 1] = this.args[x].indexOf(" ") == -1 ? this.args[x] : this.quotechar + this.args[x] + this.quotechar;
        }
        return String.join((CharSequence)" ", copy);
    }

    public boolean hasOptions() {
        return this.options.size() > 0;
    }

    public Set getOptions() {
        return this.options;
    }

    public void setOption(String name) {
        this.options.add(name);
    }

    public boolean isOption(String name) {
        return this.options.contains(name);
    }

    public void addToken(List tokens, String token) {
        if (token.startsWith("+") && token.indexOf(" ") == -1) {
            this.options.add(token);
        } else {
            tokens.add(token);
        }
    }

    public void work(String argz) {
        char temp;
        int x;
        this.options = new HashSet();
        LinkedList<String> tokens = new LinkedList<String>();
        StringBuffer token = new StringBuffer();
        argz = argz.trim();
        for (x = 0; x < argz.length(); ++x) {
            temp = argz.charAt(x);
            if (temp == ' ') {
                this.command = token.toString();
                token = new StringBuffer();
                break;
            }
            if (temp == ',' && x + 2 < argz.length() && argz.charAt(x + 2) == ' ') {
                this.command = token.toString();
                this.quotechar = argz.charAt(x + 1);
                token = new StringBuffer();
                x += 2;
                break;
            }
            if (temp == ',' && x + 2 == argz.length()) {
                this.command = token.toString();
                this.quotechar = argz.charAt(x + 1);
                token = new StringBuffer();
                x += 2;
                break;
            }
            token.append(temp);
        }
        if ("".equals(this.command)) {
            this.command = argz;
            return;
        }
        while (x < argz.length()) {
            temp = argz.charAt(x);
            if (temp == ' ') {
                if (token.length() > 0) {
                    this.addToken(tokens, token.toString());
                }
                token = new StringBuffer();
            } else if (temp == this.quotechar && token.length() == 0) {
                ++x;
                while (x < argz.length() && argz.charAt(x) != this.quotechar) {
                    token.append(argz.charAt(x));
                    ++x;
                }
                tokens.add(token.toString());
                token = new StringBuffer();
            } else {
                token.append(temp);
            }
            ++x;
        }
        if (token.length() > 0) {
            this.addToken(tokens, token.toString());
        }
        this.args = new String[tokens.size()];
        Iterator i = tokens.iterator();
        int z = 0;
        while (i.hasNext()) {
            this.args[z] = (String)i.next();
            ++z;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Original:   >>>" + this.original + "<<<\n");
        result.append("Command:    >>>" + this.command + "<<<\n");
        result.append("Quote Char: >>>" + this.quotechar + "<<<\n");
        result.append("Full Command: >" + this.getFullCommand() + "<<<\n");
        result.append("Options:       " + this.options + "\n");
        for (int x = 0; x < this.args.length; ++x) {
            result.append("\targ: >>>" + this.args[x] + "<<<\n");
        }
        return result.toString();
    }

    public static void main(String[] args) {
        CommandParser parser = new CommandParser(args[0]);
        System.out.println(parser.toString());
    }
}

