/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.util;

import crystalpalace.util.CrystalUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Stack;

public class ByteWalker {
    protected Stack states;
    protected ByteOrder order;
    protected byte[] data;
    protected boolean sane = true;

    public ByteWalker(byte[] data) {
        this.data = data;
        this.states = new Stack();
        this.little();
        this.pushState();
    }

    public void little() {
        this.order = ByteOrder.LITTLE_ENDIAN;
    }

    public void big() {
        this.order = ByteOrder.BIG_ENDIAN;
    }

    public boolean isSane() {
        return this.sane;
    }

    public byte[] popBytes(int length) {
        try {
            if (length == 0) {
                return new byte[0];
            }
            byte[] temp = new byte[length];
            this.getState().readFully(temp, 0, length);
            return temp;
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.print_error("Could not pop: " + length + " bytes");
            CrystalUtils.handleException(ex);
            return new byte[0];
        }
    }

    public int popByte() {
        try {
            return this.getState().read();
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.print_error("Could not pop byte");
            CrystalUtils.handleException(ex);
            return 0;
        }
    }

    public void skip(int x) {
        try {
            this.getState().skip(x);
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.print_error("Could not skip " + x + " bytes");
            CrystalUtils.handleException(ex);
        }
    }

    public boolean isComplete() {
        try {
            return this.getState().available() == 0;
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.print_error("Could not assess available bytes");
            CrystalUtils.handleException(ex);
            return false;
        }
    }

    public void Mark() {
        try {
            this.GoTo(this.data.length - this.getState().available());
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.handleException(ex);
        }
    }

    public int getPosition() {
        try {
            return this.data.length - this.getState().available();
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.handleException(ex);
            return -1;
        }
    }

    public void GoTo(int x) {
        this.pushState();
        try {
            this.getState().skip(x);
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.print_error("Could not skip " + x + " bytes as part of GoTo");
            CrystalUtils.handleException(ex);
        }
    }

    public void Return() {
        this.popState();
    }

    protected void pushState() {
        this.states.push(new DataInputStream(new ByteArrayInputStream(this.data)));
    }

    protected void popState() {
        try {
            DataInputStream in = (DataInputStream)this.states.pop();
            in.close();
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.print_error("Could not pop state");
            CrystalUtils.handleException(ex);
        }
    }

    protected DataInputStream getState() {
        return (DataInputStream)this.states.peek();
    }

    protected ByteBuffer _getBytes(int length) {
        ByteBuffer wrapper = ByteBuffer.wrap(this.popBytes(length));
        wrapper.order(this.order);
        return wrapper;
    }

    public int readShort() {
        return Short.toUnsignedInt(this._getBytes(2).getShort());
    }

    public int readInt() {
        return this._getBytes(4).getInt();
    }

    public long readLong() {
        return this._getBytes(8).getLong();
    }

    public byte[] getBytes(int length) {
        return this.popBytes(length);
    }

    public String readStringA(int length) {
        try {
            int len;
            byte[] data = this.popBytes(length);
            for (len = 0; len < data.length && data[len] != 0; ++len) {
            }
            return new String(data, 0, len, "UTF-8");
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.print_error("Could not read string " + length + " bytes");
            CrystalUtils.handleException(ex);
            return "";
        }
    }

    public String readStringA() {
        try {
            this.Mark();
            int x = 0;
            while (this.popByte() != 0) {
                ++x;
            }
            this.Return();
            return this.readStringA(x);
        }
        catch (Exception ex) {
            this.sane = false;
            CrystalUtils.print_error("Could not read ASCIIZ string");
            CrystalUtils.handleException(ex);
            return "";
        }
    }
}

