/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.spec.SpecObject;
import crystalpalace.spec.SpecProgram;
import java.io.File;
import java.util.Stack;

public class SpecProgramException
extends Exception {
    protected SpecProgram program;
    protected String message;

    public SpecProgramException(SpecProgram program, String message) {
        this.program = program;
        this.message = message;
    }

    public String getCommand() {
        return this.program.getLastCommand();
    }

    public SpecObject getArgument() {
        return this.program.getLastArgument();
    }

    public Stack getStack() {
        return this.program.getStack();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getTarget() {
        return this.program.getLastTarget();
    }

    public String getFile() {
        return this.program.getFile();
    }

    public String getFileName() {
        return new File(this.program.getFile()).getName();
    }

    @Override
    public String toString() {
        StringBuffer temp = new StringBuffer();
        temp.append(this.getMessage() + " in " + this.getFileName() + " (" + this.getTarget() + ")\n");
        temp.append("Last command:  " + this.getCommand() + "\n");
        if (this.getArgument() != null) {
            temp.append("Last argument: " + this.getArgument() + "\n");
        } else {
            temp.append("Last argument: [null]\n");
        }
        temp.append("Stack:         " + this.getStack() + "\n");
        return temp.toString();
    }
}

