/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFParser;
import crystalpalace.export.ExportObject;
import crystalpalace.pe.PEObjectSimple;
import crystalpalace.spec.LinkSpec;
import crystalpalace.spec.SpecObject;
import crystalpalace.spec.SpecParseException;
import crystalpalace.spec.SpecProgramException;
import crystalpalace.util.CommandParser;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Packer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SpecProgram {
    protected Map directives = new HashMap();
    protected Stack state = new Stack();
    protected String parent = ".";
    protected String name = "";
    protected String last = "";
    protected SpecObject larg = null;
    protected String ltarg = null;
    protected String ltarch = null;

    public void reset() {
        this.state = new Stack();
        this.last = "";
        this.larg = null;
        this.ltarg = null;
    }

    public SpecProgram(String parent) {
        this.parent = parent;
        this.name = new File(parent).getName();
    }

    public String getFile() {
        return this.parent;
    }

    public String getLastTarget() {
        return this.ltarg;
    }

    public SpecObject getLastArgument() {
        return this.larg;
    }

    public String getLastCommand() {
        return this.last;
    }

    public Stack getStack() {
        return this.state;
    }

    public boolean targets(String arch) {
        return this.getInstructionsForLabel(arch).size() > 0;
    }

    public List getInstructionsForLabel(String label) {
        if (!this.directives.containsKey(label)) {
            this.directives.put(label, new LinkedList());
        }
        return (LinkedList)this.directives.get(label);
    }

    protected void push(byte[] b, String source) {
        this.state.push(new SpecObject(this, b, source));
        this.larg = null;
    }

    protected void push(ExportObject o, String source) {
        this.state.push(new SpecObject(this, o, source));
        this.larg = null;
    }

    protected void push(SpecObject obj) {
        this.state.push(obj);
        this.larg = null;
    }

    protected SpecObject pop() throws SpecProgramException {
        if (this.state.empty()) {
            throw new SpecProgramException(this, "POP - stack is empty");
        }
        this.larg = (SpecObject)this.state.pop();
        return this.larg;
    }

    public byte[] runDll(Map env) throws SpecProgramException, SpecParseException {
        byte[] dll = this.getFromEnv(env, "$DLL");
        PEObjectSimple obj = new PEObjectSimple(dll);
        String label = obj.getMachine() + ".dll";
        String arch = obj.getMachine();
        return this.run(label, arch, env);
    }

    public byte[] runObject(Map env) throws SpecProgramException, SpecParseException {
        byte[] object = this.getFromEnv(env, "$OBJECT");
        COFFObject coff = null;
        try {
            coff = new COFFParser().parse(object).getObject();
        }
        catch (RuntimeException rex) {
            throw new RuntimeException("Invalid Object: " + rex.getMessage());
        }
        String label = coff.getMachine() + ".o";
        String arch = coff.getMachine();
        return this.run(label, arch, env);
    }

    public void _run(String label, String arch, Map env) throws SpecProgramException, SpecParseException {
        if (!this.targets(label) && !this.targets(arch)) {
            throw new SpecProgramException(this, "Spec does not have target for '" + label + "' or '" + arch + "'");
        }
        List inst = this.getInstructionsForLabel(this.targets(label) ? label : arch);
        this.ltarg = label;
        this.ltarch = arch;
        for (CommandParser command : inst) {
            Packer pack;
            byte[] data;
            byte[] key;
            byte[] val;
            String var;
            String symbol;
            SpecObject obj;
            SpecObject obj2;
            File temp;
            SpecObject obj3;
            File temp2;
            String[] args = command.getArguments();
            this.last = command.getOriginal();
            if ("load".equals(command.getCommand()) && args.length == 1) {
                try {
                    temp2 = this.getFileFromArg(args[0]);
                    this.push(CrystalUtils.readFromFile(temp2.getPath()), temp2.getName());
                    continue;
                }
                catch (IOException ioex) {
                    throw new SpecProgramException(this, ioex.getMessage());
                }
            }
            if ("load".equals(command.getCommand()) && args.length == 2) {
                try {
                    temp2 = this.getFileFromArg(args[1]);
                    this.putEnv(env, args[0], CrystalUtils.readFromFile(temp2.getPath()));
                    continue;
                }
                catch (IOException ioex) {
                    throw new SpecProgramException(this, ioex.getMessage());
                }
            }
            if ("mergelib".equals(command.getCommand())) {
                try {
                    temp2 = this.getFileFromArg(args[0]);
                    ZipFile zip = new ZipFile(temp2);
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    LinkedList<COFFObject> coffs = new LinkedList<COFFObject>();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        InputStream is = zip.getInputStream(entry);
                        byte[] data2 = CrystalUtils.readBytes(is, (int)entry.getSize());
                        this.push(data2, entry.getName());
                        SpecObject arg = this.pop();
                        coffs.add(this.createCOFF(arg));
                    }
                    SpecObject obj4 = this.pop();
                    obj4.getObject().merge(coffs);
                    this.push(obj4);
                    continue;
                }
                catch (RuntimeException rtx) {
                    throw new SpecProgramException(this, rtx.getMessage());
                }
                catch (IOException ioex) {
                    throw new SpecProgramException(this, ioex.getMessage());
                }
            }
            if ("run".equals(command.getCommand())) {
                try {
                    temp2 = this.getFileFromArg(args[0]);
                    LinkSpec spec = LinkSpec.Parse(temp2.getPath());
                    spec.program.state = this.state;
                    spec.program._run(label, arch, env);
                    continue;
                }
                catch (IOException ioex) {
                    throw new SpecProgramException(this, ioex.getMessage());
                }
            }
            if ("coffparse".equals(command.getCommand())) {
                obj3 = this.pop();
                try {
                    temp = this.getOutFileFromArg(args[0]);
                    obj3.getObject().coffparse(temp);
                }
                catch (IOException ioex) {
                    throw new SpecProgramException(this, ioex.getMessage());
                }
                this.push(obj3);
                continue;
            }
            if ("disassemble".equals(command.getCommand())) {
                obj3 = this.pop();
                try {
                    temp = this.getOutFileFromArg(args[0]);
                    obj3.getObject().disassemble(temp);
                }
                catch (IOException ioex) {
                    throw new SpecProgramException(this, ioex.getMessage());
                }
                this.push(obj3);
                continue;
            }
            if ("link".equals(command.getCommand())) {
                byte[] value = this.pop().getBytes();
                obj2 = this.pop();
                try {
                    obj2.getObject().link(args[0], value);
                }
                catch (RuntimeException rex) {
                    this.handleException(rex);
                }
                this.push(obj2);
                continue;
            }
            if ("export".equals(command.getCommand())) {
                obj3 = this.pop();
                ExportObject eobj = obj3.getObject();
                try {
                    this.push(eobj.export(), obj3.getSource());
                }
                catch (RuntimeException rex) {
                    this.handleException(rex);
                }
                continue;
            }
            if ("make".equals(command.getCommand())) {
                if (!"x64".equals(arch) && "make pic64".equals(command.getFullCommand())) {
                    throw new SpecProgramException(this, "make pic64 is x64-only");
                }
                obj3 = this.pop();
                try {
                    ExportObject exp = new ExportObject(this.createCOFF(obj3), args[0], command.getOptions());
                    this.push(exp, obj3.getSource());
                }
                catch (RuntimeException rex) {
                    this.handleException(rex);
                }
                continue;
            }
            if ("merge".equals(command.getCommand())) {
                try {
                    SpecObject arg = this.pop();
                    COFFObject coff = this.createCOFF(arg);
                    obj = this.pop();
                    obj.getObject().merge(coff);
                    this.push(obj);
                }
                catch (RuntimeException rex) {
                    this.handleException(rex);
                }
                continue;
            }
            if ("reladdr".equals(command.getCommand())) {
                obj3 = this.pop();
                symbol = args[0];
                if (!"x86".equals(arch) || !obj3.getObject().isPIC()) {
                    throw new SpecProgramException(this, "reladdr [_symbol] is x86 PIC-only");
                }
                if (obj3.getObject().hasX86Retaddr()) {
                    throw new SpecProgramException(this, "reladdr [_symbol] has no meaning when fixptrs is set. The reladdr command creates an allow list of symbols to populate with partial pointers--forcing an error for any symbols not in this list. It's purpose is to make sure you're aware of which x86 symbols have partial pointers and require special care. With fixptrs your x86 symbol references are transparently fixed--negating the need for this command. How to fix: remove the reladdr command.");
                }
                obj3.getObject().useRelativeAddress(symbol);
                this.push(obj3);
                continue;
            }
            if ("fixptrs".equals(command.getCommand())) {
                obj3 = this.pop();
                symbol = args[0];
                if (!"x86".equals(arch) || !obj3.getObject().isPIC()) {
                    throw new SpecProgramException(this, "fixptrs [_symbol] is x86 PIC-only");
                }
                if (obj3.getObject().hasRelativeAddressSymbols()) {
                    throw new SpecProgramException(this, "reladdr [_symbol] has no meaning when fixptrs is set. The reladdr command creates an allow list of symbols to populate with partial pointers--forcing an error for any symbols not in this list. It's purpose is to make sure you're aware of which x86 symbols have partial pointers and require special care. With fixptrs your x86 symbol references are transparently fixed--negating the need for this command. How to fix: remove the reladdr command.");
                }
                try {
                    obj3.getObject().fixX86References(symbol);
                }
                catch (RuntimeException rex) {
                    throw new SpecProgramException(this, rex.getMessage());
                }
                this.push(obj3);
                continue;
            }
            if ("fixbss".equals(command.getCommand())) {
                obj3 = this.pop();
                symbol = args[0];
                if (!obj3.getObject().isPIC()) {
                    throw new SpecProgramException(this, "fixbss [symbol] is PIC-only");
                }
                try {
                    obj3.getObject().fixBSSReferences(symbol);
                }
                catch (RuntimeException rex) {
                    throw new SpecProgramException(this, rex.getMessage());
                }
                this.push(obj3);
                continue;
            }
            if ("dfr".equals(command.getCommand())) {
                obj3 = this.pop();
                symbol = args[0];
                if (!obj3.getObject().isPIC()) {
                    throw new SpecProgramException(this, "dfr [symbol] [method] <modules> is PIC-only");
                }
                try {
                    if (args.length == 3) {
                        obj3.getObject().getResolvers().addResolver(symbol, args[1], args[2]);
                    } else {
                        obj3.getObject().getResolvers().setDefaultResolver(symbol, args[1]);
                    }
                }
                catch (RuntimeException rex) {
                    throw new SpecProgramException(this, rex.getMessage());
                }
                this.push(obj3);
                continue;
            }
            if ("remap".equals(command.getCommand())) {
                obj3 = this.pop();
                try {
                    obj3.getObject().remap(args[0], args[1]);
                }
                catch (RuntimeException rex) {
                    throw new SpecProgramException(this, rex.getMessage());
                }
                this.push(obj3);
                continue;
            }
            if ("generate".equals(command.getCommand())) {
                var = args[0];
                int len = CrystalUtils.parseInt(args[1], 0);
                if (len < 0) {
                    throw new SpecProgramException(this, "Nice try, we can't generate a negative size byte array");
                }
                val = new byte[len];
                try {
                    SecureRandom rng = SecureRandom.getInstanceStrong();
                    rng.nextBytes(val);
                }
                catch (Exception ex) {
                    throw new SpecProgramException(this, ex.getMessage());
                }
                this.putEnv(env, var, val);
                continue;
            }
            if ("patch".equals(command.getCommand())) {
                var = args[1];
                String sym = args[0];
                obj = this.pop();
                if ("x86".equals(arch) && obj.getObject().isPIC() && !obj.getObject().hasX86Retaddr()) {
                    throw new SpecProgramException(this, "x86 PIC requires fixptrs is set to use patch");
                }
                try {
                    obj.getObject().patch(sym, this.getFromEnv(env, var));
                }
                catch (RuntimeException rex) {
                    this.handleException(rex);
                }
                this.push(obj);
                continue;
            }
            if ("import".equals(command.getCommand())) {
                String funcs = args[0];
                obj2 = this.pop();
                if ("object".equals(obj2.getObject().getType())) {
                    try {
                        obj2.getObject().setAPI(funcs);
                    }
                    catch (RuntimeException rex) {
                        this.handleException(rex);
                    }
                } else {
                    throw new SpecProgramException(this, "Argument is not a PICO (COFF) - can't import functions to it");
                }
                this.push(obj2);
                continue;
            }
            if ("xor".equals(command.getCommand())) {
                obj3 = this.pop();
                key = this.getFromEnv(env, args[0]);
                val = obj3.getBytes();
                for (int x = 0; x < val.length; ++x) {
                    int n = x;
                    val[n] = (byte)(val[n] ^ key[x % key.length]);
                }
                this.push(val, obj3.getSource());
                continue;
            }
            if ("rc4".equals(command.getCommand())) {
                obj3 = this.pop();
                key = this.getFromEnv(env, args[0]);
                val = obj3.getBytes();
                try {
                    val = CrystalUtils.rc4encrypt(key, val);
                }
                catch (Exception ex) {
                    throw new SpecProgramException(this, ex.getMessage());
                }
                this.push(val, obj3.getSource());
                continue;
            }
            if ("preplen".equals(command.getCommand())) {
                obj3 = this.pop();
                data = obj3.getBytes();
                pack = new Packer();
                pack.little();
                pack.addData(data);
                this.push(pack.getBytes(), obj3.getSource());
                continue;
            }
            if ("prepsum".equals(command.getCommand())) {
                obj3 = this.pop();
                data = obj3.getBytes();
                pack = new Packer();
                pack.little();
                pack.addDataVerify(data);
                this.push(pack.getBytes(), obj3.getSource());
                continue;
            }
            if ("push".equals(command.getCommand())) {
                this.push(this.getFromEnv(env, args[0]), args[0]);
                continue;
            }
            throw new SpecProgramException(this, "This is a bug? Did not process '" + command.getOriginal() + "'");
        }
    }

    public byte[] run(String label, String arch, Map env) throws SpecProgramException, SpecParseException {
        this._run(label, arch, env);
        if (this.state.empty()) {
            throw new SpecProgramException(this, "Stack is empty. Where's the bytes I want to return?");
        }
        SpecObject obj = this.pop();
        if (!this.state.empty()) {
            throw new SpecProgramException(this, "Stack is not empty. Make sure all objects are processed");
        }
        return obj.getBytes();
    }

    public void handleException(RuntimeException rex) throws SpecProgramException {
        if (rex.getClass() != RuntimeException.class) {
            CrystalUtils.handleException(rex);
            throw new SpecProgramException(this, rex.getClass().getName() + ": " + rex.getMessage());
        }
        throw new SpecProgramException(this, rex.getMessage());
    }

    public COFFObject createCOFF(SpecObject obj) throws SpecProgramException {
        COFFParser parser = new COFFParser();
        try {
            parser.parse(obj.getBytes());
        }
        catch (RuntimeException rex) {
            this.handleException(rex);
        }
        if (!this.ltarch.equals(parser.getObject().getMachine())) {
            throw new SpecProgramException(this, parser.getObject().getMachine() + " COFF arch differs from " + this.ltarg + " .spec target");
        }
        return parser.getObject();
    }

    public File getFileFromArg(String arg) throws SpecProgramException {
        File temp = new File(new File(this.parent).getParent(), arg);
        if (!temp.exists()) {
            throw new SpecProgramException(this, "File does not exist " + temp.getPath());
        }
        if (temp.isDirectory()) {
            throw new SpecProgramException(this, "File is a folder " + temp.getPath());
        }
        if (!temp.canRead()) {
            throw new SpecProgramException(this, "File is not readable " + temp.getPath());
        }
        return temp;
    }

    public File getOutFileFromArg(String arg) throws SpecProgramException {
        File temp = new File(".", arg);
        if (temp.isDirectory()) {
            throw new SpecProgramException(this, "Out file is a folder " + temp.getPath());
        }
        if (temp.exists() && !temp.canWrite()) {
            throw new SpecProgramException(this, "Out file is not writable " + temp.getPath());
        }
        return temp;
    }

    public void putEnv(Map env, String key, byte[] data) throws SpecProgramException {
        if (env.containsKey(key)) {
            throw new SpecProgramException(this, key + " is already present in environment. Can't overwrite");
        }
        env.put(key, data);
    }

    public byte[] getFromEnv(Map env, String key) throws SpecProgramException {
        if (env.containsKey(key)) {
            Object temp = env.get(key);
            if (temp.getClass().isArray() && temp.getClass().getComponentType() == Byte.TYPE) {
                return (byte[])temp;
            }
            throw new SpecProgramException(this, "Var " + key + " is not a byte[]");
        }
        throw new SpecProgramException(this, "Var " + key + " is not set");
    }
}

