/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.export.ExportObject;
import crystalpalace.spec.SpecProgram;
import crystalpalace.spec.SpecProgramException;

public class SpecObject {
    public static final int BYTES = 0;
    public static final int OBJECT = 1;
    protected Object value;
    protected SpecProgram owner;
    protected int type;
    protected String source;

    public SpecObject(SpecProgram owner, byte[] b, String source) {
        this.value = b;
        this.type = 0;
        this.owner = owner;
        this.source = source;
    }

    public SpecObject(SpecProgram owner, ExportObject obj, String source) {
        this.value = obj;
        this.type = 1;
        this.owner = owner;
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public byte[] getBytes() throws SpecProgramException {
        if (this.type == 0) {
            return (byte[])this.value;
        }
        throw new SpecProgramException(this.owner, "POP expected BYTES, received " + this.toString());
    }

    public ExportObject getObject() throws SpecProgramException {
        if (this.type == 1) {
            return (ExportObject)this.value;
        }
        throw new SpecProgramException(this.owner, "POP expected OBJECT, received " + this.toString());
    }

    public String toString() {
        if (this.type == 0) {
            return this.source + " as byte[" + ((byte[])this.value).length + "]";
        }
        return this.source + " as " + this.value.getClass().getSimpleName();
    }
}

