/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.spec.SpecParseException;
import crystalpalace.spec.SpecParser;
import crystalpalace.spec.SpecProgram;
import crystalpalace.spec.SpecProgramException;
import crystalpalace.util.ByteWalker;
import crystalpalace.util.CrystalUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class LinkSpec {
    protected String parent = ".";
    protected String author = "";
    protected String name = "";
    protected String description = "";
    protected SpecProgram program;

    public String getFile() {
        return this.parent;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean targets(String arch) {
        return this.program.targets(arch);
    }

    protected LinkSpec(SpecParser parser, String parent) {
        this.parent = parent;
        this.name = new File(parent).getName();
        if ("loader.spec".equals(this.name)) {
            this.name = new File(parent).getParentFile().getName();
        }
        this.program = new SpecProgram(parent);
    }

    public byte[] run(byte[] capability, Map vars) throws SpecParseException, SpecProgramException {
        ByteWalker peek = new ByteWalker(capability);
        int magic = peek.readShort();
        if (magic == 23117) {
            return this.runDll(capability, vars);
        }
        if (magic == 34404 || magic == 332) {
            return this.runObject(capability, vars);
        }
        throw new RuntimeException("Argument is not a COFF or DLL.");
    }

    public byte[] runDll(byte[] dll_arg, Map vars) throws SpecParseException, SpecProgramException {
        HashMap<String, byte[]> env = new HashMap<String, byte[]>();
        if (vars != null) {
            env.putAll(vars);
        }
        env.put("$DLL", dll_arg);
        this.program.reset();
        return this.program.runDll(env);
    }

    public byte[] runObject(byte[] object_arg, Map vars) throws SpecParseException, SpecProgramException {
        HashMap<String, byte[]> env = new HashMap<String, byte[]>();
        if (vars != null) {
            env.putAll(vars);
        }
        env.put("$OBJECT", object_arg);
        this.program.reset();
        return this.program.runObject(env);
    }

    public byte[] buildPic(String arch, Map vars) throws SpecParseException, SpecProgramException {
        HashMap env = new HashMap();
        if (vars != null) {
            env.putAll(vars);
        }
        return this.program.run(arch, arch, env);
    }

    public static LinkSpec Parse(String parent, String content) throws SpecParseException {
        SpecParser parser = new SpecParser();
        parser.parse(content, parent);
        if (parser.getErrors().size() > 0) {
            throw new SpecParseException(parser, parent);
        }
        return parser.getSpec();
    }

    public static LinkSpec Parse(String parent) throws SpecParseException, IOException {
        return LinkSpec.Parse(parent, CrystalUtils.readStringFromFile(parent));
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            CrystalUtils.print_error("Please use ./link or ./piclink");
            return;
        }
        String command = args[0];
        if (!"run".equals(command) && !"buildPic".equals(command)) {
            CrystalUtils.print_error("Unrecognized verb '" + command + "'");
            return;
        }
        if (args.length < 4) {
            if ("run".equals(command)) {
                CrystalUtils.print_error("./link [/path/to/loader.spec] [/path/to/file.dll|file.o] [out.bin] <A=...> <B=...>\n\tApply the specified .spec file to build a PIC DLL or COFF loader for file\n\n\tYou may also specify (optional) VARIABLES on the command-line too.\n\n\tFor example:\n\n\tA=04030201 places { 0x04, 0x03, 0x02, 0x01 } into $A.\n\n\tTake care with the native byte order when specifying ints/longs/pointers");
            } else if ("buildPic".equals(command)) {
                CrystalUtils.print_error("./piclink [/path/to/loader.spec] [x86|x64] [out.bin] <A=...> <B=...>\n\tRun the specified .spec file to assemble a PIC program\n\n\tYou may also specify (optional) VARIABLES on the command-line too.\n\n\tFor example:\n\n\tA=04030201 places { 0x04, 0x03, 0x02, 0x01 } into $A.\n\n\tTake care with the native byte order when specifying ints/longs/pointers");
            }
            return;
        }
        HashMap<String, byte[]> env = new HashMap<String, byte[]>();
        for (int x = 4; x < args.length; ++x) {
            String[] split = args[x].split("=");
            if (split.length != 2) {
                CrystalUtils.print_error("Argument " + args[x] + " is not KEY=######## format.");
                return;
            }
            if (split[0].startsWith("$")) {
                CrystalUtils.print_error("Do not specify $ for " + split[0] + ". I'll add '$' for you");
                return;
            }
            try {
                byte[] temp = CrystalUtils.hexToBytes(split[1]);
                env.put("$" + split[0], temp);
                continue;
            }
            catch (Exception ex) {
                CrystalUtils.print_error("Could not convert " + split[1] + " to byte[]: " + ex.getMessage());
                return;
            }
        }
        try {
            LinkSpec spec;
            if ("run".equals(command)) {
                byte[] file = CrystalUtils.readFromFile(args[2]);
                spec = LinkSpec.Parse(args[1]);
                CrystalUtils.writeToFile(args[3], spec.run(file, env));
            } else if ("buildPic".equals(command)) {
                String arch = args[2];
                spec = LinkSpec.Parse(args[1]);
                CrystalUtils.writeToFile(args[3], spec.buildPic(arch, env));
            }
        }
        catch (SpecParseException specex) {
            CrystalUtils.print_error(specex.toString());
        }
        catch (SpecProgramException progex) {
            CrystalUtils.print_error(progex.toString());
        }
        catch (IOException ex) {
            CrystalUtils.reportException(ex);
        }
    }
}

