/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.pe;

import crystalpalace.util.ByteWalker;
import crystalpalace.util.CrystalUtils;

public class PEObjectSimple {
    protected int Machine;
    protected boolean valid = true;
    protected String lastError = "";

    public PEObjectSimple(byte[] data) {
        this(new ByteWalker(data));
    }

    public PEObjectSimple(ByteWalker walker) {
        int Magic = walker.readShort();
        if (Magic != 23117) {
            throw new RuntimeException("Invalid DLL: File header is not 'MZ'");
        }
        walker.skip(58);
        long e_lfanew = walker.readInt();
        walker.GoTo((int)e_lfanew);
        long pe_signature = walker.readInt();
        if (pe_signature != 17744L) {
            throw new RuntimeException("Invalid DLL: PE signature is not 'PE'\\x00\\x00");
        }
        this.Machine = walker.readShort();
        walker.Return();
    }

    public String getMachine() {
        switch (this.Machine) {
            case 34404: {
                return "x64";
            }
            case 332: {
                return "x86";
            }
            case 43620: {
                return "arm64";
            }
        }
        return "Unknown " + CrystalUtils.toHex(this.Machine);
    }

    public String toString() {
        return this.getMachine() + " PE";
    }
}

