/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.merge;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class COFFList {
    protected List objects = new LinkedList();
    protected Map groups = new LinkedHashMap();
    protected Map symbols = new HashMap();

    public List getGroup(String name) {
        if (!this.groups.containsKey(name)) {
            this.groups.put(name, new LinkedList());
        }
        return (LinkedList)this.groups.get(name);
    }

    public Map getGroups() {
        return this.groups;
    }

    public COFFList() {
        this.getGroup(".text");
        this.getGroup(".rdata");
        this.getGroup(".data");
        this.getGroup(".bss");
    }

    public void add(COFFObject o) {
        for (Symbol _symbol : o.getSymbols().values()) {
            if (_symbol.isUndefinedSection() || !_symbol.isExternal()) continue;
            if (this.symbols.containsKey(_symbol.getName())) {
                throw new RuntimeException("Merge failed. Duplicate symbol " + _symbol.getName());
            }
            this.symbols.put(_symbol.getName(), _symbol);
        }
        this.objects.add(o);
    }

    public void walk(Section s, Set seen) {
        if (seen.contains(s)) {
            return;
        }
        seen.add(s);
        this.getGroup(s.getGroupName()).add(s);
        for (Relocation r : s.getRelocations()) {
            if (this.symbols.containsKey(r.getSymbolName())) {
                this.walk(((Symbol)this.symbols.get(r.getSymbolName())).getSection(), seen);
                continue;
            }
            if (r.getRemoteSection() == null) continue;
            this.walk(r.getRemoteSection(), seen);
        }
    }

    public void walkGroup(String n, HashSet seen) {
        for (COFFObject obj : this.objects) {
            for (Section sect : obj.getSections().values()) {
                if (".rdata$zzz".equals(sect.getName()) || !n.equals(sect.getGroupName())) continue;
                this.walk(sect, seen);
            }
        }
    }

    public void finish() {
        HashSet seen = new HashSet();
        this.walkGroup(".text", seen);
        this.walkGroup(".rdata", seen);
        this.walkGroup(".data", seen);
        this.walkGroup(".bss", seen);
    }
}

