/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.util.Concat;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SectionContainer {
    protected Concat data = new Concat();
    protected Map offs = new LinkedHashMap();
    protected List sections = new LinkedList();
    protected int slack = 0;

    public void add(Section s, boolean alignit) {
        if (this.slack > 0) {
            throw new RuntimeException("Can't add section " + s.getName() + " after an empty .bss section. Offsets will break!");
        }
        this.sections.add(s);
        this.offs.put(s, this.length());
        this.data.add(alignit ? s.getData() : s.getRawData());
    }

    public void addEmpty(Section s, boolean alignit) {
        this.sections.add(s);
        this.offs.put(s, this.length());
        this.slack += alignit ? s.getData().length : s.getRawData().length;
    }

    public List getRelocations() {
        LinkedList<Relocation> results = new LinkedList<Relocation>();
        for (Section sect : this.sections) {
            for (Relocation _reloc : sect.getRelocations()) {
                results.add(_reloc);
            }
        }
        return results;
    }

    public List getSymbols() {
        LinkedList<Symbol> results = new LinkedList<Symbol>();
        for (Section sect : this.sections) {
            for (Symbol _symbol : sect.getSymbols()) {
                results.add(_symbol);
            }
        }
        return results;
    }

    public Symbol getSymbol(String name) {
        for (Symbol symb : this.getSymbols()) {
            if (!name.equals(symb.getName())) continue;
            return symb;
        }
        return null;
    }

    public boolean hasOffset(Section s) {
        return this.offs.containsKey(s);
    }

    public int getBase(Relocation r) {
        return this.getBase(r.getSection());
    }

    public int getBase(Symbol s) {
        return this.getBase(s.getSection());
    }

    public int getBase(Section sect) {
        return (Integer)this.offs.get(sect);
    }

    public byte[] getRawData() {
        return this.data.get();
    }

    public int length() {
        return this.data.length() + this.slack;
    }
}

