/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.SectionData;
import crystalpalace.export.BuildPICO;
import crystalpalace.export.ExportObject;
import crystalpalace.export.ParseImport;
import crystalpalace.export.SectionContainer;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProgramPICO {
    protected ExportObject object;
    protected SectionContainer program;
    protected SectionContainer content;
    protected Imports imports;
    protected List patchups;

    public ProgramPICO(ExportObject object) {
        this.object = object;
        this.program = new SectionContainer();
        this.content = new SectionContainer();
        this.imports = new Imports();
        this.patchups = new LinkedList();
    }

    protected void processRelocation(Relocation r, byte[] rawdata) {
        PatchUp patch = new PatchUp(this.program, r);
        if (!patch.isValid()) {
            throw new RuntimeException("Can't process relocation for " + r.toSimpleString());
        }
        if (r.is_x64_rel32()) {
            long reladdress = (long)patch.getOffset() - (r.getVirtualAddress() + (long)r.getFromOffset());
            int offset = r.getOffsetAsLong() + (int)r.getSymbol().getValue();
            CrystalUtils.putDWORD(rawdata, patch.getVirtualAddress(), (int)reladdress + offset);
            if (!patch.isColocated(this.program)) {
                this.patchups.add(patch);
            }
        } else if (r.is("x86", 6)) {
            long offsetSymbolFromBase = patch.getOffset();
            int offsetDataFromSymbol = r.getOffsetAsLong() + (int)r.getSymbol().getValue();
            Logger.println("Symbol " + r.getSymbolName() + " from base? " + offsetSymbolFromBase + ", data from symbol? " + offsetDataFromSymbol);
            CrystalUtils.putDWORD(rawdata, patch.getVirtualAddress(), (int)offsetSymbolFromBase + offsetDataFromSymbol);
            this.patchups.add(patch);
        } else {
            throw new RuntimeException("Can't offline process relocation " + r);
        }
    }

    protected void processDataRelocation(Relocation r, byte[] rawdata) {
        PatchUp patch = new PatchUp(this.content, r);
        if (!patch.isValid()) {
            throw new RuntimeException("Can't process data relocation for " + r.toSimpleString());
        }
        if (".text".equals(r.getSymbol().getName())) {
            throw new RuntimeException(r.getSection().getName() + " has suspected jump table(s). Compile with -fno-jump-tables (GCC) or equiv. to disable.");
        }
        if (r.is_x64_rel32()) {
            throw new RuntimeException(r.getSection().getName() + " has a relative relocation for address of symbol '" + r.getSymbol().getName() + "'. I can't process this for a PICO.");
        }
        if (r.is("x64", 1)) {
            long offsetSymbolFromBase = patch.getOffset();
            int offsetDataFromSymbol = r.getOffsetAsLong() + (int)r.getSymbol().getValue();
            Logger.println("Symbol " + r.getSymbolName() + " from base? " + offsetSymbolFromBase + ", data from symbol? " + offsetDataFromSymbol);
            CrystalUtils.putDWORD(rawdata, patch.getVirtualAddress(), (int)offsetSymbolFromBase + offsetDataFromSymbol);
            this.patchups.add(patch);
        } else if (r.is("x86", 6)) {
            long offsetSymbolFromBase = patch.getOffset();
            int offsetDataFromSymbol = r.getOffsetAsLong() + (int)r.getSymbol().getValue();
            Logger.println("Symbol " + r.getSymbolName() + " from base? " + offsetSymbolFromBase + ", data from symbol? " + offsetDataFromSymbol);
            CrystalUtils.putDWORD(rawdata, patch.getVirtualAddress(), (int)offsetSymbolFromBase + offsetDataFromSymbol);
            this.patchups.add(patch);
        } else {
            throw new RuntimeException("Can't offline process data relocation " + r);
        }
    }

    public byte[] export() {
        this.program.add(this.object.getSection(".text"), false);
        this.imports.setupIAT();
        if (this.object.getSection(".rdata") != null) {
            this.content.add(this.object.getSection(".rdata"), false);
        }
        if (this.object.getSection(".data") != null) {
            this.content.add(this.object.getSection(".data"), false);
        }
        if (this.object.getSection(".cplink") != null) {
            this.content.add(this.object.getSection(".cplink"), false);
        }
        Iterator i = this.object.getLinks().iterator();
        while (i.hasNext()) {
            this.content.add((Section)i.next(), false);
        }
        this.content.addEmpty(this.object.getSection(".bss"), false);
        byte[] code = this.program.getRawData();
        for (Relocation r : this.program.getRelocations()) {
            this.processRelocation(r, code);
        }
        byte[] data = this.content.getRawData();
        for (Relocation r : this.content.getRelocations()) {
            this.processDataRelocation(r, data);
        }
        return new BuildPICO(this.object, this, code, data).export();
    }

    public SectionContainer getCode() {
        return this.program;
    }

    public SectionContainer getData() {
        return this.content;
    }

    public List getPatchUps() {
        return this.patchups;
    }

    public Map getImports() {
        return this.imports.functions;
    }

    public Map getLocalImports() {
        return this.imports.apis;
    }

    public class PatchUp {
        protected SectionContainer source = null;
        protected SectionContainer container = null;
        protected Section key = null;
        protected Relocation reloc = null;

        public PatchUp(SectionContainer s, Relocation r) {
            this.source = s;
            this.reloc = r;
            if (r.getRemoteSection() != null) {
                if (ProgramPICO.this.program.hasOffset(r.getRemoteSection())) {
                    this.container = ProgramPICO.this.program;
                    this.key = r.getRemoteSection();
                    return;
                }
                if (ProgramPICO.this.content.hasOffset(r.getRemoteSection())) {
                    this.container = ProgramPICO.this.content;
                    this.key = r.getRemoteSection();
                    return;
                }
            }
            if (ProgramPICO.this.object.getLinkedSection(r.getSymbolName()) != null) {
                this.container = ProgramPICO.this.content;
                this.key = ProgramPICO.this.object.getLinkedSection(r.getSymbolName());
            } else if (ProgramPICO.this.imports.hasKey(r.getSymbolName())) {
                this.container = ProgramPICO.this.content;
                this.key = ProgramPICO.this.imports.getKey(r.getSymbolName());
            }
        }

        public boolean isColocated(SectionContainer target) {
            return target == this.container;
        }

        public boolean isValid() {
            return this.container != null && this.key != null && this.container.hasOffset(this.key);
        }

        public int getOffset() {
            return this.container.getBase(this.key);
        }

        public int getVirtualAddress() {
            return this.source.getBase(this.reloc) + (int)this.reloc.getVirtualAddress();
        }

        public Relocation getRelocation() {
            return this.reloc;
        }

        public boolean isSourceCode() {
            return this.source == ProgramPICO.this.program;
        }

        public boolean isSourceData() {
            return this.source == ProgramPICO.this.content;
        }

        public boolean isTargetCode() {
            return this.container == ProgramPICO.this.program;
        }

        public boolean isTargetData() {
            return this.container == ProgramPICO.this.content;
        }
    }

    private class Imports {
        protected Map functions = new HashMap();
        protected Map apis = new HashMap();
        protected Map symbols = new HashMap();

        protected void trackImport(ParseImport parser, Section s) {
            String module = parser.getModule();
            String func = parser.getFunction();
            if ("".equals(module)) {
                this.apis.put(func, s);
            } else {
                if (!this.functions.containsKey(module)) {
                    this.functions.put(module, new HashMap());
                }
                Map table = (Map)this.functions.get(module);
                table.put(func, s);
            }
        }

        protected void processFunctionRelocation(String symbol, ParseImport parser, Relocation r) {
            byte[] placeholder;
            if (this.hasKey(symbol)) {
                return;
            }
            if (r.is("x64", 4)) {
                placeholder = new byte[8];
            } else if (r.is("x86", 6)) {
                placeholder = new byte[4];
            } else {
                throw new RuntimeException("Invalid machine!");
            }
            SectionData s = new SectionData(symbol, placeholder);
            this.trackImport(parser, s);
            ProgramPICO.this.content.add(s, false);
            this.symbols.put(symbol, s);
        }

        public void setupIAT() {
            for (Relocation r : ProgramPICO.this.program.getRelocations()) {
                String symbol = r.getSymbolName();
                ParseImport parser = new ParseImport(symbol);
                if (!parser.isValid()) continue;
                this.processFunctionRelocation(symbol, parser, r);
            }
        }

        public boolean hasKey(String symbol) {
            return this.symbols.containsKey(symbol);
        }

        public Section getKey(String symbol) {
            return (Section)this.symbols.get(symbol);
        }
    }
}

