/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.export.ExportObject;
import crystalpalace.export.FormatCOFF;
import crystalpalace.export.LinkedSections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProgramCOFF {
    protected ExportObject object;
    protected Map sections = new LinkedHashMap();
    protected Map sectnos = new HashMap();
    protected LinkedSections linked = new LinkedSections();

    public ProgramCOFF(ExportObject object) {
        this.object = object;
        this.setupSections();
    }

    public int getSectionNumber(Section s) {
        return (Integer)this.sectnos.get(s);
    }

    public void add(String name, Section s) {
        this.sections.put(name, s);
        this.sectnos.put(s, this.sectnos.size() + 1);
    }

    public void setupSections() {
        this.add(".text", this.object.getSection(".text"));
        if (this.object.getSection(".rdata") != null) {
            this.add(".rdata", this.object.getSection(".rdata"));
        }
        if (this.object.getSection(".data") != null) {
            this.add(".data", this.object.getSection(".data"));
        }
        if (this.object.getSection(".bss") != null) {
            this.add(".bss", this.object.getSection(".bss"));
        }
        this.linked.go(this.object);
        this.add(".cplink", this.linked.getSection());
    }

    public List getSections() {
        return new LinkedList(this.sections.values());
    }

    public List getStrings() {
        LinkedHashSet<Object> strings = new LinkedHashSet<Object>();
        strings.addAll(this.sections.keySet());
        for (Symbol temp : this.getSymbols()) {
            strings.add(temp.getName());
        }
        for (Relocation temp : this.getRelocations()) {
            strings.add(temp.getSymbolName());
        }
        return new LinkedList(strings);
    }

    public List getRelocations() {
        LinkedList results = new LinkedList();
        for (Section sect : this.sections.values()) {
            results.addAll(sect.getRelocations());
        }
        return results;
    }

    public List getSymbols() {
        LinkedList results = new LinkedList();
        for (Section sect : this.sections.values()) {
            results.addAll(sect.getSymbols());
        }
        results.addAll(this.linked.getSymbols());
        return results;
    }

    public byte[] export() {
        FormatCOFF packer = new FormatCOFF();
        packer.header(this.object.getMachine(), this.sections.size());
        for (Section sect : this.sections.values()) {
            packer.sectionHeader(sect);
        }
        for (Section sect : this.sections.values()) {
            packer.sectionData(sect);
        }
        packer.symbolTable(this);
        packer.stringTable(this);
        return packer.getBytes();
    }
}

