/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.util.CrystalUtils;

public class ParseImport {
    protected String symbol;
    protected boolean valid;
    protected String module;
    protected String function;

    public ParseImport(String symbol) {
        this.symbol = symbol;
        this.parse();
    }

    public static long ROR(long hash, int bits) {
        long a = hash >>> bits;
        long b = hash << 32 - bits;
        return (a | b) & 0xFFFFFFFFL;
    }

    public static int hash(byte[] hashme) {
        long res = 0L;
        for (int x = 0; x < hashme.length; ++x) {
            res = ParseImport.ROR(res, 13);
            res += (long)hashme[x];
        }
        return (int)res;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getModule() {
        return this.module;
    }

    public void checkAndPopulateModule() {
        if (!"".equals(this.module)) {
            return;
        }
        if (!"GetProcAddress".equals(this.function) && !"LoadLibraryA".equals(this.function)) {
            throw new RuntimeException("Function " + this.function + " is not in MODULE$Function format");
        }
        this.module = "KERNEL32";
    }

    public int getModuleHash() {
        return ParseImport.hash(CrystalUtils.toBytes(this.getModule().toUpperCase() + ".DLL", "UTF-16LE"));
    }

    public String getFunction() {
        return this.function;
    }

    public int getFunctionHash() {
        return ParseImport.hash(this.getFunction().getBytes());
    }

    public String getSymbol() {
        return this.symbol;
    }

    protected void parse() {
        String work;
        this.valid = false;
        if (this.symbol.startsWith("__imp__")) {
            work = this.symbol.substring("__imp__".length());
        } else if (this.symbol.startsWith("__imp_")) {
            work = this.symbol.substring("__imp_".length());
        } else {
            return;
        }
        String[] parse = work.split("\\$");
        if (parse.length == 2) {
            this.module = parse[0];
            this.function = parse[1];
        } else {
            this.module = "";
            this.function = work;
        }
        parse = this.function.split("\\@");
        if (parse.length == 2) {
            this.function = parse[0];
        }
        this.valid = true;
    }

    public String toString() {
        if (this.isValid()) {
            return this.symbol + ", " + this.module + ", " + this.function;
        }
        return this.symbol + " (not an import)";
    }
}

