/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.util.CrystalUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Locations {
    protected Map primary = new HashMap();
    protected List patches = new LinkedList();

    public void fixLater(Object key, String subkey, int location) {
        this.patches.add(new Patch(key, subkey, location));
    }

    public void put(Object key, String subkey, int value) {
        this.get(key).put(subkey, value);
    }

    private Map get(Object key) {
        if (this.primary.get(key) == null) {
            this.primary.put(key, new HashMap());
        }
        return (Map)this.primary.get(key);
    }

    public int get(Object key, String subkey) {
        if (!this.get(key).containsKey(subkey)) {
            throw new RuntimeException("No location for " + key + " -> " + subkey);
        }
        return (Integer)this.get(key).get(subkey);
    }

    public void patch(byte[] data) {
        for (Patch temp : this.patches) {
            temp.apply(data);
        }
    }

    private class Patch {
        protected Object key;
        protected String subkey;
        protected int location;

        public Patch(Object key, String subkey, int location) {
            this.key = key;
            this.subkey = subkey;
            this.location = location;
        }

        public void apply(byte[] data) {
            int value = Locations.this.get(this.key, this.subkey);
            CrystalUtils.putDWORD(data, this.location, value);
        }
    }
}

