/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.coff.Section;
import crystalpalace.coff.SectionData;
import crystalpalace.coff.Symbol;
import crystalpalace.export.ExportObject;
import crystalpalace.export.SectionContainer;
import java.util.LinkedList;
import java.util.List;

public class LinkedSections {
    protected Section section = null;
    protected List symbols = new LinkedList();

    public Section getSection() {
        return this.section;
    }

    public LinkedSections go(ExportObject object) {
        long value;
        String name;
        SectionContainer container = new SectionContainer();
        Section old = object.getSection(".cplink");
        if (old != null) {
            container.add(old, false);
        }
        for (Section sect : object.getLinks()) {
            container.add(sect, false);
        }
        this.section = new SectionData(".cplink", container.getRawData());
        if (old != null) {
            for (Symbol temp : old.getSymbols()) {
                name = temp.getName();
                value = (long)container.getBase(old) + temp.getValue();
                this.symbols.add(Symbol.createDataSymbol(this.section, name, value));
            }
        }
        for (Section sect : object.getLinks()) {
            name = sect.getName();
            value = container.getBase(sect);
            this.symbols.add(Symbol.createDataSymbol(this.section, name, value));
        }
        return this;
    }

    public List getSymbols() {
        return this.symbols;
    }
}

