/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.btf.Code;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.Modify;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Section;
import crystalpalace.coff.SectionData;
import crystalpalace.coff.Symbol;
import crystalpalace.export.DFR;
import crystalpalace.export.ProgramCOFF;
import crystalpalace.export.ProgramPIC64;
import crystalpalace.export.ProgramPICO;
import crystalpalace.merge.COFFMerge;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExportObject {
    protected COFFObject object;
    protected Set btfoptions;
    protected String type;
    protected Map links = new LinkedHashMap();
    protected List apitable = new LinkedList();
    protected Set reladdrs = new HashSet();
    protected PrintStream disasm_out = null;
    protected PrintStream coffpr_out = null;
    protected Map patches = new LinkedHashMap();
    protected DFR resolvers = null;
    protected String x86retaddr = null;
    protected String getbss = null;

    public ExportObject(COFFObject object, String type, Set btfoptions) {
        this.type = type;
        this.btfoptions = btfoptions;
        this.object = object;
        this.resolvers = new DFR(this);
        this.setAPI("LoadLibraryA, GetProcAddress");
    }

    public void disassemble(File out) throws FileNotFoundException {
        this.disasm_out = new PrintStream(out);
    }

    public void coffparse(File out) throws FileNotFoundException {
        this.coffpr_out = new PrintStream(out);
    }

    public void link(String name, byte[] value) {
        this.links.put(name, new SectionData(name, value));
    }

    public void patch(String symb, byte[] data) {
        this.object.checkPatch(symb, data);
        this.patches.put(symb, data);
    }

    public void merge(COFFObject object2) {
        LinkedList<COFFObject> temp = new LinkedList<COFFObject>();
        temp.add(object2);
        this.merge(temp);
    }

    public void merge(List objects) {
        COFFMerge merge = new COFFMerge();
        merge.merge(this.object);
        for (COFFObject object2 : objects) {
            merge.merge(object2);
        }
        this.object = merge.finish().getObject();
    }

    public void remap(String oldsymb, String newsymb) {
        this.object.remapSymbol(oldsymb, newsymb);
    }

    public DFR getResolvers() {
        return this.resolvers;
    }

    public void useRelativeAddress(String funcs) {
        String[] blah = funcs.split(",\\s*");
        for (int x = 0; x < blah.length; ++x) {
            this.reladdrs.add(blah[x]);
        }
    }

    public boolean hasRelativeAddressSymbols() {
        return this.reladdrs.size() > 0;
    }

    public boolean hasX86Retaddr() {
        return this.x86retaddr != null;
    }

    protected void check(String symbol) {
        Symbol temp = this.object.getSymbol(symbol);
        if (temp == null) {
            throw new RuntimeException("Symbol " + symbol + " does not exist.");
        }
        if (!temp.isFunction()) {
            throw new RuntimeException("Symbol " + symbol + " is not a function.");
        }
    }

    public void fixX86References(String retaddr) {
        this.x86retaddr = retaddr;
        this.check(retaddr);
    }

    public void fixBSSReferences(String _getbss) {
        this.getbss = _getbss;
        this.check(this.getbss);
    }

    public boolean allowsRelativeAddress(String val) {
        return this.reladdrs.contains(val);
    }

    public int getAPI(String _symbol) {
        Iterator i = this.apitable.iterator();
        int x = 0;
        while (i.hasNext()) {
            String sym = (String)i.next();
            if (sym.equals(_symbol)) {
                return x;
            }
            ++x;
        }
        return -1;
    }

    public void setAPI(String symbols) {
        this.apitable = new LinkedList();
        String[] blah = symbols.split(",\\s*");
        for (int x = 0; x < blah.length; ++x) {
            this.apitable.add(blah[x].trim());
        }
        if (this.getAPI("LoadLibraryA") != 0) {
            throw new RuntimeException("LoadLibraryA is required as the first API entry.");
        }
        if (this.getAPI("GetProcAddress") != 1) {
            throw new RuntimeException("GetProcAddress is required as the second API entry.");
        }
    }

    public boolean isPIC() {
        return "pic".equals(this.type) || "pic64".equals(this.type);
    }

    public String getMachine() {
        return this.object.getMachine();
    }

    public Section getLinkedSection(String name) {
        return (Section)this.links.get(name);
    }

    public Section getSection(String name) {
        return this.object.getSection(name);
    }

    public List getLinks() {
        return new LinkedList(this.links.values());
    }

    public String getType() {
        return this.type;
    }

    public boolean is(String _type) {
        return this.type.equals(_type);
    }

    public byte[] export() {
        COFFMerge merge = new COFFMerge();
        merge.merge(this.object);
        this.object = merge.finish().getObject();
        this.object = new Modify(this.object).fixX86(this.x86retaddr);
        this.object = new Modify(this.object).fixBSS(this.getbss);
        this.object = new Modify(this.object).resolve(this.resolvers);
        this.object = new Modify(this.object).modify(this.isPIC(), this.btfoptions);
        if (this.coffpr_out != null) {
            this.coffpr_out.println(this.object.toString());
            this.coffpr_out.flush();
            this.coffpr_out.close();
        }
        if (this.disasm_out != null) {
            CodeUtils.print(this.disasm_out, Code.Init(this.object).analyze());
            this.disasm_out.flush();
            this.disasm_out.close();
        }
        for (Map.Entry entry : this.patches.entrySet()) {
            this.object.patch((String)entry.getKey(), (byte[])entry.getValue());
        }
        if (this.is("pic")) {
            return new ProgramPIC64(this).export();
        }
        if (this.is("pic64")) {
            return new ProgramPIC64(this).export();
        }
        if (this.is("object")) {
            return new ProgramPICO(this).export();
        }
        if (this.is("coff")) {
            return new ProgramCOFF(this).export();
        }
        return new byte[0];
    }
}

