/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.coff.Symbol;
import crystalpalace.export.ExportObject;
import crystalpalace.export.ParseImport;
import crystalpalace.util.CrystalUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DFR {
    protected List resolvers = new LinkedList();
    protected Resolver defresolver = null;
    protected ExportObject object;

    public DFR(ExportObject object) {
        this.object = object;
    }

    protected List getResolvers() {
        LinkedList<Resolver> _resolvers = new LinkedList<Resolver>(this.resolvers);
        if (this.defresolver != null) {
            _resolvers.add(this.defresolver);
        }
        return _resolvers;
    }

    protected void check(String symbol, String method) {
        Symbol temp = this.object.object.getSymbol(symbol);
        if (temp == null) {
            throw new RuntimeException("Symbol " + symbol + " does not exist.");
        }
        if (!temp.isFunction()) {
            throw new RuntimeException("Symbol " + symbol + " is not a function.");
        }
        for (Resolver next : this.getResolvers()) {
            if (!symbol.equals(next.getFunction()) || method.equals(next.getMethod())) continue;
            throw new RuntimeException(next + " uses a different contract for function " + next.getFunction());
        }
    }

    public void addResolver(String func, String method, String mods) {
        this.check(func, method);
        this.resolvers.add(new Resolver(func, method, mods));
    }

    public void setDefaultResolver(String func, String method) {
        this.check(func, method);
        this.defresolver = new Resolver(func, method, null);
    }

    public Resolver getResolver(ParseImport imp) {
        for (Resolver next : this.resolvers) {
            if (!next.validFor(imp.getModule())) continue;
            return next;
        }
        if (this.defresolver != null) {
            return this.defresolver;
        }
        throw new RuntimeException("No DFR resolver matches " + imp.getSymbol());
    }

    public boolean hasResolvers() {
        return this.resolvers.size() > 0 || this.defresolver != null;
    }

    public static class Resolver {
        public String function;
        public String method;
        public Set modules;

        public Resolver(String func, String method, String _modules) {
            this.function = func;
            this.method = method;
            this.modules = _modules == null ? new HashSet() : CrystalUtils.toSet(_modules.toUpperCase());
        }

        public String getFunction() {
            return this.function;
        }

        public String getMethod() {
            return this.method;
        }

        public boolean validFor(String module) {
            return this.modules.contains(module.toUpperCase());
        }

        public boolean isRor13() {
            return "ror13".equals(this.method);
        }

        public boolean isStrings() {
            return "strings".equals(this.method);
        }

        public String toString() {
            if (this.modules.size() == 0) {
                return "Resolver " + this.function + " (" + this.method + ")";
            }
            return "Resolver " + this.function + " (" + this.method + ") for " + this.modules;
        }
    }
}

