/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.export.ExportObject;
import crystalpalace.export.FormatPICO;
import crystalpalace.export.ProgramPICO;
import crystalpalace.util.Concat;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Logger;
import crystalpalace.util.Packer;
import java.util.Map;

public class BuildPICO {
    protected ProgramPICO object;
    protected ExportObject eobject;
    protected byte[] code;
    protected byte[] data;
    protected byte[] program;
    protected byte[] header;

    public BuildPICO(ExportObject eobject, ProgramPICO object, byte[] code, byte[] data) {
        this.eobject = eobject;
        this.object = object;
        this.code = code;
        this.data = data;
    }

    public String getEntrySymbolName() {
        String machine = this.eobject.getMachine();
        if ("x64".equals(machine)) {
            return "go";
        }
        if ("x86".equals(machine)) {
            return "_go";
        }
        throw new RuntimeException(machine + " machine is not supported");
    }

    public int getEntryOffset() {
        Symbol entry = this.object.getCode().getSymbol(this.getEntrySymbolName());
        if (entry == null) {
            throw new RuntimeException("Entry point '" + this.getEntrySymbolName() + "' not found.");
        }
        return this.object.getCode().getBase(entry.getSection()) + (int)entry.getValue();
    }

    public byte[] getHeader() {
        Packer temp = new Packer();
        temp.little();
        temp.addInt(this.object.getCode().length());
        temp.addInt(this.object.getData().length());
        temp.addInt(this.program.length + 16);
        temp.addInt(this.getEntryOffset());
        int enter = this.getEntryOffset();
        Logger.println("PICO Header");
        Logger.println("  Code: " + this.object.getCode().length() + " (real: " + this.code.length + ")");
        Logger.println("  Data: " + this.object.getData().length() + " (real: " + this.data.length + ")");
        Logger.println("Offset: " + (this.program.length + 16));
        Logger.println("Entry:  " + enter + " " + CrystalUtils.toHex(enter));
        return temp.getBytes();
    }

    public byte[] getLoaderProgram() {
        FormatPICO program = new FormatPICO();
        int codeRealLen = this.code.length;
        int codeVirtLen = this.object.getCode().length();
        int dataRealLen = this.data.length;
        int dataVirtLen = this.object.getData().length();
        program.CopyCode(0, 0, codeRealLen);
        program.CopyData(codeRealLen, 0, dataRealLen);
        Logger.println("CODE is at: 0 to " + codeRealLen);
        Logger.println("DATA is at: " + codeVirtLen + " (real: " + codeRealLen + ") + " + dataVirtLen + " (real: " + dataRealLen + ")");
        for (ProgramPICO.PatchUp p : this.object.getPatchUps()) {
            Relocation r = p.getRelocation();
            if (r.is_x64_rel32()) {
                if (p.isSourceCode() && p.isTargetCode()) {
                    throw new RuntimeException("Can't generate diff loader directive for code->code relocation " + r);
                }
                if (p.isSourceCode() && p.isTargetData()) {
                    program.PatchBaseDiff(p.getVirtualAddress());
                    continue;
                }
                if (p.isSourceData() && p.isTargetCode()) {
                    throw new RuntimeException("Can't generate diff loader directive for data->code relocation " + r);
                }
                if (!p.isSourceData() || !p.isTargetData()) continue;
                throw new RuntimeException("Can't generate diff loader directive for data->data relocation " + r);
            }
            if (r.is("x64", 1) || r.is("x86", 6)) {
                if (p.isSourceCode() && p.isTargetCode()) {
                    program.PatchTextText(p.getVirtualAddress());
                    continue;
                }
                if (p.isSourceCode() && p.isTargetData()) {
                    program.PatchTextBase(p.getVirtualAddress());
                    continue;
                }
                if (p.isSourceData() && p.isTargetCode()) {
                    program.PatchBaseText(p.getVirtualAddress());
                    continue;
                }
                if (!p.isSourceData() || !p.isTargetData()) continue;
                program.PatchBaseBase(p.getVirtualAddress());
                continue;
            }
            throw new RuntimeException("I can't generate a loader directive for relocation: " + r);
        }
        for (Map.Entry entry : this.object.getImports().entrySet()) {
            String module = (String)entry.getKey();
            Map funcs = (Map)entry.getValue();
            program.LoadLibrary(module);
            for (Map.Entry fentry : funcs.entrySet()) {
                String func = (String)fentry.getKey();
                Section sect = (Section)fentry.getValue();
                program.GetProcAddress(func);
                program.PatchFunction(this.object.getData().getBase(sect));
            }
        }
        for (Map.Entry entry : this.object.getLocalImports().entrySet()) {
            String func = (String)entry.getKey();
            Section sect = (Section)entry.getValue();
            int index = this.eobject.getAPI(func);
            if (index == -1) {
                throw new RuntimeException("Function " + func + " is not imported and not in MODULE$function format");
            }
            program.PatchImport(this.object.getData().getBase(sect), index);
        }
        program.Complete();
        return program.getBytes();
    }

    public byte[] export() {
        this.program = this.getLoaderProgram();
        this.header = this.getHeader();
        Concat c = new Concat();
        c.add(this.header);
        c.add(this.program);
        c.add(this.code);
        c.add(this.data);
        Logger.print_stat("export() header " + this.header.length + "b, program " + this.program.length + "b, content " + (this.code.length + this.data.length) + "b");
        return c.get();
    }
}

