/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.coff;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFWalker;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Printer;

public class Symbol
implements Comparable {
    public static final int IMAGE_SYM_CLASS_EXTERNAL = 2;
    public static final int IMAGE_SYM_CLASS_STATIC = 3;
    public static final int IMAGE_SYM_CLASS_LABEL = 6;
    protected Section section;
    protected String Name;
    protected long Value;
    protected int Type;
    protected int StorageClass;

    public static Symbol createSectionSymbol(COFFObject obj, Section sect, String name) {
        Symbol temp = new Symbol();
        temp.section = sect;
        temp.Name = name;
        temp.Value = 0L;
        temp.Type = 0;
        temp.StorageClass = 3;
        return temp;
    }

    public static Symbol createDataSymbol(Section sect, String name, long value) {
        Symbol temp = new Symbol();
        temp.section = sect;
        temp.Name = name;
        temp.Value = value;
        temp.Type = 0;
        temp.StorageClass = 2;
        return temp;
    }

    protected Symbol() {
    }

    public static Symbol createFunctionSymbol(COFFObject obj, String name, long address) {
        Symbol temp = new Symbol();
        temp.section = obj.getSection(".text");
        temp.Name = name;
        temp.Value = address;
        temp.Type = 32;
        temp.StorageClass = 2;
        return temp;
    }

    public Symbol(COFFObject obj, Section sect, Symbol symb) {
        this.section = sect;
        this.Name = symb.Name;
        this.Value = symb.Value;
        this.Type = symb.Type;
        this.StorageClass = symb.StorageClass;
    }

    public Symbol(COFFObject obj, Section sect, COFFWalker.Symbol symb) {
        this.section = sect;
        this.Name = symb.getName();
        this.Value = symb.getValue();
        this.Type = symb.getType();
        this.StorageClass = symb.getStorageClass();
    }

    public String getName() {
        return this.Name;
    }

    public boolean isSectionName() {
        return this.StorageClass == 3 && this.Value == 0L && (this.Name.startsWith(".") || this.Name.equals(this.getSection().getName()));
    }

    public boolean isUndefinedSection() {
        return this.getSection() == null;
    }

    public Section getSection() {
        return this.section;
    }

    public int getType() {
        return this.Type;
    }

    public boolean isExternal() {
        return this.StorageClass == 2;
    }

    public boolean isGlobalVariable() {
        return this.StorageClass == 2 && !this.isFunction() && this.getSection() != null;
    }

    public boolean isFunction() {
        return this.Type == 32;
    }

    public boolean isLabel() {
        return this.StorageClass == 6;
    }

    public long getValue() {
        return this.Value;
    }

    public void setValue(long v) {
        this.Value = v;
    }

    public int compareTo(Object other) {
        return (int)this.getValue() - (int)((Symbol)other).getValue();
    }

    public String relativeTo(Relocation r) {
        long diff = r.getVirtualAddress() - this.getValue();
        if (diff > 0L) {
            return "<" + this.getName() + "+" + CrystalUtils.toHex(diff) + ">";
        }
        if (diff == 0L) {
            return "<" + this.getName() + ">";
        }
        return "<" + this.getName() + CrystalUtils.toHex(diff) + ">";
    }

    public long estimateSize() {
        if (this.getSection() == null) {
            return 0L;
        }
        for (Symbol temp : this.getSection().getSymbols()) {
            if (temp.getValue() <= this.getValue()) continue;
            return temp.getValue() - this.getValue();
        }
        return (long)this.getSection().getRawData().length - this.getValue();
    }

    public String toString() {
        if (this.isFunction()) {
            return "(SYMBOL) " + this.getName() + "' (func) at " + CrystalUtils.toHex(this.Value);
        }
        return "(SYMBOL) " + this.getName() + "' at " + CrystalUtils.toHex(this.Value);
    }

    public void toString(int idx, Printer printer) {
        printer.push("Symbol " + idx);
        printer.print("Name", this.getName());
        printer.print("Value", this.getValue());
        if (this.getSection() != null) {
            printer.print("Section", this.getSection().getName());
        } else {
            printer.print("Section", "");
        }
        printer.print("Type", this.Type);
        printer.print("StorageClass", this.StorageClass);
        if (this.isGlobalVariable() && !this.isLabel()) {
            printer.print("Est. Size", this.estimateSize() + "");
        }
        printer.pop();
    }
}

