/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.coff;

import crystalpalace.util.CrystalUtils;

public class SectionFlags {
    protected long flags;
    public static final long IMAGE_SCN_CNT_CODE = 32L;
    public static final long IMAGE_SCN_CNT_INITIALIZED_DATA = 64L;
    public static final long IMAGE_SCN_CNT_UNINITIALIZED_DATA = 128L;
    public static final long IMAGE_SCN_LNK_COMDAT = 4096L;
    public static final long IMAGE_SCN_MEM_EXECUTE = 0x20000000L;
    public static final long IMAGE_SCN_MEM_READ = 0x40000000L;
    public static final long IMAGE_SCN_MEM_WRITE = 0x80000000L;

    public static long getFlags(String section) {
        if (".text".equals(section)) {
            return 0x60000020L;
        }
        if (".rdata".equals(section)) {
            return 0x40000040L;
        }
        if (".data".equals(section)) {
            return 0xC0000040L;
        }
        if (".bss".equals(section)) {
            return 0xC0000080L;
        }
        return 0x40000040L;
    }

    private static boolean isSet(long flags, long x) {
        return (flags & x) == x;
    }

    public static boolean isUninitialized(long flags) {
        return SectionFlags.isSet(flags, 128L);
    }

    public static boolean isCommonData(long flags) {
        return SectionFlags.isSet(flags, 4096L);
    }

    public static boolean hasCode(long flags) {
        return SectionFlags.isSet(flags, 32L);
    }

    public static boolean isRead(long flags) {
        return SectionFlags.isSet(flags, 0x40000000L);
    }

    public static boolean isWrite(long flags) {
        return SectionFlags.isSet(flags, 0x80000000L);
    }

    public static boolean isExecute(long flags) {
        return SectionFlags.isSet(flags, 0x20000000L);
    }

    public static String toString(long flags) {
        StringBuffer s = new StringBuffer();
        s.append(SectionFlags.isRead(flags) ? "r" : "-");
        s.append(SectionFlags.isWrite(flags) ? "w" : "-");
        s.append(SectionFlags.isExecute(flags) ? "x" : "-");
        s.append(" ");
        if (SectionFlags.isSet(flags, 32L)) {
            s.append("(code)");
            s.append(" ");
        }
        if (SectionFlags.isSet(flags, 64L)) {
            s.append("(init)");
            s.append(" ");
        }
        if (SectionFlags.isSet(flags, 128L)) {
            s.append("(not init)");
            s.append(" ");
        }
        s.append(CrystalUtils.toHex(flags));
        return s.toString();
    }
}

