/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.coff;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFWalker;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Printer;
import java.util.Iterator;

public class Relocation {
    public static final int IMAGE_REL_AMD64_ADDR64 = 1;
    public static final int IMAGE_REL_AMD64_REL32 = 4;
    public static final int IMAGE_REL_AMD64_REL32_1 = 5;
    public static final int IMAGE_REL_AMD64_REL32_2 = 6;
    public static final int IMAGE_REL_AMD64_REL32_3 = 7;
    public static final int IMAGE_REL_AMD64_REL32_4 = 8;
    public static final int IMAGE_REL_AMD64_REL32_5 = 9;
    public static final int IMAGE_REL_I386_DIR32 = 6;
    public static final int IMAGE_REL_I386_REL32 = 20;
    protected Section parent;
    protected long VirtualAddress;
    protected String SymbolName;
    protected int Type;

    public Relocation(Section parent, long VirtualAddress, String SymbolName, int Type2) {
        this.parent = parent;
        this.VirtualAddress = VirtualAddress;
        this.SymbolName = SymbolName;
        this.Type = Type2;
    }

    public Relocation(Section parent, Relocation reloc) {
        this.parent = parent;
        this.VirtualAddress = reloc.VirtualAddress;
        this.SymbolName = reloc.SymbolName;
        this.Type = reloc.Type;
    }

    public Relocation(Section parent, COFFWalker.Relocation reloc) {
        this.parent = parent;
        this.VirtualAddress = reloc.getVirtualAddress();
        this.SymbolName = reloc.getSymbol().getName();
        this.Type = reloc.getType();
    }

    public COFFObject getObject() {
        return this.parent.getObject();
    }

    public boolean is_x64_rel32() {
        return this.getSection().getObject().getMachine().equals("x64") && this.Type >= 4 && this.Type <= 9;
    }

    public int getFromOffset() {
        if (this.is_x64_rel32()) {
            return this.Type;
        }
        return 4;
    }

    public boolean is(String _machine, int _type) {
        return _machine.equals(this.getSection().getObject().getMachine()) && this.Type == _type;
    }

    public Section getRemoteSection() {
        if (this.getSymbol().isUndefinedSection()) {
            return null;
        }
        return this.getSymbol().getSection();
    }

    public Section getSection() {
        return this.parent;
    }

    public Symbol getSymbol() {
        return this.getSection().getObject().getSymbol(this.SymbolName);
    }

    public Symbol getReferencedSymbol() {
        if (this.getSymbol().isSectionName() && this.getRemoteSection().getGroupName().equals(".text")) {
            for (Symbol next : this.getRemoteSection().getSymbols()) {
                if (next.getValue() != (long)this.getOffsetAsLong()) continue;
                return next;
            }
            return this.getSymbol();
        }
        return this.getSymbol();
    }

    public String getSymbolName() {
        return this.SymbolName;
    }

    public Symbol getFunction() {
        Iterator i = this.getSection().getSymbols().iterator();
        Symbol last = null;
        while (i.hasNext()) {
            Symbol next = (Symbol)i.next();
            if (!next.isFunction()) continue;
            if (next.getValue() >= this.getVirtualAddress()) {
                return last;
            }
            last = next;
        }
        return last;
    }

    public int getType() {
        return this.Type;
    }

    public long getVirtualAddress() {
        return this.VirtualAddress;
    }

    public int getOffsetAsLong() {
        return CrystalUtils.getDWORD(this.getSection().getRawData(), (int)this.getVirtualAddress());
    }

    public void setVirtualAddress(long va) {
        this.VirtualAddress = va;
    }

    public void setSymbolName(String name) {
        this.SymbolName = name;
    }

    public String toString() {
        return "Relocation(" + this.Type + ") " + this.toSimpleString();
    }

    public String toSimpleString() {
        Symbol func = this.getFunction();
        if (func != null) {
            return this.getSymbolName() + " @ " + CrystalUtils.toHex(this.getVirtualAddress()) + " " + func.relativeTo(this);
        }
        return this.getSymbolName() + " @ " + CrystalUtils.toHex(this.getVirtualAddress());
    }

    public void toString(int idx, Printer printer) {
        printer.push("Relocation " + idx);
        if (this.getFunction() != null) {
            printer.print("VirtualAddress", this.getVirtualAddress(), this.getFunction().relativeTo(this));
        } else {
            printer.print("VirtualAddress", this.getVirtualAddress());
        }
        printer.print("Symbol", this.getSymbolName());
        printer.print("Offset", this.getOffsetAsLong());
        printer.print("Type", this.getType());
        printer.pop();
    }
}

