/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.coff;

import crystalpalace.coff.COFFVisitor;
import crystalpalace.coff.SectionFlags;
import crystalpalace.util.ByteWalker;
import crystalpalace.util.CrystalUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class COFFWalker {
    protected StringTable strings;
    protected ByteWalker walker;
    protected Symbol[] symbols = new Symbol[0];
    protected Section[] sections = new Section[0];

    public void walk(ByteWalker walker, COFFVisitor visitor) {
        int x;
        this.walker = walker;
        Header header = new Header();
        visitor.visit(header);
        visitor.visitOH(header.getOptionalHeader());
        for (x = 0; x < this.sections.length; ++x) {
            Section sect = this.sections[x];
            visitor.visit(sect);
            Iterator j = sect.getRelocations().iterator();
            while (j.hasNext()) {
                visitor.visit((Relocation)j.next());
            }
        }
        for (x = 0; x < this.symbols.length; ++x) {
            if (this.symbols[x] == null) continue;
            visitor.visit(this.symbols[x]);
        }
    }

    public void walk(byte[] content, COFFVisitor visitor) {
        this.walk(new ByteWalker(content), visitor);
    }

    public class Header {
        protected int Machine;
        protected int NumberOfSections;
        protected long TimeDateStamp;
        protected long PointerToSymbolTable;
        protected long NumberOfSymbols;
        protected int SizeOfOptionalHeader;
        protected int Characteristics;
        protected byte[] OptionalHeader;

        public Header() {
            int x;
            this.Machine = COFFWalker.this.walker.readShort();
            if (!CrystalUtils.toSet("arm64, x86, x64").contains(this.getMachine())) {
                throw new RuntimeException("COFF starts with unrecognized Machine value " + CrystalUtils.toHex(this.Machine));
            }
            this.NumberOfSections = COFFWalker.this.walker.readShort();
            this.TimeDateStamp = COFFWalker.this.walker.readInt();
            this.PointerToSymbolTable = COFFWalker.this.walker.readInt();
            this.NumberOfSymbols = COFFWalker.this.walker.readInt();
            this.SizeOfOptionalHeader = COFFWalker.this.walker.readShort();
            this.Characteristics = COFFWalker.this.walker.readShort();
            this.OptionalHeader = COFFWalker.this.walker.getBytes(this.SizeOfOptionalHeader);
            COFFWalker.this.sections = new Section[this.NumberOfSections];
            for (x = 0; x < this.NumberOfSections; ++x) {
                COFFWalker.this.sections[x] = new Section();
            }
            COFFWalker.this.walker.GoTo((int)this.PointerToSymbolTable);
            COFFWalker.this.symbols = new Symbol[(int)this.NumberOfSymbols];
            x = 0;
            while ((long)x < this.NumberOfSymbols) {
                COFFWalker.this.symbols[x] = new Symbol();
                for (int z = 1; z <= COFFWalker.this.symbols[x].getAuxRecords(); ++z) {
                    new Symbol();
                    COFFWalker.this.symbols[x + z] = null;
                }
                x += COFFWalker.this.symbols[x].getAuxRecords();
                ++x;
            }
            COFFWalker.this.strings = new StringTable();
            COFFWalker.this.walker.Return();
            if (!COFFWalker.this.walker.isSane()) {
                throw new RuntimeException("Error(s) while parsing COFF. File is possibly malformed.");
            }
        }

        public byte[] getOptionalHeader() {
            return this.OptionalHeader;
        }

        public String getMachine() {
            switch (this.Machine) {
                case 34404: {
                    return "x64";
                }
                case 332: {
                    return "x86";
                }
                case 43620: {
                    return "arm64";
                }
            }
            return "Unknown " + CrystalUtils.toHex(this.Machine);
        }
    }

    public class Section {
        protected byte[] Name;
        protected long VirtualSize;
        protected long VirtualAddress;
        protected long SizeOfRawData;
        protected long PointerToRawData;
        protected long PointerToRelocations;
        protected long PointerToLinenumbers;
        protected int NumberOfRelocations;
        protected int NumberOfLinenumbers;
        protected long Characteristics;
        protected byte[] RawData;
        protected List relocations = new LinkedList();

        public Section() {
            this.Name = COFFWalker.this.walker.popBytes(8);
            this.VirtualSize = COFFWalker.this.walker.readInt();
            this.VirtualAddress = COFFWalker.this.walker.readInt();
            this.SizeOfRawData = COFFWalker.this.walker.readInt();
            this.PointerToRawData = COFFWalker.this.walker.readInt();
            this.PointerToRelocations = COFFWalker.this.walker.readInt();
            this.PointerToLinenumbers = COFFWalker.this.walker.readInt();
            this.NumberOfRelocations = COFFWalker.this.walker.readShort();
            this.NumberOfLinenumbers = COFFWalker.this.walker.readShort();
            this.Characteristics = COFFWalker.this.walker.readInt();
            if (SectionFlags.isUninitialized(this.Characteristics)) {
                this.RawData = new byte[(int)this.SizeOfRawData];
            } else {
                COFFWalker.this.walker.GoTo((int)this.PointerToRawData);
                this.RawData = COFFWalker.this.walker.getBytes((int)this.SizeOfRawData);
                COFFWalker.this.walker.Return();
            }
            COFFWalker.this.walker.GoTo((int)this.PointerToRelocations);
            for (int x = 0; x < this.NumberOfRelocations; ++x) {
                this.relocations.add(new Relocation());
            }
            COFFWalker.this.walker.Return();
        }

        public long getVirtualAddress() {
            return this.VirtualAddress;
        }

        public long getVirtualSize() {
            return this.VirtualSize;
        }

        public List getRelocations() {
            return this.relocations;
        }

        public byte[] getRawData() {
            return this.RawData;
        }

        public long getCharacteristics() {
            return this.Characteristics;
        }

        public String getName() {
            String name = this._getName();
            if (SectionFlags.isCommonData(this.Characteristics)) {
                return name + "-" + String.format("%016X", this.PointerToRawData);
            }
            if (".xdata".equals(name)) {
                return name + "-" + String.format("%016X", this.PointerToRawData);
            }
            return name;
        }

        public String _getName() {
            ByteWalker walker = new ByteWalker(this.Name);
            String _name = walker.readStringA(8);
            if (_name.length() == 0) {
                return "";
            }
            if (_name.charAt(0) == '/') {
                String rest = _name.substring(1);
                int pos = CrystalUtils.parseInt(rest, -1);
                if (pos == -1) {
                    return _name;
                }
                return COFFWalker.this.strings.getStringAt(pos);
            }
            return _name;
        }
    }

    public class Relocation {
        protected long VirtualAddress;
        protected long SymbolTableIndex;
        protected int Type;

        public Relocation() {
            this.VirtualAddress = COFFWalker.this.walker.readInt();
            this.SymbolTableIndex = COFFWalker.this.walker.readInt();
            this.Type = COFFWalker.this.walker.readShort();
        }

        public Symbol getSymbol() {
            return COFFWalker.this.symbols[(int)this.SymbolTableIndex];
        }

        public long getVirtualAddress() {
            return this.VirtualAddress;
        }

        public int getType() {
            return this.Type;
        }
    }

    public class Symbol {
        protected byte[] Name;
        protected long Value;
        protected int SectionNumber;
        protected int Type;
        protected int StorageClass;
        protected int AuxRecords;

        public Symbol() {
            this.Name = COFFWalker.this.walker.popBytes(8);
            this.Value = COFFWalker.this.walker.readInt();
            this.SectionNumber = COFFWalker.this.walker.readShort();
            this.Type = COFFWalker.this.walker.readShort();
            this.StorageClass = COFFWalker.this.walker.popByte();
            this.AuxRecords = COFFWalker.this.walker.popByte();
        }

        public String getName() {
            if (this.getSection() != null && this.StorageClass == 3 && this.Value == 0L && this._getName().startsWith(".")) {
                return this.getSection().getName();
            }
            if (this.getSection() != null && this.getStorageClass() == 6) {
                return this._getName() + "-" + String.format("%016X", this.getValue());
            }
            return this._getName();
        }

        public String _getName() {
            ByteWalker walker = new ByteWalker(this.Name);
            walker.Mark();
            int x = walker.readInt();
            int y = walker.readInt();
            walker.Return();
            if (x == 0 && y == 0) {
                return "";
            }
            if (x == 0) {
                return COFFWalker.this.strings.getStringAt(y);
            }
            return walker.readStringA(8);
        }

        public long getValue() {
            return this.Value;
        }

        public int getType() {
            return this.Type;
        }

        public int getStorageClass() {
            return this.StorageClass;
        }

        public Section getSection() {
            if (this.SectionNumber >= 1 && this.SectionNumber <= COFFWalker.this.sections.length) {
                return COFFWalker.this.sections[this.SectionNumber - 1];
            }
            return null;
        }

        public int getAuxRecords() {
            return this.AuxRecords;
        }
    }

    public class StringTable {
        protected int length;
        protected byte[] data;

        public StringTable() {
            this.length = COFFWalker.this.walker.readInt();
            this.data = COFFWalker.this.walker.popBytes(this.length - 4);
        }

        public String getStringAt(int index) {
            return this._getStringAt(index - 4);
        }

        protected String _getStringAt(int index) {
            try {
                int len;
                for (len = index; len < this.data.length && this.data[len] != 0; ++len) {
                }
                return new String(this.data, index, len - index, "UTF-8");
            }
            catch (Exception ex) {
                CrystalUtils.handleException(ex);
                return "";
            }
        }
    }
}

