/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.coff;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFVisitor;
import crystalpalace.coff.COFFWalker;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.util.ByteWalker;
import crystalpalace.util.CrystalUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class COFFParser
implements COFFVisitor {
    protected COFFObject object;
    protected Section section;
    protected Map sections = new HashMap();

    @Override
    public void visit(COFFWalker.Header header) {
        this.object = new COFFObject(header.getMachine());
    }

    @Override
    public void visitOH(byte[] optionalHeader) {
    }

    @Override
    public void visit(COFFWalker.Section sect) {
        this.section = new Section(this.object, sect);
        this.object.getSections().put(this.section.getName(), this.section);
        this.sections.put(sect, this.section);
    }

    @Override
    public void visit(COFFWalker.Symbol symbol) {
        Symbol s = new Symbol(this.object, symbol.getSection() != null ? (Section)this.sections.get(symbol.getSection()) : null, symbol);
        if (s.isLabel()) {
            return;
        }
        if (this.object.getSymbols().containsKey(symbol.getName())) {
            throw new RuntimeException("Duplicate symbol '" + symbol.getName() + "' in object symbol table. Crystal Palace doesn't handle this situation gracefully.");
        }
        this.object.getSymbols().put(symbol.getName(), s);
    }

    @Override
    public void visit(COFFWalker.Relocation reloc) {
        Relocation r = new Relocation(this.section, reloc);
        this.section.getRelocations().add(r);
    }

    public COFFParser parse(byte[] data) {
        new COFFWalker().walk(data, (COFFVisitor)this);
        return this;
    }

    public COFFParser parse(ByteWalker walker) {
        new COFFWalker().walk(walker, (COFFVisitor)this);
        return this;
    }

    public COFFObject getObject() {
        return this.object;
    }

    public void print() {
        System.out.println(this.object.toString());
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("./coffparse [/path/to/file.o]");
            return;
        }
        try {
            new COFFParser().parse(CrystalUtils.readFromFile(args[0])).print();
        }
        catch (IOException ioex) {
            CrystalUtils.handleException(ioex);
        }
    }
}

