/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.CodeWriter;
import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeAssemblerResult;
import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.btf.AddInstruction;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeVisitor;
import crystalpalace.btf.Jumps;
import crystalpalace.btf.RebuildStep;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Symbol;
import crystalpalace.util.CrystalUtils;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Rebuilder {
    protected Code analysis;
    protected Map funcs;
    protected COFFObject object;
    protected CodeAssembler program = null;
    protected CodeAssemblerResult results = null;
    protected Map relocs = new LinkedHashMap();
    protected RebuildStep state = new RebuildStep(this);
    protected Map labels = new HashMap();
    protected Jumps jumps = null;

    public Rebuilder(Code analysis, Map funcs) {
        this.analysis = analysis;
        this.funcs = funcs;
        this.object = analysis.getObject();
    }

    protected byte[] assemble() {
        final ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        Object result = this.program.assemble(new CodeWriter(){

            @Override
            public void writeByte(byte value) {
                out.write(value);
            }
        }, 0L, 4);
        if (result instanceof String) {
            throw new RuntimeException("assemble() failed: " + (String)result);
        }
        this.results = (CodeAssemblerResult)result;
        return out.toByteArray();
    }

    public void walk(CodeVisitor visitor) {
        for (Map.Entry entry : this.funcs.entrySet()) {
            String func = (String)entry.getKey();
            List insts = (List)entry.getValue();
            for (Instruction next : insts) {
                visitor.visit(next);
            }
        }
    }

    public COFFObject rebuild() {
        return this.rebuild(null);
    }

    public COFFObject rebuild(AddInstruction adder) {
        this.program = new CodeAssembler(this.object.getBits());
        this.jumps = new Jumps(this.analysis, this.program);
        for (Map.Entry entry : this.funcs.entrySet()) {
            this.labels.put(entry.getKey(), this.program.createLabel());
        }
        this.walk(new CodeVisitor(){

            @Override
            public void visit(Instruction next) {
                Relocation r = Rebuilder.this.analysis.getRelocation(next);
                if (r == null) {
                    return;
                }
                CodeLabel label = Rebuilder.this.jumps.createLabel(next.getIP());
                long offset = r.getVirtualAddress() - next.getIP();
                Rebuilder.this.relocs.put(r, new RelocationFix(r, label, (int)offset));
            }
        });
        this.walk(this.jumps);
        for (Map.Entry entry : this.funcs.entrySet()) {
            boolean isFunction = this.analysis.isFunction((String)entry.getKey());
            this.program.label((CodeLabel)this.labels.get(entry.getKey()));
            this.program.zero_bytes();
            for (Instruction inst : (List)entry.getValue()) {
                Symbol temp;
                this.state.step(inst);
                try {
                    if (this.jumps.hasLabel(inst)) {
                        this.program.label(this.jumps.getLabel(inst));
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException("Can't label '" + String.format("%016X %s", inst.getIP(), inst.getOpCode().toInstructionString()) + "'. (a label already exists?)");
                }
                Instruction copy = inst.copy();
                copy.setIP(0L);
                if (this.analysis.hasRelocation(inst)) {
                    if (adder == null || !isFunction) {
                        this.program.addInstruction(copy);
                        continue;
                    }
                    adder.addInstruction(this.program, this.state, copy);
                    continue;
                }
                if (inst.isCallNear()) {
                    temp = this.analysis.getLabel(inst.getMemoryDisplacement32());
                    if (temp != null) {
                        this.program.addInstruction(Instruction.createBranch(inst.getCode(), ((CodeLabel)this.labels.get((Object)temp.getName())).id));
                        continue;
                    }
                } else if (inst.isIPRelativeMemoryOperand()) {
                    if ("LEA r64, m".equals(inst.getOpCode().toInstructionString())) {
                        temp = this.analysis.getLabel(inst.getMemoryDisplacement32());
                        if (temp != null) {
                            this.program.lea(new AsmRegister64(new ICRegister(inst.getOp0Register())), AsmRegisters.mem_ptr((CodeLabel)this.labels.get(temp.getName())));
                            continue;
                        }
                    } else if ("MOV r64, r/m64".equals(inst.getOpCode().toInstructionString())) {
                        temp = this.analysis.getLabel(inst.getMemoryDisplacement32());
                        if (temp != null) {
                            this.program.mov(new AsmRegister64(new ICRegister(inst.getOp0Register())), AsmRegisters.mem_ptr((CodeLabel)this.labels.get(temp.getName())));
                            continue;
                        }
                    } else if ("CALL r/m64".equals(inst.getOpCode().toInstructionString()) && (temp = this.analysis.getLabel(inst.getMemoryDisplacement32())) != null) {
                        this.program.call(AsmRegisters.qword_ptr((CodeLabel)this.labels.get(temp.getName())));
                        continue;
                    }
                } else if (this.jumps.isJump(inst)) {
                    this.program.addInstruction(Instruction.createBranch(inst.getCode(), this.jumps.getJumpLabel((Instruction)inst).id));
                    continue;
                }
                if (inst.isIPRelativeMemoryOperand()) {
                    throw new RuntimeException("Can't transform '" + String.format("%016X %s", inst.getIP(), inst.getOpCode().toInstructionString()) + "'. (Modified program will crash)");
                }
                if (adder == null || !isFunction) {
                    this.program.addInstruction(copy);
                    continue;
                }
                adder.addInstruction(this.program, this.state, copy);
            }
        }
        byte[] text_content = this.assemble();
        this.object.getSection(".text").setData(text_content);
        for (Symbol temp : this.object.getSection(".text").getSymbols()) {
            if (!this.labels.containsKey(temp.getName())) continue;
            temp.setValue(this.results.getLabelRIP((CodeLabel)this.labels.get(temp.getName())));
        }
        LinkedList<Relocation> newrelocs = new LinkedList<Relocation>();
        for (RelocationFix entry : this.relocs.values()) {
            CodeLabel label = entry.getLabel();
            Relocation reloc = entry.getRelocation();
            reloc.setVirtualAddress(this.results.getLabelRIP(label) + (long)entry.getOffsetFromInstruction());
            if (".text".equals(reloc.getSymbolName())) {
                Symbol temp = this.analysis.getLabel(entry.getRelocOffsetLong());
                if (temp != null) {
                    entry.setRelocOffsetValue(temp.getValue());
                } else {
                    throw new RuntimeException("Could not fix " + entry.toStringOld() + " - no symbol at " + CrystalUtils.toHex(entry.getRelocOffsetLong()) + ". (Modified program will crash)");
                }
            }
            this.object.getSection(".text").patch((int)reloc.getVirtualAddress(), entry.getRelocOffsetValue());
            newrelocs.add(reloc);
        }
        this.object.getSection(".text").setRelocations(newrelocs);
        return this.object;
    }

    protected class RelocationFix {
        protected Relocation reloc;
        protected int instOffset;
        protected byte[] valueAt;
        protected CodeLabel label;
        protected String toStrOld;

        public RelocationFix(Relocation reloc, CodeLabel label, int instOffset) {
            this.reloc = reloc;
            this.label = label;
            this.instOffset = instOffset;
            this.valueAt = Rebuilder.this.object.getSection(".text").fetch((int)reloc.getVirtualAddress(), 4);
            this.toStrOld = reloc.toString();
        }

        public Relocation getRelocation() {
            return this.reloc;
        }

        public CodeLabel getLabel() {
            return this.label;
        }

        public int getOffsetFromInstruction() {
            return this.instOffset;
        }

        public long getRelocOffsetLong() {
            return CrystalUtils.getDWORD(this.valueAt, 0);
        }

        public byte[] getRelocOffsetValue() {
            return this.valueAt;
        }

        public void setRelocOffsetValue(long x) {
            CrystalUtils.putDWORD(this.valueAt, 0, (int)x);
        }

        public String toStringOld() {
            return this.toStrOld;
        }
    }
}

