/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.btf.Rebuilder;
import crystalpalace.coff.Relocation;

public class RebuildStep {
    protected Rebuilder builder;
    protected Instruction instruction;

    public RebuildStep(Rebuilder builder) {
        this.builder = builder;
    }

    public void step(Instruction inst) {
        this.instruction = inst;
    }

    public int getInstructionLength() {
        return this.instruction.getLength();
    }

    public String getInstructionString() {
        return String.format("%016X %s", this.instruction.getIP(), this.instruction.getOpCode().toInstructionString());
    }

    public int getRelocOffset() {
        Rebuilder.RelocationFix fix = (Rebuilder.RelocationFix)this.builder.relocs.get(this.getRelocation());
        return fix.instOffset;
    }

    public void setRelocOffset(int x) {
        Rebuilder.RelocationFix fix = (Rebuilder.RelocationFix)this.builder.relocs.get(this.getRelocation());
        fix.instOffset = x;
    }

    public void createLabel(CodeAssembler program) {
        CodeLabel label = program.createLabel();
        program.label(label);
        Rebuilder.RelocationFix fix = (Rebuilder.RelocationFix)this.builder.relocs.get(this.getRelocation());
        fix.label = label;
    }

    public Relocation getRelocation() {
        return this.builder.analysis.getRelocation(this.instruction);
    }

    public boolean hasRelocation() {
        return this.builder.analysis.hasRelocation(this.instruction);
    }

    public void resolve() {
        this.builder.relocs.remove(this.getRelocation());
    }

    public CodeLabel getLabel(String func) {
        return (CodeLabel)this.builder.labels.get(func);
    }
}

