/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.info.InstructionInfo;
import com.github.icedland.iced.x86.info.InstructionInfoFactory;
import crystalpalace.btf.BaseModify;
import crystalpalace.btf.Code;
import crystalpalace.btf.RebuildStep;

public class Mutator
extends BaseModify {
    @Override
    public void setupVerbs() {
        this.verbs.add(new Load());
        this.verbs.add(new Store32());
        this.verbs.add(new Store64());
        this.verbs.add(new MovImmReg32());
        this.verbs.add(new MovImmReg64());
        this.verbs.add(new MovImmMem32());
        this.verbs.add(new Nop());
        this.verbs.add(new PushImm32());
        this.verbs.add(new ZeroReg32());
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        return !step.hasRelocation();
    }

    public Mutator(Code code) {
        super(code);
    }

    public boolean isRegOnly(Instruction next) {
        InstructionInfoFactory instrInfoFactory = new InstructionInfoFactory();
        InstructionInfo info = instrInfoFactory.getInfo(next);
        return !info.getUsedMemory().iterator().hasNext();
    }

    protected void _buildConstant64(CodeAssembler program, AsmRegister64 reg, long constant) {
        long part1 = this.nextLong();
        AsmRegister64 tmp = this.getRandReg64(reg);
        program.push(tmp);
        program.mov(tmp, part1);
        program.mov(reg, constant - part1);
        program.add(reg, tmp);
        program.pop(tmp);
    }

    protected void _buildConstant(CodeAssembler program, AsmRegister32 reg, int constant) {
        if (constant == 0) {
            this._zeroReg32(program, reg);
            return;
        }
        int part1 = this.nextInt(Math.abs(constant));
        switch (this.nextInt(4)) {
            case 0: {
                this._zeroReg32(program, reg);
                program.add(reg, part1);
                program.add(reg, constant - part1);
                break;
            }
            case 1: {
                program.mov(reg, part1);
                program.add(reg, constant - part1);
                break;
            }
            case 2: {
                this._zeroReg32(program, reg);
                program.or(reg, part1);
                program.add(reg, constant - part1);
                break;
            }
            case 3: {
                this._buildConstant(program, reg, part1);
                program.add(reg, constant - part1);
            }
        }
    }

    protected void _nop32(CodeAssembler program) {
        AsmRegister32 reg = this.getRandReg32();
        switch (this.nextInt(6)) {
            case 0: {
                program.nop();
                break;
            }
            case 1: {
                program.or(reg, reg);
                break;
            }
            case 2: {
                program.and(reg, reg);
                break;
            }
            case 3: {
                program.add(reg, 0);
                break;
            }
            case 4: {
                program.sub(reg, 0);
                break;
            }
            case 5: {
                this._nop(program);
                this._nop(program);
            }
        }
    }

    protected void _nop64(CodeAssembler program) {
        AsmRegister64 reg = this.getRandReg64();
        switch (this.nextInt(6)) {
            case 0: {
                program.nop();
                break;
            }
            case 1: {
                program.or(reg, reg);
                break;
            }
            case 2: {
                program.and(reg, reg);
                break;
            }
            case 3: {
                program.add(reg, 0);
                break;
            }
            case 4: {
                program.sub(reg, 0);
                break;
            }
            case 5: {
                this._nop(program);
                this._nop(program);
            }
        }
    }

    protected void _nop(CodeAssembler program) {
        if ("x86".equals(this.object.getMachine())) {
            this._nop32(program);
        } else if ("x64".equals(this.object.getMachine())) {
            this._nop64(program);
        }
    }

    protected void _zeroReg32(CodeAssembler program, AsmRegister32 reg) {
        switch (this.nextInt(5)) {
            case 0: {
                program.xor(reg, reg);
                break;
            }
            case 1: {
                program.and(reg, 0);
                break;
            }
            case 2: {
                program.mov(reg, 0);
                break;
            }
            case 3: {
                program.imul(reg, reg, 0);
                break;
            }
            case 4: {
                program.sub(reg, reg);
            }
        }
    }

    private class ZeroReg32
    implements BaseModify.ModifyVerb {
        private ZeroReg32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, imm32".equals(istr) && next.getImmediate32() == 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 reg = new AsmRegister32(new ICRegister(next.getOp0Register()));
            Mutator.this._zeroReg32(program, reg);
        }
    }

    private class Nop
    implements BaseModify.ModifyVerb {
        private Nop() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "NOP".equals(istr) || "NOP r/m32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            Mutator.this._nop(program);
        }
    }

    private class Store64
    implements BaseModify.ModifyVerb {
        private Store64() {
        }

        public boolean isDesiredReg(Instruction next) {
            return next.getMemoryBase() == 58 || next.getMemoryBase() == 57;
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m64, r64".equals(istr) && this.isDesiredReg(next);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            String istr = next.getOpCode().toInstructionString();
            long displ = next.getMemoryDisplacement64();
            AsmMemoryOperand dst = Mutator.this.getMemOperand(next);
            if (displ > 255L || displ < -255L || displ == 0L || dst == null) {
                program.addInstruction(next);
            } else {
                AsmRegister64 src = new AsmRegister64(new ICRegister(next.getOp1Register()));
                AsmRegister64 tmp = Mutator.this.getRandReg64(src);
                long newdispl = Mutator.this.nextInt(10) * 8;
                if (Mutator.this.nextInt(2) == 0) {
                    newdispl *= -1L;
                }
                program.push(tmp);
                dst = dst.displacement(newdispl);
                program.lea(tmp, dst);
                dst = dst.displacement(displ - newdispl).base(tmp);
                if (next.getMemoryBase() == 57) {
                    dst = dst.add(8L);
                }
                program.mov(dst, src);
                program.pop(tmp);
            }
        }
    }

    private class Store32
    implements BaseModify.ModifyVerb {
        private Store32() {
        }

        public boolean isDesiredReg(Instruction next) {
            return next.getMemoryBase() == 42 || next.getMemoryBase() == 41;
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m32, r32".equals(istr) && "x86".equals(Mutator.this.object.getMachine()) && this.isDesiredReg(next);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            String istr = next.getOpCode().toInstructionString();
            long displ = next.getMemoryDisplacement64();
            AsmMemoryOperand dst = Mutator.this.getMemOperand(next);
            if (displ > 255L || displ < -255L || displ == 0L || dst == null) {
                program.addInstruction(next);
            } else {
                AsmRegister32 src = new AsmRegister32(new ICRegister(next.getOp1Register()));
                AsmRegister32 tmp = Mutator.this.getRandReg32(src);
                long newdispl = Mutator.this.nextInt(10) * 8;
                if (Mutator.this.nextInt(2) == 0) {
                    newdispl *= -1L;
                }
                program.push(tmp);
                dst = dst.displacement(newdispl);
                program.lea(tmp, dst);
                dst = dst.displacement(displ - newdispl).base(tmp);
                if (next.getMemoryBase() == 41) {
                    dst = dst.add(4L);
                }
                program.mov(dst, src);
                program.pop(tmp);
            }
        }
    }

    private class Load
    implements BaseModify.ModifyVerb {
        private Load() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r64, r/m64".equals(istr) || "MOV r32, r/m32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            String istr = next.getOpCode().toInstructionString();
            AsmMemoryOperand src = Mutator.this.getMemOperand(next);
            long displ = next.getMemoryDisplacement64();
            if (displ > 255L || displ < -255L || displ == 0L || src == null) {
                program.addInstruction(next);
            } else if ("MOV r64, r/m64".equals(istr)) {
                AsmRegister64 dst = new AsmRegister64(new ICRegister(next.getOp0Register()));
                long newdispl = Mutator.this.nextInt(10) * 8;
                if (Mutator.this.nextInt(2) == 0) {
                    newdispl *= -1L;
                }
                src = src.displacement(newdispl);
                program.lea(dst, src);
                src = src.displacement(displ - newdispl).base(dst);
                program.mov(dst, src);
            } else if ("x86".equals(Mutator.this.object.getMachine()) && "MOV r32, r/m32".equals(istr)) {
                AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
                long newdispl = Mutator.this.nextInt(10) * 8;
                if (Mutator.this.nextInt(2) == 0) {
                    newdispl *= -1L;
                }
                src = src.displacement(newdispl);
                program.lea(dst, src);
                src = src.displacement(displ - newdispl).base(dst);
                program.mov(dst, src);
            } else {
                program.addInstruction(next);
            }
        }
    }

    private class MovImmMem32
    implements BaseModify.ModifyVerb {
        private MovImmMem32() {
        }

        public boolean isDesiredReg(Instruction next) {
            return next.getMemoryBase() == 58 || next.getMemoryBase() == 57 || next.getMemoryBase() == 42 || next.getMemoryBase() == 41;
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m32, imm32".equals(istr) && this.isDesiredReg(next) && next.getMemoryIndex() == 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            if ("x64".equals(Mutator.this.object.getMachine())) {
                AsmRegister64 reg64 = Mutator.this.getRandReg64();
                AsmRegister32 reg32 = Mutator.this.toReg32(reg64);
                AsmMemoryOperand dst = Mutator.this.getMemOperand(next);
                if (next.getMemoryBase() == 57) {
                    dst = dst.add(8L);
                }
                program.push(reg64);
                Mutator.this._buildConstant(program, reg32, next.getImmediate32());
                program.mov(dst, reg32);
                program.pop(reg64);
            } else if ("x86".equals(Mutator.this.object.getMachine())) {
                AsmRegister32 reg32 = Mutator.this.getRandReg32();
                AsmMemoryOperand dst = Mutator.this.getMemOperand(next);
                if (next.getMemoryBase() == 41) {
                    dst = dst.add(4L);
                }
                program.push(reg32);
                Mutator.this._buildConstant(program, reg32, next.getImmediate32());
                program.mov(dst, reg32);
                program.pop(reg32);
            }
        }
    }

    private class MovImmReg64
    implements BaseModify.ModifyVerb {
        private MovImmReg64() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r64, imm64".equals(istr) && next.getImmediate64() != 0L;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister64 reg = new AsmRegister64(new ICRegister(next.getOp0Register()));
            Mutator.this._buildConstant64(program, reg, next.getImmediate64());
        }
    }

    private class MovImmReg32
    implements BaseModify.ModifyVerb {
        private MovImmReg32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, imm32".equals(istr) && next.getImmediate32() != 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 reg = new AsmRegister32(new ICRegister(next.getOp0Register()));
            Mutator.this._buildConstant(program, reg, next.getImmediate32());
        }
    }

    private class PushImm32
    implements BaseModify.ModifyVerb {
        private PushImm32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "PUSH imm32".equals(istr) && next.getImmediate32() != 0 && "x86".equals(Mutator.this.object.getMachine());
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 reg = Mutator.this.getRandReg32();
            program.push(reg);
            Mutator.this._buildConstant(program, reg, next.getImmediate32());
            program.xchg(Mutator.this.getStackPtr(), reg);
        }
    }
}

